<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ restaurant()->name }}</title>

    <style>
        /* TODO: optimize */

        body {
            font-family: 'Roboto', sans-serif;
            margin: 0px;
            padding: 0px;
        }

        .receipt {
            padding: 3mm;
            width: 80mm;
            /* border: 1px solid black; */
        }

        .orderNo {
            width: 100%;
            text-align: right;
            padding-bottom: 1mm;
            font-size: 10pt;
            font-weight: bold;
        }

        .orderNo:empty {
            display: none;
        }

        .headerSubTitle {
            text-align: center;
            font-size: 10pt;
        }

        .headerTitle {
            text-align: center;
            font-size: 12pt;
            font-weight: bold;
        }

        #location {
            margin-top: 5pt;
            text-align: center;
            font-size: 10pt;
            font-weight: 500;
        }

        #date {
            margin: 5pt 0px;
            text-align: center;
            font-size: 8pt;
        }

        #barcode {
            display: block;
            margin: 0px auto;
        }

        #barcode:empty {
            display: none;
        }

        .watermark {
            position: absolute;
            left: 7mm;
            top: 60mm;
            width: 75mm;
            opacity: 0.1;
        }

        .keepIt {
            text-align: center;
            font-size: 12pt;
            font-weight: bold;
        }

        .keepItBody {
            text-align: justify;
            font-size: 8pt;
        }

        .item {
            margin-bottom: 1mm;
        }

        .itemRow {
            display: flex;
            font-size: 8pt;
            align-items: baseline;
        }

        .itemRow>div {
            align-items: baseline;
        }

        .itemName {
            font-weight: bold;
        }

        .itemPrice {
            text-align: right;
            flex-grow: 1;
        }

        .itemColor {
            width: 10px;
            height: 100%;
            background: yellow;
            margin: 0px 2px;
            padding: 0px;
        }

        .itemColor:before {
            content: "\00a0";
        }


        .itemData2 {
            text-align: right;
            flex-grow: 1;
        }

        .itemData3 {
            width: 15mm;
            text-align: right;
        }

        .itemQuantity:before {
            content: "x";
        }

        .itemTaxable:after {
            content: " T";
        }

        .flex {
            display: flex;
            justify-content: center;
        }

        #qrcode {
            align-self: center;
            flex: 0 0 100px
        }

        .totals {
            flex-grow: 1;
            align-self: center;
            font-size: 8pt;
        }

        .totals .row {
            display: flex;
            text-align: right;
        }

        .totals .section {
            padding-top: 2mm;
        }

        .totalRow>div,
        .total>div {
            text-align: right;
            align-items: baseline;
            font-size: 8pt;
        }

        .totals .col1 {
            text-align: right;
            flex-grow: 1;
        }

        .totals .col2 {
            width: 22mm;
        }

        .totals .col2:empty {
            display: none;
        }

        .totals .col3 {
            width: 15mm;
        }

        .footer {
            overflow: hidden;
            margin-top: 5mm;
            border-radius: 7px;
            width: 100%;
            background: black;
            color: white;
            text-align: center;
            font-weight: bold;
            text-transform: uppercase;
        }

        .footer:empty {
            display: none;
        }

        .eta {
            padding: 1mm 0px;
        }

        .eta:empty {
            display: none;
        }

        .eta:before {
            content: "Estimated time order will be ready: ";
            font-size: 8pt;
            display: block;
        }

        .etaLabel {
            font-size: 8pt;
        }

        .printType {
            padding: 1mm 0px;
            width: 100%;
            background: grey;
            color: white;
            text-align: center;
            font-weight: bold;
            text-transform: uppercase;
        }

        .about {
            font-size: 12pt;
            overflow: hidden;
            background: #FCEC52;
            color: #3A5743;
            border-radius: 7px;
            padding: 0px;
            position: absolute;
            width: 500px;
            text-align: center;
            left: 50%;
            margin-top: 50px;
            margin-left: -250px;
        }

        .arrow_box h3,
        ul {
            margin: 5px;
        }

        .about li {
            text-align: left;
        }

        .arrow_box {
            position: absolute;
            background: #88b7d5;
            padding: 5px;
            margin-top: 20px;
            left: 95mm;
            top: 2;
            width: 500px;
            border: 4px solid #c2e1f5;
        }

        .arrow_box:after,
        .arrow_box:before {
            right: 100%;
            top: 50%;
            border: solid transparent;
            content: " ";
            height: 0;
            width: 0;
            position: absolute;
            pointer-events: none;
        }

        .arrow_box:after {
            border-color: rgba(136, 183, 213, 0);
            border-right-color: #88b7d5;
            border-width: 30px;
            margin-top: -30px;
        }

        .arrow_box:before {
            border-color: rgba(194, 225, 245, 0);
            border-right-color: #c2e1f5;
            border-width: 36px;
            margin-top: -36px;
        }
    </style>

    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'PT Sans', sans-serif;
        }

        @page {
            size: 2.8in 11in;
            margin-top: 0cm;
            margin-left: 0cm;
            margin-right: 0cm;
        }

        table {
            width: 100%;
        }

        tr {
            width: 100%;

        }

        h1 {
            text-align: center;
            vertical-align: middle;
        }

        #logo {
            width: 60%;
            text-align: center;
            -webkit-align-content: center;
            align-content: center;
            padding: 5px;
            margin: 2px;
            display: block;
            margin: 0 auto;
        }

        header {
            width: 100%;
            text-align: center;
            -webkit-align-content: center;
            align-content: center;
            vertical-align: middle;
        }

        .items thead {
            text-align: center;
        }

        .center-align {
            text-align: center;
        }

        .bill-details td {
            font-size: 12px;
        }

        .receipt {
            font-size: medium;
        }

        .items .heading {
            font-size: 12px;
            text-transform: uppercase;
            border-top: 1px solid black;
            margin-bottom: 4px;
            border-bottom: 1px solid black;
            vertical-align: middle;
            font-weight: 500;
        }

        .items thead tr th:nth-child(1),
        .items tbody tr td:nth-child(1) {
            width: 5%;
        }

        .items thead tr th:nth-child(2),
        .items tbody tr td:nth-child(2) {
            width: 47%;
            min-width: 47%;
            max-width: 47%;
            word-break: break-all;
            text-align: left;
        }

        .items td {
            font-size: 12px;
            text-align: right;
            vertical-align: bottom;
        }

        .price::before {
            font-family: Arial;
            text-align: right;
        }

        .sum-up {
            text-align: right !important;
        }

        .total {
            font-size: 13px;
            border-top: 1px dashed black !important;
            border-bottom: 1px dashed black !important;
        }

        .total.text,
        .total.price {
            text-align: right;
        }

        .line {
            border-top: 1px solid black !important;
        }

        .heading.rate {
            width: 20%;
        }

        .heading.amount {
            width: 25%;
        }

        .heading.qty {
            width: 5%
        }

        p {
            padding: 1px;
            margin: 0;
        }

        section,
        footer {
            font-size: 12px;
        }
    </style>
</head>

<body>


    <!-- START RECEIPT -->
    <div class="receipt">
        {{-- <img class="watermark" src="https://www.dropbox.com/s/mmf6y9rpibwy9tk/bronyhouse-logo-sm.svg?raw=1"> --}}
        <div class="orderNo">
            @lang('modules.order.orderNumber')# <span id="Order #">{{ $order->order_number }}</span>
        </div>
        <div class="headerTitle">
            {{ restaurant()->name }}
        </div>
        <div class="headerSubTitle">
            {{ restaurant()->phone_number }}
        </div>
        <div id="location">
            {{ restaurant()->address }}
        </div>
        <div id="date">
            {{ $order->date_time->timezone(timezone())->format('d M, Y h:i A') }}
        </div>

        <!-- Items Purchased -->
        <table class="items">
            <thead>
                <tr>
                    <th class="heading name">#</th>
                    <th class="heading name">@lang('modules.menu.itemName')</th>
                    <th class="heading qty">@lang('modules.order.qty')</th>
                    <th class="heading rate sum-up">@lang('modules.order.price')</th>
                    <th class="heading amount sum-up">@lang('modules.order.amount')</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($order->items as $item)
                <tr>
                    <td style="text-align: center; vertical-align: top">{{ $loop->iteration }}</td>
                    <td>{{ $item->menuItem->item_name }} {!!  (isset($item->menuItemVariation) ? '<br>(' . $item->menuItemVariation->variation . ')' : '') !!}</td>
                    <td style="text-align: center">{{ $item->quantity }}</td>
                    <td class="price">{{ currency() . $item->price }}</td>
                    <td class="price">{{ currency() . $item->amount }}</td>
                </tr>
                @endforeach

                <tr>
                    <td colspan="4" class="sum-up line">@lang('modules.order.subTotal')</td>
                    <td class="line price sum-up">{{ currency() }}{{ $order->sub_total }}</td>
                </tr>

                @foreach ($order->taxes as $item)
                <tr>
                    <td colspan="4" class="sum-up">{{ $item->tax->tax_name }} ({{ $item->tax->tax_percent }}%)</td>
                    <td class="price sum-up">{{ currency() }}{{ (($item->tax->tax_percent / 100) * $order->sub_total ) }}</td>
                </tr>
                @endforeach

                <tr>
                    <th colspan="4" class="total text">@lang('modules.order.total')</th>
                    <th class="total price">{{ currency() }}{{ $order->total }}</th>
                </tr>
            </tbody>
        </table>
        <section>

            <p style="text-align:center">
                @lang('messages.thankYouVisit')
            </p>
        </section>
        {{-- <footer style="text-align:center">
            <p>Technology Partner Dotworld Technologies</p>
        </footer> --}}


        <script>
            window.print();

        </script>
</body>

</html>
