<div class="px-4">

    <h2 class="text-2xl font-extrabold dark:text-white">@lang('modules.order.myOrders')</h2>

    <ul role="list" class=" space-y-2 dark:divide-gray-700 mt-4">
        @foreach ($orders as $order)
        <li class="p-3 border rounded-md">
            <div class="flex flex-col space-y-4" x-data="{ expanded: false }">

                <div class="flex items-center justify-between cursor-pointer"  x-on:click="expanded = ! expanded">
                    <div class="flex items-center min-w-0">
                        <div>
                            <p class="font-medium text-skin-base truncate dark:text-white">
                                @lang('modules.order.orderNumber') #{{ $order->order_number }}
                            </p>
                            <div class="flex items-center flex-1 text-xs text-gray-500">
                               {{ $order->items->count() }} @lang('modules.menu.item') | {{ $order->date_time->timezone(timezone())->format('M d, Y H:i A') }}
                            </div>
                        </div>
                    </div>
                    <div class="inline-flex flex-col text-right text-base font-semibold text-gray-900 dark:text-white">
                        <div>{{ currency() . $order->total }}</div>
                        <div class="text-xs text-gray-500 font-light">@lang('modules.order.includeTax')</div>
                    </div>
                </div>

                <div class="flex flex-col" x-show="expanded">
                    <table class=" flex-1  min-w-full divide-y divide-gray-200 table-fixed dark:divide-gray-600">
                        <thead class="bg-gray-100 dark:bg-gray-700">
                            <tr>
                                <th scope="col"
                                    class="p-2 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">
                                    @lang('modules.menu.itemName')
                                </th>
                                <th scope="col"
                                    class="p-2 text-xs text-center text-gray-500 uppercase dark:text-gray-400">
                                    @lang('modules.order.qty')
                                </th>
                                <th scope="col"
                                    class="p-2 text-xs font-medium text-right text-gray-500 uppercase dark:text-gray-400">
                                    @lang('modules.order.price')
                                </th>
                                <th scope="col"
                                    class="p-2 text-xs font-medium text-right text-gray-500 uppercase dark:text-gray-400">
                                    @lang('modules.order.amount')
                                </th>

                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200 dark:bg-gray-800 dark:divide-gray-700"
                            wire:key='menu-item-list-{{ microtime() }}'>

                            @forelse ($order->items as $key => $item)
                            <tr class="hover:bg-gray-100 dark:hover:bg-gray-700"
                                wire:key='menu-item-{{ $key . microtime() }}' wire:loading.class.delay='opacity-10'>
                                <td class="flex flex-col p-2 mr-12 lg:min-w-28">
                                    <div class="text-xs text-gray-900 dark:text-white inline-flex items-center">
                                        {{ $item->menuItem->item_name }}
                                    </div>
                                    <div class="text-xs text-gray-600 dark:text-white inline-flex items-center">
                                        {{ (isset($item->menuItemVariation) ? $item->menuItemVariation->variation : '')
                                        }}
                                    </div>

                                </td>
                                <td class="p-2 text-base text-gray-900 whitespace-nowrap text-center">
                                    {{ $item->quantity }}
                                </td>

                                <td
                                    class="p-2 text-xs font-medium text-gray-700 whitespace-nowrap dark:text-white text-right">
                                    {{ currency() . $item->price }}
                                </td>
                                <td
                                    class="p-2 text-xs font-medium text-gray-900 whitespace-nowrap dark:text-white text-right">
                                    {{ currency() . $item->amount }}
                                </td>

                            </tr>
                            @empty
                            <tr class="hover:bg-gray-100 dark:hover:bg-gray-700">
                                <td class="p-2 space-x-6" colspan="5">
                                    @lang('messages.noItemAdded')
                                </td>
                            </tr>
                            @endforelse

                        </tbody>
                    </table>
                </div>

            </div>

        </li>
        @endforeach
    </ul>
</div>