<?php

namespace App\Livewire\Forms;

use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;

class EditPackage extends Component
{

    use LivewireAlert;

    public $package;
    public $packageName;
    public $packagePrice;

    public function mount()
    {
        $this->packageName = $this->package->package_name;
        $this->packagePrice = $this->package->price;
    }

    public function submitForm()
    {
        $this->validate([
            'packageName' => 'required',
            'packagePrice' => 'required',
        ]);

        $this->package->package_name = $this->packageName;
        $this->package->price = $this->packagePrice;
        $this->package->save();

        cache()->forget('package');

        $this->alert('success', __('messages.packageUpdated'), [
            'toast' => true,
            'position' => 'top-end',
            'showCancelButton' => false,
            'cancelButtonText' => __('app.close')
        ]);
    }

    public function render()
    {
        return view('livewire.forms.edit-package');
    }

}
