<?php

namespace App\Livewire\Customer;

use App\Models\Customer;
use App\Models\Order;
use Livewire\Attributes\On;
use Livewire\Component;

class AddCustomer extends Component
{

    public $order;
    public $customerName;
    public $customerPhone;
    public $customerEmail;
    public $customerAddress;
    public $showAddCustomerModal = false;

    #[On('showAddCustomerModal')]
    public function showAddCustomer($id = null)
    {
        if (!is_null($id)) {
            $this->order = Order::find($id);
        }

        $this->showAddCustomerModal = true;
    }

    public function submitForm()
    {
        $this->validate([
            'customerName' => 'required'
        ]);

        $customer = Customer::create([
            'name' => $this->customerName,
            'phone' => $this->customerPhone,
            'email' => $this->customerEmail,
            'delivery_address' => $this->customerAddress
        ]);

        if (!is_null($this->order)) {
            $this->order->customer_id = $customer->id;
            $this->order->delivery_address = $this->customerAddress;
            $this->order->save();

            $this->dispatch('showOrderDetail', id: $this->order->id);
            $this->dispatch('refreshOrders');
            $this->dispatch('refreshPos');
        }

        // Reset the value
        $this->customerName = '';
        $this->customerPhone = '';
        $this->customerEmail = '';
        $this->customerAddress = '';
        
        $this->showAddCustomerModal = false;

    }

    public function render()
    {
        return view('livewire.customer.add-customer');
    }

}
