<?php

namespace App\Http\Controllers;

use App\Exports\StaffExport;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class StaffController extends Controller
{

    public function index()
    {
        abort_if((!user_can('Show Staff Member')), 403);
        return view('staff.index');
    }

    public function export()
    {
        return Excel::download(new StaffExport, 'staff-'.now()->toDateTimeString().'.xlsx');
    }

}
