<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use App\Models\Order;
use App\Models\Restaurant;
use App\Models\Table;
use Illuminate\Http\Request;

class ShopController extends Controller
{

    public function cart($hash)
    {
        $restaurant = Restaurant::where('hash', $hash)->first();
        return view('shop.index', ['restaurant' => $restaurant]);
    }

    public function orderSuccess($id)
    {
        $order = Order::findOrFail($id);
        return view('shop.order_success', ['restaurant' => $order->branch->restaurant, 'id' => $id]);
    }

    public function bookTable($hash)
    {
        $restaurant = Restaurant::where('hash', $hash)->firstOrFail();
        return view('shop.book_a_table', ['restaurant' => $restaurant]);
    }

    public function myBookings($hash)
    {
        $restaurant = Restaurant::where('hash', $hash)->firstOrFail();
        return view('shop.bookings', ['restaurant' => $restaurant]);
    }

    public function profile($hash)
    {
        $restaurant = Restaurant::where('hash', $hash)->firstOrFail();
        return view('shop.profile', ['restaurant' => $restaurant]);
    }

    public function myOrders($hash)
    {
        $restaurant = Restaurant::where('hash', $hash)->firstOrFail();
        return view('shop.orders', ['restaurant' => $restaurant]);
    }

    public function about($hash)
    {
        $restaurant = Restaurant::where('hash', $hash)->firstOrFail();
        return view('shop.about', ['restaurant' => $restaurant]);
    }

    public function contact($hash)
    {
        $restaurant = Restaurant::where('hash', $hash)->firstOrFail();
        return view('shop.contact', ['restaurant' => $restaurant]);
    }

    public function tableOrder($hash)
    {
        $table = Table::where('hash', $hash)->firstOrFail();
        return view('shop.index', ['tableHash' => $hash, 'restaurant' => $table->branch->restaurant]);
    }

}
