#
# TABLE STRUCTURE FOR: ambulance_call
#

DROP TABLE IF EXISTS `ambulance_call`;

CREATE TABLE `ambulance_call` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `vehicle_id` int(11) NOT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `address` text,
  `vehicle_model` varchar(20) DEFAULT NULL,
  `driver` varchar(100) NOT NULL,
  `amount` float(10,2) DEFAULT '0.00',
  `net_amount` float(10,2) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `call_from` varchar(200) NOT NULL,
  `call_to` varchar(200) NOT NULL,
  `charge_category_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `standard_charge` int(11) DEFAULT NULL,
  `tax_percentage` float(10,2) DEFAULT NULL,
  `generated_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `vehicle_id` (`vehicle_id`),
  KEY `generated_by` (`generated_by`),
  CONSTRAINT `ambulance_call_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_2` FOREIGN KEY (`vehicle_id`) REFERENCES `vehicles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_3` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (5, 6, NULL, 2, NULL, NULL, NULL, 'siv', '100.00', NULL, '2021-05-01 16:20:00', '', '', NULL, 0, 0, '0.00', 1, '2021-05-01 10:50:46');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (6, 6, NULL, 2, NULL, NULL, NULL, 'siv', '500.00', NULL, '2021-05-06 11:39:00', '', '', NULL, 0, 0, '0.00', 1, '2021-05-06 06:09:32');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (7, 22, NULL, 2, NULL, NULL, NULL, '', '315.00', NULL, '2021-05-24 07:08:00', '', '', NULL, 11, 300, NULL, 1, '2021-05-24 07:11:42');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (8, 22, NULL, 2, NULL, NULL, NULL, 'siv', '525.00', NULL, '2021-05-24 07:14:00', '', '', NULL, 13, 500, '5.00', 1, '2021-05-24 07:17:18');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (9, 22, NULL, 2, NULL, NULL, NULL, 'siv', '525.00', NULL, '2021-05-24 07:21:00', '', '', 7, 12, 500, '5.00', 1, '2021-05-24 07:48:48');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (10, 22, NULL, 2, NULL, NULL, NULL, 'siv', '315.00', NULL, '2021-05-26 07:54:00', '', '', 7, 11, 300, '15.00', 1, '2021-05-25 07:56:12');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (11, 22, NULL, 2, NULL, NULL, NULL, 'siv', '315.00', NULL, '2021-05-26 07:54:00', '', '', 7, 11, 300, '15.00', 1, '2021-05-25 07:58:05');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (12, 22, NULL, 2, NULL, NULL, NULL, 'siv', '525.00', NULL, '2021-05-25 07:59:00', '', '', 7, 13, 500, '25.00', 1, '2021-05-25 08:00:51');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (13, 22, NULL, 2, NULL, NULL, NULL, 'siv', '525.00', NULL, '2021-05-25 07:59:00', '', '', 7, 13, 500, '25.00', 1, '2021-05-25 08:04:42');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (14, 22, NULL, 2, NULL, NULL, NULL, 'siv', '525.00', NULL, '2021-05-25 07:59:00', '', '', 7, 13, 500, '25.00', 1, '2021-05-25 08:07:56');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (15, 22, NULL, 2, NULL, NULL, NULL, 'siv', '525.00', NULL, '2021-05-25 07:59:00', '', '', 7, 13, 500, '25.00', 1, '2021-05-25 08:09:24');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (16, 22, NULL, 2, NULL, NULL, NULL, 'siv', '525.00', NULL, '2021-05-25 07:59:00', '', '', 7, 13, 500, '25.00', 1, '2021-05-25 08:12:11');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (17, 14, NULL, 2, NULL, NULL, NULL, 'siv', '315.00', NULL, '2021-05-25 08:19:00', '', '', 7, 11, 300, '5.00', 1, '2021-05-25 08:20:45');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (18, 145, NULL, 2, NULL, NULL, NULL, 'siv', '200.00', '525.00', '2021-05-27 04:57:00', '', '', 7, 13, 500, '5.00', 1, '2021-05-26 04:59:40');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (19, 145, NULL, 2, NULL, NULL, NULL, 'siv', '500.00', '525.00', '2021-05-26 05:05:00', '', '', 7, 13, 500, '5.00', 1, '2021-05-26 05:06:51');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (20, 14, NULL, 2, NULL, NULL, NULL, 'siv', '500.00', '525.00', '2021-05-26 07:41:00', '', '', 7, 13, 500, '5.00', 1, '2021-05-26 07:43:11');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (21, 139, 138, 1, NULL, NULL, NULL, 'siv', NULL, '525.00', '2021-05-26 07:45:00', '', '', 7, 11, 300, '5.00', 1, '2021-05-26 07:46:37');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (22, 14, 0, 1, NULL, NULL, NULL, 'kkk', '500.00', '525.00', '2021-05-28 10:56:00', '', '', 7, 13, 500, '5.00', 1, '2021-05-28 10:57:25');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (23, 22, 0, 2, NULL, NULL, NULL, 'siv', '500.00', '525.00', '2021-05-28 11:44:00', '', '', 7, 12, 500, '5.00', 1, '2021-05-28 11:46:12');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (24, 14, 56, 2, NULL, NULL, NULL, 'siv', '300.00', '315.00', '2021-06-08 17:29:00', '', '', 7, 11, 300, '5.00', 1, '2021-06-08 12:01:13');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (25, 16, 0, 3, NULL, NULL, NULL, 'tttt', '300.00', '315.00', '2021-06-14 16:18:00', '', '', 7, 11, 300, '5.00', 1, '2021-06-14 10:48:43');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (26, 184, 0, 3, NULL, NULL, NULL, 'tttt', '300.00', '315.00', '2021-06-19 17:35:00', '', '', 7, 11, 300, '5.00', 1, '2021-06-18 12:06:00');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (27, 191, 0, 3, NULL, NULL, NULL, 'tttt', '300.00', '315.00', '2021-06-21 14:40:00', '', '', 7, 11, 300, '5.00', 1, '2021-06-21 09:18:57');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (29, 206, 199, 3, NULL, NULL, NULL, 'tttt', '300.00', '315.00', '2021-06-21 18:27:00', '', '', 7, 11, 300, '5.00', 1, '2021-06-21 12:58:01');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (30, 206, 0, 3, NULL, NULL, NULL, 'tttt', '300.00', '315.00', '2021-06-22 17:42:00', '', '', 7, 11, 300, '5.00', 1, '2021-06-22 12:21:14');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (31, 14, 56, 3, NULL, NULL, NULL, 'tttt', NULL, '525.00', '2021-06-22 18:02:00', '', '', 7, 11, 100, '5.00', 1, '2021-06-22 12:32:24');
INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `amount`, `net_amount`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `tax_percentage`, `generated_by`, `created_at`) VALUES (32, 14, 56, 1, NULL, NULL, NULL, 'kkk', '500.00', '525.00', '2021-06-25 14:14:00', '', '', 7, 13, 500, '5.00', 1, '2021-06-25 08:44:45');


#
# TABLE STRUCTURE FOR: appoint_priority
#

DROP TABLE IF EXISTS `appoint_priority`;

CREATE TABLE `appoint_priority` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appoint_priority` varchar(100) CHARACTER SET latin1 NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (1, 'Normal', '2021-04-20 06:44:03');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (2, 'Urgent', '2021-04-20 06:44:18');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (3, 'Very Urgent', '2021-04-20 06:48:42');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `time` time DEFAULT NULL,
  `priority` varchar(100) NOT NULL,
  `patient_name` varchar(50) DEFAULT NULL,
  `gender` varchar(10) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `mobileno` varchar(20) DEFAULT NULL,
  `specialist` varchar(100) NOT NULL,
  `doctor` int(11) DEFAULT NULL,
  `amount` varchar(200) NOT NULL,
  `message` text,
  `appointment_status` varchar(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `is_opd` varchar(10) NOT NULL,
  `is_ipd` varchar(10) NOT NULL,
  `shift_id` int(11) DEFAULT NULL,
  `is_queue` int(11) DEFAULT NULL,
  `live_consult` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor` (`doctor`),
  CONSTRAINT `appointment_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_2` FOREIGN KEY (`doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=195 DEFAULT CHARSET=utf8;

INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (24, NULL, '2021-04-07 12:35:00', NULL, '2', 'Mayank', 'Male', '', '9770227992', '', 7, '', 'sdfsddsfs', 'approved', 'Offline', '2021-04-30 07:05:25', '', '', NULL, 0, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (30, 205, '2021-04-30 12:59:00', NULL, '1', 'Subham', '', '', '7657577', '', 7, '', 'gfgfgfffgfg', 'approved', 'Offline', '2021-04-30 07:29:31', '', 'yes', NULL, 0, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (31, 7, '2021-04-26 00:00:00', '10:00:00', '', 'check', 'Male', '', '979797979', '2', 7, '', NULL, 'approved', 'Online', '2021-04-30 11:47:55', '', '', 1, 1, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (32, NULL, '2021-05-01 09:46:00', NULL, '2', 'navneet', 'Male', '', '9844562244', '', 17, '', 'ttttttttt', 'approved', 'Offline', '2021-05-01 04:17:32', '', '', NULL, 0, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (33, 6, '2021-05-01 10:06:00', NULL, '1', 'ayush', 'Male', '', '7657657466', '', 17, '', 'jhjgh jhjghj ghjg', 'approved', 'Offline', '2021-05-01 04:37:28', 'yes', 'yes', NULL, 0, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (34, NULL, '2021-05-01 13:01:00', NULL, '1', 'garima', 'Female', '', '777588589', '', 15, '', 'appointment ', 'pending', 'Offline', '2021-05-01 07:32:19', '', '', NULL, 0, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (35, 6, '2021-05-01 07:43:00', NULL, '1', 'ayush', 'Male', '', '9999999999', '', 7, '', 'kjklj', 'approved', 'Offline', '2021-05-01 07:44:52', '', '', NULL, 0, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (36, NULL, '2021-05-01 13:15:00', NULL, '1', 'tarun', 'Male', '', '43333', '', 17, '', 'ggg', 'pending', 'Offline', '2021-05-01 07:45:40', '', '', NULL, 0, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (46, 13, '2021-05-03 18:34:00', NULL, '', 'kanak', '', 'kanak@gmail.com', '9856598659', '', 3, '', 'dgdg', 'pending', 'Online', '2021-05-03 13:04:32', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (49, 17, '2021-05-05 12:54:00', NULL, '2', 'medal', 'Male', 'medal@gmail.com', '778994455', '', 7, '', 'urgent ', 'approved', 'Offline', '2021-05-05 07:25:33', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (50, NULL, '2021-05-06 13:09:00', NULL, '1', 'gaima test', 'Female', '', '74788589595', '', 7, '', 'test', 'pending', 'Offline', '2021-05-06 07:39:59', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (51, 18, '2021-05-06 00:00:00', '10:20:00', '', 'test', 'Male', 'test@gmail.com', '555555', '2', 7, '', NULL, 'pending', 'Online', '2021-05-06 08:21:56', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (52, 22, '2021-05-06 00:00:00', '10:30:00', '', '5april', 'Male', '5april@gmail.com', '445555', '2', 7, '', 'g', 'approved', 'Online', '2021-05-06 13:28:26', '', '', 1, 0, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (53, 32, '2021-05-08 11:13:00', NULL, '1', 'nodi', 'Male', 'garimarock01@gmail.com', '65678484994', '', 7, '', 'na', 'approved', 'Offline', '2021-05-08 05:44:53', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (54, 14, '2021-05-03 00:00:00', '10:20:00', '', 'ankit kumar', 'Male', 'ankit@gmail.com', '9586598659', '2', 7, '', NULL, 'pending', 'Online', '2021-05-08 05:49:15', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (55, 14, '2021-05-08 08:07:00', NULL, '', 'ankit kumar', '', 'ankit@gmail.com', '9586598659', '', 7, '', 'test', 'pending', 'Online', '2021-05-08 08:09:07', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (56, 33, '2021-05-04 00:00:00', '10:20:00', '', 'Sagar', 'Male', 'sagar.shrivastava889@gmail.com', '9691641840', '2', 7, '', NULL, 'pending', 'Online', '2021-05-08 08:28:58', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (57, 33, '2021-05-08 08:27:00', NULL, '', 'Sagar', '', 'sagar.shrivastava889@gmail.com', '9691641840', '', 7, '', 'test', 'pending', 'Online', '2021-05-08 08:29:27', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (58, 33, '2021-05-08 08:31:00', NULL, '1', 'Sagar', '', 'sagar.shrivastava889@gmail.com', '9691641840', '', 7, '', 'test', 'approved', 'Offline', '2021-05-08 08:32:57', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (59, 33, '2021-05-08 08:33:00', NULL, '1', 'Sagar', 'Male', 'sagar.shrivastava889@gmail.com', '9691641840', '', 7, '', 'test', 'approved', 'Offline', '2021-05-08 08:34:58', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (60, 33, '2021-05-08 08:48:00', NULL, '1', 'Sagar', 'Male', 'sagar.shrivastava889@gmail.com', '9691641840', '', 7, '', 'test', 'approved', 'Offline', '2021-05-08 08:49:43', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (61, NULL, '2021-05-08 14:55:00', NULL, '2', '8', 'Male', '', '444', '', 7, '', 'f', 'pending', 'Offline', '2021-05-08 09:25:46', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (63, NULL, '2021-05-08 15:14:00', NULL, '2', 'ravi das', 'Male', 'garimarock01@gmail.com', '6647488393', '', 24, '', 'appointment ', 'approved', 'Offline', '2021-05-08 09:44:50', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (64, NULL, '2021-05-08 15:17:00', NULL, '1', 'checkkkkk', 'Male', 'garimarock01@gmail.com', '2222', '', 7, '', '222', 'approved', 'Offline', '2021-05-08 09:48:00', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (66, 34, '2021-05-08 16:44:00', NULL, '1', 'kartik', 'Male', 'kartic@gmail.com', '895845845', '', 7, '', 'ytytrytryr', 'approved', 'Offline', '2021-05-08 11:14:57', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (68, 45, '2021-05-13 00:00:00', '10:20:00', '', 'h', 'Female', 'hg@hgj.ffg', '9754928606', '2', 7, '', NULL, 'pending', 'Online', '2021-05-12 11:42:55', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (114, 128, '2021-05-14 12:33:00', NULL, '1', 'kanna', '', '', '66666', '', 15, '', 'g', 'approved', 'Online', '2021-05-14 07:03:23', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (119, 135, '2021-05-10 00:00:00', '10:10:00', '', 'preeti', 'Female', 'preeti.pandey912@gmail.com', '9926226698', '2', 7, '', NULL, 'pending', 'Online', '2021-05-14 08:10:35', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (120, NULL, '2021-05-14 13:51:00', NULL, '1', 'r', 'Male', '', '44444', '', 7, '', '4', 'pending', 'Offline', '2021-05-14 08:21:53', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (121, NULL, '2021-05-14 14:16:00', NULL, '1', 'gg', '', '', '5555', '', 17, '', 'ggg', 'pending', 'Offline', '2021-05-14 08:47:02', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (122, 137, '2021-05-14 15:42:00', NULL, '', 'extra amount', '', 'garimarock01@gmail.com', '444', '', 17, '', 'bbb', 'approved', 'Online', '2021-05-14 10:12:20', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (123, NULL, '2021-05-14 17:06:00', NULL, '1', 'hh', 'Male', '', '6666', '', 24, '', 'hh', 'pending', 'Offline', '2021-05-14 11:36:26', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (124, 14, '2021-05-14 17:23:00', NULL, '1', 'ankit kumar', 'Male', 'garimarock01@gmail.com', '9586598659', '', 24, '', 'ff', 'approved', 'Offline', '2021-05-14 11:53:21', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (125, NULL, '2021-05-14 17:23:00', NULL, '1', 'ffff', 'Male', 'garimarock01@gmail.com', '555', '', 17, '', 'gg', 'approved', 'Offline', '2021-05-14 11:53:48', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (126, NULL, '2021-05-17 11:48:00', NULL, '1', 'ayush', 'Male', 'garimarock01@gmail.com6678', '66666', '', 7, '', 'vvv', 'approved', 'Offline', '2021-05-17 06:18:37', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (127, 24, '2021-05-17 11:51:00', NULL, '1', 'fffff', '', 'garimarock01@gmail.com', '333', '', 7, '', 'fff', 'approved', 'Offline', '2021-05-17 06:21:45', '', 'yes', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (128, 139, '2021-05-19 10:25:00', NULL, '1', 'mayank', 'Male', 'mayankpachouri.project@gmail.com', '8956598659', '', 25, '', 'tttttt', 'approved', 'Offline', '2021-05-19 04:55:02', '', 'yes', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (129, 139, '2021-05-20 10:36:00', NULL, '1', 'mayank', 'Male', 'mayankpachouri.project@gmail.com', '8956598659', '', 24, '', 'ttt', 'approved', 'Offline', '2021-05-19 05:06:48', 'yes', 'yes', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (130, 9, '2021-06-02 12:44:00', NULL, '1', 'satyam', 'Male', '', '8658658577', '', 7, '', 'ttrtrtteee', 'approved', 'Offline', '2021-06-02 07:14:55', 'yes', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (131, NULL, '2021-06-03 15:19:00', NULL, '1', 'rinki', 'Female', 'rinki@gmail.com', '33763637', '', 7, '', 'dfnvfndv', 'pending', 'Offline', '2021-06-03 09:49:51', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (132, NULL, '2021-06-03 15:19:00', NULL, '1', 'rinki', 'Female', 'rinki@gmail.com', '33763637', '', 7, '', 'dfnvfndv', 'pending', 'Offline', '2021-06-03 09:49:51', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (133, 165, '2021-06-03 15:20:00', NULL, '1', 'vhfbvhfhf', 'Male', 'garimarock01@gmail.com', '76576578', '', 7, '', 'fff', 'approved', 'Offline', '2021-06-03 09:52:13', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (134, NULL, '2021-06-17 11:15:00', NULL, '1', 'Srishti', 'Female', 'abc@gmail.com', '1234567890', '', 7, '', 'Appointment', 'pending', 'Offline', '2021-06-17 05:51:45', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (135, 184, '2021-06-17 19:30:00', NULL, '', 'Srishti', '', 'abc@gmail.com', '1234567890', '', 7, '', 'sgsgf', 'pending', 'Online', '2021-06-17 05:57:44', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (136, 184, '2021-06-17 11:25:00', NULL, '', 'Srishti', '', 'abc@gmail.com', '1234567890', '', 7, '', 'ddfbnbnbn', 'pending', 'Online', '2021-06-17 06:00:21', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (137, 184, '2021-06-18 11:26:00', NULL, '', 'Srishti', '', 'abc@gmail.com', '1234567890', '', 15, '', 'sgd', 'pending', 'Online', '2021-06-17 06:01:18', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (138, 187, '2018-09-10 00:00:00', '10:50:00', '', 'sameer', 'Female', 'superadmin@gmail.com', '1141397780', '3', 7, '', NULL, 'pending', 'Online', '2021-06-18 08:41:12', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (139, 192, '2021-06-18 14:56:00', NULL, '1', 'sam', '', '', '852741963', '', 24, '', 'ghgththb', 'approved', 'Offline', '2021-06-18 09:35:18', 'yes', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (140, 184, '2021-06-18 17:37:00', NULL, '', 'Srishti', '', 'abc@gmail.com', '1234567890', '', 7, '', 'dvd', 'pending', 'Online', '2021-06-18 12:08:06', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (141, 190, '2021-06-19 10:41:00', NULL, '1', 'harni', '', 'harni@gmail.com', '741258902', '', 24, '', 'test', 'approved', 'Online', '2021-06-19 05:20:08', 'yes', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (142, 191, '2021-06-19 11:12:00', NULL, '3', 'Surya Saxena', '', 'surya@gmail.com', '7418529630', '', 7, '', 'test', 'approved', 'Offline', '2021-06-19 05:53:18', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (143, 5, '2021-06-21 11:04:00', NULL, '1', 'ayush test', 'Male', 'ayush@gmail.com', '7418529630', '', 7, '', 'ergrtgtf', 'pending', 'Offline', '2021-06-21 05:44:45', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (144, 14, '2021-06-21 11:06:00', NULL, '1', 'ankit kumar', 'Male', 'rahul@gmail.com', '741852963', '', 7, '', 'ggftbtf', 'approved', 'Offline', '2021-06-21 05:46:11', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (145, 193, '2021-06-21 11:45:00', NULL, '', 'custom new', '', '', '', '', 24, '', 'sagdjchduch', 'pending', 'Online', '2021-06-21 06:24:47', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (146, 14, '2021-06-21 00:00:00', '10:00:00', '', 'ankit kumar', 'Male', 'ankit@gmail.com', '9586598659', '3', 7, '', NULL, 'approved', 'Online', '2021-06-21 06:30:50', '', '', 1, 1, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (147, 14, '2021-06-21 00:00:00', '10:00:00', '', 'ankit kumar', 'Male', 'ankit@gmail.com', '9586598659', '3', 7, '', NULL, 'pending', 'Online', '2021-06-21 06:34:58', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (148, 14, '2021-06-22 12:06:00', NULL, '1', 'ankit kumar', 'Male', 'ankit@gmail.com', '9586598659', '', 7, '', 'asdfsa', 'approved', 'Offline', '2021-06-21 06:36:17', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (149, 194, '2021-06-21 00:00:00', '10:20:00', '', 'ajay', 'Male', 'ajay@gmail.com', '34257477577', '2', 24, '', NULL, 'pending', 'Online', '2021-06-21 06:58:29', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (150, 194, '2021-06-21 00:00:00', '10:30:00', '', 'ajay', 'Male', 'ajay@gmail.com', '34257477577', '2', 24, '', NULL, 'pending', 'Online', '2021-06-21 06:59:53', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (151, 194, '2021-06-23 00:00:00', '17:10:00', '', 'ajay', 'Male', 'ajay@gmail.com', '34257477577', '3', 7, '', 'adsfa', 'approved', 'Online', '2021-06-21 07:07:50', '', '', 2, 0, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (152, 195, '2021-06-21 00:00:00', '10:00:00', '', 'akhil', 'Male', 'akhiluser@gmail.com', '9999999992', '2', 24, '', NULL, 'pending', 'Online', '2021-06-21 09:17:44', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (153, 196, '2021-06-21 00:00:00', '10:00:00', '', 'akhil', 'Male', 'akhialuser@gmail.com', '999997777', '2', 24, '', NULL, 'pending', 'Online', '2021-06-21 09:24:49', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (154, 197, '2021-06-21 00:00:00', '10:00:00', '', 'akhil', 'Male', 'akhiaaluser@gmail.com', '9999977771', '2', 24, '', NULL, 'pending', 'Online', '2021-06-21 09:28:51', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (155, 200, '2021-06-21 00:00:00', '10:00:00', '', 'cfgbfcb', 'Female', 'sadtfgdt@gmail.com', '741852963', '2', 24, '', NULL, 'pending', 'Online', '2021-06-21 09:38:38', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (156, 203, '2021-06-21 00:00:00', '10:00:00', '', 'sagar', 'Male', 'sagar.shrivastava@outlook.com', '9999889988', '2', 24, '', NULL, 'approved', 'Online', '2021-06-21 10:45:55', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (157, 203, '2021-06-21 00:00:00', '10:00:00', '', 'sagar', 'Male', 'sagar.shrivastava@outlook.com', '9999889988', '2', 24, '', NULL, 'pending', 'Online', '2021-06-21 10:47:50', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (158, 203, '2021-06-21 16:21:00', NULL, '1', 'sagar', 'Male', 'sagar.shrivastava@outlook.com', '9999889988', '', 7, '', 'asdfas', 'approved', 'Offline', '2021-06-21 10:51:44', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (159, 204, '2021-06-21 17:20:00', NULL, '1', 'discharge', 'Male', 'discharge', '7418529630', '', 7, '', 'dsfvcdd', 'approved', 'Offline', '2021-06-21 11:59:19', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (160, 206, '2021-06-25 17:53:00', NULL, '1', 'OPIP', 'Male', '', '7485963210', '', 10, '', 'NA', 'approved', 'Offline', '2021-06-21 12:32:53', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (161, 207, '2021-06-21 18:16:00', NULL, '1', 'bill summery ', 'Male', '', '7412525252', '', 24, '', 'tyhht', 'approved', 'Offline', '2021-06-21 12:55:13', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (162, 208, '2021-06-22 09:52:00', NULL, '1', 'test', 'Female', 'test@gmail.com', '7418529633', '', 7, '', 'test', 'approved', 'Offline', '2021-06-22 04:33:31', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (164, 209, '2021-06-22 11:32:00', NULL, '', 'ginni', '', 'ginni@gmail.com', '7896541230', '', 7, '', 'appointment', 'pending', 'Online', '2021-06-22 06:11:50', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (165, 209, '2021-06-22 12:05:00', NULL, '', 'ginni', '', 'ginni@gmail.com', '7896541230', '', 24, '', 'fdjhhfgbf', 'cancel', 'Online', '2021-06-22 06:44:06', 'yes', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (166, 209, '2021-06-09 12:18:00', NULL, '', 'ginni', '', 'ginni@gmail.com', '7896541230', '', 7, '', 'dscfsdf', 'cancel', 'Online', '2021-06-22 06:57:05', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (167, 209, '2021-06-22 12:27:00', NULL, '', 'ginni', '', 'ginni@gmail.com', '7896541230', '', 24, '', 'hnjghn', 'pending', 'Online', '2021-06-22 07:06:05', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (169, 222, '2022-06-22 00:00:00', '11:15:00', '', 'realme', 'Female', 'realme2gmail.com', '8525845632', '3', 7, '', 'gyhtyhg', 'approved', 'Online', '2021-06-22 09:43:43', 'yes', '', 1, 0, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (170, 212, '2022-06-22 00:00:00', '18:05:00', '', 'testpay', 'Male', 'test2gma', '7895461233', '3', 7, '', 'ddf', 'approved', 'Online', '2021-06-22 10:00:43', 'yes', '', 2, 0, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (171, 209, '2022-06-21 00:00:00', '11:00:00', '', 'ginni', 'Female', 'ginni@gmail.com', '7896541230', '2', 24, '', NULL, 'pending', 'Online', '2021-06-22 10:12:17', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (172, 213, '2022-06-22 00:00:00', '10:30:00', '', 'rinku', 'Female', 'test2gmail.com', '741258963', '2', 24, '', NULL, 'pending', 'Online', '2021-06-22 10:15:50', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (173, 191, '2021-06-22 00:00:00', '10:10:00', '', 'Surya Saxena', '', '', '', '2', 24, '', NULL, 'pending', 'Online', '2021-06-22 10:43:05', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (174, 191, '2021-06-22 00:00:00', '10:10:00', '', 'Surya Saxena', '', '', '', '2', 24, '', NULL, 'pending', 'Online', '2021-06-22 10:43:46', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (175, 191, '2022-06-20 00:00:00', '10:10:00', '', 'Surya Saxena', 'Male', 'surya@gmail.com', '7418529630', '2', 24, '', NULL, 'pending', 'Online', '2021-06-22 10:55:22', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (176, 215, '2022-06-20 00:00:00', '10:20:00', '', 'new patient', 'Male', 'newpadfasdfdsafatient@gmai.com', '8899889988', '2', 24, '', 'weqrew', 'approved', 'Online', '2021-06-22 10:56:53', '', '', 1, 0, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (177, 214, '2022-06-20 00:00:00', '10:10:00', '', 'check', 'Female', 'check@gmail.com', '741258963254', '2', 24, '', NULL, 'pending', 'Online', '2021-06-22 11:04:46', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (178, 216, '2022-06-20 00:00:00', '11:00:00', '', 'tanu', 'Male', 'tanu12@gmail.com', '741852369', '2', 24, '', NULL, 'pending', 'Online', '2021-06-22 11:07:35', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (179, 217, '2022-06-21 00:00:00', '11:50:00', '', 'FFV', 'Male', 'FDVFDV@GMAIL.COM', '0223585252', '2', 24, '', NULL, 'pending', 'Online', '2021-06-22 11:34:08', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (180, 218, '2022-06-22 00:00:00', '11:00:00', '', 'GFFBGB', 'Female', 'FGBFGF@GMAIL.COM', '5855', '2', 24, '', NULL, 'pending', 'Online', '2021-06-22 11:34:56', '', '', 1, 0, '');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (181, 219, '2022-06-22 00:00:00', '11:00:00', '', 'dfvgf', 'Male', 'fvfdvd@gmail.com', '7894561582', '2', 24, '', 'd', 'cancel', 'Online', '2021-06-22 11:37:18', '', '', 1, 0, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (182, 219, '2021-06-22 17:01:00', NULL, '', 'dfvgf', '', 'fvfdvd@gmail.com', '7894561582', '', 7, '', 'fdd', 'pending', 'Online', '2021-06-22 11:40:39', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (183, 206, '2021-06-22 18:17:00', NULL, '', 'OPIP', '', '', '7485963210', '', 25, '', 'yjyuj', 'pending', 'Online', '2021-06-22 12:56:25', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (184, 220, '2022-06-22 00:00:00', '11:15:00', '', 'dfgfdgfd', 'Female', 'df@gmail.com', '789785455', '3', 7, '', 'c', 'approved', 'Online', '2021-06-22 13:09:35', 'yes', '', 1, 0, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (185, 221, '2021-06-23 10:07:00', NULL, '1', 'Wednesday ', 'Female', 'wed@gmail.com', '7418529630', '', 7, '', 'sgdd', 'approved', 'Offline', '2021-06-23 04:46:34', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (186, 184, '2021-06-25 11:47:00', NULL, '', 'Srishti', '', 'abc@gmail.com', '1234567890', '', 24, '', 'ghhdd', 'pending', 'Online', '2021-06-25 06:19:18', '', '', NULL, NULL, 'yes');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (187, 14, '2021-06-26 15:07:00', NULL, '2', 'ankit kumar', 'Male', 'newemail@email.com', '9988776655', '', 7, '', 'new message', 'pending', 'Offline', '2021-06-26 09:38:46', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (188, 14, '2021-06-26 15:19:00', NULL, '1', 'ankit kumar', 'Male', 'ankit@gmail.com', '9586598659', '', 7, '', 'message test edit', 'pending', 'Offline', '2021-06-26 09:50:18', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (189, 226, '2021-06-30 11:42:00', NULL, '1', 'pathology', '', '', '7896541230', '', 7, '', 'pathology', 'approved', 'Offline', '2021-06-30 06:21:39', '', '', NULL, NULL, 'no');
INSERT INTO `appointment` (`id`, `patient_id`, `date`, `time`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `shift_id`, `is_queue`, `live_consult`) VALUES (194, 231, '2021-07-01 10:41:00', NULL, '1', 'Thursday ', '', '', '852741963', '', 7, '', 'na', 'approved', 'Offline', '2021-07-01 05:11:50', 'yes', '', NULL, NULL, 'no');


#
# TABLE STRUCTURE FOR: appointment_payment
#

DROP TABLE IF EXISTS `appointment_payment`;

CREATE TABLE `appointment_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `paid_amount` float(10,2) NOT NULL,
  `payment_mode` varchar(50) NOT NULL,
  `payment_type` varchar(100) NOT NULL,
  `transaction_id` varchar(100) NOT NULL,
  `note` varchar(100) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `appointment_payment` (`id`, `appointment_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (1, 54, '300.00', 'Billplz', 'Online', 'ypddym0e', 'Payment deposit through Billplz TXN ID: ypddym0e', '2021-05-08 05:51:34');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (2, 146, '100.00', 'Paytm', 'Online', '20210621111212800110168560402755627', 'Payment deposit through Paytm TXN ID: 20210621111212800110168560402755627', '2021-06-21 12:03:40');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (3, 156, '100.00', 'Billplz', 'Online', 'ydeag20t', 'Payment deposit through Billplz TXN ID: ydeag20t', '2021-06-21 16:20:14');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (4, 164, '100.00', 'Billplz', 'Online', 'dmzfbsp9', 'Payment deposit through Billplz TXN ID: dmzfbsp9', '2021-06-22 11:52:19');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (5, 164, '100.00', 'Billplz', 'Online', 'dmzfbsp9', 'Payment deposit through Billplz TXN ID: dmzfbsp9', '2021-06-22 12:10:01');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (6, 165, '100.00', 'Billplz', 'Online', 'aftkeggj', 'Payment deposit through Billplz TXN ID: aftkeggj', '2021-06-22 12:14:43');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (7, 181, '100.00', 'Stripe', 'Online', 'ch_1J57x6GufJyZiUEptGlSUvLl', 'Payment deposit through Stripe TXN ID: ch_1J57x6GufJyZiUEptGlSUvLl', '2021-06-22 17:09:37');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (8, 182, '150.00', 'Billplz', 'Online', 'hmo0j036', 'Payment deposit through Billplz TXN ID: hmo0j036', '2021-06-22 17:11:39');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (9, 182, '150.00', 'Billplz', 'Online', 'hmo0j036', 'Payment deposit through Billplz TXN ID: hmo0j036', '2021-06-22 17:11:46');
INSERT INTO `appointment_payment` (`id`, `appointment_id`, `paid_amount`, `payment_mode`, `payment_type`, `transaction_id`, `note`, `date`) VALUES (10, 176, '100.00', 'Billplz', 'Online', 'unjzek4k', 'Payment deposit through Billplz TXN ID: unjzek4k', '2021-06-22 17:13:22');


#
# TABLE STRUCTURE FOR: appointment_queue
#

DROP TABLE IF EXISTS `appointment_queue`;

CREATE TABLE `appointment_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `global_shift_id` int(11) DEFAULT NULL,
  `date` date NOT NULL DEFAULT '2021-01-11',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `appointment_id` (`appointment_id`),
  KEY `staff_id` (`staff_id`),
  KEY `global_shift_id` (`global_shift_id`),
  CONSTRAINT `appointment_queue_ibfk_1` FOREIGN KEY (`appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_queue_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_queue_ibfk_3` FOREIGN KEY (`global_shift_id`) REFERENCES `global_shift` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `appointment_queue` (`id`, `appointment_id`, `staff_id`, `position`, `global_shift_id`, `date`, `created_at`) VALUES (1, 146, 7, 1, 1, '2021-06-21', '2021-06-26 10:55:00');


#
# TABLE STRUCTURE FOR: bed
#

DROP TABLE IF EXISTS `bed`;

CREATE TABLE `bed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `bed_type_id` int(11) NOT NULL,
  `bed_group_id` int(11) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bed_type_id` (`bed_type_id`),
  KEY `bed_group_id` (`bed_group_id`),
  CONSTRAINT `bed_ibfk_1` FOREIGN KEY (`bed_type_id`) REFERENCES `bed_type` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bed_ibfk_2` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8;

INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (1, 'A1', 2, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (2, 'A2', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (3, 'A3', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (4, 'A4', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (6, 'A5', 1, 5, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (7, 'A6', 3, 2, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (8, 'A7', 3, 2, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (9, 'A8', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (10, 'A9', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (11, 'A10', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (12, 'B1', 1, 2, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (13, 'B2', 1, 2, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (14, 'B3', 1, 2, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (15, 'B4', 1, 2, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (16, 'B5', 1, 2, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (17, 'B6', 1, 2, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (18, 'B7', 1, 2, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (19, 'covid', 1, 7, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (20, 'A12', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (21, 'A13', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (22, 'A14', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (23, 'ccv', 2, 7, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (24, 'testing bed', 1, 7, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (25, 'g', 2, 7, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (26, 'test 1', 1, 7, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (27, 'test 2', 1, 7, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (28, 'test 3', 1, 7, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (29, 'A11', 1, 2, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (30, 'new bed', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (31, 'small bed', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (32, 'private bed', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (33, 'covid bed', 3, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (34, 'bed new', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (35, 'first', 1, 3, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (36, 'RAHUL TEST BED', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (37, 'AB1', 1, 1, 'no');


#
# TABLE STRUCTURE FOR: bed_group
#

DROP TABLE IF EXISTS `bed_group`;

CREATE TABLE `bed_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `floor` int(11) NOT NULL,
  `is_active` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`, `created_at`) VALUES (1, 'G1', '', 1, 1, '2021-04-29 16:16:14');
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`, `created_at`) VALUES (2, 'F1', '', 2, 1, '2021-04-29 16:16:14');
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`, `created_at`) VALUES (3, 'S1', '', 3, 1, '2021-04-29 16:16:14');
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`, `created_at`) VALUES (4, 'G1', '', 2, 1, '2021-04-29 16:16:14');
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`, `created_at`) VALUES (5, 'F2', '', 3, 1, '2021-04-29 16:16:14');
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`, `created_at`) VALUES (6, 'test', 'fvv', 3, 1, '2021-04-29 16:16:14');
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`, `created_at`) VALUES (7, 'covid ward', '', 3, 0, '2021-04-29 16:16:14');


#
# TABLE STRUCTURE FOR: bed_type
#

DROP TABLE IF EXISTS `bed_type`;

CREATE TABLE `bed_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `bed_type` (`id`, `name`) VALUES (1, 'Single');
INSERT INTO `bed_type` (`id`, `name`) VALUES (2, 'Normal');
INSERT INTO `bed_type` (`id`, `name`) VALUES (3, 'Double ');


#
# TABLE STRUCTURE FOR: birth_report
#

DROP TABLE IF EXISTS `birth_report`;

CREATE TABLE `birth_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `child_name` varchar(200) NOT NULL,
  `child_pic` varchar(200) NOT NULL,
  `gender` varchar(200) NOT NULL,
  `birth_date` datetime DEFAULT NULL,
  `weight` varchar(200) NOT NULL,
  `mother_name` varchar(200) NOT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `contact` varchar(20) NOT NULL,
  `mother_pic` varchar(200) NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `father_pic` varchar(200) NOT NULL,
  `birth_report` mediumtext NOT NULL,
  `document` varchar(200) NOT NULL,
  `address` text NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  CONSTRAINT `birth_report_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `mother_name`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (1, 'hani', 'uploads/patient_images/no_image.png', 'Male', '2021-04-26 16:42:00', '1', '3', NULL, '8956859869', 'uploads/patient_images/no_image.png', 'ffff', 'uploads/patient_images/no_image.png', 'ddd', '', 'jbp', 'yes', '2021-04-29 16:11:14');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `mother_name`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (2, 'test', 'uploads/birth_image/2/child_img2.jpg', 'Female', '2021-04-27 15:10:00', '100', '10', NULL, '777888999', 'uploads/birth_image/2/mother_pic2.jpg', '22', 'uploads/birth_image/2/father_pic2.jpg', '22 rrrr', '', 'test', 'yes', '2021-05-07 09:03:24');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `mother_name`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (4, 'nishu', 'uploads/patient_images/no_image.png', 'Male', '2021-05-27 17:38:00', '5', '10', 55, '', 'uploads/patient_images/no_image.png', '', 'uploads/patient_images/no_image.png', '', '', '', 'yes', '2021-05-27 12:08:55');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `mother_name`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (7, 'aasdf', 'uploads/patient_images/no_image.png', 'Male', '2021-06-28 17:04:00', '40', '22', 12, '9999889988', 'uploads/patient_images/no_image.png', '', 'uploads/patient_images/no_image.png', '', '', 'addrss', 'yes', '2021-06-28 11:34:23');


#
# TABLE STRUCTURE FOR: blood_bank_products
#

DROP TABLE IF EXISTS `blood_bank_products`;

CREATE TABLE `blood_bank_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `is_blood_group` int(11) DEFAULT '1',
  `volume` varchar(100) DEFAULT NULL,
  `charge_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `charge_unit_id` (`charge_unit_id`),
  CONSTRAINT `blood_bank_products_ibfk_1` FOREIGN KEY (`charge_unit_id`) REFERENCES `charge_units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `volume`, `charge_unit_id`, `created_at`) VALUES (17, 'B-', 1, NULL, NULL, '2021-05-31 08:52:22');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `volume`, `charge_unit_id`, `created_at`) VALUES (18, 'ggg', 1, NULL, NULL, '2021-06-03 09:32:06');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `volume`, `charge_unit_id`, `created_at`) VALUES (19, 'api', 1, NULL, NULL, '2021-06-21 10:36:29');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `volume`, `charge_unit_id`, `created_at`) VALUES (20, 'RBC', 2, NULL, NULL, '2021-06-23 05:28:26');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `volume`, `charge_unit_id`, `created_at`) VALUES (21, 'A+', 1, NULL, NULL, '2021-06-28 08:35:43');


#
# TABLE STRUCTURE FOR: blood_donor
#

DROP TABLE IF EXISTS `blood_donor`;

CREATE TABLE `blood_donor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `donor_name` varchar(100) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `gender` varchar(11) DEFAULT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `address` text,
  `contact_no` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  CONSTRAINT `blood_donor_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (7, 'srishti', '2021-06-18', 18, 'Female', 'rgdg', 'ghg', '35353536356', '2021-06-18 12:02:31');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (8, 'kavya', '2021-06-25', 18, 'Female', 'dhgcedu', '', '8527419630', '2021-06-21 09:20:58');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (9, 'ererfref', '2021-06-21', 18, 'Female', 'regre', 'rgregreg', '7418529630', '2021-06-21 09:21:47');


#
# TABLE STRUCTURE FOR: blood_donor_cycle
#

DROP TABLE IF EXISTS `blood_donor_cycle`;

CREATE TABLE `blood_donor_cycle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_donor_cycle_id` int(11) NOT NULL,
  `blood_bank_product_id` int(11) DEFAULT NULL,
  `blood_donor_id` int(11) DEFAULT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `donate_date` date DEFAULT NULL,
  `bag_no` varchar(11) DEFAULT NULL,
  `lot` varchar(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `standard_charge` float(10,2) DEFAULT NULL,
  `apply_charge` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `note` text,
  `discount_percentage` float(10,2) DEFAULT '0.00',
  `tax_percentage` float(10,2) DEFAULT '0.00',
  `volume` varchar(100) DEFAULT NULL,
  `unit` int(11) DEFAULT NULL,
  `available` int(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  KEY `blood_donor_id` (`blood_donor_id`),
  KEY `charge_id` (`charge_id`),
  CONSTRAINT `blood_donor_cycle_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_donor_cycle_ibfk_2` FOREIGN KEY (`blood_donor_id`) REFERENCES `blood_donor` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_donor_cycle_ibfk_3` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8;

INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (78, 0, NULL, 7, 7, '2021-06-11', '11', '11', 1, '1000.00', '1000.00', '1150.00', '', '', '0.00', '15.00', '1', 2, 0, '2021-06-21 05:38:02');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (79, 0, NULL, 8, 7, '2021-06-21', '010120', '1020', 1, '1000.00', '1000.00', '1035.00', 'naa', 'naaa', '10.00', '15.00', '100', 1, 0, '2021-06-21 09:22:20');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (80, 0, NULL, 7, 7, '2021-06-21', '0202', '10', 1, '1000.00', '1000.00', '1150.00', '', '', '0.00', '15.00', '102', 1, 0, '2021-06-21 09:23:42');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (81, 0, NULL, 8, 7, '2021-06-21', '1000', '2', 1, '1000.00', '1000.00', '1150.00', 'test', 'naa', '0.00', '15.00', '2', 2, 0, '2021-06-21 12:52:54');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (82, 0, NULL, 7, 7, '2021-06-22', '1231', '21a', 1, '1000.00', '1000.00', '1150.00', 'institution', 'afsdfa', '0.00', '15.00', '100', 1, 0, '2021-06-23 05:13:23');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (84, 0, NULL, 7, 7, '2021-07-01', '555', '1', 1, '1000.00', '1000.00', '1150.00', '', '', '0.00', '15.00', '350', 2, 0, '2021-06-25 10:31:31');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (86, 0, NULL, 7, 7, '2021-06-10', '3333', '', 1, '1000.00', '1000.00', '1150.00', '', '', '0.00', '15.00', '', 0, 0, '2021-06-28 08:50:06');


#
# TABLE STRUCTURE FOR: blood_issue
#

DROP TABLE IF EXISTS `blood_issue`;

CREATE TABLE `blood_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `blood_donor_cycle_id` int(11) NOT NULL,
  `date_of_issue` datetime DEFAULT NULL,
  `reference` varchar(200) DEFAULT NULL,
  `charge_id` int(11) NOT NULL,
  `standard_charge` int(11) NOT NULL,
  `tax_percentage` float(10,2) NOT NULL,
  `discount_percentage` float(10,2) DEFAULT '0.00',
  `amount` decimal(15,2) DEFAULT NULL,
  `net_amount` float(10,2) NOT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `technician` varchar(50) DEFAULT NULL,
  `remark` mediumtext,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `generated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `blood_donor_cycle_id` (`blood_donor_cycle_id`),
  KEY `patient_id` (`patient_id`),
  KEY `charge_id` (`charge_id`),
  CONSTRAINT `blood_issue_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_2` FOREIGN KEY (`blood_donor_cycle_id`) REFERENCES `blood_donor_cycle` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_4` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

INSERT INTO `blood_issue` (`id`, `patient_id`, `case_reference_id`, `blood_donor_cycle_id`, `date_of_issue`, `reference`, `charge_id`, `standard_charge`, `tax_percentage`, `discount_percentage`, `amount`, `net_amount`, `institution`, `technician`, `remark`, `created_at`, `generated_by`) VALUES (11, 184, NULL, 78, '2021-06-21 11:08:00', 'Denis ', 7, 1000, '15.00', '0.00', '1000.00', '1150.00', NULL, 'cb', '', '2021-06-21 05:38:35', 1);
INSERT INTO `blood_issue` (`id`, `patient_id`, `case_reference_id`, `blood_donor_cycle_id`, `date_of_issue`, `reference`, `charge_id`, `standard_charge`, `tax_percentage`, `discount_percentage`, `amount`, `net_amount`, `institution`, `technician`, `remark`, `created_at`, `generated_by`) VALUES (12, 206, NULL, 81, '2021-06-21 18:14:00', 'Ankit Khatri', 7, 1000, '15.00', '0.00', '1000.00', '1150.00', NULL, '', '', '2021-06-21 12:54:02', 1);
INSERT INTO `blood_issue` (`id`, `patient_id`, `case_reference_id`, `blood_donor_cycle_id`, `date_of_issue`, `reference`, `charge_id`, `standard_charge`, `tax_percentage`, `discount_percentage`, `amount`, `net_amount`, `institution`, `technician`, `remark`, `created_at`, `generated_by`) VALUES (13, 14, NULL, 79, '2021-06-23 10:49:00', 'Ankit Khatri', 7, 1000, '15.00', '0.00', '1000.00', '1150.00', NULL, 'sfda', 'asdf', '2021-06-23 05:21:05', 1);
INSERT INTO `blood_issue` (`id`, `patient_id`, `case_reference_id`, `blood_donor_cycle_id`, `date_of_issue`, `reference`, `charge_id`, `standard_charge`, `tax_percentage`, `discount_percentage`, `amount`, `net_amount`, `institution`, `technician`, `remark`, `created_at`, `generated_by`) VALUES (14, 3, NULL, 82, '2021-06-01 16:32:00', 'Ankit Khatri', 7, 1000, '15.00', '0.00', '1000.00', '1150.00', NULL, '', '', '2021-06-25 11:03:25', 1);


#
# TABLE STRUCTURE FOR: captcha
#

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (1, 'userlogin', 0, '2021-06-18 11:40:25');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (2, 'login', 0, '2021-06-26 11:32:37');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (3, 'appointment', 0, '2021-04-07 04:33:53');


#
# TABLE STRUCTURE FOR: case_references
#

DROP TABLE IF EXISTS `case_references`;

CREATE TABLE `case_references` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=222 DEFAULT CHARSET=utf8;

INSERT INTO `case_references` (`id`, `created_at`) VALUES (1, '2021-04-20 07:54:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (3, '2021-04-20 08:01:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (5, '2021-04-20 09:40:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (6, '2021-04-20 09:41:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (7, '2021-04-20 09:58:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (8, '2021-04-20 10:04:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (9, '2021-04-20 10:11:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (10, '2021-04-20 12:16:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (11, '2021-04-21 08:55:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (12, '2021-04-21 08:56:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (13, '2021-04-21 09:23:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (14, '2021-04-24 09:54:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (15, '2021-04-26 08:38:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (16, '2021-04-26 08:41:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (17, '2021-04-26 10:09:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (18, '2021-04-26 10:10:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (19, '2021-04-26 10:22:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (20, '2021-04-27 07:40:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (21, '2021-04-28 06:10:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (22, '2021-04-28 07:21:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (23, '2021-04-28 08:53:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (24, '2021-04-28 09:06:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (25, '2021-04-28 17:11:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (29, '2021-04-29 11:46:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (30, '2021-04-29 11:54:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (31, '2021-04-30 05:41:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (32, '2021-04-30 05:41:57');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (33, '2021-04-30 05:42:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (34, '2021-04-30 07:44:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (37, '2021-04-30 10:56:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (39, '2021-05-01 04:48:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (41, '2021-05-01 04:54:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (42, '2021-05-01 06:28:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (43, '2021-05-01 06:52:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (44, '2021-05-01 06:55:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (45, '2021-05-01 07:05:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (46, '2021-05-01 08:48:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (49, '2021-05-01 09:47:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (50, '2021-05-01 10:22:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (53, '2021-05-03 05:57:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (54, '2021-05-03 07:19:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (55, '2021-05-03 10:22:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (56, '2021-05-03 12:39:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (57, '2021-05-04 08:57:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (58, '2021-05-04 09:12:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (59, '2021-05-04 10:49:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (60, '2021-05-04 10:55:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (61, '2021-05-04 10:56:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (62, '2021-05-04 10:56:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (63, '2021-05-04 10:59:31');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (64, '2021-05-04 10:59:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (65, '2021-05-04 11:00:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (66, '2021-05-04 11:21:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (69, '2021-05-04 11:40:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (70, '2021-05-04 12:45:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (71, '2021-05-05 08:53:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (72, '2021-05-05 10:02:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (74, '2021-05-05 11:23:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (75, '2021-05-06 07:23:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (76, '2021-05-07 11:53:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (77, '2021-05-07 13:09:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (78, '2021-05-08 05:49:18');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (79, '2021-05-08 11:18:34');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (80, '2021-05-08 11:30:11');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (81, '2021-05-11 08:52:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (82, '2021-05-11 08:55:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (83, '2021-05-11 09:06:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (84, '2021-05-11 09:11:33');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (85, '2021-05-11 09:15:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (86, '2021-05-11 09:23:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (87, '2021-05-11 09:24:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (88, '2021-05-11 09:27:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (89, '2021-05-11 09:27:43');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (90, '2021-05-11 09:28:35');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (91, '2021-05-11 09:29:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (92, '2021-05-11 09:36:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (93, '2021-05-11 09:37:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (94, '2021-05-11 09:38:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (95, '2021-05-11 09:39:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (96, '2021-05-11 09:39:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (97, '2021-05-11 09:41:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (98, '2021-05-11 09:42:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (99, '2021-05-11 09:44:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (100, '2021-05-11 09:45:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (101, '2021-05-11 09:48:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (102, '2021-05-11 09:51:22');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (103, '2021-05-11 09:53:47');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (104, '2021-05-11 09:54:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (105, '2021-05-11 09:54:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (106, '2021-05-11 09:55:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (107, '2021-05-11 10:21:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (108, '2021-05-11 10:41:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (109, '2021-05-11 10:42:55');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (110, '2021-05-11 10:54:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (111, '2021-05-11 11:24:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (112, '2021-05-11 11:25:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (113, '2021-05-11 11:32:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (114, '2021-05-11 11:33:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (115, '2021-05-11 11:34:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (116, '2021-05-11 11:35:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (117, '2021-05-11 11:35:40');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (118, '2021-05-11 11:49:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (119, '2021-05-11 11:51:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (120, '2021-05-11 12:53:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (121, '2021-05-11 13:01:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (122, '2021-05-11 13:02:14');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (123, '2021-05-11 13:03:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (124, '2021-05-11 13:04:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (125, '2021-05-11 13:04:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (126, '2021-05-11 13:10:42');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (127, '2021-05-11 13:11:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (128, '2021-05-13 04:56:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (129, '2021-05-14 08:17:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (130, '2021-05-14 08:23:48');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (131, '2021-05-14 10:15:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (132, '2021-05-14 11:41:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (133, '2021-05-18 04:46:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (134, '2021-05-18 04:56:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (135, '2021-05-18 06:41:04');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (136, '2021-05-18 06:56:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (137, '2021-05-19 04:39:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (138, '2021-05-19 05:05:03');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (139, '2021-05-31 04:46:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (140, '2021-06-02 06:06:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (141, '2021-06-02 06:07:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (142, '2021-06-02 16:37:45');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (144, '2021-06-03 06:19:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (145, '2021-06-03 06:30:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (146, '2021-06-03 06:59:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (147, '2021-06-03 07:00:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (148, '2021-06-03 07:02:06');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (151, '2021-06-03 09:35:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (152, '2021-06-04 07:07:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (153, '2021-06-04 09:34:39');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (154, '2021-06-14 05:50:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (155, '2021-06-17 06:02:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (156, '2021-06-17 06:12:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (157, '2021-06-17 06:14:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (158, '2021-06-17 14:12:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (159, '2021-06-17 14:18:19');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (160, '2021-06-17 14:45:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (161, '2021-06-17 15:38:10');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (162, '2021-06-17 15:43:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (163, '2021-06-17 15:45:30');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (164, '2021-06-17 15:46:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (165, '2021-06-17 15:54:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (166, '2021-06-17 15:56:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (167, '2021-06-17 15:57:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (168, '2021-06-17 15:58:59');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (169, '2021-06-17 16:00:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (170, '2021-06-17 16:04:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (171, '2021-06-18 05:13:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (172, '2021-06-18 09:53:29');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (173, '2021-06-18 10:12:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (174, '2021-06-18 11:34:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (175, '2021-06-18 13:04:52');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (176, '2021-06-18 15:20:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (177, '2021-06-19 05:41:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (178, '2021-06-19 06:00:24');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (179, '2021-06-19 06:29:13');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (180, '2021-06-19 06:30:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (181, '2021-06-19 06:33:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (182, '2021-06-19 06:43:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (183, '2021-06-19 06:44:38');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (184, '2021-06-19 10:57:20');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (185, '2021-06-19 11:41:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (186, '2021-06-21 06:25:58');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (187, '2021-06-21 09:34:07');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (188, '2021-06-21 09:48:02');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (189, '2021-06-21 09:58:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (190, '2021-06-21 09:59:26');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (191, '2021-06-21 10:04:28');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (192, '2021-06-21 10:05:17');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (193, '2021-06-21 10:07:05');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (194, '2021-06-21 10:07:27');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (195, '2021-06-21 10:42:09');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (196, '2021-06-21 11:51:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (197, '2021-06-21 12:00:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (198, '2021-06-21 12:22:25');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (199, '2021-06-21 12:35:12');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (200, '2021-06-21 12:55:56');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (201, '2021-06-22 04:34:50');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (202, '2021-06-22 06:53:21');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (203, '2021-06-22 11:17:49');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (204, '2021-06-22 11:21:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (205, '2021-06-22 11:24:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (206, '2021-06-22 13:13:15');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (207, '2021-06-23 04:51:16');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (208, '2021-06-23 09:35:00');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (209, '2021-06-26 11:01:23');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (210, '2021-06-28 16:36:01');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (211, '2021-06-28 16:43:08');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (212, '2021-06-29 04:46:51');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (213, '2021-06-29 06:03:54');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (214, '2021-06-30 04:42:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (215, '2021-06-30 06:22:37');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (216, '2021-06-30 08:31:41');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (217, '2021-06-30 09:15:46');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (218, '2021-06-30 10:13:44');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (219, '2021-06-30 11:21:53');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (220, '2021-06-30 11:39:32');
INSERT INTO `case_references` (`id`, `created_at`) VALUES (221, '2021-07-01 05:15:19');


#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text NOT NULL,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = patients',
  `status` tinyint(1) NOT NULL,
  `header_height` int(11) NOT NULL,
  `content_height` int(11) NOT NULL,
  `footer_height` int(11) NOT NULL,
  `content_width` int(11) NOT NULL,
  `enable_patient_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: charge_categories
#

DROP TABLE IF EXISTS `charge_categories`;

CREATE TABLE `charge_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type_id` int(11) NOT NULL,
  `name` varchar(200) NOT NULL,
  `description` mediumtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `charge_type_id` (`charge_type_id`),
  CONSTRAINT `charge_categories_ibfk_1` FOREIGN KEY (`charge_type_id`) REFERENCES `charge_type_master` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `created_at`) VALUES (1, 1, 'Pathology Charge', 'tttt', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `created_at`) VALUES (2, 2, 'Radiology Charge', 'tt', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `created_at`) VALUES (3, 8, 'OPD Doctor Charge', 'ttt', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `created_at`) VALUES (4, 8, 'OPD Visit Doctor Charge', 'uygfvvgh', '2021-05-07 13:32:10');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `created_at`) VALUES (5, 9, 'Blood bannk Charge', 'ddd', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `created_at`) VALUES (6, 15, 'IPD Admission Charge', 't', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `created_at`) VALUES (7, 18, 'ambulance', 'test\r\n', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `created_at`) VALUES (8, 1, 'other process ', 'nannnaa', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `created_at`) VALUES (10, 1, 'procedures', 'proceduresprocesduresprocesdu\r\n', '2021-06-22 13:15:01');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `created_at`) VALUES (11, 20, '678i76i8t67', 'i876i8768it78', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `created_at`) VALUES (12, 26, 'OPD Charge', 'Charge', NULL);


#
# TABLE STRUCTURE FOR: charge_type_master
#

DROP TABLE IF EXISTS `charge_type_master`;

CREATE TABLE `charge_type_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) CHARACTER SET latin1 NOT NULL,
  `is_default` varchar(10) CHARACTER SET latin1 NOT NULL,
  `is_active` varchar(10) CHARACTER SET latin1 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (1, 'Procedures', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (2, 'Investigations', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (3, 'Supplier', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (4, 'Operation Theatre', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (5, 'Others', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (6, 'Ward Charge', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (8, 'Doctor Charge', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (9, 'Blood Bank', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (14, 'Pathology ', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (15, 'IPD', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (16, 'Radiology', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (18, 'testing', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (19, 'test charge', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (20, '100', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (21, 'Procedures', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (22, 'Procedures', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (23, 'opd test ', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (26, 'OPD Charge', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (27, 'sdfsdfsdfds', 'no', 'yes');


#
# TABLE STRUCTURE FOR: charge_type_module
#

DROP TABLE IF EXISTS `charge_type_module`;

CREATE TABLE `charge_type_module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type_master_id` int(11) DEFAULT NULL,
  `module_shortcode` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8;

INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (9, 15, 'ipd');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (12, 16, 'ipd');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (27, 14, 'ipd');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (31, 19, 'ipd');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (33, 1, 'pathology');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (34, 2, 'radiology');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (35, 9, 'blood_bank');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (39, 16, 'pathology');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (41, 18, 'ambulance');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (42, 20, 'ambulance');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (43, 14, 'pathology');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (47, 20, 'blood_bank');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (48, 14, 'radiology');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (51, 22, 'ambulance');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (57, 22, 'pathology');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (58, 21, 'pathology');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (59, 20, 'pathology');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (60, 22, 'radiology');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (61, 21, 'radiology');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (62, 20, 'radiology');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (63, 19, 'radiology');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (65, 26, 'opd');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (67, 27, 'pathology');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (68, 27, 'radiology');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (69, 27, 'blood_bank');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`) VALUES (70, 27, 'ambulance');


#
# TABLE STRUCTURE FOR: charge_units
#

DROP TABLE IF EXISTS `charge_units`;

CREATE TABLE `charge_units` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `unit` varchar(50) DEFAULT NULL,
  `is_active` int(1) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (1, 'Nos', 1, '2021-04-11 07:34:17');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (2, 'Day', 1, '2021-04-11 07:34:08');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (8, 'Hour', 0, '2021-04-11 07:34:00');


#
# TABLE STRUCTURE FOR: charges
#

DROP TABLE IF EXISTS `charges`;

CREATE TABLE `charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_category_id` int(11) NOT NULL,
  `tax_category_id` int(11) NOT NULL,
  `description` mediumtext NOT NULL,
  `name` varchar(200) NOT NULL,
  `standard_charge` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `charge_unit_id` int(10) DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `charge_category_id` (`charge_category_id`),
  KEY `tax_category_id` (`tax_category_id`),
  CONSTRAINT `charges_ibfk_1` FOREIGN KEY (`charge_category_id`) REFERENCES `charge_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `charges_ibfk_2` FOREIGN KEY (`tax_category_id`) REFERENCES `tax_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `description`, `name`, `standard_charge`, `date`, `charge_unit_id`, `status`) VALUES (1, 1, 11, 'maleria', 'malaria', '500', '0000-00-00', 1, '');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `description`, `name`, `standard_charge`, `date`, `charge_unit_id`, `status`) VALUES (2, 2, 7, '', 'CT Scan', '1000', '0000-00-00', 1, '');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `description`, `name`, `standard_charge`, `date`, `charge_unit_id`, `status`) VALUES (3, 3, 12, '', 'OPD Doctor Charge', '500', '0000-00-00', 1, '');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `description`, `name`, `standard_charge`, `date`, `charge_unit_id`, `status`) VALUES (4, 4, 12, '', 'OPD Visit Doctor Charge', '500', '0000-00-00', 1, '');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `description`, `name`, `standard_charge`, `date`, `charge_unit_id`, `status`) VALUES (5, 1, 11, 'hdhf', 'Nimonia', '5000', '0000-00-00', 1, '');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `description`, `name`, `standard_charge`, `date`, `charge_unit_id`, `status`) VALUES (7, 5, 2, '', 'test', '1000', '0000-00-00', 1, '');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `description`, `name`, `standard_charge`, `date`, `charge_unit_id`, `status`) VALUES (10, 1, 2, 'test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb atest test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb atest test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb atest test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb a\r\ntest test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb atest test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb atest test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb atest test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb test test testb a\r\n', 'Bed Charge', '100', NULL, 1, '');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `description`, `name`, `standard_charge`, `date`, `charge_unit_id`, `status`) VALUES (11, 7, 9, '', 'test', '300', NULL, 12, '');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `description`, `name`, `standard_charge`, `date`, `charge_unit_id`, `status`) VALUES (12, 7, 9, '', 'ambulance', '500', NULL, 1, '');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `description`, `name`, `standard_charge`, `date`, `charge_unit_id`, `status`) VALUES (13, 7, 9, '', 'ambulance', '500', NULL, 1, '');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `description`, `name`, `standard_charge`, `date`, `charge_unit_id`, `status`) VALUES (14, 1, 6, '', 'OPD EXTRA CHARGES', '10', NULL, 1, '');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `description`, `name`, `standard_charge`, `date`, `charge_unit_id`, `status`) VALUES (15, 12, 2, '', 'OPD CHARGES', '100', NULL, 2, '');


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type_id` int(11) NOT NULL,
  `source` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `description` text NOT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `image` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `complaint_type_id` (`complaint_type_id`),
  CONSTRAINT `complaint_ibfk_1` FOREIGN KEY (`complaint_type_id`) REFERENCES `complaint_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `complaint` (`id`, `complaint_type_id`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`, `created_at`) VALUES (2, 1, 'Online ', 'garima', '789444', '', '2021-05-05', 'test ', 'yes', '', '', '', NULL);
INSERT INTO `complaint` (`id`, `complaint_type_id`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`, `created_at`) VALUES (3, 1, 'Online ', 'Jhon', '8521479630', '', '2021-06-21', '', '', '', '', '', NULL);
INSERT INTO `complaint` (`id`, `complaint_type_id`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`, `created_at`) VALUES (4, 1, 'Online ', 'Jhon', '8527419630', '', '2021-06-21', '', '8521749630', 'rtyh', '', '', NULL);
INSERT INTO `complaint` (`id`, `complaint_type_id`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`, `created_at`) VALUES (5, 1, 'Offline', 'new complain test edit', '9988776655 edit', '', '2021-06-24', 'new description edit', 'new action taken edit', 'new assigned edit', 'new note edit', 'id5.png', '2021-06-26 09:30:43');


#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (1, 'mmmmm', 'hhhh', '2021-05-01 10:20:19');


#
# TABLE STRUCTURE FOR: conference_staff
#

DROP TABLE IF EXISTS `conference_staff`;

CREATE TABLE `conference_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `conference_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (1, '2021-05-12 07:37:49', 52, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (2, '2021-05-12 07:48:00', 53, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (3, '2021-05-12 07:51:00', 54, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (4, '2021-05-12 07:51:13', 55, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (5, '2021-05-12 07:51:15', 56, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (6, '2021-05-12 07:53:16', 57, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (7, '2021-05-12 07:53:17', 58, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (8, '2021-05-12 07:55:19', 59, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (9, '2021-05-12 07:55:56', 60, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (10, '2021-05-12 07:56:18', 61, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (11, '2021-05-12 07:56:43', 62, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (12, '2021-05-12 07:57:21', 63, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (13, '2021-05-12 07:57:52', 64, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (14, '2021-05-12 07:58:25', 65, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (15, '2021-05-12 07:58:41', 66, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (16, '2021-05-12 08:00:10', 67, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (17, '2021-05-12 08:00:33', 68, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (18, '2021-05-12 08:00:59', 69, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (19, '2021-05-12 08:01:55', 70, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (20, '2021-05-12 08:02:15', 71, 26);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (21, '2021-05-13 07:21:13', 4, 7);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (22, '2021-05-13 07:21:13', 4, 8);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (23, '2021-05-24 05:40:26', 11, 3);
INSERT INTO `conference_staff` (`id`, `created_at`, `conference_id`, `staff_id`) VALUES (24, '2021-05-24 05:40:38', 12, 3);


#
# TABLE STRUCTURE FOR: conferences
#

DROP TABLE IF EXISTS `conferences`;

CREATE TABLE `conferences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purpose` varchar(200) NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) NOT NULL,
  `visit_details_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `created_id` int(11) DEFAULT NULL,
  `title` text NOT NULL,
  `date` datetime NOT NULL,
  `duration` int(11) NOT NULL,
  `password` varchar(100) NOT NULL,
  `host_video` int(11) NOT NULL,
  `client_video` int(11) NOT NULL,
  `description` mediumtext NOT NULL,
  `timezone` text NOT NULL,
  `return_response` text CHARACTER SET latin1 NOT NULL,
  `api_type` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8;

INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (1, 'consult', 17, 0, 53, 0, 1, 'Online consult for OPDN36 Checkup ID 53', '2021-05-13 10:26:00', 0, 'x37Um', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"saQIxp4wQTG0tqoc2k9Ybw==\",\"id\":79024695279,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for OPDN36 Checkup ID 53\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-05-13T04:56:51Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-05-13T04:56:51Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/79024695279?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiJrcC1FS1BzVFJuMS0tREJJM3BiUWZEVjh4S3czSGVuMlgxbFlqamxKVFpjLkFHLnY4cWd4LUVIcDFSQUdoc1l1bF9tQ3BXVWpCQVZpenpWb3ZMNk50bjRsUkE2NG5CVFBGTG92YnRITnpsdzM3YldaWVVGT3FoN2FDQk9MekZyLlpGUXZWME5YQ3pyem1reDlWek9raUEuMVdjeDdzUVlDZXVxdVRKeiIsImV4cCI6MTYyMDg4OTAxMSwiaWF0IjoxNjIwODgxODExLCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.sSZ8KtpXvfW-Jnk0_UtiMd9B-3UtR7ctuVvurXoUj2E\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/79024695279?pwd=MXRtN1dwdUczOFFSZVZGTVY5R1Bpdz09\",\"password\":\"x37Um\",\"h323_password\":\"414161\",\"pstn_password\":\"414161\",\"encrypted_password\":\"MXRtN1dwdUczOFFSZVZGTVY5R1Bpdz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-05-13 04:56:51');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (2, 'consult', 24, 16, 0, 12, 1, 'ttttt', '2021-05-13 11:44:00', 20, 'aXFFW', 1, 1, 'dgdgdgd', 'Asia/Kolkata', '{\"uuid\":\"ogIOCTpITlykgVx4g6HIHw==\",\"id\":77888936230,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"ttttt\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-05-13T06:15:27Z\",\"duration\":20,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-05-13T06:15:27Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/77888936230?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiIwUHNkTXBaX0wtNWdoNmd6ZUJKaUJKM2RBTENoUEdydGU4Mm16RzJxVkRJLkFHLktZRkZHTjluZ2VJbUlvbXNXeEYxVGYxbVF0cmtocnl0QXBMUkM4LTFZNXNhRlk5TlVPVWQ1Mk40QmFzdGFsTEMzdkpZODhFUEFpRFFVTmNDLkRiWW9hNW1yb2ZzUi1EQTV2SzZKb1EubGVCaTJKNHcxYV9pSDUwZiIsImV4cCI6MTYyMDg5MzcyNywiaWF0IjoxNjIwODg2NTI3LCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.XiZTNV-WcjiZbeOAaLYGTphw5LXwX7zH9KaAs7ujJ84\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/77888936230?pwd=OElSSzI3VkxFWk5UcTNMZHlCMDZtQT09\",\"password\":\"aXFFW\",\"h323_password\":\"648894\",\"pstn_password\":\"648894\",\"encrypted_password\":\"OElSSzI3VkxFWk5UcTNMZHlCMDZtQT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-05-13 06:15:27');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (3, 'consult', 24, 16, 53, 0, 1, 'tttrrree', '2021-05-13 11:59:00', 20, 'HAqgR', 1, 1, 'hfhfh', 'Asia/Kolkata', '{\"uuid\":\"lOWKYkhETv2z6a98LcgEGg==\",\"id\":76876959632,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Zoom Meeting\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-05-13T06:31:09Z\",\"duration\":20,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-05-13T06:31:09Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/76876959632?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiJ2QUNfMkxKUWVENHlBTE9kTXNNa0hzSllvN3QwTkRqeDBBdTJ2VmoyOUNBLkFHLjdCWjlQNFFRNmw4a0FlUEdxTFFyVHNMN2FpU2pQTHNXVGJsbm9pUnlWM2tRaUEtVk5STjgzaXFXdW00Y0Frd1JqZndZSzRxTjhhdFRRLUdjLnByZksyZXNOUGxoaEdvRTFld0Nhcncud2JoOTNfMVhWYlg0bzU1MCIsImV4cCI6MTYyMDg5NDY2OSwiaWF0IjoxNjIwODg3NDY5LCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.CZ63moi_6AjI1sXjOAW6Cbo80cNFRT1iqL86criKTeU\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/76876959632?pwd=eXB2a3R0Ujc5ZHFsdEdFME5WQzdhUT09\",\"password\":\"HAqgR\",\"h323_password\":\"410113\",\"pstn_password\":\"410113\",\"encrypted_password\":\"eXB2a3R0Ujc5ZHFsdEdFME5WQzdhUT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 2, '2021-06-08 11:28:29');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (6, 'consult', 7, 0, 54, 0, 1, 'Online consult for Revisit OPDN37', '2021-05-06 12:54:00', 0, 'ColQ4', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"tk7MocLTTr6qWR0vBqVLXg==\",\"id\":76780029324,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN37\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-05-14T08:17:18Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-05-14T08:17:18Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/76780029324?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiJGcFdVVGF4T3FQWFR0cExfRmNYQlUtakRGQW5CbnMwazV2LXBkbDZxUUNrLkFHLkRwZDhXck8tMXJWWEo4aUpQaHpTemw0TlZtLURHcmMwenptQTlLREJReUZndlZsMDNfbDhOOU1NaWFqWlF2QmlzYmk5SHJnVWprWmhmU2pFLjB2VjdFZlhHV2o1UWNMZ19RTnZOUGcuUVdRRUZZQ1RQWW1lUlFsdSIsImV4cCI6MTYyMDk4NzQzOCwiaWF0IjoxNjIwOTgwMjM4LCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.TybECy6INfiboCcaCQv9OwSYBvK7V1ZNH4obrZVRc8w\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/76780029324?pwd=a21RdkdzM3lzNFFTaUhYQklKZ1Nndz09\",\"password\":\"ColQ4\",\"h323_password\":\"859941\",\"pstn_password\":\"859941\",\"encrypted_password\":\"a21RdkdzM3lzNFFTaUhYQklKZ1Nndz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-05-14 08:17:18');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (7, 'consult', 17, 0, 56, 0, 1, 'Online consult for OPDN39 Checkup ID 56', '2021-05-14 15:42:00', 0, 'hKwjr', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"QPCtCcSLTqKZWZSy+65j4g==\",\"id\":73362453895,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for OPDN39 Checkup ID 56\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-05-14T10:15:55Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-05-14T10:15:55Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/73362453895?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiJSQzRBbUdfRFlsdzgxSVFrWE5MM045dEZ4eFByMk1pS0lSclBHVjhERGVzLkFHLi1ScVU4U3Rra01qZlJScUpHb0FNTDlQWXZodjRvR2ZKUDM0ck1pU1FCSHlBTE5NaW0waWtNVWVUTkxpR3otTEtEdDhlWEwtYUtNdy1Bc3JRLjRoNUxpNjV2YXNLZk5DVHZSRXBOc1EuT2V1VnhyaW84ellFeWdMViIsImV4cCI6MTYyMDk5NDU1NSwiaWF0IjoxNjIwOTg3MzU1LCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.09_hqEAXOv-cXl8S_F2cRIkB8aKDGku_GnObsh6A5ms\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/73362453895?pwd=Z3QrVGNUem1hVjlGenNHc2owWmlQUT09\",\"password\":\"hKwjr\",\"h323_password\":\"743729\",\"pstn_password\":\"743729\",\"encrypted_password\":\"Z3QrVGNUem1hVjlGenNHc2owWmlQUT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-05-14 10:15:55');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (8, 'consult', 24, 0, 57, 0, 1, 'Online consult for Revisit OPDN40', '2021-05-14 15:42:00', 0, '5RHcT', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"2aKil11STLqtCVijHqJHsg==\",\"id\":78620250469,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN40\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-05-14T11:41:02Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-05-14T11:41:02Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/78620250469?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiJCVGlRRTMtZjRCTHljbnQzNmhlZm5ObUJWdVR1QzVlREFYN3dESGtRMFlRLkFHLnBVdTYyVm9BWTN2TEtFVUdKMlpkS2o4ZFR5NjdSTzZHanNlVUFVNTFzZlE5WXBQMUVqSXFYWEM1RV9DZ1Npb0liRW00UkxGUy1tNWxNZV9TLlpfWGZpaDNLWVpyQTRxMWxlUGVrQlEuTnZSeUhLVlF4Wi1TdjNRdSIsImV4cCI6MTYyMDk5OTY2MiwiaWF0IjoxNjIwOTkyNDYyLCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.W7pygLCGDmGYPOJPldVwSQ0EvybN4iO8PUWoyXWQJdg\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/78620250469?pwd=Sjg2S2gzRGJDSmxLWWZZdnh6REJpZz09\",\"password\":\"5RHcT\",\"h323_password\":\"839192\",\"pstn_password\":\"839192\",\"encrypted_password\":\"Sjg2S2gzRGJDSmxLWWZZdnh6REJpZz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-05-14 11:41:02');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (9, 'consult', 7, 0, 58, 0, 1, 'Online consult for Checkup ID 58', '2021-05-06 12:54:00', 0, '', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"P1+rcyLeTfe3FXToq1qYvQ==\",\"id\":79267253848,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Checkup ID 58\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-05-15T11:27:31Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-05-15T11:27:31Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/79267253848?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiI2bEhFZHhENHJYUzRDLVg3UE1ETkxSLWJnT3J5bUYzOGpscEkzRGQ0bGNZLkFHLnltVWlQQWh6bFdHaHFKdUxtRFM0eEhGNmxDS2RNckZUdUpYQ3A4Ykx5RUZ0R2JXMlVMaWdhNzNkclluSVFZdFNSalpLeHN5MDJoUVBNM196LjItMEh6M0FWSW0tbjJpUmNURXdiZHcuRFd2aklfY3VJLWt4YjlGVCIsImV4cCI6MTYyMTA4NTI1MSwiaWF0IjoxNjIxMDc4MDUxLCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.a4rvz0isL_wG-JE0m1VODSkuZTxGodKdSqgboPqU06E\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/79267253848?pwd=VjloSHJYOXBkQWtMZTdnOHQzWFVvUT09\",\"password\":\"8ETTP5\",\"h323_password\":\"538690\",\"pstn_password\":\"538690\",\"encrypted_password\":\"VjloSHJYOXBkQWtMZTdnOHQzWFVvUT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-05-15 11:27:31');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (10, 'consult', 15, 0, 61, 0, 1, 'Online consult for Revisit OPDN43', '2021-05-08 11:13:00', 0, 'wxKuh', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"aY83Sp4rQQeLFkSjeCxMXQ==\",\"id\":77619719481,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN43\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-05-18T06:56:55Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-05-18T06:56:55Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/77619719481?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiI2T1pCSlRUMm5EOGJPTGRmdGY3VGlHUElDdzhjdU9WSktROU1URFZlRnBVLkFHLnVYbTZpWXBFS3RSa3N2ZFpXdVctT2J4VU1uUGRlYWFtc3hIb1JDNGVmbGpUWHRJd3Y0dTViWU9HejZaeC0yZ1gwNXBRbmM2SjRyLVNTelMwLnBVT3hkalRkRktCa0xQVVcyOUVZZlEucGY3aXVuNHFWNXQzaEVqTyIsImV4cCI6MTYyMTMyODIxNSwiaWF0IjoxNjIxMzIxMDE1LCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.lN0nCriHkiuj8bCSuVOK1SsiG4CIvhNLts1YJFLgfo4\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/77619719481?pwd=NlVkeGxsVHpyUkJJckhLQktkZ3UwQT09\",\"password\":\"wxKuh\",\"h323_password\":\"710059\",\"pstn_password\":\"710059\",\"encrypted_password\":\"NlVkeGxsVHpyUkJJckhLQktkZ3UwQT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-05-18 06:56:55');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (12, 'meeting', NULL, 0, 0, 0, 1, 'demo', '2021-05-24 11:09:00', 5, 'QUyNB', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"\\/dM4k7AYR0uo2blyUaRh\\/A==\",\"id\":74423259683,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"demo\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-05-24T05:40:38Z\",\"duration\":5,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-05-24T05:40:38Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/74423259683?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnQiLCJ1aWQiOiJPLURHVmhGR1Q5YUNZUE9fU3g1ZWlnIiwiaXNzIjoid2ViIiwic3R5IjoxLCJ3Y2QiOiJ1czA0IiwiY2x0IjowLCJzdGsiOiJTNER2dFJXdkhJUWZySUdva1J3Y0F4UHBNbVNoZnlNWXNkRzB4aG5UYW53LkFHLmdRN1d5M0FvemlfSG55UTFfNmE0cTlpblctT2M3NVJnMi1YS2ZZU01MdXlMTmF5VHRSZk1yTExaV2YxMVVhRE42N1BQaVd3bTNJdnRJRU1NLlE0eWQ0UUIyZUx2b0JzcmxGVE9FQ2cuOFhadEZwU2xWS1pFSlUyQiIsImV4cCI6MTYyMTg0MjAzOCwiaWF0IjoxNjIxODM0ODM4LCJhaWQiOiJSMXg0cnJDYlFFQzVDeVBSalB1MWNnIiwiY2lkIjoiIn0.In3qddIFloS0ckCkcE8xzD4ksknMjPrdgWZB-VmaoYE\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/74423259683?pwd=ejY1THJFOFRYMU1oZlE1RGxhNVJ3QT09\",\"password\":\"QUyNB\",\"h323_password\":\"435800\",\"pstn_password\":\"435800\",\"encrypted_password\":\"ejY1THJFOFRYMU1oZlE1RGxhNVJ3QT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 1, '2021-06-30 16:58:17');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (13, 'consult', 7, 0, 71, 0, 1, 'Online consult for Revisit OPDN53', '2021-06-04 12:36:00', 0, '2as2I', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"UcoARrOCRueAQVbxLerZQQ==\",\"id\":76279720255,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN53\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-04T09:34:40Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-04T09:34:40Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/76279720255?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IkhNMWJkOTBYanA1dmFDWTB3aW16Z0gxeWg0alMtRVNuNmIwRmpNMndvancuQUcuUEZ3bmZXeVNNVXBhb2NkR3RURGN5RjZCTElhc0htVE1INkd1bW5ZUlg0dnJoSGU5SXdzMkoyb1R6X1IwbzRZbThsb2Vpczlkd0p1WEFOeGsuNUlzcUNNekVmbDc5dVhTQ3ZodGZTQS5ueFdwS2hhT1UzU0o3UkJjIiwiZXhwIjoxNjIyODA2NDgwLCJpYXQiOjE2MjI3OTkyODAsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.eO1q_mYIaWL5_9IQXSiEYPqknduyXhqFzC8WexNU6zs\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/76279720255?pwd=b1FCWnJlVXozZno0YVJlTnRIaWtzdz09\",\"password\":\"2as2I\",\"h323_password\":\"166434\",\"pstn_password\":\"166434\",\"encrypted_password\":\"b1FCWnJlVXozZno0YVJlTnRIaWtzdz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-04 09:34:40');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (14, 'consult', 7, 0, 72, 0, 1, 'Online consult for Checkup ID 72', '2021-05-04 18:08:00', 0, '', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"c+qNFkjOStupUvZUNLf0DA==\",\"id\":73433118452,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Checkup ID 72\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-04T10:13:12Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-04T10:13:12Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/73433118452?zak=eyJ6bV9za20iOiJ6bV9vMm0iLCJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IkxkdWZCUzJPMExUM3lMWlRMaTI4STQ4UWJwVVBmczNXQV80MDJ3aUhHcW8uQUcuRDRwZWoydzFaZHBjZ2U2anFoVUVabm5mQkJONGhhekNINk05ZWktbUF4YjA3al9lYVYybi0wamNMYW9TeFJKYjdPQ3E3MTB1azlkT3VHZWQueXFsZHd5RzY1TnpXMFhZWmpVUE9OUS5FcUJJVXAzNE1ud1dWZmM5IiwiZXhwIjoxNjIyODA4NzkyLCJpYXQiOjE2MjI4MDE1OTIsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.ptSQTOb1F5dhUx1vvv7hEkzOnvdxHgm1fD3Wo1TbtO8\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/73433118452?pwd=OHBpZWlVdlhrVE1MTDhPYUV1YWFodz09\",\"password\":\"39A3bF\",\"h323_password\":\"670563\",\"pstn_password\":\"670563\",\"encrypted_password\":\"OHBpZWlVdlhrVE1MTDhPYUV1YWFodz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-04 10:13:12');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (15, 'consult', 17, 0, 75, 0, 1, 'Online consult for Revisit OPDN56', '2021-06-18 11:27:00', 0, 'zM43j', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"8EeGHjG6ShS+Pc\\/6AhABqA==\",\"id\":78219525493,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN56\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-18T00:27:00Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-17T06:12:26Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/78219525493?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IjZibFVxYnp6N3E3MXdoTEEtLW1LY0s0d0dWQzZfWV9Gb3g0a3ZJZTUwX0EuQUcuR1BfZ3dwZkI2UGJFWGFpR2RXazNjM21iZXlSZkJFMGZCUkNMZG1wV2RzcVNka2hzWWFjZkNMU2JZcmliTkNYSU9FTW9QSFpaNGxsX2VBeEsuc3lNcWp1ZWpZWGJ1WmY1b3FoSTBPUS5CM0VKUFYtbjBUNlZJQ296IiwiZXhwIjoxNjIzOTE3NTQ2LCJpYXQiOjE2MjM5MTAzNDYsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.Wq2FL2hI1BEPAef-QfbFZ4wnnGyrgpj3aj5rxaOQVPI\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/78219525493?pwd=OGlSanlEQTdQSS83V0U4Ny9XbWdBdz09\",\"password\":\"zM43j\",\"h323_password\":\"628814\",\"pstn_password\":\"628814\",\"encrypted_password\":\"OGlSanlEQTdQSS83V0U4Ny9XbWdBdz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-17 06:12:27');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (16, 'consult', 24, 0, 0, 38, 1, 'Online consult for IPDN38', '2021-06-18 11:39:00', 0, 'EBg8o', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"\\/YYOnhMOQ6WplawtrznILQ==\",\"id\":75618047727,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for IPDN38\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-18T00:39:00Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-17T06:14:52Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/75618047727?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6InpINW83bklvQ3lxSmh1V3FRWWJsS1BHUjJRemx2emJPU29JNmR6WlBEZ2MuQUcuTHdhZm9Ic1R5QS1PSzJZRm5ya3lnbmZiQ0JMOW92ZTlWbDBwRFdtMENuUnpNa3NRZGxxYjFjdERBakVHT0kwc3ZRNWMxTVpxM1hVN3hpbF8uU01VSkZFMy1jT0Rkb0FEdW9HYmZFdy4tS25wWW94QlBWV0FLWEZaIiwiZXhwIjoxNjIzOTE3NjkyLCJpYXQiOjE2MjM5MTA0OTIsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.PetE-JLHxHZspZNUkEDg1K_Tyua2IU2XMzhALZD-u5w\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/75618047727?pwd=b1lXZjM5bzMrZUw5eXNYY05SVThhZz09\",\"password\":\"EBg8o\",\"h323_password\":\"168560\",\"pstn_password\":\"168560\",\"encrypted_password\":\"b1lXZjM5bzMrZUw5eXNYY05SVThhZz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-17 06:14:52');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (17, 'consult', 7, 0, 92, 0, 1, 'Online consult for Checkup ID 92', '2021-06-18 15:32:00', 0, '', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"tttn1D\\/8Q5e0384iXYZkdg==\",\"id\":71189360186,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Checkup ID 92\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-18T10:29:10Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-18T10:29:10Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/71189360186?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IjlYWm1WaHFZNGoyaW4xV29MTXdlR0IyMjVVQWJ0cFZNRFhxank4TlQzcTAuQUcuVW54WUZsc1JmZ25hbGVRQ2oybHJYN05UbTVjVWlCM2U5UnVQeGhTS2E2WXNCdzZqYXUzV3JZNUxUVzdRdWFDRm9hZWd4azAxeEM0QXFkQTcuTVJvOFpNRS0yLVUtcFNkZmc1QzVxdy4za2NCN1lxQUdaM1NiZmxUIiwiZXhwIjoxNjI0MDE5MzUwLCJpYXQiOjE2MjQwMTIxNTAsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.7dMlmBVdHdzkKBO9ACCZyzLQpehkyi-egkVuVsPQ_MI\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/71189360186?pwd=aFRCcWswbnUrNGtLZUEzLzlqOWRXQT09\",\"password\":\"Kk5SmK\",\"h323_password\":\"834433\",\"pstn_password\":\"834433\",\"encrypted_password\":\"aFRCcWswbnUrNGtLZUEzLzlqOWRXQT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-18 10:29:10');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (18, 'consult', 15, 0, 93, 0, 1, 'Online consult for Checkup ID 93', '2021-06-18 15:14:00', 0, '', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"ksDuERGcQ9OLrEuuWYux5g==\",\"id\":73862718922,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Checkup ID 93\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-18T11:04:02Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-18T11:04:02Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/73862718922?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IlBSTUZVQWN5aVVzaU5Zb05VMklzSXh0bGU3anBSeUdQa3pac3FBbzk2UTguQUcueWZLSTdGVFJKbUtOV2Z1MjRqdVBaY0R4NmV5QnEtajFiMGlXeUZuNnNWNi03RjdKWVlXekQxZ21TTU5oSHRGZGxFdWFJSzYtMTlIUU9OcS0uZTRDeEVGU0tUVnNjdXlKQjRzUmlWdy5vaXhDcWg3WWE4bVpOcnNNIiwiZXhwIjoxNjI0MDIxNDQyLCJpYXQiOjE2MjQwMTQyNDIsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.YxcO2RAQ4jZDjOgZ6zGjkd3y20TwIwgizA7MH-zHeD8\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/73862718922?pwd=MjdzTzdyMzlQZFA5VEdlWjk5TEk0UT09\",\"password\":\"NsCST4\",\"h323_password\":\"436504\",\"pstn_password\":\"436504\",\"encrypted_password\":\"MjdzTzdyMzlQZFA5VEdlWjk5TEk0UT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-18 11:04:02');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (19, 'consult', 7, 184, 74, 0, 1, 'gdsgds', '2021-06-18 17:37:00', 1, '3vH7U', 1, 1, 'ss', 'Asia/Kolkata', '{\"uuid\":\"eoYsk+HxTkStBmEMe+XchA==\",\"id\":71109663360,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"gdsgds\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-18T12:07:31Z\",\"duration\":1,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-18T12:07:31Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/71109663360?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IlVsU0dpODhNcTBJRUF2dHJuUHNjZTFZbURRdGNaNnd2RnAycGhXN2gyVkkuQUcuUGxFZW9fWmdwTGZQdEphM2dUdWE0LUhJSGFBT2NTd0c3UFFKR3FLRmFVVTllTTdyclRDOFRsX2hmUzJaY2l0REhPZGpXMjZkSWJ4LVBGZUEucVUzVEwyWWsyY1JVdGhKSTJlYTM4QS5CZVRsbVlWaktqN0RkTkhQIiwiZXhwIjoxNjI0MDI1MjUxLCJpYXQiOjE2MjQwMTgwNTEsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.CoykacCgPCOvZaceGEqCZtmOKyXe_IauRreE7dd7DrQ\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/71109663360?pwd=K3FPMjJqZkJiemdOVmtZWjFjNjFBZz09\",\"password\":\"3vH7U\",\"h323_password\":\"046750\",\"pstn_password\":\"046750\",\"encrypted_password\":\"K3FPMjJqZkJiemdOVmtZWjFjNjFBZz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-19 11:30:36');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (20, 'consult', 24, 0, 95, 0, 1, 'Online consult for Revisit OPDN74', '2021-06-18 16:55:00', 0, 'koma8', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"BHpT2UZ9SrOXMWAaxe+dmw==\",\"id\":77992517467,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN74\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-18T13:04:53Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-18T13:04:53Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/77992517467?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6Ijd2c3dUcFpTLV9Dc0F4bk1mQUNZdXhlQ09NSG1DYXVISlRHUjZESjVBU0UuQUcuank3amRHX3d6bzhlRENTbi10YTQwc3NDVGF1SUtDWWpfeFRSZmVsdGthLXdmLVlVSElxcllxcTZLVlcybXR5dVgyV1plaEwwYkd6Nm1oOGguY055NzFPd2dNYUVsRG5memVxcGdXQS5YaUtFN3pkNFpOTXJqZl9PIiwiZXhwIjoxNjI0MDI4NjkzLCJpYXQiOjE2MjQwMjE0OTMsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.Bl8i6QjCiIu3XsvXCExPvY3cy3W-0Yjjwh6KE1e-Fzg\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/77992517467?pwd=bmcrNEtnb3BXUHhWUUZydkFRNFYydz09\",\"password\":\"koma8\",\"h323_password\":\"103767\",\"pstn_password\":\"103767\",\"encrypted_password\":\"bmcrNEtnb3BXUHhWUUZydkFRNFYydz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-18 13:04:53');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (21, 'consult', 24, 0, 96, 0, 1, 'Online consult for Revisit OPDN75', '2021-06-25 16:55:00', 0, '92ezv', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"3qGdN0eMRJOHV93obyilAA==\",\"id\":76162094517,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN75\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-25T05:55:00Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-18T15:20:27Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/76162094517?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6Im5QWkU3cjU2RkFDNEdwMEstZjA0SlVmcUlNMUpYdVVZRFBueTZyckMtREUuQUcuWDFKZndKY3AxYnZRcTZPUy1iMVN1U2lrRUJEcG14eFpRREFrNGUyVEh2TTE4bm5tcEJ0V3NCaldsY2dXM2ZTakNBaTNpd0twYmVVOTR6VG8uQnB2ckVnYzZGUW50TmtHbjJOckFwZy51OW51dnhoZHZ3bE9lNWdjIiwiZXhwIjoxNjI0MDM2ODI3LCJpYXQiOjE2MjQwMjk2MjcsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.1CdJzRAtlJHv0GgeOPaxfOp8XfWR2tzTmljaVtwSdqU\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/76162094517?pwd=azJ1QkQycFV0MTJMdytSVjk2UlNNZz09\",\"password\":\"92ezv\",\"h323_password\":\"872871\",\"pstn_password\":\"872871\",\"encrypted_password\":\"azJ1QkQycFV0MTJMdytSVjk2UlNNZz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-18 15:20:27');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (22, 'consult', 24, 0, 97, 0, 1, 'Online consult for Checkup ID 97', '2021-06-25 16:55:00', 0, '', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"WBOn9nGhRBWAIE9QS50OGQ==\",\"id\":73498148196,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Checkup ID 97\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-25T05:55:00Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-18T15:40:36Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/73498148196?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6InZLbDcydHF3NGFOUUJNSTVQQ0NzVnVESnBja3pRNVUzeEkxSXA5SXFEU0UuQUcuZVhhVm9WXzB6Q3ZZbXJmckhTdEpzZmlUUjdfMFFRdTlCSkxqMDRkNjV6dmVKUDFtdHlUT2JIUHJna0VtTWo3VmpZZ1NhZEhtWGp0Z3B5dFcua0RQeWdzanU0ZHF4aC1fMk1URTNkZy54dExvNTd1eFNJWmpWZzh5IiwiZXhwIjoxNjI0MDM4MDM2LCJpYXQiOjE2MjQwMzA4MzYsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.rLIZjQ4jbXipZRiKTEEq_PU9IgoM_7MhOGvksncRWtM\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/73498148196?pwd=QnJheTRMZlhoZDFUUkRSN2dQdjRsdz09\",\"password\":\"3Bi9tQ\",\"h323_password\":\"692950\",\"pstn_password\":\"692950\",\"encrypted_password\":\"QnJheTRMZlhoZDFUUkRSN2dQdjRsdz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-18 15:40:36');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (23, 'consult', 17, 0, 98, 0, 1, 'Online consult for Checkup ID 98', '2021-06-25 16:55:00', 0, '', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"f7rvF8dIR+OUkv\\/sGVKGXQ==\",\"id\":74672290892,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Checkup ID 98\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-25T05:55:00Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-18T15:45:31Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/74672290892?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IkdRLXF6eWtwbGFGMzA2NkdqWndPVno1czBScDhTTDV4LXRabGFiSHdyX2suQUcuYzZuVkozVHdrTjYwWlpFVUFCUUNZZzZNS1hvaUR1dGI1NzFOamFqWm9iSWsxNDByZ3k2aXh6dVFlMUIySjlUSkQ1alJrVmVuYXNfa0JCVEsuSS1MemV6Um5nU2hjNWJ1WDBHQWFrZy45TFZ5eFdkR1lFdU44T3JwIiwiZXhwIjoxNjI0MDM4MzMxLCJpYXQiOjE2MjQwMzExMzEsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.x23D7hSSqep95tv2GMha4MPu84zaqi8uJcrON89KkBU\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/74672290892?pwd=eVFON0lDZXhkZmI1Y3BqWTNWVmZVQT09\",\"password\":\"1AEzyp\",\"h323_password\":\"476860\",\"pstn_password\":\"476860\",\"encrypted_password\":\"eVFON0lDZXhkZmI1Y3BqWTNWVmZVQT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-18 15:45:31');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (24, 'consult', 7, 0, 99, 0, 1, 'Online consult for Checkup ID 99', '2021-06-18 16:55:00', 0, '', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"+PrnsyvxQQKyNG2Ah8eIwA==\",\"id\":71600370530,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Checkup ID 99\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-18T16:41:52Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-18T16:41:52Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/71600370530?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IlZ6ZUlzeE9Va3M1djZTZFBlY2dQTFk1MjRfZVBCcUFSZ0xTT2FIcWpsNFkuQUcueS0yQ1NBY3BPeHVPdkRPTzVIckp6MFJwT3U0MEJrdHMtTzFDWkluOTB3YzZVS3ZKcHgzMjF2SG1QdS0tYW9objVuOTVLZU03RFkydXYxZnEuOXVDWk5hZVYxOHpMZ3pTNVQwM2hZQS5MaXhISHYwS2VyVW9kLXdvIiwiZXhwIjoxNjI0MDQxNzEyLCJpYXQiOjE2MjQwMzQ1MTIsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.gwstB2L1XJeMxit7nsvigKa-l4DHvrAyLL_213E6S4c\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/71600370530?pwd=T2R0bWRzSlNXdDN6VEpveG1sREQ2dz09\",\"password\":\"8maED1\",\"h323_password\":\"354923\",\"pstn_password\":\"354923\",\"encrypted_password\":\"T2R0bWRzSlNXdDN6VEpveG1sREQ2dz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-18 16:41:52');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (25, 'consult', 24, 0, 100, 0, 1, 'Online consult for OPDN76 Checkup ID 100', '2021-06-19 10:41:00', 0, 'Fcbsr', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"3OrcuVXgT8en3uibIe78Fw==\",\"id\":73210378921,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for OPDN76 Checkup ID 100\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-19T05:41:54Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-19T05:41:54Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/73210378921?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IlJVMlNnbENTcndQMEwyOVZQeFJZT1hfeUs2MENTd2lKSFdRb3hyZTFiSFkuQUcuam9MMzNMYy1ZMElqN1JieEZ5X3JIMzc1b253RnozaTNyRjlPZEFHNlpjemVLWWg2RDIxcVB4bVlGaG04R0RGVGhhMjFXYTJVLWVvOVlWYTguZTFyc2M4T1lWYlRIX2FSaFhsRFFCQS5DaE5rQ25BMHVheC1rc3I2IiwiZXhwIjoxNjI0MDg4NTE1LCJpYXQiOjE2MjQwODEzMTUsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.UYnGTBLJKvBTbzlcKChNhU5TkxLSK-yLmUMnAR4OXNU\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/73210378921?pwd=dXJtQytwZ1BHb1BFeHdhclhFaUFCdz09\",\"password\":\"Fcbsr\",\"h323_password\":\"512173\",\"pstn_password\":\"512173\",\"encrypted_password\":\"dXJtQytwZ1BHb1BFeHdhclhFaUFCdz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-19 05:41:55');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (26, 'consult', 7, 0, 101, 0, 1, 'Online consult for OPDN77 Checkup ID 101', '2021-06-19 11:12:00', 0, 'ULsih', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"7Pd6cXIjTR2XQn0EIds4NQ==\",\"id\":77664585810,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for OPDN77 Checkup ID 101\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-19T06:00:25Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-19T06:00:25Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/77664585810?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IldDeW9tM3E5ZDBqcC1zU2ZBV3V1NFBpRXVIMWxRT2dpX0J5U2pCMWdxc0kuQUcuYndCcUtDeEhIVVBmaWoxZHl6YUotbXRCMTd4alVKUE5JT0NJOWszZEk3M3hwZC1QbnNzcjdQMHZaVG1NY1J0S1dqYUF2Wk1PM1VLNzN0REQueXBhNEt4M0d0ZGNaY3ktWWp1TnJldy5vc2tjT2tRUmdRa0hiRjVDIiwiZXhwIjoxNjI0MDg5NjI1LCJpYXQiOjE2MjQwODI0MjUsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.lDVJVq5-vgs-JsreCifsE5qlyAEl3_PSLLr_qVsEJ38\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/77664585810?pwd=cUJqbitPaHdoMHBsZzVoRTBZME5adz09\",\"password\":\"ULsih\",\"h323_password\":\"082429\",\"pstn_password\":\"082429\",\"encrypted_password\":\"cUJqbitPaHdoMHBsZzVoRTBZME5adz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-19 06:00:25');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (27, 'consult', 24, 0, 102, 0, 1, 'Online consult for Revisit OPDN78', '2021-06-19 11:12:00', 0, 'EHzWe', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"9vaBF+5uSE6n4OeyYTo\\/lA==\",\"id\":79922192232,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN78\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-19T06:29:14Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-19T06:29:14Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/79922192232?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6Ikw3WnB1NnNySlRDc3VzdkVWYlpqdmt2SzYyV0dZdjhDdVAwdzRQRnR6c1EuQUcuQ3FlYWFfRXBYdmtQVnpZX1JxSGdiRVpxTk9vUXNyMXFXVVRrX2U4dXVPWWxFVU5oYTNXT0tDcVZ1aVo1dFpLNTFVMzFENkVWSTlqQ19paTIuTnNNTklWWndtZ1NXLWNEWHMwYm9jdy5JbjhYMXhfQk9xa2lMQ2FfIiwiZXhwIjoxNjI0MDkxMzU0LCJpYXQiOjE2MjQwODQxNTQsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.vRiWrU_K_s1VvbuZmHNbQ_rhvRzkl4jkcTlWK6NidLo\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/79922192232?pwd=L2JuVlFlQVdwVG1HQS9SejNHbjRwdz09\",\"password\":\"EHzWe\",\"h323_password\":\"552022\",\"pstn_password\":\"552022\",\"encrypted_password\":\"L2JuVlFlQVdwVG1HQS9SejNHbjRwdz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-19 06:29:14');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (28, 'consult', 7, 0, 103, 0, 1, 'Online consult for Revisit OPDN79', '2021-06-19 11:12:00', 0, 'LearW', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"QyxcNQ0DR7yCu549zO4O7A==\",\"id\":76273733502,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN79\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-19T06:30:56Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-19T06:30:56Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/76273733502?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6ImNxTVNmYUtPVUNxSUxNLWdvMFZFelo5X1lHaXR5WUJUMl9IT0tSN1d6QXcuQUcuLWRkSDd2R3hEcF9hLUpPY2xIVWI5VEF6dUJ6ajR6QndweFcwQm9ZRktJVUs2NWYwOTgxZk11OXNBVTRlbXdyN2J4dU8yOGo3YUluajBLTFkuOUlZRE5fQ2FtS2VCSXZPUERUTnF6QS5adEw2ai1NeG1kMG4wSl9IIiwiZXhwIjoxNjI0MDkxNDU2LCJpYXQiOjE2MjQwODQyNTYsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.RbKizXDZTwPbAbS490oTKHfEp_6BbJtpq-e3_LM0Tv0\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/76273733502?pwd=MlR4QUt3SkUrTW1NL3hCR3BCdWVSUT09\",\"password\":\"LearW\",\"h323_password\":\"414571\",\"pstn_password\":\"414571\",\"encrypted_password\":\"MlR4QUt3SkUrTW1NL3hCR3BCdWVSUT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-19 06:30:56');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (29, 'consult', 24, 0, 104, 0, 1, 'Online consult for Revisit OPDN80', '2021-06-19 11:12:00', 0, 'V9tWi', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"Vvxkwt\\/VRnq6HqONdA+HSQ==\",\"id\":76822762857,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN80\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-19T06:33:09Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-19T06:33:09Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/76822762857?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IlNOLXNWZWtBemEyMGJfVVlTVEFQbzJxZmR0NWg1d25aNnN3UVZxWFFMa1EuQUcuN0V0aVNSSzRKNDc4YjlLQjBlVUdJU0dqYnJDUWlEMjE3ZTlhcmI4elFrUGpWeUxSem1aZjMyUDRiV1pwOFZ4ekpiM1hFVXE1a2tSUXRyMGcuQU56YzRScHl5bEdmcjJ2cUVpQ0xVQS5fa0x6VDlMcTVkZ2syT2lZIiwiZXhwIjoxNjI0MDkxNTg5LCJpYXQiOjE2MjQwODQzODksImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.9WAjpRrYWTvmedwp_wQaYO__vx2iS2-_5FaWFcCjrEE\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/76822762857?pwd=NldXYWVBdm5adTNFQStlVWhwbDFpQT09\",\"password\":\"V9tWi\",\"h323_password\":\"716553\",\"pstn_password\":\"716553\",\"encrypted_password\":\"NldXYWVBdm5adTNFQStlVWhwbDFpQT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-19 06:33:09');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (30, 'consult', 7, 0, 105, 0, 1, 'Online consult for Revisit OPDN81', '2021-06-19 11:12:00', 0, 'Pmkxv', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"RVfNoP78SNqLSxeSqEqkog==\",\"id\":78610313761,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN81\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-19T06:43:55Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-19T06:43:55Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/78610313761?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6Ik1Eb2lfZ3JnUkMta01KN2hweW5FeWwwSzQzWVdEeVJfSUNnbl9sWU1xd1kuQUcudk52TklMbjdYYnR0d09Oc0RIVDJBaVZMVkRoWVFLUXYwOUl1NnBmTllMV3hiQzlVMjk1WFRPY2JyU3ZkSUR6MXE2QzBIMlVCZFg1aDJuX0YucEU5TlhQcXcyYUZyRS0tdjFfQk5TQS5oS0ZMS1RUR1lrVWFsMEM3IiwiZXhwIjoxNjI0MDkyMjM1LCJpYXQiOjE2MjQwODUwMzUsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.DT6O3mro31uDGx-AViem-GIb07Z5taFDm4ZsOXG0XNI\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/78610313761?pwd=eFJTZlNIdG9xcEo5eWNZSEhxejV6Zz09\",\"password\":\"Pmkxv\",\"h323_password\":\"432362\",\"pstn_password\":\"432362\",\"encrypted_password\":\"eFJTZlNIdG9xcEo5eWNZSEhxejV6Zz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-19 06:43:55');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (31, 'consult', 7, 0, 106, 0, 1, 'Online consult for Revisit OPDN82', '2021-06-19 11:12:00', 0, 'p0ACA', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"OGCFGGWIRmyNTcepu2gZTA==\",\"id\":72969633505,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN82\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-19T06:44:39Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-19T06:44:39Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/72969633505?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IjZMVzk0VDBseE5JekZyVkJzaE1PNzRyQm1kNW40eXk5c1Q5bkRNYkxQMG8uQUcucjhvM3AyWlZXYm5oMWluV3BfanZWRDZrWml1eXlKM0htZVZ5bUFISWJDWm9fNGxGQmFheHVheURYZmJUUm9HdlQwNFk0Z3lLa3hob1A4SlYuaTBxYW5GWGFBOUVkRDRWWFlqdFpZUS5pdE9nUTNWWUpheHF6UkJ4IiwiZXhwIjoxNjI0MDkyMjc5LCJpYXQiOjE2MjQwODUwNzksImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.9vmFmbFS26juLoyUrPKSYz0uY6IryAZWD9OQc_N8J1A\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/72969633505?pwd=d3kvSzREN1NMVTh0ZTQrSEpRcXE4dz09\",\"password\":\"p0ACA\",\"h323_password\":\"545394\",\"pstn_password\":\"545394\",\"encrypted_password\":\"d3kvSzREN1NMVTh0ZTQrSEpRcXE4dz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-19 06:44:39');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (32, 'consult', 24, 0, 107, 0, 1, 'Online consult for OPDN83 Checkup ID 107', '2021-06-18 14:56:00', 0, 'ujNPQ', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"BBg1I3dDQXeXS9aOmWIAbA==\",\"id\":76430813050,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for OPDN83 Checkup ID 107\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-19T10:57:20Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-19T10:57:20Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/76430813050?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IlFpbDQzMzk0SFRUTkxBYXNDTjYyQklxYnUtbUVqdV9GcnVLT2lpMUNabU0uQUcuRVhKbGQ0UVZzM2FpUHpkUktPTVVTWFZrSmplM2lVWDREQ2xWRTlLaHJhTmZMZjhhLVdsWmFibWEtTm9wTVEyWTdRc295Ti1VLUoxVEx2OVUuT3ZwRUdaaDBjaVJ3bWdZOTk4OTdpdy5mTVJUY1dFN3dtRkp0UFlxIiwiZXhwIjoxNjI0MTA3NDQxLCJpYXQiOjE2MjQxMDAyNDEsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.7ZBPqHP14EmaLhrAshnNelz50p0oahLAg1PcwNoX7Mo\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/76430813050?pwd=aUZNV0FXWkFiSVE0YTgyQ3FGMHFrUT09\",\"password\":\"ujNPQ\",\"h323_password\":\"886920\",\"pstn_password\":\"886920\",\"encrypted_password\":\"aUZNV0FXWkFiSVE0YTgyQ3FGMHFrUT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-19 10:57:21');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (33, 'consult', 7, 0, 109, 0, 1, 'Online consult for Checkup ID 109', '2021-06-19 11:12:00', 0, '', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"uwU9KsNVReGJmRakP1f8ww==\",\"id\":73871568097,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Checkup ID 109\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-19T11:56:23Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-19T11:56:23Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/73871568097?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IjZTSGlBRzVzMFhBSzluRW9MRm9wZHhxelZoRW5TdDRMTVBuQ3Z4anVIQlkuQUcuSmlZdTJvY1FoUWNLVm4zQ1owRC1JVjI3bmJCNFdveFdna3JRemMxVTlxZ09WbUwxeTJTOWZ5ZFFkdUVDU2dqSEt5RnRMQ2w1azhUWW5FVXIuM1dlYWhOdHk5QWNmT2Z4UWNlVjhiQS5GdWV3RDBRa1FRX2MzUUUxIiwiZXhwIjoxNjI0MTEwOTgzLCJpYXQiOjE2MjQxMDM3ODMsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.LWP_Ktme5Tckt82scaWuopxWWAfrT9B41DAnO9NJ-qg\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/73871568097?pwd=S0pvUVBOcnBPUnBxcnRVaVRqeWladz09\",\"password\":\"sH06hc\",\"h323_password\":\"874312\",\"pstn_password\":\"874312\",\"encrypted_password\":\"S0pvUVBOcnBPUnBxcnRVaVRqeWladz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-19 11:56:23');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (34, 'consult', 7, 0, 111, 0, 1, 'Online consult for OPDN86 Checkup ID 111', '2021-06-21 14:54:00', 0, 'ku9KL', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"UiQ6ZLiDQwKv0T7QXQ0Zcg==\",\"id\":76881458251,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for OPDN86 Checkup ID 111\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-21T09:34:08Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-21T09:34:08Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/76881458251?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6Ik9WN29hMkFIOUprbkducXlaMkVHTlBNb1h0ZXlBRGo1V0trYndKdUJlY2suQUcuSVRWMEVSN0hMekpCRWFzYmFMLWF0Q0xzODhGY3NzZnI2MEdDVEtKbE5LTk1WdTE2R2h1TEFIZ0diRWlMY1BSUU0tSHhfT083NDJTZG9zMzIuNE8zUWFCQTlROVkzMm5tME83WEFYZy5qSUJZTmJnZTRoVGVMUXRsIiwiZXhwIjoxNjI0Mjc1MjQ4LCJpYXQiOjE2MjQyNjgwNDgsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.XpkXPdd2UwiRPGSglZuU1qdLtKy3gLmvGsxOTc2IUoY\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/76881458251?pwd=dGhsT05ZcW1tYStnTHh4WGJPMDY0UT09\",\"password\":\"ku9KL\",\"h323_password\":\"522600\",\"pstn_password\":\"522600\",\"encrypted_password\":\"dGhsT05ZcW1tYStnTHh4WGJPMDY0UT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-21 09:34:08');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (35, 'consult', 24, 0, 112, 0, 1, 'Online consult for Revisit OPDN87', '2021-06-19 11:12:00', 0, 'vE0Kq', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"D\\/lhtrFMTHaWW+HSQc6kEA==\",\"id\":79907089517,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN87\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-21T09:48:03Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-21T09:48:03Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/79907089517?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IkgydDV6Zi1lT05RWlJJWTBVSENlNUNMZmNGSjVxbVh4Z0F6SUp1dFRMYkEuQUcuZ0dyWDhBUDQ1bjF0NFNsaHMwSUJKanVKMWRsZWlhM0psOEtmY0hkUDhUXzNqemYyN044X29FWnhiZmwtR2J0X19Xby04RkNnN2lLZURaVGEuWVRyTTYxNmJNOTJzWEs5TWRNMDJuUS4wY25YdHZQMzBXb2twU0pqIiwiZXhwIjoxNjI0Mjc2MDgzLCJpYXQiOjE2MjQyNjg4ODMsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.dhhYkHun4C4G-krftMRpqDLvVAcefSaBtUD4nDAJO_U\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/79907089517?pwd=NmFUUE42VnY2Z3p3ZmlFZEF5bjZlZz09\",\"password\":\"vE0Kq\",\"h323_password\":\"706217\",\"pstn_password\":\"706217\",\"encrypted_password\":\"NmFUUE42VnY2Z3p3ZmlFZEF5bjZlZz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-21 09:48:03');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (36, 'consult', 7, 0, 113, 0, 1, 'Online consult for Revisit OPDN88', '2021-06-19 11:12:00', 0, 'n9WtI', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"ZDeeMyVmQGSbrVIo48fXag==\",\"id\":74856913389,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN88\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-21T09:58:50Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-21T09:58:50Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/74856913389?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6Im9DOFFlVFVydFFZZXBBUmp1MndEVFpnNF9raElWUGxjdVlGTlAwMUs4RWcuQUcuYTlVV0MwUU4xZVFCS2dPVWlrNjcxWmRqMDBob0dWNUFtQVN6MUc0TXZNR19nZXUwc1BqT092bGFKZV9iWjJOdWRvUFdDT0VNbXdUdG5VcVcuNWg0SWpTM3lvRHVpdWdCNWYyWTRSUS5BcW9Dc1lMMTdhdS05c21jIiwiZXhwIjoxNjI0Mjc2NzMwLCJpYXQiOjE2MjQyNjk1MzAsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.CcSk9oT6m3HVBC2JSTSsFr57xEJmMzGPtrWwV2Pc1K4\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/74856913389?pwd=SFh3b0k2b0ZZOVNmNFoyL01EYldnQT09\",\"password\":\"n9WtI\",\"h323_password\":\"832020\",\"pstn_password\":\"832020\",\"encrypted_password\":\"SFh3b0k2b0ZZOVNmNFoyL01EYldnQT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-21 09:58:50');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (37, 'consult', 7, 0, 115, 0, 1, 'Online consult for Revisit OPDN90', '2021-06-19 10:41:00', 0, 'hVFJK', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"TY8JjZZASG2CQIy1Ew5GwQ==\",\"id\":78531932705,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN90\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-21T10:04:29Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-21T10:04:29Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/78531932705?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6InJYNk5QNmJPZXBtVEpsd3JBbGh4N0RFd2V6UDhkbm1hdlRZNmhSWTMyR3MuQUcuWlpubTg3UFVvMHdJREJmTEwya2pJZVhwdTdveU5MdmpDTGdMZjZZTGRackFOQnR2QTFQbnJmbjUzcjVLWTZydUkxSHhJdFpLWEgtWGpRRlUuNG5BUjJCQTFuSWpaWkFab0lraWpzZy5KN0d2bkVLemlBc0VFMElaIiwiZXhwIjoxNjI0Mjc3MDY5LCJpYXQiOjE2MjQyNjk4NjksImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.PYmwH21LfYyFHPNS5jKdC2qD3-Dq2Sg3BEGM7Smx-P0\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/78531932705?pwd=MjFpck5BSEdra3lERnRLZ3kwVEFZZz09\",\"password\":\"hVFJK\",\"h323_password\":\"436531\",\"pstn_password\":\"436531\",\"encrypted_password\":\"MjFpck5BSEdra3lERnRLZ3kwVEFZZz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-21 10:04:29');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (38, 'consult', 7, 0, 117, 0, 1, 'Online consult for Revisit OPDN92', '2021-06-19 10:41:00', 0, 'QKxcP', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"eJ1WFswdS7akoj5ltSpdlw==\",\"id\":74725319079,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN92\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-21T10:07:06Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-21T10:07:06Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/74725319079?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6InpwdXRybHRublVZNmotM3lFU3BiRUdZLUhTd21seF9LOERQdWgybnVMejAuQUcuRTFTS3pxVUs5SF93ODZGS3RXXzk2Sy1Lcjh5VWpYbUNFSEdueTExQlRCNkN2N2NqME5ZR2xqN2otdG9jU2tZZU8xVFBab0JrVmY3QWgxTjIuZWZzekRpYjBPVE5RU0FKeGFtY0t2Zy5WSmJrRzFaMkFOTktybVN1IiwiZXhwIjoxNjI0Mjc3MjI2LCJpYXQiOjE2MjQyNzAwMjYsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.qW6XgC57v7gp5vz_m6PB10GWsSxgN0DYtQf8zHM13R0\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/74725319079?pwd=NHM2bTdHNDFXUWtjR0FaY2R0V0xzdz09\",\"password\":\"QKxcP\",\"h323_password\":\"777120\",\"pstn_password\":\"777120\",\"encrypted_password\":\"NHM2bTdHNDFXUWtjR0FaY2R0V0xzdz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-21 10:07:06');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (39, 'consult', 24, 0, 118, 0, 1, 'Online consult for Revisit OPDN93', '2021-06-19 10:41:00', 0, '8CFSc', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"4pJ7zqQxQBOvT5LiDOra9A==\",\"id\":74457396504,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN93\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-21T10:07:27Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-21T10:07:27Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/74457396504?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IkxsZGNmdTNneUpSMFV0YlViLVhnSVpCYUVaZmZILXlDc0J1UUM0RUdGLXcuQUcuWFQ0NTZWcUdUUXM0cDZNQVNFVkVKLWVNMHlNVzFGZTNCbTlVRUNUS2VnT01rNDVQWjByRUpPaDB0eVVtQjZld2VKMW54QmZyQkQzbk50dEkudk1Ua2lSOUJMSEZOd2VaMTJiOWJKQS4wMEM1amlvdXg2YmtEYlpWIiwiZXhwIjoxNjI0Mjc3MjQ4LCJpYXQiOjE2MjQyNzAwNDgsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.GMoYhv0RCV85upimHkBCo6i-D8ijFEcMqEhHZK5m8g0\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/74457396504?pwd=akkvQU1udTV4U0NPT2hTRkpGSmVQZz09\",\"password\":\"8CFSc\",\"h323_password\":\"825371\",\"pstn_password\":\"825371\",\"encrypted_password\":\"akkvQU1udTV4U0NPT2hTRkpGSmVQZz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-21 10:07:28');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (40, 'consult', 7, 0, 119, 0, 1, 'Online consult for Checkup ID 119', '2021-06-19 11:12:00', 0, '', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"ukk1ykJtTvm77qbgxVPYaQ==\",\"id\":72892433336,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Checkup ID 119\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-21T10:36:33Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-21T10:36:33Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/72892433336?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6ImRDZjJWYVFhZEdhTnVXQXMyNFVOb2xoS0xLMW5XRjJ4SkdLejVMc19DeFUuQUcucDhDb3RRWDVhWkhhOWVwb0wtb1NjOF9jUEYyc1JjNVJlTnlWOFZiYmt5cGt5aGdPVFJTbW9aVDc1RGEzUFlFWS0xTkU0SlRiNjZDTU9uQ3IuRHRpLVQ0Y3A4WWxMMUItTm43dmFjUS5VaUc1bmFJb3RzVnkzTXRtIiwiZXhwIjoxNjI0Mjc4OTkzLCJpYXQiOjE2MjQyNzE3OTMsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.boI3sLWBd1TtKV-fIYMNEE6U2I5-e-v4RI460IAB3A0\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/72892433336?pwd=TnNVMExMTE5NVGhWeG90bU5OcXNoZz09\",\"password\":\"475jZj\",\"h323_password\":\"398557\",\"pstn_password\":\"398557\",\"encrypted_password\":\"TnNVMExMTE5NVGhWeG90bU5OcXNoZz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-21 10:36:33');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (41, 'consult', 7, 0, 0, 40, 1, 'Online consult for IPDN40', '2021-04-30 12:59:00', 0, 'LgIj1', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"c0dgCUmmSkyh8RlCNv0tGA==\",\"id\":71531191235,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for IPDN40\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-21T12:22:26Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-21T12:22:26Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/71531191235?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6ImtEVzFPd1BZZ0p1TVhzOW9hdklTYmROUHRHTDY2MllDMG1XNEtxMXkxaDguQUcudEltZkdPRFJQQ1pqamVDLThiVmFLXzl4UmFuYVBxWVBkaU1HMzBmdTlOYW1jRUxDRFFOZ2hxYzZtR2xoanlPc1Flc0h1TDNQY0xVTTRUcGguYmRxakxDNjlIakQ2TTlDem56U0Nqdy5odG9iV2F5N2hEay0wNkpGIiwiZXhwIjoxNjI0Mjg1MzQ2LCJpYXQiOjE2MjQyNzgxNDYsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.ZyuuFmP9HEUWSUMtWvpiwKGTvqy90e-986J7CSm3Bi0\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/71531191235?pwd=YzEyQi9Lb0NrK2MxQmx4VmpXZW5zZz09\",\"password\":\"LgIj1\",\"h323_password\":\"475279\",\"pstn_password\":\"475279\",\"encrypted_password\":\"YzEyQi9Lb0NrK2MxQmx4VmpXZW5zZz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-21 12:22:27');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (42, 'consult', 7, 206, 123, 0, 1, 'test ', '2021-06-21 19:11:00', 11, 'hKD2v', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"4LWgrtnkSpGtXSrfAfoJWA==\",\"id\":74231480383,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"test \",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-21T13:43:32Z\",\"duration\":11,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-21T13:43:32Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/74231480383?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6ImotbXhlZDZGbkxQSHlOMnNjOS1BRlVFeFZxVmM5bkVXczFwbEM1NTVLYzQuQUcudXBaUl9CTTFMSUZ6N1F0QjZzS1dWb3ZSLW1iNUs4cDRaeUMtYUw5ck92U2F2bm5pb2Rta1FYam5nN3JSUzU1cXhGaW1HbER3RlphdmsyekcuODEteG5XOWExcWFTUUthMnhfNEQ4QS5pQTZlX0RUS3ZQQ3FoRlpxIiwiZXhwIjoxNjI0MjkwMjEyLCJpYXQiOjE2MjQyODMwMTIsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.-fXFAEkg_fkLWuXyaJzLbeG-g5YtfLOMDlKe3vLfjfU\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/74231480383?pwd=c1hZT3dneEN2TGM2bVFWYVZzWWVFUT09\",\"password\":\"hKD2v\",\"h323_password\":\"062703\",\"pstn_password\":\"062703\",\"encrypted_password\":\"c1hZT3dneEN2TGM2bVFWYVZzWWVFUT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-21 13:43:32');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (43, 'consult', 7, 0, 125, 0, 1, 'Online consult for OPDN99 Checkup ID 125', '2021-06-22 09:52:00', 0, 'r078e', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"z8dFuFaFT52SXln5+E8YdQ==\",\"id\":77323450743,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for OPDN99 Checkup ID 125\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-22T04:34:51Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-22T04:34:51Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/77323450743?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IkVmVkxrc3pBTk5lWVFTY0xzU3EtUGJkZGNCblllVGR2WmdhdnowY0VlRlkuQUcuTVZLV0pWN0lnX2tpdlNycXR4RGpNTHF6dWJpR2lUZG1zTU5xS19SdHhzMmZpWU83eG14QmxSYVNsYnJzTlIzWGZqWnVHRVhEZ2lNYW80Q2EuSlp2YUg0X2x5SU9Fb2hFbDlDSmdjdy5HS3hhcUdiUGNHLVVWWUZIIiwiZXhwIjoxNjI0MzQzNjkxLCJpYXQiOjE2MjQzMzY0OTEsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.QAylS7whs2Cd70DWWrGaJnzhQh0oQZuO6bkB-FFLuuY\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/77323450743?pwd=eFhmWnVRUFdLVUx2YkZCNUZ1b2Y3Zz09\",\"password\":\"r078e\",\"h323_password\":\"432434\",\"pstn_password\":\"432434\",\"encrypted_password\":\"eFhmWnVRUFdLVUx2YkZCNUZ1b2Y3Zz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-22 04:34:51');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (44, 'consult', 7, 216, 0, 0, 1, 'test', '2021-06-22 16:55:00', 4, 'vO8k1', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"KFD1PdwpRGe52\\/Zk\\/BV4KQ==\",\"id\":78767350194,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"test\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-22T11:25:48Z\",\"duration\":4,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-22T11:25:48Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/78767350194?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6ImExZG1CazEyMlFnSGdyZkJpdmtaUHhQU1daLUFFT2ZhaGZkN1Noa2JWV2MuQUcueG1OWllYdXg0NGRVZzNreENqMTFuR2xiRjBERlNibFdiRU9YZ25EVndJVWpEOU5DZnI0OExnRndQUkZmbUJzQXdMU0ZxWHpWNVE5a0w2UWguMmFETEh2WmtYaUtvVng1X0VOSnNqZy5KQTRKaHcxRER0WXpJT2I2IiwiZXhwIjoxNjI0MzY4MzQ4LCJpYXQiOjE2MjQzNjExNDgsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.QIQO61JxNHQWAQwt9ILEzzXQTQnzbLQHMRCz9JT0ggA\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/78767350194?pwd=ZDZpVVFQR0kwR28yczQ2d25MSFcwQT09\",\"password\":\"vO8k1\",\"h323_password\":\"756522\",\"pstn_password\":\"756522\",\"encrypted_password\":\"ZDZpVVFQR0kwR28yczQ2d25MSFcwQT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-22 11:25:48');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (45, 'consult', 7, 0, 131, 0, 1, 'Online consult for OPDN105 Checkup ID 131', '2021-06-23 10:07:00', 0, 'cVVlM', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"2XsNqSSOTYOcqLpVX34O\\/g==\",\"id\":78240227882,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for OPDN105 Checkup ID 131\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-23T04:51:17Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-23T04:51:17Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/78240227882?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6Ik92VjhMLXZlamR0T3dfUVNUUkdneGNvd09UQVZUdW94QkkzOWhaUkgxeVkuQUcuUHVFelNCeGNVSGZraWdEWnZrWFVHbFpEdGQ1VlhKaHNPN2NfQjB3VUgta0lPWHowNVZCNzZQWE1Xbl9naVZnSU9MNy1wOFFEZktkUENZTDQuWnFpNzhRRDlRc2pGR04yMWdrQlZJQS5DOXZUQ20xeDR1NXVBakJGIiwiZXhwIjoxNjI0NDMxMDc3LCJpYXQiOjE2MjQ0MjM4NzcsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.BLfCzzpFHpj9Od_pbvhnd2mTh0U82kcVTm9H0PIvQyQ\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/78240227882?pwd=Qm9OM2FSdnZKSnYwQWI5Tjh0MCtzUT09\",\"password\":\"cVVlM\",\"h323_password\":\"601852\",\"pstn_password\":\"601852\",\"encrypted_password\":\"Qm9OM2FSdnZKSnYwQWI5Tjh0MCtzUT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-23 04:51:17');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (46, 'consult', 7, 0, 133, 0, 1, 'Online consult for OPDN107 Checkup ID 133', '2021-06-26 16:30:00', 0, '7VOaY', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"YGkf+u\\/\\/QZm6oX8CZjX5nw==\",\"id\":76470628738,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for OPDN107 Checkup ID 133\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-26T11:01:24Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-26T11:01:24Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/76470628738?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IkRCbmRwbUtGVHpDQkVqcGRkYW5TZlNRa3pCZ1NEY1pjSk5YTmRNbGpRd2suQUcuY2VoWjhBRHhQeVI2QnJuaDhUTWZUQzNsUXdXRGVnRDBtZWo1MGJUZ1JTb09fTkdHNHluNkIwYUpsbjlsejhab3Z6OUdMb29ZOXNNdFRBajIuVVFnRjh1b1UzRVJnVGxNcUZ4NXM5Zy5haDI3UG1FOVk2cDdJd3kyIiwiZXhwIjoxNjI0NzEyNDg0LCJpYXQiOjE2MjQ3MDUyODQsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.E3hRUXHWRjY3q7Z5n6LeOb4lCmsYl6p6nuybSmbRV3Y\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/76470628738?pwd=Y1lBMlBFNUlVN0RUQVZqSUJrREFSUT09\",\"password\":\"7VOaY\",\"h323_password\":\"468552\",\"pstn_password\":\"468552\",\"encrypted_password\":\"Y1lBMlBFNUlVN0RUQVZqSUJrREFSUT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-26 11:01:24');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (47, 'consult', 10, 0, 133, 0, 1, 'Online consult for Revisit OPDN108', '2021-06-25 17:53:00', 0, 'BNCct', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"NAPQWqByQ+io39Of+PEdkQ==\",\"id\":72059690057,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN108\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-28T16:36:02Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-28T16:36:02Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/72059690057?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IjJZaTl0ak5qSEc5dXJQdUtZSkhzZTNDUVhuR1c5UkdWZ3A3TXlsVE9Ma28uQUcua0d4ZEdBTFA2ZFVPNUJxaUlIV2FYem1GM2hyaGN3Wk5hTUoxYXhYSkpRaWxvSTR1a09UMkJTcHlvdE5KY2lvaG5QVUNNQjJyR3VZbXR4cVcuYVZjcXBOeUpmSUFtdWo0dVVnWDJIZy5SRlEtTEFIcWhoRlVQR0sxIiwiZXhwIjoxNjI0OTA1MzYyLCJpYXQiOjE2MjQ4OTgxNjIsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.dPWb0uGEDONfDXn8kvsLi13QdJmCsuh1K5pubkX_FFo\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/72059690057?pwd=eXRLTEdneTRScG9jVUoybUlNQ2crZz09\",\"password\":\"BNCct\",\"h323_password\":\"414707\",\"pstn_password\":\"414707\",\"encrypted_password\":\"eXRLTEdneTRScG9jVUoybUlNQ2crZz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-28 16:36:02');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (48, 'consult', 24, 0, 137, 0, 1, 'Online consult for Revisit OPDN112', '2021-06-29 11:24:00', 0, 'jOCgv', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"k\\/GXG675Q4SZZZecvr9Zfw==\",\"id\":77052237226,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN112\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-30T04:42:45Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-30T04:42:45Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/77052237226?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6Im5ja2VJMDJ5cjFnbFZOY0tKUFhYd1FmVUMzRVRaYkIyNmlLMGlYa0ZQMWsuQUcuSldfNW43M29QOXNrRDRJMjFISTFpN3o4amQ3MEdIaS1YVzU3X3hoY2ZGQWsySnRCNjRWb0I4bk5BeWVJMW5nSFFXUzRIZmlxcU1pMTdmZ2IuRWpic2NMVC03VWRPT3otVHIwVGNVdy5RMVFmUWhQaWxjaXg1TzhGIiwiZXhwIjoxNjI1MDM1MzY1LCJpYXQiOjE2MjUwMjgxNjUsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.6ubonuKZSGUvvqCE-U24Mn2ww6VQIsEy7KPX0G46E28\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/77052237226?pwd=cVltTUNrbzNsTVJNQTY5U1Uyb0N4QT09\",\"password\":\"jOCgv\",\"h323_password\":\"078101\",\"pstn_password\":\"078101\",\"encrypted_password\":\"cVltTUNrbzNsTVJNQTY5U1Uyb0N4QT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-30 04:42:45');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (49, 'consult', 7, 226, 0, 43, 1, 'testing', '2021-06-30 15:07:00', 10, 'U3HTt', 1, 1, 'ds', 'Asia/Kolkata', '{\"uuid\":\"aiRALc7EQASHmdnwULonGw==\",\"id\":79138726782,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"testing\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-30T09:38:04Z\",\"duration\":10,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-30T09:38:04Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/79138726782?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IkM3aDNrckdpd05qMmpFalBya2lZTXRZNnF1d05aQ0FCbFhqajY0OW1CSGsuQUcuMnBNcGVhVWJtZ2ZlR2xRLWN6V3hZZ3RMN3M1aDV2TGV4ampES0R2Smd6dUdRVkhqdVBEMTlOeFFlQ29rbXFiWTF2RUJZTEtoTllMYTUwUjcuWC1vMDZVRWR5ZlpfU2k2OFU2QlJCQS5tQWNKS2Q5SzZLbmZNZTNkIiwiZXhwIjoxNjI1MDUzMDg0LCJpYXQiOjE2MjUwNDU4ODQsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.aCq300LHT5dEbB19SM3PjvoFFeaioov_QZMp1SQ3qS4\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/79138726782?pwd=SWhXWjhIT0Z3V1JhOUlYeXRid0ErQT09\",\"password\":\"U3HTt\",\"h323_password\":\"862530\",\"pstn_password\":\"862530\",\"encrypted_password\":\"SWhXWjhIT0Z3V1JhOUlYeXRid0ErQT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-30 09:38:04');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (50, 'consult', 24, 226, 138, 0, 1, 'test', '2021-06-30 15:08:00', 10, '6mb97', 1, 1, 'dd', 'Asia/Kolkata', '{\"uuid\":\"7CaqWUoERUuLxY0fqk7x0w==\",\"id\":74202296263,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"test\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-30T09:39:41Z\",\"duration\":10,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-30T09:39:41Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/74202296263?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6Iml0WW83bWNOdEQ2b2JqaURfSnhONlpOT2pfNm5LdTl2WG5jUFIyaUQ3NjguQUcuUzNud0tJX0ZYN2NaZDdRdkRNQk1tQ0hPZzl0cFpGZ29DYjlJS3NfTDdPdFA5UVBzUFFkVDF5NE9jU2ZzQVFHV0JoaW9YaTRRY2FWSjM1RW4udXhYbTNXdmdwUkZLRVBmLTF1YWVfQS5fN2M3Y1dHb3JhVmE0TlZRIiwiZXhwIjoxNjI1MDUzMTgxLCJpYXQiOjE2MjUwNDU5ODEsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.kXkTxoxUnEHLBZmks__oAA1jL-ZDhrVFKQAP6bjm_l0\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/74202296263?pwd=cmJxS1V2cC8xcURvZVZUNExKUGFHQT09\",\"password\":\"6mb97\",\"h323_password\":\"002391\",\"pstn_password\":\"002391\",\"encrypted_password\":\"cmJxS1V2cC8xcURvZVZUNExKUGFHQT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-30 09:39:41');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (51, 'consult', 24, 0, 140, 0, 1, 'Online consult for Revisit OPDN115', '2021-06-19 17:02:00', 0, '81Nky', 1, 1, '', 'Asia/Kolkata', '{\"uuid\":\"ZlN6bh0jQyKQLsir3B\\/NyQ==\",\"id\":75062508654,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"Online consult for Revisit OPDN115\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-30T10:13:45Z\",\"duration\":60,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-30T10:13:45Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/75062508654?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IjM2dHJvTGh6VWpyYVEwMVU1ZmlSZU51Vm96MGtJTGNQY1g4ajNsbzNPdTQuQUcuUjdhVlo2anhENXZDQ3lKMlA0blJySVZxZWZyMTVoMkVOV3R2LXhCY3NIaFdFRHpYNnliWXhwWDIyWDN0bVhhUmthWDk5SW5MRFlRRzIyOUcuRGxBOWhxOENhaGVFVVBNMWRFcC1HUS5ERkN3N29fOFdxaXZ3WWtYIiwiZXhwIjoxNjI1MDU1MjI1LCJpYXQiOjE2MjUwNDgwMjUsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.4cvLJ5lSRznPl2vXRiUFLQtdGcOdUbrjxpCJ30d6Cf4\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/75062508654?pwd=Y0gvSnpORjNLVnlRdzhTQ3lNcEs1dz09\",\"password\":\"81Nky\",\"h323_password\":\"479394\",\"pstn_password\":\"479394\",\"encrypted_password\":\"Y0gvSnpORjNLVnlRdzhTQ3lNcEs1dz09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-30 10:13:45');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `created_at`) VALUES (52, 'consult', 24, 226, 138, 0, 1, 'sss', '2021-06-30 16:34:00', 10, 'KqaKV', 1, 1, 's', 'Asia/Kolkata', '{\"uuid\":\"z7IS7QEIRLm1DkW96CzrCA==\",\"id\":77959846122,\"host_id\":\"O-DGVhFGT9aCYPO_Sx5eig\",\"host_email\":\"garimas663@gmail.com\",\"topic\":\"sss\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2021-06-30T11:05:04Z\",\"duration\":10,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2021-06-30T11:05:04Z\",\"start_url\":\"https:\\/\\/us04web.zoom.us\\/s\\/77959846122?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJhdWQiOiJjbGllbnRzbSIsInVpZCI6Ik8tREdWaEZHVDlhQ1lQT19TeDVlaWciLCJpc3MiOiJ3ZWIiLCJzdHkiOjEsIndjZCI6InVzMDQiLCJjbHQiOjAsInN0ayI6IjNsdmVJSm1oNmhXODJoVGVabnpWOWZ0UmJCVS1LRXFEUFM5TFlZYUhrVXcuQUcubTBGVU9BUGprR1doSERJLXBTNnJULW5VTExHWVpjOFh3SXZHYVFwT2Z3aXVQLU5BdzUxLWtFUFlmU0U5bHVvaWt4ai1jVXZBQzI5MjhVS1Yucy1XekttdVZWbkRjbmRMQmhTVElWUS5Zcmhtd3pkdGdqRkh6SG56IiwiZXhwIjoxNjI1MDU4MzA0LCJpYXQiOjE2MjUwNTExMDQsImFpZCI6IlIxeDRyckNiUUVDNUN5UFJqUHUxY2ciLCJjaWQiOiIifQ.oaOEk2KOs4gXAEDx33KXM41uuh2lsabQVffl0LYIYKY\",\"join_url\":\"https:\\/\\/us04web.zoom.us\\/j\\/77959846122?pwd=ZHZTVHRwcm8rQnRXNnZMTHY3LzRHUT09\",\"password\":\"KqaKV\",\"h323_password\":\"776320\",\"pstn_password\":\"776320\",\"encrypted_password\":\"ZHZTVHRwcm8rQnRXNnZMTHY3LzRHUT09\",\"settings\":{\"host_video\":true,\"participant_video\":true,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":true,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"alternative_hosts_email_notification\":true,\"device_testing\":false}}', 'global', 0, '2021-06-30 11:05:04');


#
# TABLE STRUCTURE FOR: conferences_history
#

DROP TABLE IF EXISTS `conferences_history`;

CREATE TABLE `conferences_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `total_hit` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: consult_charges
#

DROP TABLE IF EXISTS `consult_charges`;

CREATE TABLE `consult_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor` int(11) NOT NULL,
  `standard_charge` float(10,2) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `doctor` (`doctor`),
  CONSTRAINT `consult_charges_ibfk_1` FOREIGN KEY (`doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: consultant_register
#

DROP TABLE IF EXISTS `consultant_register`;

CREATE TABLE `consultant_register` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) NOT NULL,
  `date` date DEFAULT NULL,
  `ins_date` date DEFAULT NULL,
  `instruction` text NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `cons_doctor` (`cons_doctor`),
  CONSTRAINT `consultant_register_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `consultant_register_ibfk_2` FOREIGN KEY (`cons_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (1, 3, '2021-04-20', '2021-04-20', 'ttttt', 7, '2021-04-28 15:37:46');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (2, 4, '2021-04-21', '2021-04-21', 'jjjjjjjjjj', 17, '2021-04-28 15:37:46');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (3, 4, '1970-01-01', '2021-04-24', 'fff', 7, '2021-04-28 15:37:46');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (4, 4, '1970-01-01', '2021-04-24', 'fff', 7, '2021-04-28 15:37:46');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (5, 4, '1970-01-01', '2021-04-24', 'mm', 7, '2021-04-28 15:37:46');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (7, 7, '2021-05-01', '2021-05-01', 'ok', 17, '2021-05-01 10:24:26');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (9, 9, '2021-05-04', '2021-05-04', 'yttttttttt', 7, '2021-05-04 10:23:00');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (10, 11, '2021-05-04', '2021-05-04', 'ddd', 7, '2021-05-04 10:25:16');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (11, 13, '2021-05-05', '2021-05-07', 'test', 7, '2021-05-05 11:33:30');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (12, 13, '2021-05-06', '2021-05-05', 'check', 17, '2021-05-05 11:41:29');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (15, 12, '2021-05-06', '2021-05-07', 'ggggg', 24, '2021-05-07 08:23:10');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (16, 14, '2021-05-07', '2021-05-13', 'fff', 24, '2021-05-07 09:30:30');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (18, 24, '1970-01-01', '2021-05-08', 'test', 17, '2021-05-08 13:57:02');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (20, 23, '2021-05-11', '2021-05-10', 'iiiiii', 24, '2021-05-10 04:18:11');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (21, 23, '2021-05-10', '2021-05-10', 'rrtyr', 17, '2021-05-10 04:20:41');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (22, 28, '0000-00-00', '2021-05-12', 'test', 7, '2021-05-12 04:23:56');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (24, 2, '2021-05-05', '2021-05-11', 'j', 24, '2021-05-14 07:38:17');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (26, 22, '2021-05-06', '2021-05-14', 'm', 17, '2021-05-14 08:22:41');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (27, 38, '2021-06-18', '2021-06-17', 'xZAz', 7, '2021-06-17 06:20:29');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (28, 41, '2021-06-01', '2021-06-25', 'Instruction', 7, '2021-06-25 06:42:05');
INSERT INTO `consultant_register` (`id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`, `created_at`) VALUES (29, 42, '2021-06-25', '2021-06-28', 'instruction', 7, '2021-06-28 05:29:07');


#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `file` varchar(250) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `note` text,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (13, 'asdfsa', 'asdfsa', 'No', NULL, 0, '', 'no', '2021-02-17 12:59:18', '1970-01-01');
INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (14, 'fgggfffff', 'ffffff', 'No', 'uploads/hospial_content/material/14.jpg', 0, '', 'no', '2021-02-17 13:01:50', '1970-01-01');
INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (15, 'sdas', 'asfsda', 'No', NULL, 0, '', 'no', '2021-02-18 06:46:37', '1970-01-01');
INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (16, 'asfdsa', 'adfaf', 'No', NULL, 0, '', 'no', '2021-02-18 06:47:22', '1970-01-01');
INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (17, 'sfda', 'adfa', 'No', NULL, 0, '', 'no', '2021-02-18 06:48:19', '1970-01-01');
INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (18, 'asdfsda', 'asdfsa', 'No', NULL, 0, '', 'no', '2021-02-18 06:49:50', '1970-01-01');
INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (19, 'asdfsa', 'asdfsa', 'No', 'uploads/hospial_content/material/19.jpg', 0, '', 'no', '2021-02-18 06:51:03', '1970-01-01');
INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (20, 'asdfsa', 'asdf', 'No', NULL, 0, '', 'no', '2021-02-18 06:52:49', '1970-01-01');
INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (26, 'content title', 'content type', 'No', 'uploads/hospital_content/material/26.png', 0, '', 'no', '2021-02-19 12:30:39', '1970-01-01');
INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (27, 'test', 'test', 'No', 'uploads/hospital_content/material/27.jpg', 0, 'fgbfb', 'no', '2021-02-23 08:15:53', '2021-02-10');
INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (28, 'test', 'dem0', 'No', 'uploads/hospital_content/material/28.jpg', 0, '', 'no', '2021-02-23 11:32:50', '1970-01-01');
INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (30, 'check', 'pdf', 'No', 'uploads/hospital_content/material/30.pdf', 0, 'na', 'no', '2021-03-20 13:01:33', '2021-03-21');
INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (31, 'bhjkhuk', 'ljl,', 'No', 'uploads/hospital_content/material/31.png', 0, '', 'no', '2021-03-27 13:03:04', '1970-01-01');
INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (32, 'rfgr', 'fdrsfsdf', 'No', 'uploads/hospital_content/material/32.jpg', 0, 'ujhkhjkhj', 'no', '2021-04-03 06:13:39', '1970-01-01');


#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `belong_table_id` int(11) DEFAULT NULL,
  `custom_field_id` int(11) DEFAULT NULL,
  `field_value` varchar(200) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1636 DEFAULT CHARSET=utf8;

INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1, 10, 2, 'nnnnn gggg', '2021-05-04 08:57:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2, 11, 2, '', '2021-05-04 09:12:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3, 10, 9, 'rrrrrr', '2021-05-04 10:25:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4, 15, 1, '', '2021-05-04 10:49:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (5, 16, 1, '', '2021-05-04 10:55:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (6, 17, 1, '', '2021-05-04 10:56:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (7, 18, 1, '', '2021-05-04 10:56:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (8, 19, 1, '', '2021-05-04 10:59:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (9, 20, 1, '', '2021-05-04 10:59:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (10, 21, 1, '', '2021-05-04 11:00:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (11, 22, 1, '', '2021-05-04 11:21:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (12, 25, 1, 'eewew', '2021-05-04 11:40:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (13, 16, 5, 'ghgg', '2021-05-04 12:44:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (14, 26, 1, '', '2021-05-04 12:45:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (15, 24, 6, '1', '2021-05-04 12:51:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (16, 25, 6, 'f', '2021-05-04 12:58:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (17, 26, 6, '', '2021-05-04 13:03:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (18, 27, 6, '', '2021-05-04 13:10:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (19, 31, 7, '', '2021-05-05 05:21:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (20, 48, 3, 'rerr', '2021-05-05 07:24:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (21, 48, 4, 'tyr', '2021-05-05 07:24:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (22, 49, 3, 'check', '2021-05-05 07:25:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (23, 49, 4, 'double check', '2021-05-05 07:25:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (24, 35, 3, '', '2021-05-05 07:31:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (25, 35, 4, 'g', '2021-05-05 07:31:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (26, 1, 5, 'ytryrty', '2021-05-05 07:41:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (27, 17, 5, '', '2021-05-05 08:50:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (28, 27, 1, 'check print', '2021-05-05 08:53:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (29, 24, 8, 'text custom fields', '2021-05-05 09:27:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (30, 28, 6, '', '2021-05-05 09:32:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (31, 28, 1, '', '2021-05-05 10:02:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (32, 0, 6, '', '2021-05-05 10:16:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (33, 29, 6, '', '2021-05-05 10:16:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (34, 30, 6, '', '2021-05-05 10:17:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (35, 25, 8, '', '2021-05-05 10:32:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (36, 31, 6, '', '2021-05-05 10:36:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (37, 32, 7, '', '2021-05-05 10:36:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (38, 3, 8, 'gfhghg ghjghjghjhg', '2021-05-05 10:37:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (39, 30, 1, 'jjyjyjyjyj', '2021-05-05 11:23:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (40, 11, 9, 'test', '2021-05-05 11:33:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (41, 12, 9, 'checkk', '2021-05-05 11:41:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (42, 13, 2, 'gjjgjgjj', '2021-05-05 12:58:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (43, 13, 10, 'hjhjj', '2021-05-05 12:58:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (44, 12, 2, 'uuuuuuuuuuu', '2021-05-05 13:04:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (45, 12, 10, 'jjjjjjjjjjjj', '2021-05-05 13:04:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (46, 14, 2, '', '2021-05-06 05:20:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (47, 14, 10, '', '2021-05-06 05:20:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (48, 6, 15, 'aa', '2021-05-06 06:09:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (49, 6, 16, 'green', '2021-05-06 06:09:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (50, 31, 1, '', '2021-05-06 07:23:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (51, 50, 3, '', '2021-05-06 07:39:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (52, 50, 4, 'test', '2021-05-06 07:39:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (53, 35, 7, '', '2021-05-06 08:13:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (54, 19, 5, '', '2021-05-06 09:27:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (55, 19, 12, '', '2021-05-06 09:27:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (56, 33, 7, '', '2021-05-06 09:28:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (57, 34, 7, '', '2021-05-06 09:28:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (58, 20, 5, '', '2021-05-06 09:31:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (59, 20, 12, '', '2021-05-06 09:31:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (60, 35, 7, '', '2021-05-06 09:37:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (61, 32, 6, '', '2021-05-06 12:01:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (62, 36, 7, '', '2021-05-06 12:03:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (63, 0, 6, '', '2021-05-06 12:18:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (64, 0, 6, '', '2021-05-07 07:52:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (65, 0, 6, '', '2021-05-08 10:19:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (66, 21, 5, '', '2021-05-06 13:03:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (67, 21, 12, '', '2021-05-06 13:03:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (68, 52, 3, 'g', '2021-05-06 13:39:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (69, 52, 4, 'g', '2021-05-06 13:39:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (70, 23, 5, '', '2021-05-07 06:08:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (71, 23, 12, '', '2021-05-07 06:08:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (72, 24, 5, '', '2021-05-07 06:13:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (73, 24, 12, '', '2021-05-07 06:13:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (74, 25, 5, '', '2021-05-07 06:18:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (75, 25, 12, '', '2021-05-07 06:18:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (76, 26, 5, '', '2021-05-07 06:18:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (77, 26, 12, '', '2021-05-07 06:18:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (78, 27, 5, '', '2021-05-07 06:20:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (79, 27, 12, '', '2021-05-07 06:20:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (80, 28, 5, '', '2021-05-07 06:21:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (81, 28, 12, '', '2021-05-07 06:21:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (82, 37, 7, '', '2021-05-07 06:21:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (83, 29, 5, '', '2021-05-07 06:24:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (84, 29, 12, '', '2021-05-07 06:24:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (85, 38, 7, '', '2021-05-07 07:13:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (86, 39, 7, '', '2021-05-07 07:15:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (87, 40, 7, '', '2021-05-07 07:15:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (88, 41, 7, '', '2021-05-07 07:17:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (89, 42, 7, '', '2021-05-07 07:25:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (90, 43, 7, '', '2021-05-07 07:26:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (91, 44, 7, '', '2021-05-07 07:27:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (92, 0, 6, '', '2021-05-14 10:50:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (93, 2, 14, 'jkkl hhhh', '2021-05-07 09:03:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (94, 30, 5, '', '2021-05-07 08:00:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (95, 30, 12, '', '2021-05-07 08:00:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (96, 45, 7, '', '2021-05-07 08:00:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (97, 13, 9, 'iyui', '2021-05-07 08:13:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (98, 14, 9, 'hhhjhj', '2021-05-07 08:16:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (99, 15, 9, 'ggggg', '2021-05-07 08:23:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (100, 16, 9, 'ffff', '2021-05-07 09:30:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (101, 31, 5, '', '2021-05-07 11:53:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (102, 31, 12, '', '2021-05-07 11:53:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (103, 15, 2, '', '2021-05-07 11:53:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (104, 15, 10, '', '2021-05-07 11:53:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (105, 32, 1, '', '2021-05-07 13:09:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (106, 53, 3, '', '2021-05-08 05:44:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (107, 53, 4, 'red', '2021-05-08 05:44:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (108, 32, 5, '', '2021-05-08 05:48:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (109, 32, 12, '', '2021-05-08 05:48:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (110, 33, 1, '', '2021-05-08 05:49:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (111, 58, 3, '', '2021-05-08 08:32:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (112, 58, 4, 'test', '2021-05-08 08:32:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (113, 59, 3, '', '2021-05-08 08:34:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (114, 59, 4, 'test', '2021-05-08 08:34:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (115, 60, 3, '', '2021-05-08 08:49:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (116, 60, 4, 'test', '2021-05-08 08:49:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (117, 61, 3, '', '2021-05-08 09:25:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (118, 63, 3, '', '2021-05-08 09:44:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (119, 64, 3, '', '2021-05-08 09:48:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (120, 34, 6, '', '2021-05-08 10:19:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (121, 35, 6, '', '2021-05-08 11:06:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (122, 36, 6, '', '2021-05-08 11:07:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (123, 66, 3, 'yyyyyyy', '2021-05-08 11:14:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (124, 34, 5, 'gggg', '2021-05-08 11:18:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (125, 34, 12, 'gggg', '2021-05-08 11:18:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (126, 34, 1, '', '2021-05-08 11:18:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (127, 0, 7, '', '2021-05-08 11:20:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (128, 0, 18, '', '2021-05-08 11:20:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (129, 0, 19, '', '2021-05-08 11:20:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (130, 0, 20, '', '2021-05-08 11:20:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (131, 0, 7, '', '2021-05-08 11:20:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (132, 0, 18, '', '2021-05-08 11:20:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (133, 0, 19, '', '2021-05-08 11:20:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (134, 0, 20, '', '2021-05-08 11:20:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (135, 0, 7, '', '2021-05-08 11:20:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (136, 0, 18, '', '2021-05-08 11:20:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (137, 0, 19, '', '2021-05-08 11:20:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (138, 0, 20, '', '2021-05-08 11:20:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (139, 0, 7, '', '2021-05-08 11:21:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (140, 0, 18, '', '2021-05-08 11:21:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (141, 0, 19, '', '2021-05-08 11:21:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (142, 0, 20, '', '2021-05-08 11:21:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (143, 0, 7, '', '2021-05-08 11:21:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (144, 0, 18, '', '2021-05-08 11:21:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (145, 0, 19, '', '2021-05-08 11:21:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (146, 0, 20, '', '2021-05-08 11:21:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (147, 0, 7, '', '2021-05-08 11:21:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (148, 0, 18, '', '2021-05-08 11:21:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (149, 0, 19, '', '2021-05-08 11:21:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (150, 0, 20, '', '2021-05-08 11:21:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (151, 0, 7, '', '2021-05-08 11:21:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (152, 0, 18, '', '2021-05-08 11:21:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (153, 0, 19, '', '2021-05-08 11:21:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (154, 0, 20, '', '2021-05-08 11:21:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (155, 46, 7, '', '2021-05-08 11:21:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (156, 46, 18, '', '2021-05-08 11:21:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (157, 46, 19, '', '2021-05-08 11:21:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (158, 46, 20, '', '2021-05-08 11:21:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (159, 67, 3, 'hhhhhhhhhhhppppppp', '2021-05-08 11:22:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (160, 35, 1, '', '2021-05-08 11:30:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (161, 1, 12, '', '2021-05-08 11:47:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (162, 47, 7, '', '2021-05-08 12:25:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (163, 47, 18, '', '2021-05-08 12:25:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (164, 47, 19, '', '2021-05-08 12:25:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (165, 47, 20, '', '2021-05-08 12:25:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (166, 0, 7, '', '2021-05-17 09:23:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (167, 0, 18, '', '2021-05-17 09:23:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (168, 0, 19, '', '2021-05-17 09:23:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (169, 0, 20, '', '2021-05-17 09:23:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (170, 17, 9, 'ff', '2021-05-08 12:55:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (171, 18, 9, 'test', '2021-05-08 13:57:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (172, 19, 9, 'hjhjh', '2021-05-10 03:57:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (173, 20, 9, 'hhhhhhhh', '2021-05-10 04:18:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (174, 21, 9, 'tyty', '2021-05-10 04:20:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (175, 24, 2, '', '2021-05-10 09:41:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (176, 24, 10, '', '2021-05-10 09:41:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (177, 35, 5, '', '2021-05-11 08:12:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (178, 35, 12, '', '2021-05-11 08:12:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (179, 35, 30, '', '2021-05-11 08:12:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (180, 35, 31, '', '2021-05-11 08:12:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (181, 35, 32, '', '2021-05-11 08:12:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (182, 36, 5, '', '2021-05-11 08:13:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (183, 36, 12, '', '2021-05-11 08:13:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (184, 36, 30, '', '2021-05-11 08:13:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (185, 36, 31, '', '2021-05-11 08:13:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (186, 36, 32, '', '2021-05-11 08:13:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (187, 36, 1, '', '2021-05-11 08:52:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (188, 37, 1, '', '2021-05-11 08:55:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (189, 38, 1, '', '2021-05-11 09:06:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (190, 39, 1, '', '2021-05-11 09:11:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (191, 40, 1, '', '2021-05-11 09:15:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (192, 41, 1, '', '2021-05-11 09:23:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (193, 42, 1, '', '2021-05-11 09:24:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (194, 43, 1, '', '2021-05-11 09:27:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (195, 44, 1, '', '2021-05-11 09:27:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (196, 45, 1, '', '2021-05-11 09:28:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (197, 46, 1, '', '2021-05-11 09:29:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (198, 47, 1, '', '2021-05-11 09:36:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (199, 48, 1, '', '2021-05-11 09:37:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (200, 49, 1, '', '2021-05-11 09:38:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (201, 50, 1, '', '2021-05-11 09:39:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (202, 51, 1, '', '2021-05-11 09:39:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (203, 52, 1, '', '2021-05-11 09:41:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (204, 53, 1, '', '2021-05-11 09:42:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (205, 54, 1, '', '2021-05-11 09:44:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (206, 55, 1, '', '2021-05-11 09:45:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (207, 56, 1, '', '2021-05-11 09:48:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (208, 57, 1, '', '2021-05-11 09:51:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (209, 58, 1, '', '2021-05-11 09:53:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (210, 59, 1, '', '2021-05-11 09:54:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (211, 60, 1, '', '2021-05-11 09:54:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (212, 61, 1, '', '2021-05-11 09:55:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (213, 37, 5, '', '2021-05-11 10:19:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (214, 37, 12, '', '2021-05-11 10:19:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (215, 37, 30, '', '2021-05-11 10:19:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (216, 37, 31, '', '2021-05-11 10:19:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (217, 37, 32, '', '2021-05-11 10:19:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (218, 25, 2, '', '2021-05-11 10:21:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (219, 25, 10, '', '2021-05-11 10:21:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (220, 26, 2, '', '2021-05-11 10:41:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (221, 26, 10, '', '2021-05-11 10:41:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (222, 27, 2, '', '2021-05-11 10:42:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (223, 27, 10, '', '2021-05-11 10:42:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (224, 28, 2, 'j', '2021-05-11 10:54:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (225, 28, 10, 'j', '2021-05-11 10:54:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (226, 38, 5, '', '2021-05-11 11:00:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (227, 38, 12, '', '2021-05-11 11:00:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (228, 38, 30, '', '2021-05-11 11:00:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (229, 38, 31, '', '2021-05-11 11:00:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (230, 38, 32, '', '2021-05-11 11:00:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (231, 29, 2, '', '2021-05-11 11:24:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (232, 29, 10, '', '2021-05-11 11:24:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (233, 30, 2, '', '2021-05-11 11:25:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (234, 30, 10, '', '2021-05-11 11:25:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (235, 31, 2, '', '2021-05-11 11:32:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (236, 31, 10, '', '2021-05-11 11:32:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (237, 32, 2, '', '2021-05-11 11:33:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (238, 32, 10, '', '2021-05-11 11:33:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (239, 33, 2, '', '2021-05-11 11:34:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (240, 33, 10, '', '2021-05-11 11:34:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (241, 34, 2, '', '2021-05-11 11:35:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (242, 34, 10, '', '2021-05-11 11:35:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (243, 35, 2, '', '2021-05-11 11:35:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (244, 35, 10, '', '2021-05-11 11:35:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (245, 36, 2, '', '2021-05-11 11:49:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (246, 36, 10, '', '2021-05-11 11:49:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (247, 37, 2, '', '2021-05-11 11:51:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (248, 37, 10, '', '2021-05-11 11:51:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (249, 62, 1, '', '2021-05-11 12:53:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (250, 63, 1, '', '2021-05-11 13:01:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (251, 64, 1, '', '2021-05-11 13:02:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (252, 65, 1, '', '2021-05-11 13:03:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (253, 66, 1, '', '2021-05-11 13:04:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (254, 67, 1, '', '2021-05-11 13:04:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (255, 68, 1, '', '2021-05-11 13:10:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (256, 69, 1, '', '2021-05-11 13:11:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (257, 39, 5, '', '2021-05-11 14:00:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (258, 39, 12, '', '2021-05-11 14:00:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (259, 39, 30, '', '2021-05-11 14:00:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (260, 39, 31, '', '2021-05-11 14:00:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (261, 39, 32, '', '2021-05-11 14:00:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (262, 40, 5, '', '2021-05-11 14:00:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (263, 40, 12, '', '2021-05-11 14:00:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (264, 40, 30, '', '2021-05-11 14:00:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (265, 40, 31, '', '2021-05-11 14:00:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (266, 40, 32, '', '2021-05-11 14:00:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (267, 41, 5, '', '2021-05-11 14:02:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (268, 41, 12, '', '2021-05-11 14:02:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (269, 41, 30, '', '2021-05-11 14:02:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (270, 41, 31, '', '2021-05-11 14:02:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (271, 41, 32, '', '2021-05-11 14:02:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (272, 22, 9, '', '2021-05-12 04:23:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (273, 26, 8, '', '2021-05-12 06:02:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (274, 26, 17, '', '2021-05-12 06:02:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (275, 51, 13, 'yyyyyyyyyy', '2021-05-12 06:28:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (276, 37, 6, '', '2021-05-12 08:00:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (277, 37, 37, '', '2021-05-12 08:00:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (278, 37, 38, '', '2021-05-12 08:00:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (279, 37, 39, '', '2021-05-12 08:00:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (280, 52, 13, 'ttttt', '2021-05-12 08:36:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (281, 36, 1, '', '2021-05-13 04:56:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (282, 72, 5, '', '2021-05-13 06:31:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (283, 72, 12, '', '2021-05-13 06:31:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (284, 72, 30, '', '2021-05-13 06:31:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (285, 72, 31, '', '2021-05-13 06:31:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (286, 72, 32, '', '2021-05-13 06:31:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (287, 123, 5, '', '2021-05-14 06:57:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (288, 123, 12, '', '2021-05-14 06:57:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (289, 123, 30, '', '2021-05-14 06:57:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (290, 123, 31, '', '2021-05-14 06:57:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (291, 123, 32, '', '2021-05-14 06:57:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (292, 124, 5, '', '2021-05-14 06:57:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (293, 124, 12, '', '2021-05-14 06:57:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (294, 124, 30, '', '2021-05-14 06:57:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (295, 124, 31, '', '2021-05-14 06:57:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (296, 124, 32, '', '2021-05-14 06:57:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (297, 125, 5, '', '2021-05-14 06:57:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (298, 125, 12, '', '2021-05-14 06:57:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (299, 125, 30, '', '2021-05-14 06:57:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (300, 125, 31, '', '2021-05-14 06:57:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (301, 125, 32, '', '2021-05-14 06:57:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (302, 126, 5, '', '2021-05-14 06:58:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (303, 126, 12, '', '2021-05-14 06:58:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (304, 126, 30, '', '2021-05-14 06:58:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (305, 126, 31, '', '2021-05-14 06:58:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (306, 126, 32, '', '2021-05-14 06:58:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (307, 127, 5, '', '2021-05-14 06:58:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (308, 127, 12, '', '2021-05-14 06:58:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (309, 127, 30, '', '2021-05-14 06:58:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (310, 127, 31, '', '2021-05-14 06:58:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (311, 127, 32, '', '2021-05-14 06:58:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (312, 128, 5, '', '2021-05-14 06:58:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (313, 128, 12, '', '2021-05-14 06:58:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (314, 128, 30, '', '2021-05-14 06:58:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (315, 128, 31, '', '2021-05-14 06:58:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (316, 128, 32, '', '2021-05-14 06:58:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (317, 114, 3, '', '2021-05-14 07:03:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (318, 114, 33, '', '2021-05-14 07:03:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (319, 114, 34, '', '2021-05-14 07:03:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (320, 114, 35, '', '2021-05-14 07:03:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (321, 114, 36, '', '2021-05-14 07:03:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (322, 23, 9, 'gggg', '2021-05-14 07:37:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (323, 24, 9, '', '2021-05-14 07:38:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (324, 25, 9, '', '2021-05-14 08:15:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (325, 120, 3, '', '2021-05-14 08:21:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (326, 120, 33, '', '2021-05-14 08:21:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (327, 120, 34, '', '2021-05-14 08:21:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (328, 120, 35, '', '2021-05-14 08:21:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (329, 120, 36, '', '2021-05-14 08:21:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (330, 26, 9, '', '2021-05-14 08:22:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (331, 136, 5, '', '2021-05-14 08:23:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (332, 136, 12, '', '2021-05-14 08:23:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (333, 136, 30, '', '2021-05-14 08:23:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (334, 136, 31, '', '2021-05-14 08:23:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (335, 136, 32, '', '2021-05-14 08:23:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (336, 38, 1, '', '2021-05-14 08:23:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (337, 121, 3, '', '2021-05-14 08:47:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (338, 121, 33, '', '2021-05-14 08:47:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (339, 121, 34, '', '2021-05-14 08:47:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (340, 121, 35, '', '2021-05-14 08:47:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (341, 121, 36, '', '2021-05-14 08:47:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (342, 122, 3, '', '2021-05-14 10:12:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (343, 122, 33, '', '2021-05-14 10:12:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (344, 122, 34, '', '2021-05-14 10:12:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (345, 122, 35, '', '2021-05-14 10:12:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (346, 122, 36, '', '2021-05-14 10:12:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (347, 39, 1, '', '2021-05-14 10:15:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (348, 0, 37, '', '2021-05-14 10:50:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (349, 0, 38, '', '2021-05-14 10:50:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (350, 0, 39, '', '2021-05-14 10:50:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (351, 33, 6, '', '2021-05-14 10:50:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (352, 33, 37, '', '2021-05-14 10:50:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (353, 33, 38, '', '2021-05-14 10:50:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (354, 33, 39, '', '2021-05-14 10:50:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (355, 4, 5, '', '2021-05-14 10:59:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (356, 4, 12, '', '2021-05-14 10:59:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (357, 4, 30, '', '2021-05-14 10:59:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (358, 4, 31, '', '2021-05-14 10:59:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (359, 4, 32, '', '2021-05-14 10:59:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (360, 0, 7, '', '2021-05-14 11:11:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (361, 0, 18, '', '2021-05-14 11:11:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (362, 0, 19, '', '2021-05-14 11:11:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (363, 0, 20, '', '2021-05-14 11:11:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (364, 49, 7, '', '2021-05-14 11:11:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (365, 49, 18, '', '2021-05-14 11:11:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (366, 49, 19, '', '2021-05-14 11:11:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (367, 49, 20, '', '2021-05-14 11:11:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (368, 123, 3, '', '2021-05-14 11:36:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (369, 123, 33, '', '2021-05-14 11:36:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (370, 123, 34, '', '2021-05-14 11:36:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (371, 123, 35, '', '2021-05-14 11:36:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (372, 123, 36, '', '2021-05-14 11:36:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (373, 137, 5, '', '2021-05-14 11:51:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (374, 137, 12, '', '2021-05-14 11:51:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (375, 137, 30, '', '2021-05-14 11:51:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (376, 137, 31, '', '2021-05-14 11:51:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (377, 137, 32, '', '2021-05-14 11:51:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (378, 124, 3, '', '2021-05-14 11:53:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (379, 124, 33, '', '2021-05-14 11:53:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (380, 124, 34, '', '2021-05-14 11:53:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (381, 124, 35, '', '2021-05-14 11:53:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (382, 124, 36, '', '2021-05-14 11:53:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (383, 125, 3, '', '2021-05-14 11:53:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (384, 125, 33, '', '2021-05-14 11:53:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (385, 125, 34, '', '2021-05-14 11:53:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (386, 125, 35, '', '2021-05-14 11:53:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (387, 125, 36, '', '2021-05-14 11:53:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (388, 37, 6, '', '2021-05-15 06:46:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (389, 37, 37, '', '2021-05-15 06:46:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (390, 37, 38, '', '2021-05-15 06:46:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (391, 37, 39, '', '2021-05-15 06:46:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (392, 38, 6, '', '2021-05-15 06:47:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (393, 38, 37, '', '2021-05-15 06:47:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (394, 38, 38, '', '2021-05-15 06:47:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (395, 38, 39, '', '2021-05-15 06:47:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (396, 58, 13, 'hththhthth', '2021-05-15 11:27:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (397, 126, 3, '', '2021-05-17 06:18:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (398, 126, 33, '', '2021-05-17 06:18:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (399, 126, 34, '', '2021-05-17 06:18:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (400, 126, 35, '', '2021-05-17 06:18:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (401, 126, 36, '', '2021-05-17 06:18:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (402, 127, 3, '', '2021-05-17 06:21:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (403, 127, 33, '', '2021-05-17 06:21:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (404, 127, 34, '', '2021-05-17 06:21:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (405, 127, 35, '', '2021-05-17 06:21:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (406, 127, 36, '', '2021-05-17 06:21:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (407, 6, 5, '', '2021-05-17 06:30:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (408, 6, 12, '', '2021-05-17 06:30:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (409, 6, 30, '', '2021-05-17 06:30:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (410, 6, 31, '', '2021-05-17 06:30:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (411, 6, 32, '', '2021-05-17 06:30:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (412, 0, 7, '', '2021-05-17 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (413, 0, 18, '', '2021-05-17 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (414, 0, 19, '', '2021-05-17 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (415, 0, 20, '', '2021-05-17 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (416, 48, 7, '', '2021-05-17 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (417, 48, 18, '', '2021-05-17 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (418, 48, 19, '', '2021-05-17 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (419, 48, 20, '', '2021-05-17 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (420, 50, 7, '', '2021-05-17 09:24:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (421, 50, 18, '', '2021-05-17 09:24:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (422, 50, 19, '', '2021-05-17 09:24:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (423, 50, 20, '', '2021-05-17 09:24:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (424, 39, 6, '', '2021-05-17 12:43:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (425, 39, 37, '', '2021-05-17 12:43:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (426, 39, 38, '', '2021-05-17 12:43:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (427, 39, 39, '', '2021-05-17 12:43:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (428, 40, 6, '', '2021-05-17 14:01:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (429, 40, 37, '', '2021-05-17 14:01:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (430, 40, 38, '', '2021-05-17 14:01:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (431, 40, 39, '', '2021-05-17 14:01:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (432, 41, 6, '', '2021-05-17 14:01:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (433, 41, 37, '', '2021-05-17 14:01:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (434, 41, 38, '', '2021-05-17 14:01:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (435, 41, 39, '', '2021-05-17 14:01:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (436, 41, 1, '', '2021-05-18 04:46:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (437, 31, 2, '', '2021-05-18 04:56:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (438, 31, 10, '', '2021-05-18 04:56:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (439, 31, 40, 'rr', '2021-05-18 04:56:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (440, 138, 5, '', '2021-05-18 06:40:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (441, 138, 12, '', '2021-05-18 06:40:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (442, 138, 30, '', '2021-05-18 06:40:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (443, 138, 31, '', '2021-05-18 06:40:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (444, 138, 32, '', '2021-05-18 06:40:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (445, 42, 1, '', '2021-05-18 06:41:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (446, 51, 7, '', '2021-05-18 10:08:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (447, 51, 18, '', '2021-05-18 10:08:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (448, 51, 19, '', '2021-05-18 10:08:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (449, 51, 20, '', '2021-05-18 10:08:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (450, 0, 6, 'Printreportpharma', '2021-06-03 10:40:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (451, 42, 37, 'Custom field', '2021-05-18 16:32:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (452, 42, 38, 'Custom field', '2021-05-18 16:32:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (453, 42, 39, 'Custom field', '2021-05-18 16:32:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (454, 44, 1, '', '2021-05-19 04:39:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (455, 128, 3, '', '2021-05-19 04:55:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (456, 128, 33, '', '2021-05-19 04:55:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (457, 128, 34, '', '2021-05-19 04:55:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (458, 128, 35, '', '2021-05-19 04:55:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (459, 128, 36, '', '2021-05-19 04:55:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (460, 139, 5, '', '2021-05-19 05:04:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (461, 139, 12, '', '2021-05-19 05:04:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (462, 139, 30, '', '2021-05-19 05:04:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (463, 139, 31, '', '2021-05-19 05:04:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (464, 139, 32, '', '2021-05-19 05:04:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (465, 45, 1, '', '2021-05-19 05:05:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (466, 129, 3, '', '2021-05-19 05:06:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (467, 129, 33, '', '2021-05-19 05:06:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (468, 129, 34, '', '2021-05-19 05:06:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (469, 129, 35, '', '2021-05-19 05:06:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (470, 129, 36, '', '2021-05-19 05:06:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (471, 25, 42, 'hhht', '2021-05-20 06:13:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (472, 0, 6, '', '2021-05-21 05:22:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (473, 0, 6, '', '2021-05-22 06:55:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (474, 140, 5, '', '2021-05-21 06:32:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (475, 140, 12, '', '2021-05-21 06:32:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (476, 140, 30, '', '2021-05-21 06:32:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (477, 140, 31, '', '2021-05-21 06:32:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (478, 141, 5, '', '2021-05-21 06:40:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (479, 141, 12, '', '2021-05-21 06:40:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (480, 141, 30, '', '2021-05-21 06:40:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (481, 141, 31, '', '2021-05-21 06:40:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (482, 142, 5, '', '2021-05-21 06:41:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (483, 142, 12, '', '2021-05-21 06:41:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (484, 142, 30, '', '2021-05-21 06:41:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (485, 142, 31, '', '2021-05-21 06:41:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (486, 143, 5, '', '2021-05-21 06:41:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (487, 143, 12, '', '2021-05-21 06:41:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (488, 143, 30, '', '2021-05-21 06:41:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (489, 143, 31, '', '2021-05-21 06:41:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (490, 43, 6, '', '2021-05-22 06:55:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (491, 0, 6, '', '2021-06-16 16:34:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (492, 144, 5, '', '2021-05-22 16:01:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (493, 144, 12, '', '2021-05-22 16:01:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (494, 144, 30, '', '2021-05-22 16:01:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (495, 144, 31, '', '2021-05-22 16:01:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (496, 7, 15, 'aa', '2021-05-24 07:11:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (497, 7, 16, '', '2021-05-24 07:11:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (498, 8, 15, 'aa', '2021-05-24 07:17:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (499, 8, 16, '', '2021-05-24 07:17:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (500, 9, 15, 'aa', '2021-05-24 07:48:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (501, 9, 16, 'adfafdsafasf', '2021-05-24 07:48:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (502, 10, 15, 'aa', '2021-05-25 07:56:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (503, 10, 16, '', '2021-05-25 07:56:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (504, 11, 15, 'aa', '2021-05-25 07:58:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (505, 11, 16, '', '2021-05-25 07:58:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (506, 12, 15, 'aa', '2021-05-25 08:00:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (507, 12, 16, '', '2021-05-25 08:00:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (508, 13, 15, 'aa', '2021-05-25 08:04:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (509, 13, 16, '', '2021-05-25 08:04:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (510, 14, 15, 'aa', '2021-05-25 08:07:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (511, 14, 16, '', '2021-05-25 08:07:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (512, 17, 15, 'aa', '2021-05-25 08:20:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (513, 17, 16, '', '2021-05-25 08:20:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (514, 145, 5, '', '2021-05-25 12:24:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (515, 145, 12, '', '2021-05-25 12:24:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (516, 145, 30, '', '2021-05-25 12:24:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (517, 145, 31, '', '2021-05-25 12:24:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (518, 4, 43, 'asfd', '2021-06-28 09:51:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (519, 1, 44, '', '2021-05-25 13:02:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (520, 18, 15, 'aa', '2021-05-26 04:59:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (521, 18, 16, '', '2021-05-26 04:59:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (522, 19, 15, 'aa', '2021-05-26 05:06:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (523, 19, 16, '', '2021-05-26 05:06:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (524, 20, 15, 'aa', '2021-05-26 07:43:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (525, 20, 16, '', '2021-05-26 07:43:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (526, 21, 15, 'aa', '2021-05-26 07:46:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (527, 21, 16, '', '2021-05-26 07:46:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (528, 5, 21, 'Report', '2021-05-27 06:49:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (529, 5, 45, 'Report', '2021-05-27 06:49:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (530, 6, 21, 'sdf', '2021-05-27 06:58:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (531, 6, 45, 'sdf', '2021-05-27 06:58:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (532, 26, 42, '', '2021-05-27 07:47:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (533, 7, 21, 'ghj', '2021-05-27 10:47:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (534, 7, 45, 'ghj', '2021-05-27 10:47:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (535, 4, 14, '', '2021-05-27 12:08:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (536, 4, 25, '', '2021-05-27 12:08:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (537, 4, 26, '', '2021-05-27 12:08:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (538, 4, 27, '', '2021-05-27 12:08:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (539, 4, 28, '', '2021-05-27 12:08:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (540, 22, 15, 'aa', '2021-05-28 10:57:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (541, 22, 16, '', '2021-05-28 10:57:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (542, 23, 15, 'aa', '2021-05-28 11:46:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (543, 23, 16, '', '2021-05-28 11:46:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (544, 8, 21, 'gdfg', '2021-05-31 04:45:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (545, 8, 45, 'dfg', '2021-05-31 04:45:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (546, 46, 1, '', '2021-05-31 04:46:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (547, 9, 21, 'tert', '2021-05-31 05:14:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (548, 9, 45, 'ert', '2021-05-31 05:14:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (549, 10, 21, '', '2021-05-31 13:28:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (550, 10, 45, '', '2021-05-31 13:28:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (551, 146, 5, '', '2021-06-02 06:03:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (552, 146, 12, '', '2021-06-02 06:03:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (553, 146, 30, '', '2021-06-02 06:03:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (554, 146, 31, '', '2021-06-02 06:03:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (555, 47, 1, '', '2021-06-02 06:06:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (556, 48, 1, '', '2021-06-02 06:07:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (557, 130, 3, '', '2021-06-02 07:14:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (558, 130, 33, '', '2021-06-02 07:14:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (559, 130, 34, '', '2021-06-02 07:14:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (560, 130, 35, '', '2021-06-02 07:14:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (561, 130, 36, '', '2021-06-02 07:14:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (562, 130, 46, 'tttttrrrrr', '2021-06-02 07:14:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (563, 147, 5, '', '2021-06-02 16:34:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (564, 147, 12, '', '2021-06-02 16:34:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (565, 147, 30, '', '2021-06-02 16:34:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (566, 147, 31, '', '2021-06-02 16:34:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (567, 49, 1, '', '2021-06-02 16:37:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (568, 33, 2, '', '2021-06-03 06:30:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (569, 33, 10, '', '2021-06-03 06:30:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (570, 33, 40, 'asdfa', '2021-06-03 06:30:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (571, 50, 1, '', '2021-06-03 06:59:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (572, 51, 1, '', '2021-06-03 07:00:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (573, 35, 2, '', '2021-06-03 07:02:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (574, 35, 10, '', '2021-06-03 07:02:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (575, 35, 40, 'asdfsa', '2021-06-03 07:02:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (576, 148, 5, '', '2021-06-03 09:23:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (577, 148, 12, '', '2021-06-03 09:23:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (578, 148, 30, '', '2021-06-03 09:23:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (579, 148, 31, '', '2021-06-03 09:23:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (580, 149, 5, '', '2021-06-03 09:23:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (581, 149, 12, '', '2021-06-03 09:23:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (582, 149, 30, '', '2021-06-03 09:23:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (583, 149, 31, '', '2021-06-03 09:23:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (584, 150, 5, '', '2021-06-03 09:23:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (585, 150, 12, '', '2021-06-03 09:23:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (586, 150, 30, '', '2021-06-03 09:23:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (587, 150, 31, '', '2021-06-03 09:23:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (588, 151, 5, '', '2021-06-03 09:23:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (589, 151, 12, '', '2021-06-03 09:23:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (590, 151, 30, '', '2021-06-03 09:23:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (591, 151, 31, '', '2021-06-03 09:23:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (592, 152, 5, '', '2021-06-03 09:23:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (593, 152, 12, '', '2021-06-03 09:23:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (594, 152, 30, '', '2021-06-03 09:23:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (595, 152, 31, '', '2021-06-03 09:23:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (596, 153, 5, '', '2021-06-03 09:23:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (597, 153, 12, '', '2021-06-03 09:23:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (598, 153, 30, '', '2021-06-03 09:23:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (599, 153, 31, '', '2021-06-03 09:23:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (600, 154, 5, '', '2021-06-03 09:23:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (601, 154, 12, '', '2021-06-03 09:23:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (602, 154, 30, '', '2021-06-03 09:23:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (603, 154, 31, '', '2021-06-03 09:23:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (604, 155, 5, '', '2021-06-03 09:23:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (605, 155, 12, '', '2021-06-03 09:23:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (606, 155, 30, '', '2021-06-03 09:23:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (607, 155, 31, '', '2021-06-03 09:23:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (608, 156, 5, '', '2021-06-03 09:24:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (609, 156, 12, '', '2021-06-03 09:24:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (610, 156, 30, '', '2021-06-03 09:24:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (611, 156, 31, '', '2021-06-03 09:24:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (612, 157, 5, '', '2021-06-03 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (613, 157, 12, '', '2021-06-03 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (614, 157, 30, '', '2021-06-03 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (615, 157, 31, '', '2021-06-03 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (616, 158, 5, '', '2021-06-03 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (617, 158, 12, '', '2021-06-03 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (618, 158, 30, '', '2021-06-03 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (619, 158, 31, '', '2021-06-03 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (620, 159, 5, '', '2021-06-03 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (621, 159, 12, '', '2021-06-03 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (622, 159, 30, '', '2021-06-03 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (623, 159, 31, '', '2021-06-03 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (624, 160, 5, '', '2021-06-03 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (625, 160, 12, '', '2021-06-03 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (626, 160, 30, '', '2021-06-03 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (627, 160, 31, '', '2021-06-03 09:24:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (628, 161, 5, '', '2021-06-03 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (629, 161, 12, '', '2021-06-03 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (630, 161, 30, '', '2021-06-03 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (631, 161, 31, '', '2021-06-03 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (632, 162, 5, '', '2021-06-03 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (633, 162, 12, '', '2021-06-03 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (634, 162, 30, '', '2021-06-03 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (635, 162, 31, '', '2021-06-03 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (636, 163, 5, '', '2021-06-03 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (637, 163, 12, '', '2021-06-03 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (638, 163, 30, '', '2021-06-03 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (639, 163, 31, '', '2021-06-03 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (640, 164, 5, '', '2021-06-03 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (641, 164, 12, '', '2021-06-03 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (642, 164, 30, '', '2021-06-03 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (643, 164, 31, '', '2021-06-03 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (644, 36, 2, '', '2021-06-03 09:35:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (645, 36, 10, '', '2021-06-03 09:35:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (646, 36, 40, 'ttt', '2021-06-03 09:35:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (647, 131, 3, 'f fn', '2021-06-03 09:49:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (648, 131, 33, 'rfrf', '2021-06-03 09:49:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (649, 131, 34, 'rffnfm', '2021-06-03 09:49:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (650, 131, 35, 'frf', '2021-06-03 09:49:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (651, 131, 36, 'frfr', '2021-06-03 09:49:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (652, 131, 46, 'fff', '2021-06-03 09:49:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (653, 132, 3, 'f fn', '2021-06-03 09:49:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (654, 132, 33, 'rfrf', '2021-06-03 09:49:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (655, 132, 34, 'rffnfm', '2021-06-03 09:49:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (656, 132, 35, 'frf', '2021-06-03 09:49:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (657, 132, 36, 'frfr', '2021-06-03 09:49:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (658, 132, 46, 'fff', '2021-06-03 09:49:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (659, 133, 3, 'ff', '2021-06-03 09:52:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (660, 133, 33, 'ff', '2021-06-03 09:52:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (661, 133, 34, 'fff', '2021-06-03 09:52:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (662, 133, 35, 'fff', '2021-06-03 09:52:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (663, 133, 36, '', '2021-06-03 09:52:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (664, 133, 46, '', '2021-06-03 09:52:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (665, 165, 5, '', '2021-06-03 09:55:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (666, 165, 12, '', '2021-06-03 09:55:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (667, 165, 30, '', '2021-06-03 09:55:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (668, 165, 31, '', '2021-06-03 09:55:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (669, 166, 5, '', '2021-06-03 09:56:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (670, 166, 12, '', '2021-06-03 09:56:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (671, 166, 30, '', '2021-06-03 09:56:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (672, 166, 31, '', '2021-06-03 09:56:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (673, 42, 6, 'Printreportpharma', '2021-06-03 10:40:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (674, 11, 45, 'ry', '2021-06-03 11:23:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (675, 37, 40, 'tttt', '2021-06-03 11:24:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (676, 52, 1, 'tttttttttttttt', '2021-06-04 07:07:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (677, 53, 1, '', '2021-06-04 09:34:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (678, 72, 13, '', '2021-06-04 10:13:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (679, 72, 41, 'jlkjl', '2021-06-04 10:13:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (680, 12, 45, 'ewr', '2021-06-05 10:54:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (681, 13, 45, '', '2021-06-07 07:27:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (682, 14, 45, '', '2021-06-07 07:28:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (683, 15, 45, '', '2021-06-07 07:31:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (684, 16, 45, '', '2021-06-07 07:35:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (685, 18, 45, '', '2021-06-07 07:40:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (686, 52, 7, 'dfg', '2021-06-07 12:09:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (687, 52, 18, 'dfg', '2021-06-07 12:09:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (688, 52, 19, 'dfg', '2021-06-07 12:09:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (689, 52, 20, 'dfg', '2021-06-07 12:09:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (690, 24, 15, 'aa', '2021-06-08 12:01:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (691, 24, 16, 'color', '2021-06-08 12:01:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (692, 24, 47, '', '2021-06-08 12:01:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (693, 18, 45, '', '2021-06-09 06:07:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (694, 19, 45, '', '2021-06-09 08:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (695, 6, 45, '', '2021-06-09 10:15:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (696, 6, 45, '', '2021-06-09 10:17:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (697, 6, 45, '', '2021-06-09 10:17:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (698, 54, 1, '', '2021-06-14 05:50:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (699, 167, 12, '', '2021-06-14 05:54:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (700, 167, 30, '', '2021-06-14 05:54:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (701, 167, 31, '', '2021-06-14 05:54:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (702, 168, 12, '', '2021-06-14 05:54:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (703, 168, 30, '', '2021-06-14 05:54:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (704, 168, 31, '', '2021-06-14 05:54:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (705, 169, 12, '', '2021-06-14 05:54:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (706, 169, 30, '', '2021-06-14 05:54:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (707, 169, 31, '', '2021-06-14 05:54:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (708, 170, 12, '', '2021-06-14 05:54:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (709, 170, 30, '', '2021-06-14 05:54:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (710, 170, 31, '', '2021-06-14 05:54:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (711, 171, 12, '', '2021-06-14 05:54:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (712, 171, 30, '', '2021-06-14 05:54:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (713, 171, 31, '', '2021-06-14 05:54:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (714, 172, 12, '', '2021-06-14 05:54:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (715, 172, 30, '', '2021-06-14 05:54:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (716, 172, 31, '', '2021-06-14 05:54:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (717, 173, 12, '', '2021-06-14 05:54:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (718, 173, 30, '', '2021-06-14 05:54:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (719, 173, 31, '', '2021-06-14 05:54:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (720, 27, 42, '', '2021-06-14 10:19:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (721, 25, 15, 'aa', '2021-06-14 10:48:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (722, 25, 16, '', '2021-06-14 10:48:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (723, 25, 47, '', '2021-06-14 10:48:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (724, 9, 45, 'ggggfhgf', '2021-06-15 12:26:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (725, 174, 12, '', '2021-06-16 16:00:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (726, 174, 30, '', '2021-06-16 16:00:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (727, 174, 31, '', '2021-06-16 16:00:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (728, 175, 12, '', '2021-06-16 16:00:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (729, 175, 30, '', '2021-06-16 16:00:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (730, 175, 31, '', '2021-06-16 16:00:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (731, 176, 12, '', '2021-06-16 16:00:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (732, 176, 30, '', '2021-06-16 16:00:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (733, 176, 31, '', '2021-06-16 16:00:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (734, 177, 12, '', '2021-06-16 16:00:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (735, 177, 30, '', '2021-06-16 16:00:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (736, 177, 31, '', '2021-06-16 16:00:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (737, 178, 12, '', '2021-06-16 16:01:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (738, 178, 30, '', '2021-06-16 16:01:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (739, 178, 31, '', '2021-06-16 16:01:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (740, 179, 12, '', '2021-06-16 16:09:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (741, 179, 30, '', '2021-06-16 16:09:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (742, 179, 31, '', '2021-06-16 16:09:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (743, 180, 12, '', '2021-06-16 16:10:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (744, 180, 30, '', '2021-06-16 16:10:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (745, 180, 31, '', '2021-06-16 16:10:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (746, 181, 12, '', '2021-06-16 16:12:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (747, 181, 30, '', '2021-06-16 16:12:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (748, 181, 31, '', '2021-06-16 16:12:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (749, 182, 12, '', '2021-06-16 16:20:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (750, 182, 30, '', '2021-06-16 16:20:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (751, 182, 31, '', '2021-06-16 16:20:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (752, 44, 6, '', '2021-06-16 16:34:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (753, 183, 12, '', '2021-06-17 05:25:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (754, 183, 30, '', '2021-06-17 05:25:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (755, 183, 31, '', '2021-06-17 05:25:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (756, 134, 3, 'blood', '2021-06-17 05:51:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (757, 134, 33, '', '2021-06-17 05:51:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (758, 134, 34, '', '2021-06-17 05:51:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (759, 134, 35, '', '2021-06-17 05:51:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (760, 134, 36, '', '2021-06-17 05:51:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (761, 134, 46, '', '2021-06-17 05:51:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (762, 184, 12, '', '2021-06-17 05:55:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (763, 184, 30, '', '2021-06-17 05:55:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (764, 184, 31, '', '2021-06-17 05:55:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (765, 135, 3, 'dfd', '2021-06-17 05:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (766, 135, 33, '', '2021-06-17 05:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (767, 135, 34, '', '2021-06-17 05:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (768, 135, 35, '', '2021-06-17 05:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (769, 135, 36, '', '2021-06-17 05:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (770, 135, 46, '', '2021-06-17 05:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (771, 136, 3, 'hrhrh', '2021-06-17 06:00:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (772, 136, 33, 'dbhh', '2021-06-17 06:00:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (773, 136, 34, 'hhrth', '2021-06-17 06:00:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (774, 136, 35, 'ghreghr', '2021-06-17 06:00:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (775, 136, 36, 'rghre', '2021-06-17 06:00:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (776, 136, 46, 'ege', '2021-06-17 06:00:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (777, 137, 3, 'gd', '2021-06-17 06:01:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (778, 137, 33, 'gd', '2021-06-17 06:01:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (779, 137, 34, 'dg', '2021-06-17 06:01:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (780, 137, 35, 'dfg', '2021-06-17 06:01:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (781, 137, 36, 'dfgd', '2021-06-17 06:01:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (782, 137, 46, 'g', '2021-06-17 06:01:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (783, 55, 1, '', '2021-06-17 06:02:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (784, 56, 1, '', '2021-06-17 06:12:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (785, 38, 2, '', '2021-06-17 06:14:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (786, 38, 10, '', '2021-06-17 06:14:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (787, 38, 40, 'gsg', '2021-06-17 06:14:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (788, 27, 9, 'xa', '2021-06-17 06:20:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (789, 6, 8, '', '2021-06-17 10:13:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (790, 6, 17, '', '2021-06-17 10:13:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (791, 57, 1, '', '2021-06-17 14:12:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (792, 58, 1, '', '2021-06-17 14:18:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (793, 59, 1, '', '2021-06-17 14:45:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (794, 60, 1, '', '2021-06-17 15:38:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (795, 61, 1, '', '2021-06-17 15:43:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (796, 62, 1, '', '2021-06-17 15:45:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (797, 63, 1, '', '2021-06-17 15:46:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (798, 64, 1, '', '2021-06-17 15:54:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (799, 65, 1, '', '2021-06-17 15:56:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (800, 66, 1, '', '2021-06-17 15:57:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (801, 67, 1, '', '2021-06-17 15:58:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (802, 68, 1, '', '2021-06-17 16:00:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (803, 185, 12, '', '2021-06-17 16:03:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (804, 185, 30, '', '2021-06-17 16:03:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (805, 185, 31, '', '2021-06-17 16:03:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (806, 69, 1, '', '2021-06-17 16:04:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (807, 186, 12, '', '2021-06-18 05:12:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (808, 186, 30, '', '2021-06-18 05:12:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (809, 186, 31, '', '2021-06-18 05:12:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (810, 70, 1, '', '2021-06-18 05:13:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (811, 3, 17, '', '2021-06-18 07:19:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (812, 8, 8, '', '2021-06-18 07:20:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (813, 8, 17, '', '2021-06-18 07:20:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (814, 15, 8, '', '2021-06-18 07:21:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (815, 15, 17, '', '2021-06-18 07:21:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (816, 7, 8, '', '2021-06-18 07:22:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (817, 7, 17, '', '2021-06-18 07:22:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (818, 17, 8, '', '2021-06-18 07:22:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (819, 17, 17, '', '2021-06-18 07:22:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (820, 24, 17, '', '2021-06-18 07:30:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (821, 139, 3, 'hhbrftg', '2021-06-18 09:35:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (822, 139, 33, 'rthtrh', '2021-06-18 09:35:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (823, 139, 34, 'trhtrh', '2021-06-18 09:35:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (824, 139, 35, 'gtrht', '2021-06-18 09:35:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (825, 139, 36, '', '2021-06-18 09:35:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (826, 139, 46, '', '2021-06-18 09:35:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (827, 188, 12, '', '2021-06-18 09:53:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (828, 188, 30, '', '2021-06-18 09:53:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (829, 188, 31, '', '2021-06-18 09:53:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (830, 71, 1, '', '2021-06-18 09:53:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (831, 189, 12, '', '2021-06-18 10:10:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (832, 189, 30, '', '2021-06-18 10:10:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (833, 189, 31, '', '2021-06-18 10:10:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (834, 72, 1, 'ikliui', '2021-06-18 10:12:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (835, 92, 13, '', '2021-06-18 10:29:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (836, 92, 41, 'jmhmhmhumhujjm', '2021-06-18 10:29:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (837, 93, 13, '', '2021-06-18 11:04:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (838, 93, 41, 'dcdcd', '2021-06-18 11:04:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (839, 190, 12, '', '2021-06-18 11:34:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (840, 190, 30, '', '2021-06-18 11:34:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (841, 190, 31, '', '2021-06-18 11:34:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (842, 73, 1, '', '2021-06-18 11:34:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (843, 53, 7, '', '2021-06-18 11:59:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (844, 53, 18, '', '2021-06-18 11:59:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (845, 53, 19, '', '2021-06-18 11:59:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (846, 53, 20, '', '2021-06-18 11:59:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (847, 28, 42, 'dwdwdwdwdwdddwd', '2021-06-18 12:00:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (848, 26, 15, 'aa', '2021-06-18 12:06:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (849, 26, 16, 'white', '2021-06-18 12:06:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (850, 26, 47, '', '2021-06-18 12:06:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (851, 140, 3, 'dfds', '2021-06-18 12:08:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (852, 140, 33, '', '2021-06-18 12:08:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (853, 140, 34, '', '2021-06-18 12:08:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (854, 140, 35, '', '2021-06-18 12:08:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (855, 140, 36, '', '2021-06-18 12:08:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (856, 140, 46, '', '2021-06-18 12:08:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (857, 74, 1, '', '2021-06-18 13:04:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (858, 75, 1, '', '2021-06-18 15:20:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (859, 97, 13, 'a', '2021-06-18 15:40:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (860, 97, 41, 'b', '2021-06-18 15:40:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (861, 98, 13, 'a', '2021-06-18 15:45:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (862, 98, 41, 'ab', '2021-06-18 15:45:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (863, 99, 13, 'a', '2021-06-18 16:41:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (864, 99, 41, 'bb', '2021-06-18 16:41:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (865, 141, 34, 'nana', '2021-06-19 05:20:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (866, 141, 35, 'nanana', '2021-06-19 05:20:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (867, 141, 36, 'nanana', '2021-06-19 05:20:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (868, 141, 46, 'nananan', '2021-06-19 05:20:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (869, 76, 1, '', '2021-06-19 05:41:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (870, 142, 34, 'rfvrjkfreoke', '2021-06-19 05:53:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (871, 142, 35, 'erfpokropfrefporpfuiliu', '2021-06-21 05:52:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (872, 142, 36, 'rfrkfejofi', '2021-06-19 05:53:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (873, 142, 46, 'fguiyrffguierf', '2021-06-19 05:53:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (874, 191, 12, 'vbfvbfg', '2021-06-19 05:58:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (875, 191, 30, 'fbvfgbvf', '2021-06-19 05:58:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (876, 191, 31, 'hnghn', '2021-06-19 05:58:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (877, 77, 1, '', '2021-06-19 06:00:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (878, 78, 1, '', '2021-06-19 06:29:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (879, 79, 1, '', '2021-06-19 06:30:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (880, 80, 1, 'test', '2021-06-19 06:33:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (881, 81, 1, '', '2021-06-19 06:43:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (882, 82, 1, '', '2021-06-19 06:44:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (883, 192, 12, '', '2021-06-19 10:53:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (884, 192, 30, '', '2021-06-19 10:53:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (885, 192, 31, '', '2021-06-19 10:53:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (886, 83, 1, 'gvrtgvrtgt', '2021-06-19 10:57:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (887, 193, 12, '', '2021-06-19 11:40:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (888, 193, 30, '', '2021-06-19 11:40:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (889, 193, 31, '', '2021-06-19 11:40:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (890, 84, 48, 'ASF547BD', '2021-06-19 11:41:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (891, 109, 49, 'hgjnghngh', '2021-06-19 11:56:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (892, 143, 34, 'gtrfgrtf', '2021-06-21 05:44:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (893, 143, 35, 'grtfgbtr', '2021-06-21 05:44:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (894, 143, 36, 'trgtrg', '2021-06-21 05:44:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (895, 143, 46, 'rtgrtg', '2021-06-21 05:44:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (896, 144, 34, 'bf', '2021-06-21 05:46:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (897, 144, 35, 'fg', '2021-06-21 05:46:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (898, 144, 36, 'fdgfdgfd', '2021-06-21 05:46:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (899, 144, 46, 'gdfg', '2021-06-21 05:46:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (900, 145, 34, 'frgvrdfgrd', '2021-06-21 06:24:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (901, 145, 35, 'grdgrt', '2021-06-21 06:24:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (902, 145, 36, 'grtgrtg', '2021-06-21 06:24:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (903, 145, 46, 'rtgrtgrtg', '2021-06-21 06:24:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (904, 85, 48, '001245', '2021-06-21 06:25:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (905, 85, 51, 'dfgfgf', '2021-06-21 06:25:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (906, 148, 34, '', '2021-06-21 06:36:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (907, 148, 35, '', '2021-06-21 06:36:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (908, 148, 36, '', '2021-06-21 06:36:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (909, 148, 46, '', '2021-06-21 06:36:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (910, 21, 45, '', '2021-06-21 09:17:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (911, 27, 15, 'aa', '2021-06-21 09:18:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (912, 27, 16, 'fg', '2021-06-21 09:18:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (913, 27, 47, 'ffvfd', '2021-06-21 09:18:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (914, 198, 50, 'dfgvdhdguyhd', '2021-06-21 09:33:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (915, 86, 48, '01258465', '2021-06-21 09:34:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (916, 86, 51, 'testban', '2021-06-21 09:34:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (917, 199, 50, 'Full address *', '2021-06-21 09:35:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (918, 201, 50, 'op.;po;', '2021-06-21 09:43:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (919, 87, 48, '012546', '2021-06-21 09:48:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (920, 87, 51, 'dgfey', '2021-06-21 09:48:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (921, 88, 48, 'adfd', '2021-06-21 09:58:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (922, 88, 51, 'dfsdfsdfsd', '2021-06-21 09:58:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (923, 89, 48, 'fvdv', '2021-06-21 09:59:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (924, 89, 51, 'fdf', '2021-06-21 09:59:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (925, 90, 48, 'aa', '2021-06-21 10:04:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (926, 90, 51, 'aaa', '2021-06-21 10:04:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (927, 91, 48, 'h01', '2021-06-21 10:05:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (928, 91, 51, 'h', '2021-06-21 10:05:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (929, 92, 48, 'aaa', '2021-06-21 10:07:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (930, 92, 51, 'aaaa', '2021-06-21 10:07:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (931, 93, 48, 'aaa', '2021-06-21 10:07:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (932, 93, 51, 'aaa', '2021-06-21 10:07:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (933, 151, 34, '', '2021-06-21 10:29:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (934, 151, 35, '', '2021-06-21 10:29:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (935, 151, 36, '', '2021-06-21 10:29:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (936, 151, 46, '', '2021-06-21 10:29:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (937, 119, 49, 'hfdhvdfjhvfduvf', '2021-06-21 10:36:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (938, 202, 50, 'rferfer', '2021-06-21 10:40:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (939, 94, 48, '01255', '2021-06-21 10:42:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (940, 94, 51, 'trgrtgrtg', '2021-06-21 10:42:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (941, 158, 34, '', '2021-06-21 10:51:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (942, 158, 35, '', '2021-06-21 10:51:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (943, 158, 36, '', '2021-06-21 10:51:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (944, 158, 46, 'asdfaf', '2021-06-21 10:55:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (945, 191, 50, '12 Glen Abbey St, Rouse Hill, NSW 2155', '2021-06-21 11:43:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (946, 95, 48, '0212', '2021-06-21 11:51:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (947, 95, 51, 'na', '2021-06-21 11:51:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (948, 159, 34, '', '2021-06-21 11:59:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (949, 159, 35, '', '2021-06-21 11:59:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (950, 159, 36, '', '2021-06-21 11:59:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (951, 159, 46, '', '2021-06-21 11:59:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (952, 204, 50, 'gfgf', '2021-06-21 11:59:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (953, 96, 48, '11', '2021-06-21 12:00:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (954, 96, 51, '8', '2021-06-21 12:00:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (955, 205, 50, 'INDORE', '2021-06-21 12:20:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (956, 40, 2, '', '2021-06-21 12:22:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (957, 40, 10, '', '2021-06-21 12:22:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (958, 40, 40, '6UTYUYT', '2021-06-21 12:22:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (959, 160, 34, '', '2021-06-21 12:32:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (960, 160, 35, '', '2021-06-21 12:32:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (961, 160, 36, '', '2021-06-21 12:32:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (962, 160, 46, '', '2021-06-21 12:32:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (963, 206, 50, 'INDORE', '2021-06-21 12:34:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (964, 97, 48, '01253', '2021-06-21 12:35:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (965, 97, 51, 'NA', '2021-06-21 12:35:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (966, 28, 15, 'aa', '2021-06-21 12:46:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (967, 28, 16, '', '2021-06-21 12:46:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (968, 28, 47, '', '2021-06-21 12:46:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (969, 161, 34, 'gghh', '2021-06-21 12:55:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (970, 161, 35, 'thth', '2021-06-21 12:55:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (971, 161, 36, 'ht', '2021-06-21 12:55:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (972, 161, 46, 'thth', '2021-06-21 12:55:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (973, 207, 50, '43r43r34r', '2021-06-21 12:55:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (974, 98, 48, '01254878', '2021-06-21 12:55:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (975, 98, 51, 'thtrhtr', '2021-06-21 12:55:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (976, 29, 15, 'aa', '2021-06-21 12:58:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (977, 29, 16, '', '2021-06-21 12:58:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (978, 29, 47, '', '2021-06-21 12:58:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (979, 162, 34, 'edfce', '2021-06-22 04:33:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (980, 162, 35, 'fefesf', '2021-06-22 04:33:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (981, 162, 36, 'sefe', '2021-06-22 04:33:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (982, 162, 46, 'fferfef', '2021-06-22 04:33:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (983, 208, 50, 'indore', '2021-06-22 04:34:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (984, 99, 48, 'e0124858', '2021-06-22 04:34:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (985, 99, 51, 'checkk', '2021-06-22 04:34:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (986, 164, 34, 'ba', '2021-06-22 06:11:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (987, 164, 35, 'BBD', '2021-06-22 06:11:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (988, 164, 36, 'DDD', '2021-06-22 06:11:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (989, 164, 46, 'DDDD', '2021-06-22 06:11:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (990, 165, 34, 'fgbfcb', '2021-06-22 06:44:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (991, 165, 35, 'bfbfg', '2021-06-22 06:44:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (992, 165, 36, 'bfgb', '2021-06-22 06:44:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (993, 165, 46, 'fgbfgb', '2021-06-22 06:44:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (994, 100, 48, '012512', '2021-06-22 06:53:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (995, 100, 51, 'gfjhtfghtjk', '2021-06-22 06:53:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (996, 166, 34, 'dsfds', '2021-06-22 06:57:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (997, 166, 35, 'fdf', '2021-06-22 06:57:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (998, 166, 36, 'sdfsd', '2021-06-22 06:57:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (999, 166, 46, 'fdsfcdsfc', '2021-06-22 06:57:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1000, 167, 34, 'ghng', '2021-06-22 07:06:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1001, 167, 35, 'gfhgfhgh', '2021-06-22 07:06:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1002, 167, 36, 'ghgf', '2021-06-22 07:06:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1003, 167, 46, 'hfghfgh', '2021-06-22 07:06:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1004, 54, 7, '', '2021-06-22 08:19:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1005, 54, 18, '', '2021-06-22 08:19:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1006, 54, 19, '', '2021-06-22 08:19:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1007, 54, 20, '', '2021-06-22 08:19:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1008, 55, 7, '', '2021-06-22 08:27:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1009, 55, 18, '', '2021-06-22 08:27:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1010, 55, 19, '', '2021-06-22 08:27:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1011, 55, 20, '', '2021-06-22 08:27:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1012, 56, 7, '', '2021-06-22 09:15:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1013, 56, 18, '', '2021-06-22 09:15:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1014, 56, 19, '', '2021-06-22 09:15:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1015, 56, 20, '', '2021-06-22 09:15:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1016, 57, 7, '', '2021-06-22 09:16:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1017, 57, 18, '', '2021-06-22 09:16:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1018, 57, 19, '', '2021-06-22 09:16:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1019, 57, 20, '', '2021-06-22 09:16:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1020, 58, 7, '', '2021-06-22 09:16:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1021, 58, 18, '', '2021-06-22 09:16:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1022, 58, 19, '', '2021-06-22 09:16:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1023, 58, 20, '', '2021-06-22 09:16:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1024, 169, 34, 'fgfdgdfg', '2021-06-22 09:45:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1025, 169, 35, '', '2021-06-22 09:45:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1026, 169, 36, '', '2021-06-22 09:45:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1027, 169, 46, 'fggf', '2021-06-22 09:45:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1028, 59, 7, '', '2021-06-22 10:42:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1029, 59, 18, '', '2021-06-22 10:42:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1030, 59, 19, '', '2021-06-22 10:42:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1031, 59, 20, '', '2021-06-22 10:42:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1032, 60, 7, '', '2021-06-22 10:42:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1033, 60, 18, '', '2021-06-22 10:42:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1034, 60, 19, '', '2021-06-22 10:42:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1035, 60, 20, '', '2021-06-22 10:42:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1036, 36, 7, '', '2021-06-22 10:43:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1037, 36, 18, '', '2021-06-22 10:43:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1038, 36, 19, '', '2021-06-22 10:43:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1039, 36, 20, '', '2021-06-22 10:43:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1040, 33, 18, '', '2021-06-22 10:43:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1041, 33, 19, '', '2021-06-22 10:43:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1042, 33, 20, '', '2021-06-22 10:43:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1043, 176, 34, 'qwerq', '2021-06-22 10:58:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1044, 176, 35, '', '2021-06-22 10:58:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1045, 176, 36, '', '2021-06-22 10:58:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1046, 176, 46, 'asdf', '2021-06-22 10:58:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1047, 101, 48, 'dfg012', '2021-06-22 11:17:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1048, 101, 51, 'test', '2021-06-22 11:17:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1049, 102, 48, 'fd012d', '2021-06-22 11:21:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1050, 102, 51, 'tsre', '2021-06-22 11:21:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1051, 103, 48, 'dff02', '2021-06-22 11:24:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1052, 103, 51, 'gfdgf', '2021-06-22 11:24:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1053, 182, 34, 'fdfd', '2021-06-22 11:40:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1054, 182, 35, 'fd', '2021-06-22 11:40:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1055, 182, 36, 'fdfd', '2021-06-22 11:40:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1056, 182, 46, 'fdfd', '2021-06-22 11:40:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1057, 181, 34, 'dd', '2021-06-22 11:42:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1058, 181, 35, 'dd', '2021-06-22 11:42:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1059, 181, 36, 'dd', '2021-06-22 11:42:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1060, 181, 46, 'dd', '2021-06-22 11:42:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1061, 30, 15, 'aa', '2021-06-22 12:21:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1062, 30, 16, '', '2021-06-22 12:21:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1063, 30, 47, '', '2021-06-22 12:21:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1064, 31, 15, 'aa', '2021-06-22 12:32:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1065, 31, 16, '', '2021-06-22 12:32:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1066, 31, 47, '', '2021-06-22 12:32:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1067, 61, 7, '', '2021-06-22 12:50:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1068, 61, 18, '', '2021-06-22 12:50:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1069, 61, 19, '', '2021-06-22 12:50:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1070, 61, 20, '', '2021-06-22 12:50:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1071, 183, 34, 'yjyj', '2021-06-22 12:56:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1072, 183, 35, 'yjy', '2021-06-22 12:56:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1073, 183, 36, 'jgy', '2021-06-22 12:56:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1074, 183, 46, 'yyj', '2021-06-22 12:56:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1075, 184, 34, 'c', '2021-06-22 13:12:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1076, 184, 35, 'c', '2021-06-22 13:12:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1077, 184, 36, 'c', '2021-06-22 13:12:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1078, 184, 46, 'cc', '2021-06-22 13:12:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1079, 104, 48, 'ff', '2021-06-22 13:13:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1080, 104, 51, 'ff', '2021-06-22 13:13:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1081, 62, 7, '', '2021-06-22 13:36:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1082, 62, 18, '', '2021-06-22 13:36:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1083, 62, 19, '', '2021-06-22 13:36:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1084, 62, 20, '', '2021-06-22 13:36:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1085, 185, 34, 'dfdf', '2021-06-23 04:46:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1086, 185, 35, 'dds', '2021-06-23 04:46:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1087, 185, 36, 'dfdf', '2021-06-23 04:46:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1088, 185, 46, 'dff', '2021-06-23 04:46:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1089, 221, 50, 'fddgfdgfdg', '2021-06-23 04:50:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1090, 105, 48, 'sd344', '2021-06-23 04:51:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1091, 105, 51, 'frrff', '2021-06-23 04:51:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1092, 63, 7, '', '2021-06-23 04:54:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1093, 63, 18, '', '2021-06-23 04:54:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1094, 63, 19, '', '2021-06-23 04:54:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1095, 63, 20, '', '2021-06-23 04:54:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1096, 64, 7, '', '2021-06-23 04:54:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1097, 64, 18, '', '2021-06-23 04:54:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1098, 64, 19, '', '2021-06-23 04:54:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1099, 64, 20, '', '2021-06-23 04:54:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1100, 36, 7, '', '2021-06-23 04:59:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1101, 36, 18, '', '2021-06-23 04:59:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1102, 36, 19, '', '2021-06-23 04:59:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1103, 36, 20, '', '2021-06-23 04:59:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1104, 37, 7, '', '2021-06-23 05:00:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1105, 37, 18, '', '2021-06-23 05:00:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1106, 37, 19, '', '2021-06-23 05:00:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1107, 37, 20, '', '2021-06-23 05:00:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1108, 38, 7, '', '2021-06-23 05:01:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1109, 38, 18, '', '2021-06-23 05:01:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1110, 38, 19, '', '2021-06-23 05:01:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1111, 38, 20, '', '2021-06-23 05:01:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1112, 39, 7, '', '2021-06-23 05:30:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1113, 39, 18, '', '2021-06-23 05:30:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1114, 39, 19, '', '2021-06-23 05:30:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1115, 39, 20, '', '2021-06-23 05:30:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1116, 29, 42, '', '2021-06-23 05:52:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1117, 0, 6, '', '2021-06-28 11:44:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1118, 40, 7, '', '2021-06-23 06:47:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1119, 40, 18, '', '2021-06-23 06:47:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1120, 40, 19, '', '2021-06-23 06:47:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1121, 40, 20, '', '2021-06-23 06:47:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1122, 65, 7, '', '2021-06-23 07:20:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1123, 65, 18, '', '2021-06-23 07:20:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1124, 65, 19, '', '2021-06-23 07:20:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1125, 65, 20, '', '2021-06-23 07:20:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1126, 66, 52, 'bab', '2021-06-23 08:50:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1127, 66, 53, 'abababa', '2021-06-23 08:50:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1128, 66, 54, '1', '2021-06-23 08:50:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1129, 67, 52, 'gg', '2021-06-23 09:00:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1130, 67, 53, 'gg', '2021-06-23 09:00:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1131, 67, 54, '1', '2021-06-23 09:00:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1132, 67, 55, '2', '2021-06-23 09:00:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1133, 0, 52, 'g', '2021-06-23 12:50:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1134, 0, 53, 'g', '2021-06-23 12:50:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1135, 0, 54, '5', '2021-06-23 12:50:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1136, 68, 55, '1,2,3', '2021-06-23 09:31:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1137, 106, 48, '1', '2021-06-23 09:35:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1138, 106, 51, '1', '2021-06-23 09:35:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1139, 69, 52, 'f', '2021-06-23 09:50:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1140, 69, 53, 'f', '2021-06-23 09:50:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1141, 69, 54, '3', '2021-06-23 09:50:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1142, 69, 55, '1,2', '2021-06-23 09:50:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1143, 0, 52, 'A', '2021-06-23 11:23:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1144, 0, 53, 'A', '2021-06-23 11:23:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1145, 0, 54, '1', '2021-06-23 11:23:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1146, 0, 55, '2', '2021-06-23 11:23:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1147, 2, 44, 'gfg', '2021-06-23 10:45:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1148, 0, 52, 'A', '2021-06-23 11:23:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1149, 0, 53, 'A', '2021-06-23 11:23:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1150, 0, 54, '1', '2021-06-23 11:23:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1151, 0, 55, '2', '2021-06-23 11:23:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1152, 70, 52, 'A', '2021-06-23 11:23:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1153, 70, 53, 'A', '2021-06-23 11:23:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1154, 70, 54, '1', '2021-06-23 11:23:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1155, 70, 55, '2', '2021-06-23 11:23:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1156, 71, 52, '', '2021-06-23 11:29:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1157, 71, 53, '', '2021-06-23 11:29:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1158, 71, 54, '', '2021-06-23 11:29:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1159, 72, 52, '', '2021-06-23 11:32:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1160, 72, 53, '', '2021-06-23 11:32:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1161, 72, 54, '', '2021-06-23 11:32:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1162, 73, 52, '', '2021-06-23 11:35:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1163, 73, 53, '', '2021-06-23 11:35:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1164, 73, 54, '', '2021-06-23 11:35:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1165, 74, 52, '', '2021-06-23 11:36:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1166, 74, 53, '', '2021-06-23 11:36:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1167, 74, 54, '', '2021-06-23 11:36:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1168, 75, 52, '', '2021-06-23 11:56:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1169, 75, 53, '', '2021-06-23 11:56:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1170, 75, 54, '', '2021-06-23 11:56:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1171, 222, 50, 'Athlone Northgate st Athlone', '2021-06-23 12:03:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1172, 0, 52, '', '2021-06-23 12:16:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1173, 0, 53, '', '2021-06-23 12:16:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1174, 0, 54, '', '2021-06-23 12:16:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1175, 0, 52, '', '2021-06-23 12:51:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1176, 0, 53, '', '2021-06-23 12:51:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1177, 0, 54, '', '2021-06-23 12:51:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1178, 68, 52, 'g', '2021-06-23 12:50:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1179, 68, 53, 'g', '2021-06-23 12:50:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1180, 68, 54, '5', '2021-06-23 12:50:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1181, 76, 52, '', '2021-06-23 12:51:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1182, 76, 53, '', '2021-06-23 12:51:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1183, 76, 54, '', '2021-06-23 12:51:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1184, 77, 52, '', '2021-06-24 04:57:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1185, 77, 53, '', '2021-06-24 04:57:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1186, 77, 54, '', '2021-06-24 04:57:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1187, 0, 52, '', '2021-06-24 05:03:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1188, 0, 53, '', '2021-06-24 05:03:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1189, 0, 54, '', '2021-06-24 05:03:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1190, 0, 52, '', '2021-06-24 05:03:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1191, 0, 53, '', '2021-06-24 05:03:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1192, 0, 54, '', '2021-06-24 05:03:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1193, 0, 52, '', '2021-06-24 05:04:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1194, 0, 53, '', '2021-06-24 05:04:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1195, 0, 54, '', '2021-06-24 05:04:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1196, 0, 52, '', '2021-06-24 05:04:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1197, 0, 53, '', '2021-06-24 05:04:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1198, 0, 54, '', '2021-06-24 05:04:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1199, 0, 52, '', '2021-06-24 05:04:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1200, 0, 53, '', '2021-06-24 05:04:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1201, 0, 54, '', '2021-06-24 05:04:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1202, 0, 52, '', '2021-06-24 05:13:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1203, 0, 53, '', '2021-06-24 05:13:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1204, 0, 54, '', '2021-06-24 05:13:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1205, 0, 52, '', '2021-06-24 05:21:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1206, 0, 53, '', '2021-06-24 05:21:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1207, 0, 54, '', '2021-06-24 05:21:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1208, 0, 52, '', '2021-06-24 06:15:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1209, 0, 53, '', '2021-06-24 06:15:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1210, 0, 54, '', '2021-06-24 06:15:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1211, 0, 52, '', '2021-06-30 08:03:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1212, 0, 53, '', '2021-06-30 08:03:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1213, 0, 54, '', '2021-06-30 08:03:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1214, 0, 52, '', '2021-06-24 06:18:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1215, 0, 53, '', '2021-06-24 06:18:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1216, 0, 54, '', '2021-06-24 06:18:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1217, 0, 52, '', '2021-06-24 06:30:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1218, 0, 53, '', '2021-06-24 06:30:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1219, 0, 54, '', '2021-06-24 06:30:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1220, 78, 52, '', '2021-06-24 06:30:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1221, 78, 53, '', '2021-06-24 06:30:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1222, 78, 54, '', '2021-06-24 06:30:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1223, 80, 52, '', '2021-06-24 06:37:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1224, 80, 53, '', '2021-06-24 06:37:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1225, 80, 54, '', '2021-06-24 06:37:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1226, 0, 52, '', '2021-06-24 15:07:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1227, 0, 53, '', '2021-06-24 15:07:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1228, 0, 54, '', '2021-06-24 15:07:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1229, 0, 52, '', '2021-06-30 06:29:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1230, 0, 53, '', '2021-06-30 06:29:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1231, 0, 54, '', '2021-06-30 06:29:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1232, 186, 34, 'jhhg', '2021-06-25 06:19:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1233, 186, 35, '', '2021-06-25 06:19:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1234, 186, 36, '', '2021-06-25 06:19:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1235, 186, 46, 'fdfd', '2021-06-25 06:19:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1236, 28, 9, 'test', '2021-06-26 12:49:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1237, 32, 15, 'aa', '2021-06-25 08:44:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1238, 32, 16, '', '2021-06-25 08:44:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1239, 32, 47, '', '2021-06-25 08:44:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1240, 82, 52, '', '2021-06-25 10:25:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1241, 82, 53, '', '2021-06-25 10:25:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1242, 82, 54, '', '2021-06-25 10:25:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1243, 0, 52, '', '2021-06-25 10:26:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1244, 0, 53, '', '2021-06-25 10:26:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1245, 0, 54, '', '2021-06-25 10:26:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1246, 0, 52, '', '2021-06-25 10:26:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1247, 0, 53, '', '2021-06-25 10:26:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1248, 0, 54, '', '2021-06-25 10:26:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1249, 0, 52, '', '2021-06-25 10:26:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1250, 0, 53, '', '2021-06-25 10:26:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1251, 0, 54, '', '2021-06-25 10:26:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1252, 83, 52, '', '2021-06-25 10:26:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1253, 83, 53, '', '2021-06-25 10:26:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1254, 83, 54, '', '2021-06-25 10:26:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1255, 223, 50, 'f', '2021-06-25 11:05:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1256, 84, 52, '', '2021-06-25 15:47:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1257, 84, 53, '', '2021-06-25 15:47:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1258, 84, 54, '', '2021-06-25 15:47:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1259, 187, 34, 'new custom field test', '2021-06-26 09:38:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1260, 187, 35, 'custom field 1', '2021-06-26 09:38:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1261, 187, 36, 'custom field 2', '2021-06-26 09:38:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1262, 187, 46, 'appointment custom field test', '2021-06-26 09:38:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1263, 188, 34, 'test edit', '2021-06-26 10:17:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1264, 188, 35, 'test edit', '2021-06-26 10:17:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1265, 188, 36, 'test edit', '2021-06-26 10:17:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1266, 188, 46, 'test testetstest edit', '2021-06-26 10:17:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1267, 107, 48, 'a', '2021-06-26 11:01:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1268, 107, 51, 'a', '2021-06-26 11:01:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1269, 29, 9, 'instruction', '2021-06-28 05:29:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1270, 85, 52, '', '2021-06-28 06:54:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1271, 85, 53, '', '2021-06-28 06:54:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1272, 85, 54, '', '2021-06-28 06:54:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1273, 7, 14, '', '2021-06-28 11:34:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1274, 1, 14, '', '2021-06-28 11:34:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1275, 45, 6, '', '2021-06-28 11:44:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1276, 108, 48, 'a', '2021-06-28 16:36:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1277, 108, 51, 'a', '2021-06-28 16:36:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1278, 109, 48, 'ss', '2021-06-28 16:43:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1279, 109, 51, 'sss', '2021-06-28 16:43:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1280, 224, 50, 'Indore Bilaspur', '2021-06-29 04:46:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1281, 110, 48, 'dfg0125', '2021-06-29 04:46:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1282, 110, 51, 'fd', '2021-06-29 04:46:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1283, 0, 52, '', '2021-06-29 05:13:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1284, 0, 53, '', '2021-06-29 05:13:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1285, 0, 54, '', '2021-06-29 05:13:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1286, 0, 52, '', '2021-06-29 05:22:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1287, 0, 53, '', '2021-06-29 05:22:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1288, 0, 54, '', '2021-06-29 05:22:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1289, 0, 52, '', '2021-06-30 05:36:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1290, 0, 53, '', '2021-06-30 05:36:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1291, 0, 54, '', '2021-06-30 05:36:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1292, 0, 52, '', '2021-06-30 05:33:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1293, 0, 53, '', '2021-06-30 05:33:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1294, 0, 54, '', '2021-06-30 05:33:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1295, 0, 52, '', '2021-06-30 04:46:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1296, 0, 53, '', '2021-06-30 04:46:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1297, 0, 54, '', '2021-06-30 04:46:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1298, 225, 50, 'goa', '2021-06-29 06:03:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1299, 111, 48, 'gf678f', '2021-06-29 06:03:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1300, 111, 51, 'test', '2021-06-29 06:03:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1301, 0, 52, '', '2021-06-29 07:23:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1302, 0, 53, '', '2021-06-29 07:23:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1303, 0, 54, '', '2021-06-29 07:23:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1304, 89, 52, '', '2021-06-29 07:23:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1305, 89, 53, '', '2021-06-29 07:23:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1306, 89, 54, '', '2021-06-29 07:23:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1307, 90, 52, '', '2021-06-29 08:39:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1308, 90, 53, '', '2021-06-29 08:39:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1309, 90, 54, '', '2021-06-29 08:39:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1310, 91, 52, '', '2021-06-29 09:48:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1311, 91, 53, '', '2021-06-29 09:48:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1312, 91, 54, '', '2021-06-29 09:48:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1313, 92, 52, '', '2021-06-29 09:48:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1314, 92, 53, '', '2021-06-29 09:48:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1315, 92, 54, '', '2021-06-29 09:48:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1316, 93, 52, '', '2021-06-29 12:08:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1317, 93, 53, '', '2021-06-29 12:08:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1318, 93, 54, '', '2021-06-29 12:08:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1319, 94, 52, '', '2021-06-29 12:11:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1320, 94, 53, '', '2021-06-29 12:11:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1321, 94, 54, '', '2021-06-29 12:11:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1322, 30, 42, '', '2021-06-29 14:13:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1323, 31, 42, '', '2021-06-29 14:17:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1324, 32, 42, '', '2021-06-29 14:32:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1325, 112, 48, 'fbfb', '2021-06-30 04:42:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1326, 112, 51, 'gbhfgbgfgb', '2021-06-30 04:42:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1327, 88, 52, '', '2021-06-30 04:46:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1328, 88, 53, '', '2021-06-30 04:46:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1329, 88, 54, '', '2021-06-30 04:46:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1330, 0, 52, '', '2021-06-30 04:59:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1331, 0, 53, '', '2021-06-30 04:59:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1332, 0, 54, '', '2021-06-30 04:59:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1333, 0, 52, '', '2021-06-30 05:04:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1334, 0, 53, '', '2021-06-30 05:04:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1335, 0, 54, '', '2021-06-30 05:04:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1336, 0, 52, '', '2021-06-30 09:27:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1337, 0, 53, '', '2021-06-30 09:27:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1338, 0, 54, '', '2021-06-30 09:27:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1339, 0, 52, '', '2021-06-30 05:36:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1340, 0, 53, '', '2021-06-30 05:36:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1341, 0, 54, '', '2021-06-30 05:36:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1342, 86, 52, '', '2021-06-30 05:36:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1343, 86, 53, '', '2021-06-30 05:36:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1344, 86, 54, '', '2021-06-30 05:36:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1345, 0, 52, '', '2021-06-30 05:38:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1346, 0, 53, '', '2021-06-30 05:38:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1347, 0, 54, '', '2021-06-30 05:38:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1348, 0, 52, '', '2021-06-30 07:29:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1349, 0, 53, '', '2021-06-30 07:29:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1350, 0, 54, '', '2021-06-30 07:29:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1351, 96, 52, '', '2021-06-30 06:08:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1352, 96, 53, '', '2021-06-30 06:08:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1353, 96, 54, '', '2021-06-30 06:08:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1354, 97, 52, '', '2021-06-30 06:09:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1355, 97, 53, '', '2021-06-30 06:09:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1356, 97, 54, '', '2021-06-30 06:09:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1357, 98, 52, '', '2021-06-30 06:13:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1358, 98, 53, '', '2021-06-30 06:13:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1359, 98, 54, '', '2021-06-30 06:13:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1360, 0, 52, 'fbfgb', '2021-06-30 11:55:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1361, 0, 53, 'fgbfbvfg', '2021-06-30 11:55:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1362, 0, 54, '1', '2021-06-30 11:55:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1363, 189, 34, 'gfg', '2021-06-30 06:21:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1364, 189, 35, 'grg', '2021-06-30 06:21:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1365, 189, 36, '', '2021-06-30 06:21:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1366, 189, 46, 'gfgg', '2021-06-30 06:21:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1367, 226, 50, 'fg', '2021-06-30 06:22:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1368, 113, 48, 'f', '2021-06-30 06:22:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1369, 113, 51, 'f', '2021-06-30 06:22:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1370, 100, 52, '', '2021-06-30 06:23:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1371, 100, 53, '', '2021-06-30 06:23:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1372, 100, 54, '', '2021-06-30 06:23:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1373, 101, 52, '', '2021-06-30 06:25:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1374, 101, 53, '', '2021-06-30 06:25:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1375, 101, 54, '', '2021-06-30 06:25:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1376, 80, 52, '', '2021-06-30 06:27:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1377, 80, 53, '', '2021-06-30 06:27:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1378, 80, 54, '', '2021-06-30 06:27:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1379, 81, 52, '', '2021-06-30 06:29:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1380, 81, 53, '', '2021-06-30 06:29:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1381, 81, 54, '', '2021-06-30 06:29:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1382, 0, 52, '', '2021-06-30 06:36:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1383, 0, 53, '', '2021-06-30 06:36:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1384, 0, 54, '', '2021-06-30 06:36:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1385, 65, 52, '', '2021-06-30 06:36:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1386, 65, 53, '', '2021-06-30 06:36:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1387, 65, 54, '', '2021-06-30 06:36:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1388, 82, 52, '', '2021-06-30 06:46:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1389, 82, 53, '', '2021-06-30 06:46:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1390, 82, 54, '', '2021-06-30 06:46:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1391, 83, 52, '', '2021-06-30 07:06:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1392, 83, 53, '', '2021-06-30 07:06:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1393, 83, 54, '', '2021-06-30 07:06:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1394, 84, 52, '', '2021-06-30 07:07:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1395, 84, 53, '', '2021-06-30 07:07:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1396, 84, 54, '', '2021-06-30 07:07:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1397, 85, 52, '', '2021-06-30 07:26:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1398, 85, 53, '', '2021-06-30 07:26:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1399, 85, 54, '', '2021-06-30 07:26:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1400, 86, 52, '', '2021-06-30 07:26:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1401, 86, 53, '', '2021-06-30 07:26:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1402, 86, 54, '', '2021-06-30 07:26:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1403, 87, 52, '', '2021-06-30 07:29:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1404, 87, 53, '', '2021-06-30 07:29:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1405, 87, 54, '', '2021-06-30 07:29:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1406, 88, 52, '', '2021-06-30 07:30:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1407, 88, 53, '', '2021-06-30 07:30:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1408, 88, 54, '', '2021-06-30 07:30:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1409, 89, 52, '', '2021-06-30 07:36:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1410, 89, 53, '', '2021-06-30 07:36:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1411, 89, 54, '', '2021-06-30 07:36:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1412, 90, 52, '', '2021-06-30 07:37:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1413, 90, 53, '', '2021-06-30 07:37:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1414, 90, 54, '', '2021-06-30 07:37:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1415, 91, 52, '', '2021-06-30 07:40:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1416, 91, 53, '', '2021-06-30 07:40:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1417, 91, 54, '', '2021-06-30 07:40:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1418, 92, 52, '', '2021-06-30 07:43:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1419, 92, 53, '', '2021-06-30 07:43:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1420, 92, 54, '', '2021-06-30 07:43:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1421, 93, 52, '', '2021-06-30 07:51:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1422, 93, 53, '', '2021-06-30 07:51:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1423, 93, 54, '', '2021-06-30 07:51:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1424, 79, 52, '', '2021-06-30 08:03:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1425, 79, 53, '', '2021-06-30 08:03:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1426, 79, 54, '', '2021-06-30 08:03:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1427, 40, 52, '', '2021-06-30 08:26:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1428, 40, 53, '', '2021-06-30 08:26:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1429, 40, 54, '', '2021-06-30 08:26:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1430, 43, 2, '', '2021-06-30 08:31:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1431, 43, 10, '', '2021-06-30 08:31:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1432, 43, 40, 'j', '2021-06-30 08:31:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1433, 227, 50, 'indore', '2021-06-30 09:14:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1434, 94, 52, '', '2021-06-30 09:14:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1435, 94, 53, '', '2021-06-30 09:14:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1436, 94, 54, '', '2021-06-30 09:14:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1437, 114, 48, '01211', '2021-06-30 09:15:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1438, 114, 51, 'fdfdvdrv', '2021-06-30 09:15:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1439, 95, 52, '', '2021-06-30 09:17:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1440, 95, 53, '', '2021-06-30 09:17:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1441, 95, 54, '', '2021-06-30 09:17:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1442, 96, 52, '', '2021-06-30 09:17:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1443, 96, 53, '', '2021-06-30 09:17:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1444, 96, 54, '', '2021-06-30 09:17:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1445, 97, 52, '', '2021-06-30 09:18:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1446, 97, 53, '', '2021-06-30 09:18:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1447, 97, 54, '', '2021-06-30 09:18:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1448, 98, 52, '', '2021-06-30 09:28:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1449, 98, 53, '', '2021-06-30 09:28:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1450, 98, 54, '', '2021-06-30 09:28:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1451, 0, 52, '', '2021-06-30 09:34:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1452, 0, 53, '', '2021-06-30 09:34:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1453, 0, 54, '', '2021-06-30 09:34:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1454, 61, 52, '', '2021-06-30 09:34:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1455, 61, 53, '', '2021-06-30 09:34:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1456, 61, 54, '', '2021-06-30 09:34:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1457, 33, 42, '', '2021-06-30 09:44:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1458, 0, 52, '', '2021-06-30 10:10:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1459, 0, 53, '', '2021-06-30 10:10:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1460, 0, 54, '', '2021-06-30 10:10:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1461, 57, 52, '', '2021-06-30 10:10:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1462, 57, 53, '', '2021-06-30 10:10:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1463, 57, 54, '', '2021-06-30 10:10:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1464, 115, 48, '02153', '2021-06-30 10:13:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1465, 115, 51, 'bgbgb', '2021-06-30 10:13:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1466, 116, 48, '0101', '2021-06-30 11:21:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1467, 116, 51, 'KK', '2021-06-30 11:21:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1468, 228, 50, 'kanpur', '2021-06-30 11:28:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1469, 170, 34, 'df', '2021-06-30 11:38:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1470, 170, 35, 'fdf', '2021-06-30 11:38:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1471, 170, 36, 'dfd', '2021-06-30 11:38:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1472, 170, 46, 'dfdf', '2021-06-30 11:38:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1473, 117, 48, '010', '2021-06-30 11:39:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1474, 117, 51, '1010', '2021-06-30 11:39:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1475, 0, 52, 'fbfgb', '2021-06-30 11:56:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1476, 0, 53, 'fgbfbvfg', '2021-06-30 11:56:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1477, 0, 54, '1', '2021-06-30 11:56:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1478, 0, 55, '1', '2021-06-30 11:55:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1479, 99, 55, '1', '2021-06-30 11:55:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1480, 0, 52, 'fbfgb', '2021-06-30 11:58:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1481, 0, 53, 'fgbfbvfg', '2021-06-30 11:58:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1482, 0, 54, '1', '2021-06-30 11:58:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1483, 0, 52, 'fbfgb', '2021-06-30 12:08:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1484, 0, 53, 'fgbfbvfg', '2021-06-30 12:08:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1485, 0, 54, '1', '2021-06-30 12:08:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1486, 0, 52, 'fbfgb', '2021-06-30 12:10:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1487, 0, 53, 'fgbfbvfg', '2021-06-30 12:10:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1488, 0, 54, '1', '2021-06-30 12:10:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1489, 99, 52, 'fbfgb', '2021-06-30 12:10:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1490, 99, 53, 'fgbfbvfg', '2021-06-30 12:10:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1491, 99, 54, '1', '2021-06-30 12:10:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1492, 229, 50, 'Athlone Northgate st Athlone', '2021-06-30 12:18:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1493, 100, 52, '', '2021-06-30 12:19:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1494, 100, 53, '', '2021-06-30 12:19:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1495, 100, 54, '', '2021-06-30 12:19:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1496, 101, 52, '', '2021-06-30 12:23:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1497, 101, 53, '', '2021-06-30 12:23:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1498, 101, 54, '', '2021-06-30 12:23:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1499, 34, 52, '', '2021-06-30 12:33:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1500, 34, 53, '', '2021-06-30 12:33:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1501, 34, 54, '', '2021-06-30 12:33:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1502, 102, 52, '', '2021-06-30 12:36:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1503, 102, 53, '', '2021-06-30 12:36:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1504, 102, 54, '', '2021-06-30 12:36:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1505, 230, 50, '12 Glen Abbey St, Rouse Hill, NSW 2155', '2021-06-30 13:01:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1506, 103, 52, '', '2021-06-30 15:38:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1507, 103, 53, '', '2021-06-30 15:38:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1508, 103, 54, '', '2021-06-30 15:38:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1509, 190, 34, 'custom filed', '2021-07-01 05:06:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1510, 190, 35, 'custom filed ', '2021-07-01 05:06:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1511, 190, 36, 'custom filed ', '2021-07-01 05:06:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1512, 190, 46, 'custom filed', '2021-07-01 05:06:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1513, 191, 34, 'rgd', '2021-07-01 05:07:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1514, 191, 35, 'gdg', '2021-07-01 05:07:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1515, 191, 36, 'drgdrg', '2021-07-01 05:07:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1516, 191, 46, 'rdgdr', '2021-07-01 05:07:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1517, 192, 34, 'f', '2021-07-01 05:09:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1518, 192, 35, 'refre', '2021-07-01 05:09:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1519, 192, 36, 'ferfr', '2021-07-01 05:09:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1520, 192, 46, 'effer', '2021-07-01 05:09:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1521, 193, 34, 'ff', '2021-07-01 05:10:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1522, 193, 35, 'fff', '2021-07-01 05:10:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1523, 193, 36, 'ff', '2021-07-01 05:10:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1524, 193, 46, 'f', '2021-07-01 05:10:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1525, 194, 34, 'na', '2021-07-01 05:11:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1526, 194, 35, 'na', '2021-07-01 05:11:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1527, 194, 36, 'na', '2021-07-01 05:11:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1528, 194, 46, 'na', '2021-07-01 05:11:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1529, 231, 50, 'indore', '2021-07-01 05:12:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1530, 118, 48, '454', '2021-07-01 05:15:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1531, 118, 51, 'rtr', '2021-07-01 05:15:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1532, 0, 52, 'fgjkgfkl', '2021-07-01 06:02:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1533, 0, 53, 'g,jjgklh', '2021-07-01 06:02:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1534, 0, 54, '1', '2021-07-01 06:02:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1535, 0, 55, '1,2,3', '2021-07-01 06:10:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1536, 0, 56, 'gfbgfbfgb', '2021-07-01 06:02:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1537, 0, 58, 'fgbftbftgb', '2021-07-01 06:02:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1538, 0, 59, '07.01.2021', '2021-07-01 06:02:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1539, 0, 52, 'fgjkgfkl', '2021-07-01 06:10:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1540, 0, 53, 'g,jjgklh', '2021-07-01 06:10:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1541, 0, 54, '1', '2021-07-01 06:10:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1542, 0, 56, 'gfbgfbfgb', '2021-07-01 06:10:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1543, 0, 58, 'fgbftbftgb', '2021-07-01 06:10:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1544, 0, 59, '07.01.2021', '2021-07-01 06:10:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1545, 0, 60, 'fvgdvfgdv', '2021-07-01 06:10:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1546, 0, 52, 'fgjkgfkl', '2021-07-01 06:17:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1547, 0, 53, 'g,jjgklh', '2021-07-01 06:17:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1548, 0, 54, '1', '2021-07-01 06:17:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1549, 0, 55, 'high', '2021-07-01 08:55:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1550, 0, 56, 'gfbgfbfgb', '2021-07-01 06:17:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1551, 0, 58, 'fgbftbftgb', '2021-07-01 06:18:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1552, 0, 59, '07.01.2021', '2021-07-01 06:17:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1553, 0, 60, 'fvgdvfgdv', '2021-07-01 06:17:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1554, 0, 52, 'fgjkgfkl', '2021-07-01 06:18:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1555, 0, 53, 'OPD Process Arrival at OPD Reception Registration Issue of Token Number Waiting Room Consultation with Doctor Issuance of med Chit Arrival at Pharmacy Token Number Waiting Collection of Med Departure ', '2021-07-01 06:18:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1556, 0, 54, '1', '2021-07-01 06:18:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1557, 0, 56, 'OPD Process Arrival at OPD Reception Registration Issue of Token Number Waiting Room Consultation with Doctor Issuance of med Chit Arrival at Pharmacy Token Number Waiting Collection of Med Departure ', '2021-07-01 06:18:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1558, 0, 59, '07.01.2021', '2021-07-01 06:18:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1559, 0, 60, 'OPD Process Arrival at OPD Reception Registration Issue of Token Number Waiting Room Consultation with Doctor Issuance of med Chit Arrival at Pharmacy Token Number Waiting Collection of Med Departure ', '2021-07-01 06:18:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1560, 0, 52, 'fgjkgfkl', '2021-07-01 06:19:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1561, 0, 53, 'Collection of Med Departure ', '2021-07-01 06:19:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1562, 0, 54, '1', '2021-07-01 06:19:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1563, 0, 56, 'OPD Process Arrival at OPD Recepti', '2021-07-01 06:19:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1564, 0, 58, 'fgbftbftgb', '2021-07-01 08:55:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1565, 0, 59, '07.01.2021', '2021-07-01 06:19:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1566, 0, 60, 'OPD Process Arrival at OPD Reception Registration Issue of Token Number Waiting Room Consultation with Docto', '2021-07-01 06:19:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1567, 0, 52, 'fgjkgfkl', '2021-07-01 06:19:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1568, 0, 53, 'Collection of Med Departure ', '2021-07-01 06:19:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1569, 0, 54, '1', '2021-07-01 06:19:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1570, 0, 56, 'OPD Process Arrival at OPD Recepti', '2021-07-01 06:19:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1571, 0, 59, '07.01.2021', '2021-07-01 06:19:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1572, 0, 60, 'OPD Process Arrival at OPD Reception Registration Issue of Token Number Waiting Room Consultation with Docto', '2021-07-01 06:19:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1573, 0, 52, 'fgjkgfkl', '2021-07-01 06:32:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1574, 0, 53, 'Collection of Med Departure ', '2021-07-01 06:32:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1575, 0, 54, '1', '2021-07-01 06:32:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1576, 0, 56, 'OPD Process Arrival at OPD Recepti', '2021-07-01 06:32:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1577, 0, 59, '07.01.2021', '2021-07-01 06:32:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1578, 0, 60, 'OPD Process Arrival at OPD Reception Registration Issue of Token Number Waiting Room Consultation with Docto', '2021-07-01 06:32:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1579, 0, 52, 'fgjkgfkl', '2021-07-01 06:37:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1580, 0, 53, 'Collection of Med Departure ', '2021-07-01 06:37:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1581, 0, 54, '1', '2021-07-01 06:37:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1582, 0, 56, 'OPD Process Arrival at OPD Recepti', '2021-07-01 06:37:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1583, 0, 59, '07.01.2021', '2021-07-01 06:37:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1584, 0, 60, 'OPD Process Arrival at OPD Reception Registration Issue of Token Number Waiting Room Consultation with Docto', '2021-07-01 06:39:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1585, 0, 52, 'fgjkgfkl', '2021-07-01 06:39:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1586, 0, 53, 'Collection of Med Departure ', '2021-07-01 06:39:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1587, 0, 54, '1', '2021-07-01 06:39:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1588, 0, 56, 'OPD Process Arrival at OPD Recepti', '2021-07-01 06:39:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1589, 0, 59, '07.01.2021', '2021-07-01 06:39:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1590, 0, 52, 'fgjkgfkl', '2021-07-01 06:40:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1591, 0, 53, 'Collection of Med Departure ', '2021-07-01 06:40:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1592, 0, 54, '1', '2021-07-01 06:40:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1593, 0, 56, 'OPD Process Arrival at OPD Recepti', '2021-07-01 06:40:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1594, 0, 59, '07.01.2021', '2021-07-01 06:40:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1595, 104, 60, 'OPD Process Arrival at OPD Reception Registration Issue of Token Number Waiting Room Consultation with Docto', '2021-07-01 06:39:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1596, 0, 52, 'fgjkgfkl', '2021-07-01 06:42:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1597, 0, 53, 'Collection of Med Departure ', '2021-07-01 06:42:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1598, 0, 54, '1', '2021-07-01 06:42:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1599, 0, 56, 'OPD Process Arrival at OPD Recepti', '2021-07-01 06:42:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1600, 0, 59, '07.01.2021', '2021-07-01 06:42:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1601, 0, 52, 'fgjkgfkl', '2021-07-01 08:55:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1602, 0, 53, 'Collection of Med Departure ', '2021-07-01 08:55:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1603, 0, 54, '1', '2021-07-01 08:55:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1604, 0, 56, 'OPD Process Arrival at OPD Recepti', '2021-07-01 08:55:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1605, 0, 59, '07.01.2021', '2021-07-01 08:55:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1606, 0, 52, 'fgjkgfkl', '2021-07-01 08:56:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1607, 0, 53, 'Collection of Med Departure ', '2021-07-01 08:56:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1608, 0, 54, '1', '2021-07-01 08:56:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1609, 0, 55, ' medium ', '2021-07-01 08:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1610, 0, 56, 'OPD Process Arrival at OPD Recepti', '2021-07-01 08:56:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1611, 0, 58, 'fgbftbftgb', '2021-07-01 08:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1612, 0, 59, '07.01.2021', '2021-07-01 08:56:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1613, 0, 52, 'fgjkgfkl', '2021-07-01 08:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1614, 0, 53, 'Collection of Med Departure ', '2021-07-01 08:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1615, 0, 54, '1', '2021-07-01 08:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1616, 0, 56, 'OPD Process Arrival at OPD Recepti', '2021-07-01 08:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1617, 0, 59, '07.01.2021', '2021-07-01 08:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1618, 104, 52, 'fgjkgfkl', '2021-07-01 08:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1619, 104, 53, 'Collection of Med Departure ', '2021-07-01 08:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1620, 104, 54, '1', '2021-07-01 08:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1621, 104, 55, ' medium ', '2021-07-01 08:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1622, 104, 56, 'OPD Process Arrival at OPD Recepti', '2021-07-01 08:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1623, 104, 58, 'fgbftbftgb', '2021-07-01 08:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1624, 104, 59, '07.01.2021', '2021-07-01 08:57:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1625, 41, 52, '', '2021-07-01 09:26:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1626, 41, 53, '', '2021-07-01 09:26:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1627, 41, 54, '', '2021-07-01 09:26:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1628, 41, 56, '', '2021-07-01 09:26:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1629, 232, 50, 'Main st Kilfenora Lisdoonvarna', '2021-07-01 10:20:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1630, 233, 50, 'hhh', '2021-07-01 10:30:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1631, 105, 52, '', '2021-07-01 10:31:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1632, 105, 53, '', '2021-07-01 10:31:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1633, 105, 54, '', '2021-07-01 10:31:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1634, 105, 56, '', '2021-07-01 10:31:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1635, 234, 50, 'hjhn', '2021-07-01 10:32:15');


#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int(10) DEFAULT NULL,
  `validation` int(11) DEFAULT '0',
  `field_values` mediumtext,
  `visible_on_print` int(11) DEFAULT NULL,
  `visible_on_report` int(11) DEFAULT NULL,
  `visible_on_table` int(11) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8;

INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (2, 'printreportipd', 'ipd', 'input', 12, 0, '', 1, 1, 1, NULL, 0, '2021-05-04 05:02:37');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (6, 'printreportpharma', 'pharmacy', 'input', 12, 0, '', 1, 1, 1, NULL, 0, '2021-05-04 09:33:07');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (8, 'printreportstaff', 'staff', 'input', 12, 0, '', 1, 1, 1, 1, 0, '2021-06-28 12:42:53');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (9, 'test', 'ipdconsultinstruction', 'input', 12, 0, '', 1, 1, 1, NULL, 0, '2021-05-04 10:23:57');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (10, 'testcustom', 'ipd', 'input', 12, 0, '', 0, 0, 1, NULL, 0, '2021-05-05 10:45:52');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (14, 'printreport', 'birth_report', 'input', 12, 0, '', 1, 1, 0, NULL, 0, '2021-06-18 12:52:41');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (15, 'test1', 'ambulance', 'select', 12, 1, 'aa', 0, 0, 1, NULL, 0, '2021-06-02 09:46:22');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (16, 'color', 'ambulance', 'colorpicker', 12, 0, '', 0, 0, 1, NULL, 0, '2021-05-06 06:02:46');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (17, 'f', 'staff', 'number', 12, 0, '', 1, 0, 1, 2, 0, '2021-06-28 12:42:53');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (34, 'custom field', 'appointment', 'input', 12, 1, '', 0, 0, 0, NULL, 0, '2021-06-22 05:48:57');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (35, 'custom field', 'appointment', 'input', 12, 0, '', 0, 0, 0, NULL, 0, '2021-05-10 12:58:33');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (36, 'custom field', 'appointment', 'input', 12, 0, '', 0, 0, 0, NULL, 0, '2021-05-10 12:59:04');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (40, 'Orthopedic Surgery', 'ipd', 'input', 12, 1, '', 0, 0, 0, NULL, 0, '2021-06-22 05:39:01');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (42, 'printreport', 'radiology', 'input', 12, 0, 'tttt', 1, 1, 0, NULL, 0, '2021-05-20 06:16:13');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (43, 'printreport', 'income', 'input', 12, 0, '', 1, 1, 0, NULL, 0, '2021-05-20 07:10:16');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (44, 'printreport', 'expenses', 'input', 12, 0, '', 1, 1, 0, NULL, 0, '2021-05-20 07:11:16');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (45, 'printreport', 'death_report', 'input', 12, 0, '', 1, 1, 1, NULL, 0, '2021-06-18 12:52:58');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (46, 'appointment custom field', 'appointment', 'input', 12, 1, '', 1, 1, 1, NULL, 0, '2021-06-26 07:31:53');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (47, 'printreportsambul', 'ambulance', 'input', 12, 0, '', 1, 1, 0, NULL, 0, '2021-06-02 08:22:59');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (48, 'Opd patient pan number', 'opd', 'input', 12, 1, '', 1, 1, 1, NULL, 0, '2021-06-19 11:37:59');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (49, 'recheckup custom', 'opdrecheckup', 'input', 12, 1, '', 1, 1, 1, NULL, 0, '2021-06-19 11:55:28');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (50, 'full address', 'patient', 'input', 12, 1, '', 1, 1, 1, NULL, 0, '2021-06-19 12:06:52');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (51, 'test', 'opd', 'input', 12, 1, 'fjkhijdrhfird', 1, 1, 1, NULL, 0, '2021-06-19 12:15:13');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (52, 'Pan Number', 'pathology', 'input', 12, 0, '', 1, 1, 1, NULL, 0, '2021-07-01 08:50:15');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (53, 'loan number', 'pathology', 'textarea', 12, 0, '', 1, 1, 1, NULL, 0, '2021-07-01 08:53:23');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (54, 'pan number', 'pathology', 'number', 12, 0, '', 1, 1, 1, NULL, 0, '2021-06-23 11:28:54');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (55, 'pathology discount', 'pathology', 'multiselect', 12, 0, 'high, low, medium ', 1, 1, 1, NULL, 0, '2021-07-01 08:54:58');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (56, 'input', 'pathology', 'input', 12, 0, '', 1, 1, 1, NULL, 0, '2021-07-01 06:09:58');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `weight`, `is_active`, `created_at`) VALUES (57, 'fff', 'radiology', 'number', 12, 0, 'fff', 0, 0, 0, NULL, 0, '2021-07-01 05:57:42');


#
# TABLE STRUCTURE FOR: death_report
#

DROP TABLE IF EXISTS `death_report`;

CREATE TABLE `death_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `case_reference_id` int(11) DEFAULT NULL,
  `image` varchar(200) NOT NULL,
  `death_date` datetime NOT NULL,
  `guardian_name` varchar(200) NOT NULL,
  `death_report` text NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `death_report_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `death_report_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;

INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `image`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (4, 14, 55, '', '2021-05-04 16:12:00', 'ttttt', 'trrrtrt', 'yes', '2021-05-04 10:42:58');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `image`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (5, 2, 72, '', '2021-04-27 00:00:00', 'test', 'Report', 'yes', '2021-05-27 06:49:22');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `image`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (6, 14, 56, '', '2021-05-06 00:00:00', 'nk kumar', 'dsf', 'yes', '2021-05-27 06:58:06');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `image`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (7, 139, 138, '', '2021-04-29 00:00:00', 'ghj', 'ghj', 'yes', '2021-05-27 10:47:11');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `image`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (8, 14, 69, '', '2021-05-05 00:00:00', 'nk kumar', 'df', 'yes', '2021-05-31 04:45:49');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `image`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (9, 16, 128, '', '2021-05-05 00:00:00', 'kl singh', 'drger', 'yes', '2021-05-31 05:14:10');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `image`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (10, 2, 72, '', '2021-05-05 00:00:00', 'test', '', 'yes', '2021-05-31 13:28:09');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `image`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (11, 139, 147, '', '2021-06-10 00:00:00', 't', 't', 'yes', '2021-06-03 11:23:04');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `image`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (18, 147, 142, '', '2021-06-09 00:00:00', 'Guardian Name12', '', 'yes', '2021-06-07 07:40:53');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `image`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (19, 135, 133, '', '2021-06-10 14:53:00', 'fg', 'fg', 'yes', '2021-06-09 08:24:13');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `image`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (20, 22, 173, '', '2021-06-19 16:37:00', 'hfgbf', 'bfb', 'yes', '2021-06-19 11:16:36');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `image`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (21, 191, 182, '', '2021-06-21 14:34:00', 'karun', 'dscfd', 'yes', '2021-06-21 09:13:44');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `image`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (22, 191, 182, '', '2021-06-21 14:34:00', 'karun', 'dscfd', 'yes', '2021-06-21 09:13:51');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `image`, `death_date`, `guardian_name`, `death_report`, `is_active`, `created_at`) VALUES (23, 206, 199, '', '2021-06-28 16:08:00', 'OPIP', '', 'yes', '2021-06-28 10:39:00');


#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (1, 'Department', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (2, 'Departmentt', 'yes');


#
# TABLE STRUCTURE FOR: diagnosis
#

DROP TABLE IF EXISTS `diagnosis`;

CREATE TABLE `diagnosis` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `report_type` varchar(200) NOT NULL,
  `document` varchar(200) NOT NULL,
  `description` text NOT NULL,
  `report_center` varchar(200) NOT NULL,
  `report_date` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `diagnosis_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8;

INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (8, 10, 'typhoid', '', '', 'in housing lab', '2021-05-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (10, 17, 'check', 'uploads/patient_images/10.txt', 'test', 'In Housing lab', '2021-05-05');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (11, 17, 'tttt', '', 'tttt', 'ttt', '2021-05-05');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (13, 32, 'testcccccc', 'uploads/patient_images/13.jpg', 'testnhbddhfds', 'in housing lab', '2021-05-08');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (15, 32, 'vfdmvkfv', '', 'vvm mb', 'fv fmvmfd', '2021-05-10');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (16, 4, 'test', '', 'test', 'test', '2021-05-31');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (17, 4, 'one', '', 'test', 'test', '2021-05-31');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (19, 4, 'newww', '', 'newwwwwwwwwww', 'newwwww', '2021-05-31');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (20, 16, 'tttt', '', 'fgf', 'gfgfg', '2021-05-10');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (21, 16, 'test diaganosi', '', 'hh', 'nnn', '2021-05-10');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (23, 18, 'ppppp', '', 'yyyy', 'uuuu', '2021-05-18');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (24, 4, 'tttttttttttttt', '', '', '', '2021-06-16');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (25, 146, 'gggggg', 'uploads/patient_images/25.png', 'dfgfdfdfdg', 'fgfdgdfgdf', '2021-06-03');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (26, 150, 'hftyhfth', 'uploads/patient_images/26.pdf', '', '', '2021-06-17');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (29, 190, 'yhjtyujtyujy', 'uploads/patient_images/29.jpg', '', 'ikuik', '2021-06-17');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (30, 191, 'test', 'uploads/patient_images/30.jpg', 'dfkvhiuviuvujrji', 'tewsthedgedh', '2021-06-17');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (31, 191, 'gthtghthg', '', '', '', '0002-02-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (32, 198, 'test', 'uploads/patient_images/32.jpg', 'test', 'test', '2021-06-21');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (33, 190, 'fgvdxg', 'uploads/patient_images/33.jpg', 'hgjhug', 'hfghgg', '2021-06-21');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (34, 206, 'corona', 'uploads/patient_images/34.jpg', 'test', 'test', '2021-06-23');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_center`, `report_date`) VALUES (35, 208, 'report type edit', 'uploads/patient_images/35.png', 'test edit', 'test edit', '2021-06-28');


#
# TABLE STRUCTURE FOR: discharge_card
#

DROP TABLE IF EXISTS `discharge_card`;

CREATE TABLE `discharge_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `opd_details_id` int(11) DEFAULT NULL,
  `ipd_details_id` int(11) DEFAULT NULL,
  `discharge_by` int(11) NOT NULL,
  `discharge_date` datetime DEFAULT NULL,
  `discharge_status` int(10) NOT NULL,
  `death_date` datetime DEFAULT NULL,
  `refer_date` datetime DEFAULT NULL,
  `refer_to_hospital` varchar(255) DEFAULT NULL,
  `reason_for_referral` varchar(255) DEFAULT NULL,
  `operation` varchar(225) NOT NULL,
  `diagnosis` varchar(255) NOT NULL,
  `investigations` text NOT NULL,
  `treatment_home` varchar(255) NOT NULL,
  `note` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;

INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (1, 28, 30, 1, '2021-04-29 00:00:00', 1, '2021-05-19 00:00:00', NULL, NULL, '', '', '', '', '', '', '2021-05-27 06:15:43');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (6, NULL, 8, 1, '2021-05-06 00:00:00', 1, '2021-05-06 00:00:00', NULL, NULL, '', 'Operation', 'Diagnosis', 'Investigations25', 'investigation1', 'Note', '2021-06-09 10:17:14');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (7, 45, 0, 1, '2021-04-29 00:00:00', 1, '2021-04-29 00:00:00', '2021-04-27 00:00:00', 'ghj', 'ghj', '', '', '', '', '', '2021-05-27 10:47:11');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (8, 25, NULL, 1, '2021-04-27 00:00:00', 1, '2021-05-05 00:00:00', NULL, '', '', '', '', '', '', '', '2021-05-31 04:45:49');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (9, 45, NULL, 1, '2021-05-04 00:00:00', 2, NULL, '2021-05-05 00:00:00', NULL, '', '', '', '', '', '', '2021-05-31 05:06:34');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (10, NULL, 12, 1, '2021-05-12 00:00:00', 1, '2021-05-05 00:00:00', NULL, NULL, '', 'gggg', 'hhhhhjj', 'hghfhfg', 'yuyuy', 'hhhhh', '2021-06-15 12:26:55');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (11, NULL, 33, 1, '2021-06-02 00:00:00', 2, NULL, '2021-06-02 00:00:00', NULL, 'facilities not available', '', '', '', '', '', '2021-06-03 09:16:35');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (12, NULL, 33, 1, '2021-06-02 00:00:00', 2, NULL, '2021-06-02 00:00:00', NULL, 'facilities not available', '', '', '', '', '', '2021-06-03 09:16:44');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (13, NULL, 35, 1, '2021-06-30 00:00:00', 2, NULL, '2021-06-30 00:00:00', NULL, '', '', '', '', '', '', '2021-06-03 09:30:56');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (14, NULL, 35, 1, '2021-06-30 00:00:00', 2, NULL, '2021-06-30 00:00:00', NULL, '', '', '', '', '', '', '2021-06-03 09:31:57');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (15, NULL, 36, 1, '2021-06-02 00:00:00', 2, NULL, '2021-06-01 00:00:00', NULL, 'asd', '', '', '', '', '', '2021-06-03 09:37:11');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (16, 51, NULL, 1, '2021-06-02 00:00:00', 1, '2021-06-10 00:00:00', NULL, NULL, '', '', '', '', '', '', '2021-06-03 11:23:04');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (17, 49, NULL, 1, '2021-06-11 00:00:00', 1, '2021-06-09 00:00:00', NULL, NULL, '', '', '', '', '', '', '2021-06-09 06:07:05');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (18, 49, NULL, 1, '2021-06-09 00:00:00', 2, NULL, '2021-06-02 00:00:00', NULL, 'ert', '', '', '', '', '', '2021-06-05 10:55:28');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (19, 41, NULL, 1, '2021-06-17 13:01:00', 2, '2021-06-10 14:53:00', '2021-06-09 13:59:00', NULL, 'Reason For Referral', '', '', '', '', '', '2021-06-09 08:26:29');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (20, 72, NULL, 1, '2021-06-19 16:37:00', 1, '2021-06-19 16:37:00', NULL, NULL, '', 'gfgfgf', 'bghnghnhg', 'bgff', 'fghfth', 'jnghgh', '2021-06-19 11:16:36');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (21, 81, NULL, 1, '2021-06-21 14:34:00', 1, '2021-06-21 14:34:00', NULL, NULL, '', 'fvdvdvd', 'vfdvfdv', 'fdvfd', 'vfdvdfv', 'dfdf', '2021-06-21 09:13:44');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (22, 81, NULL, 1, '2021-06-21 14:34:00', 1, '2021-06-21 14:34:00', NULL, NULL, '', 'fvdvdvd', 'vfdvfdv', 'fdvfd', 'vfdvdfv', 'dfdf', '2021-06-21 09:13:51');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (23, 18, NULL, 1, '2021-06-21 17:18:00', 3, NULL, NULL, NULL, '', 'na', 'ana', 'na', 'na', 'na', '2021-06-21 11:57:49');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (24, NULL, 4, 1, '2021-06-21 17:18:00', 3, NULL, NULL, NULL, '', 'na', 'ana', 'na', 'na', 'na', '2021-06-21 11:57:49');
INSERT INTO `discharge_card` (`id`, `opd_details_id`, `ipd_details_id`, `discharge_by`, `discharge_date`, `discharge_status`, `death_date`, `refer_date`, `refer_to_hospital`, `reason_for_referral`, `operation`, `diagnosis`, `investigations`, `treatment_home`, `note`, `created_at`) VALUES (25, NULL, 41, 1, '2021-06-28 16:08:00', 1, '2021-06-28 16:08:00', NULL, NULL, '', '', '', '', '', '', '2021-06-28 10:39:00');


#
# TABLE STRUCTURE FOR: discharged_summary
#

DROP TABLE IF EXISTS `discharged_summary`;

CREATE TABLE `discharged_summary` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) NOT NULL,
  `operation` varchar(200) CHARACTER SET latin1 NOT NULL,
  `diagnosis` varchar(200) CHARACTER SET latin1 NOT NULL,
  `note` text CHARACTER SET latin1 NOT NULL,
  `investigations` text CHARACTER SET latin1 NOT NULL,
  `treatment_home` text CHARACTER SET latin1 NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  CONSTRAINT `discharged_summary_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `address` text NOT NULL,
  `note` text NOT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `image` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `type`) VALUES (3, '3424', 'test', 'the stomach break it down, and the medicine can pass into the bloodstream. Y', 'A lot of medicines are swallowed, either as a pill or a liquid. Once the medicine is swallowed, A lot of medicines are swallowed, either as a pill or a liquid. Once the medicine is swallowed, the digestive juices in the stomach break it down, and the medicine can pass into the bloodstream. Your blood then carries it to other parts of your body where the medicine works best.the digestive juices in the stomach break it down, and the medicine can pass into the bloodstream. Your blood then carries i', 'fvffgvf', '2021-05-29', '', '2021-05-29 07:27:01', 'dispatch');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `type`) VALUES (11, '99990', 'test ', 'A total of 1320 confirm', 'ed cases have been reporteAA total of 1320 confirmed cases have been reported for novel coronavirus (2019-nCoV) globally, out of which 1297 cases are in China, about 237 people have been reported as severely ill and 41 people have died (as of 10 am, 25 January, GVA time). Epidemiology of hepatitis C virus in the WHO Eastern Mediterranean Region: implications for strategic action presents the results and findings of the Eastern Mediterranean Hepatitis C Virus Epidemiology S', 'test', '2021-06-18', 'id11.jpg', '2021-06-18 09:25:04', 'receive');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `created_at`, `type`) VALUES (12, 'hghg', 'ggh', 'hgfhg', 'hghgf', 'gfhfhfg', '2021-06-18', 'id12.jpg', '2021-06-18 09:31:23', 'receive');


#
# TABLE STRUCTURE FOR: doctor_absent
#

DROP TABLE IF EXISTS `doctor_absent`;

CREATE TABLE `doctor_absent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `doctor_absent_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: doctor_global_shift
#

DROP TABLE IF EXISTS `doctor_global_shift`;

CREATE TABLE `doctor_global_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `global_shift_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `doctor_global_shift_ibfk1` (`global_shift_id`),
  CONSTRAINT `doctor_global_shift_ibfk1` FOREIGN KEY (`global_shift_id`) REFERENCES `global_shift` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=96 DEFAULT CHARSET=utf8;

INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (7, 7, 1, '2021-05-01 11:07:50');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (13, 10, 2, '2021-06-18 05:44:08');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (14, 13, 3, '2021-06-18 05:44:10');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (15, 24, 1, '2021-06-18 07:35:58');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (17, 7, 3, '2021-06-18 08:23:12');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (28, 25, 3, '2021-06-19 11:10:04');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (29, 24, 3, '2021-06-19 11:10:05');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (31, 18, 3, '2021-06-19 11:10:05');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (32, 17, 3, '2021-06-19 11:10:06');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (33, 15, 3, '2021-06-19 11:10:06');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (34, 7, 2, '2021-06-21 06:04:50');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (35, 10, 1, '2021-06-21 06:04:52');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (36, 13, 1, '2021-06-21 06:04:53');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (37, 13, 2, '2021-06-21 06:04:54');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (38, 10, 3, '2021-06-21 06:04:55');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (39, 14, 1, '2021-06-21 06:04:57');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (40, 14, 2, '2021-06-21 06:04:58');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (41, 14, 3, '2021-06-21 06:04:59');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (42, 15, 1, '2021-06-21 06:05:02');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (45, 19, 1, '2021-06-21 06:05:04');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (46, 25, 1, '2021-06-21 06:05:05');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (51, 24, 2, '2021-06-21 06:05:09');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (52, 19, 2, '2021-06-21 06:05:09');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (53, 18, 2, '2021-06-21 06:05:10');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (54, 25, 2, '2021-06-21 06:05:10');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (55, 17, 2, '2021-06-21 06:05:11');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (56, 15, 2, '2021-06-21 06:05:12');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (64, 27, 2, '2021-06-23 12:31:05');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (65, 27, 1, '2021-06-23 12:31:06');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (66, 18, 1, '2021-06-23 12:31:09');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (67, 17, 1, '2021-06-23 12:31:11');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (71, 26, 1, '2021-06-23 12:42:44');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (72, 26, 2, '2021-06-23 12:43:02');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (92, 26, 3, '2021-06-24 06:03:48');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (94, 19, 3, '2021-06-24 06:05:47');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (95, 27, 3, '2021-06-24 06:05:48');


#
# TABLE STRUCTURE FOR: doctor_shift
#

DROP TABLE IF EXISTS `doctor_shift`;

CREATE TABLE `doctor_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` varchar(20) CHARACTER SET latin1 DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `global_shift_id` int(11) DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `doctor_shift_ibfk1` (`global_shift_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `doctor_shift_ibfk1` FOREIGN KEY (`global_shift_id`) REFERENCES `global_shift` (`id`) ON DELETE CASCADE,
  CONSTRAINT `doctor_shift_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `doctor_shift_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (7, 'Monday', 7, 1, '10:00:00', '11:00:00', '2021-05-01 11:21:53');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (11, 'Monday', 7, 1, '11:20:00', '12:00:00', '2021-05-01 11:21:53');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (12, 'Tuesday', 7, 1, '10:13:00', '11:13:00', '2021-05-06 07:43:56');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (13, 'Thursday', 7, 1, '10:14:00', '11:14:00', '2021-05-06 07:44:13');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (14, 'Monday', 10, 2, '16:00:00', '17:00:00', '2021-06-18 05:48:14');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (15, 'Monday', 24, 1, '10:00:00', '11:00:00', '2021-06-18 07:38:49');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (16, 'Tuesday', 13, 3, '21:00:00', '22:00:00', '2021-06-18 08:25:03');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (17, 'Wednesday', 13, 3, '21:00:00', '22:40:00', '2021-06-18 08:25:36');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (18, 'Thursday', 13, 3, '22:00:00', '23:00:00', '2021-06-18 08:26:02');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (19, 'Friday', 13, 3, '22:00:00', '23:00:00', '2021-06-18 08:26:27');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (20, 'Tuesday', 24, 1, '10:59:00', '12:00:00', '2021-06-18 09:40:31');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (21, 'Wednesday', 24, 1, '10:02:00', '11:02:00', '2021-06-18 09:40:45');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (22, 'Thursday', 24, 1, '10:02:00', '11:02:00', '2021-06-18 09:41:33');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (23, 'Monday', 7, 3, '20:31:00', '21:31:00', '2021-06-19 11:10:23');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (24, 'Wednesday', 7, 1, '10:20:00', '11:20:00', '2021-06-21 05:59:20');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (25, 'Friday', 7, 1, '10:20:00', '11:20:00', '2021-06-21 05:59:31');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (26, 'Saturday', 7, 1, '10:20:00', '11:20:00', '2021-06-21 05:59:37');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (27, 'Monday', 7, 2, '17:00:00', '20:00:00', '2021-06-21 07:04:20');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (28, 'Tuesday', 7, 2, '17:00:00', '20:00:00', '2021-06-21 07:05:52');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (29, 'Wednesday', 7, 2, '17:00:00', '20:00:00', '2021-06-21 07:06:14');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (30, 'Thursday', 7, 2, '17:00:00', '20:00:00', '2021-06-21 07:06:28');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (31, 'Friday', 7, 2, '17:00:00', '20:00:00', '2021-06-21 07:06:43');
INSERT INTO `doctor_shift` (`id`, `day`, `staff_id`, `global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (32, 'Saturday', 7, 2, '17:00:00', '20:00:00', '2021-06-21 07:06:58');


#
# TABLE STRUCTURE FOR: dose_duration
#

DROP TABLE IF EXISTS `dose_duration`;

CREATE TABLE `dose_duration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (1, 'BD', '2021-05-11 11:22:09');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (2, 'Monday to Saturday', '2021-05-13 13:01:14');


#
# TABLE STRUCTURE FOR: dose_interval
#

DROP TABLE IF EXISTS `dose_interval`;

CREATE TABLE `dose_interval` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (1, 'sdf', '2021-05-10 09:59:51');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (3, 's', '2021-05-11 06:15:38');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (4, 'd', '2021-05-11 06:18:12');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (5, 'd', '2021-05-11 06:19:31');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (6, 'd', '2021-05-11 06:19:39');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (7, '6 Hours', '2021-05-13 13:00:26');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (8, '5 Hours', '2021-05-13 13:00:43');


#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `smtp_auth` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `smtp_auth`, `is_active`, `created_at`) VALUES (2, 'smtp', 'smtp.gmail.com', '587', 'webfebtest@gmail.com', 'higdadoxyjtlibxl', 'tls', 'true', 'yes', '2021-05-08 05:44:12');


#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` text NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int(11) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (1, 'Add Task', '', '2021-02-12 00:00:00', '2021-02-12 00:00:00', 'task', '#000', '1', 7, 'yes');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (2, 'Add TaskAdd Task', '', '2021-02-14 00:00:00', '2021-02-14 00:00:00', 'task', '#000', '1', 7, 'no');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (4, 'fvfgvhudfvuyd', '', '2021-02-16 00:00:00', '2021-02-23 00:00:00', 'private', '#337ab7', '1', 0, '');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (5, 'bbbbbbbbbbbbbbbbb', '', '2021-02-12 00:00:00', '2021-02-12 00:00:00', 'task', '#000', '1', 7, 'no');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (6, 'hhh', '', '2021-02-03 00:00:00', '2021-02-03 00:00:00', 'task', '#000', '6', 4, 'yes');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (8, 'sdfsa', '', '2021-02-23 10:00:00', '2021-02-23 10:00:00', 'private', '#337ab7', '6', 0, '');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (9, 'fsdafd', '', '2021-03-02 10:00:00', '2021-03-02 10:00:00', 'private', '#337ab7', '1', 0, '');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (10, 'rfgdxg', '', '2021-04-14 00:00:00', '2021-04-14 00:00:00', 'task', '#000', '1', 7, 'no');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (12, 'meeting', 'sasasasasas', '2021-04-13 10:00:00', '2021-04-16 10:00:00', 'private', '#337ab7', '1', 0, '');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (13, 'ada', '', '2021-06-18 00:00:00', '2021-06-18 00:00:00', 'task', '#000', '364', 0, 'no');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (14, 'Event Title', 'DescriptionDescriptionDescription', '2021-06-01 00:00:00', '2021-06-01 00:00:00', 'private', '#337ab7', '1', 0, '');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (15, 'Event Title 2', 'Description Description Description', '2021-06-02 00:00:00', '2021-06-02 00:00:00', 'private', '#7cb342', '1', 0, '');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (16, 'eee', '', '2021-01-06 00:00:00', '2021-01-06 00:00:00', 'task', '#000', '1', 7, 'no');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (17, 'fg', 'gfgfbfgb', '2021-06-09 00:00:00', '2021-06-09 00:00:00', 'public', '#8e24aa', '0', 0, '');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (18, 'gfbgfbfgbv', 'fgbgdfvbfcbv', '2021-06-11 00:00:00', '2021-06-14 00:00:00', 'private', '#8e24aa', '1', 0, '');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`) VALUES (19, 'qq', 'qq', '2021-06-05 00:00:00', '2021-06-05 00:00:00', 'private', '#337ab7', '1', 0, '');


#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'Electricity Bill', '', 'yes', 'no', '2020-12-09 06:01:25');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (2, 'Building rent', '', 'yes', 'no', '2020-12-09 06:01:40');


#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `documents` varchar(255) DEFAULT NULL,
  `note` text,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `generated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `exp_head_id` (`exp_head_id`),
  CONSTRAINT `expenses_ibfk_1` FOREIGN KEY (`exp_head_id`) REFERENCES `expense_head` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `generated_by`) VALUES (1, 2, 'devu', '665945', '2021-05-25', '2000.00', NULL, 'yyyyy', 'yes', 'no', '2021-05-25 13:28:53', 1);
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`, `generated_by`) VALUES (2, 1, 'fgdfgd', 'g0121', '2021-06-23', '200.00', 'uploads/hospital_expense/2.jpg', 'fgfgf', 'yes', 'no', '2021-06-23 10:45:58', 1);


#
# TABLE STRUCTURE FOR: floor
#

DROP TABLE IF EXISTS `floor`;

CREATE TABLE `floor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `floor` (`id`, `name`, `description`) VALUES (1, 'Ground', '');
INSERT INTO `floor` (`id`, `name`, `description`) VALUES (2, 'First', '');
INSERT INTO `floor` (`id`, `name`, `description`) VALUES (3, 'Second', '');


#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` mediumtext NOT NULL,
  `vid_title` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `created_at`, `file_type`, `file_size`, `vid_url`, `vid_title`) VALUES (2, NULL, 'uploads/gallery/media/thumb/', 'uploads/gallery/media/', 'Screenshot (3).png', 'Screenshot (3).png', '2021-02-02 11:05:57', 'image/png', '236050', '', '');


#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) NOT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ext_url` mediumtext,
  `open_new_tab` int(11) DEFAULT '0',
  `ext_url_link` mediumtext,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT '0',
  `description` mediumtext,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (16, 2, 'Home', 1, 0, NULL, NULL, NULL, 'home-1', NULL, 0, NULL, 'no', '2018-07-14 08:44:12');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (23, 1, 'Appointment', 77, 0, '1', NULL, 'https://dev.webfeb.com/sh32/form/appointment', 'appointment', 2, 0, NULL, 'no', '2021-06-21 10:33:46');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (26, 1, 'Home', 1, 0, NULL, NULL, NULL, 'home', NULL, 0, NULL, 'no', '2019-01-24 08:48:17');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (27, 2, 'Appointment', 0, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment-1', NULL, 0, NULL, 'no', '2019-11-02 16:24:41');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (28, 1, 'Contact Us', 76, 0, NULL, NULL, NULL, 'contact-us', NULL, 0, NULL, 'no', '2020-12-19 08:15:42');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` mediumtext,
  `open_new_tab` int(10) NOT NULL DEFAULT '0',
  `ext_url` mediumtext NOT NULL,
  `ext_url_link` mediumtext NOT NULL,
  `publish` int(11) NOT NULL DEFAULT '0',
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 09:24:49');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 09:24:55');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (3, ' vnvn', 'vnvn', '', 0, '', '', 0, 'manual', 'no', '2020-12-29 11:47:32');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (9, 'test menu', 'test-menu', 'test', 0, '', '', 0, 'manual', 'no', '2021-02-03 05:16:27');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `front_cms_page_contents_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `front_cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int(1) DEFAULT '0',
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` mediumtext,
  `meta_description` mediumtext,
  `meta_keyword` mediumtext,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext,
  `publish_date` date NOT NULL,
  `publish` int(10) DEFAULT '0',
  `sidebar` int(10) DEFAULT '0',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (1, 'default', 1, 'Home', 'page/home', 'page', 'home', '', '', '', '', '<p>Home page</p>', '0000-00-00', 1, 1, 'no', '2019-01-24 08:33:59');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<div class=\"col-md-12 col-sm-12\">\r\n<h2 class=\"text-center\">&nbsp;</h2>\r\n\r\n<p class=\"text-center\">[form-builder:complain]</p>\r\n</div>', '0000-00-00', 1, 1, 'no', '2019-01-24 08:30:12');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (54, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<html>\r\n<head>\r\n <title></title>\r\n</head>\r\n<body>\r\n<p>404 page found</p>\r\n</body>\r\n</html>', '0000-00-00', 0, NULL, 'no', '2018-05-18 09:16:04');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (76, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<p>[form-builder:contact_us]</p>', '0000-00-00', 0, NULL, 'no', '2019-01-24 08:31:58');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (77, 'manual', 0, 'our-appointment', 'page/our-appointment', 'page', 'our-appointment', '', '', '', '', '<form action=\"welcome/appointment\" method=\"get\">\r\n  First name: <input type=\"text\" name=\"fname\"><br>\r\n  Last name: <input type=\"text\" name=\"lname\"><br>\r\n  <input type=\"submit\" value=\"Submit\">\r\n</form>', '0000-00-00', 0, 1, 'no', '2019-11-01 07:32:48');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `program_id` int(11) DEFAULT NULL,
  `media_gallery_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`),
  CONSTRAINT `front_cms_program_photos_ibfk_1` FOREIGN KEY (`program_id`) REFERENCES `front_cms_programs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` mediumtext,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` mediumtext,
  `description` mediumtext,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `meta_title` mediumtext NOT NULL,
  `meta_description` mediumtext NOT NULL,
  `meta_keyword` mediumtext NOT NULL,
  `feature_image` mediumtext NOT NULL,
  `publish_date` date NOT NULL,
  `publish` varchar(10) DEFAULT '0',
  `sidebar` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `created_at`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`) VALUES (1, 'notice', 'nmbb', 'read/nmbb', 'nmbb', '2020-12-29', NULL, NULL, NULL, '<p>mm,gjg</p>', 'no', '2020-12-29 12:12:14', '', '', '', '', '0000-00-00', '0', NULL);
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `created_at`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`) VALUES (2, 'notice', 'best-hospital', 'page/', 'Best Hospital', '2020-12-31', NULL, NULL, NULL, '<p>afdsfdc</p>', 'no', '2020-12-31 06:20:22', '', '', '', '', '0000-00-00', '0', NULL);
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `created_at`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`) VALUES (6, 'gallery', 'tttttt', 'read/tttttt', 'tttttt', NULL, NULL, NULL, NULL, '<p>tttttt</p>', 'no', '2021-02-02 10:06:37', '', '', '', '', '0000-00-00', '0', NULL);
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `created_at`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`) VALUES (7, 'notice', 'tttttttt-news', 'read/tttttttt-news', 'tttttttt News', '2021-02-02', NULL, NULL, NULL, '<p>tttttt News</p>', 'no', '2021-02-02 10:22:15', '', '', '', '', '0000-00-00', '0', NULL);
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `created_at`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`) VALUES (8, 'events', 'test', 'read/test', 'test', NULL, '2021-02-02', '2021-02-02', 'dddd', '<p>ddddd</p>', 'no', '2021-02-02 11:10:48', '', '', '', '', '0000-00-00', '0', NULL);
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `created_at`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`) VALUES (9, 'banner', NULL, NULL, 'Banner Images', NULL, NULL, NULL, NULL, NULL, 'no', '2021-02-19 12:17:16', '', '', '', '', '0000-00-00', '0', 0);


#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int(10) DEFAULT '0',
  `is_active_front_cms` int(11) DEFAULT '0',
  `is_active_sidebar` int(1) DEFAULT '0',
  `logo` varchar(200) DEFAULT NULL,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` mediumtext NOT NULL,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` mediumtext,
  `footer_text` varchar(500) DEFAULT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `fav_icon`, `created_at`) VALUES (1, 'default', NULL, 1, NULL, '', '', '', '[\"news\",\"complain\"]', '', '', '', '', '', '', '', '', '', './uploads/hospital_content/logo/front_fav_icon-60067a07683f63.63783845.png', '2021-06-23 09:50:45');


#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` text NOT NULL,
  `follow_up_date` date DEFAULT NULL,
  `call_duration` varchar(50) NOT NULL,
  `note` mediumtext NOT NULL,
  `call_type` varchar(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_duration`, `note`, `call_type`, `created_at`) VALUES (11, 'Jhon', '8855221144', '2021-06-26', 'tsttt', '2021-06-30', '20', 'tsttt', 'Outgoing', '2021-06-26 08:51:10');
INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_duration`, `note`, `call_type`, `created_at`) VALUES (12, 'rf4fe4rf', '852741369', '2021-06-21', 'yhytht', '2021-06-29', '', 'tgrt', 'Incoming', NULL);
INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_duration`, `note`, `call_type`, `created_at`) VALUES (13, 'dffsfvs', '999999999', '2021-06-26', 'addfdsafsd', '2021-06-25', '10', 'asdf', 'Incoming', '2021-06-26 08:35:41');


#
# TABLE STRUCTURE FOR: global_shift
#

DROP TABLE IF EXISTS `global_shift`;

CREATE TABLE `global_shift` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) CHARACTER SET latin1 NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (1, 'Morning', '10:00:00', '12:00:00', '2021-04-06 05:49:21');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (2, 'evening', '16:00:00', '23:00:00', '2021-06-19 11:13:00');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (3, 'Night', '01:04:00', '06:00:00', '2021-06-19 11:12:39');


#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inc_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT '0.00',
  `note` text,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `documents` varchar(255) DEFAULT NULL,
  `generated_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `inc_head_id` (`inc_head_id`),
  KEY `generated_by` (`generated_by`) USING BTREE,
  CONSTRAINT `income_ibfk_1` FOREIGN KEY (`inc_head_id`) REFERENCES `income_head` (`id`) ON DELETE CASCADE,
  CONSTRAINT `income_ibfk_2` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `documents`, `generated_by`, `created_at`) VALUES (4, 4, 'deep', '4545', '2021-05-25', '1000.00', 'gggfgfg', 'yes', 'no', NULL, 1, '2021-05-25 12:55:53');


#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` text,
  `is_active` varchar(10) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (4, 'test', '', 'yes', 'no', '2021-04-30 12:29:58');


#
# TABLE STRUCTURE FOR: ipd_details
#

DROP TABLE IF EXISTS `ipd_details`;

CREATE TABLE `ipd_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `case_reference_id` int(11) NOT NULL,
  `height` varchar(5) DEFAULT NULL,
  `weight` varchar(5) DEFAULT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `bp` varchar(20) DEFAULT NULL,
  `bed` varchar(100) NOT NULL,
  `bed_group_id` int(10) DEFAULT NULL,
  `case_type` varchar(100) NOT NULL,
  `casualty` varchar(100) NOT NULL,
  `symptoms` varchar(200) NOT NULL,
  `known_allergies` varchar(200) DEFAULT NULL,
  `patient_old` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `refference` varchar(200) NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  `organisation_id` int(11) DEFAULT NULL,
  `credit_limit` varchar(100) NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `discharged` varchar(200) NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `generated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `cons_doctor` (`cons_doctor`),
  KEY `bed_group_id` (`bed_group_id`),
  CONSTRAINT `ipd_details_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_2` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_4` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_5` FOREIGN KEY (`cons_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_6` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (2, 7, 37, '', '', '', '', '', '', '21', 1, '', 'No', '', '', '', '', '', 17, 0, '5000', '', '2021-04-30 16:25:00', 'no', 'yes', '2021-04-30 10:56:13', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (3, 8, 42, '', '', '', '', '', '', '22', 1, '', 'No', '', '', '', '', '', 7, 0, '5000', '', '2021-05-01 11:57:00', 'no', 'yes', '2021-05-01 06:28:21', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (4, 9, 43, '', '', '', '', '', '', '8', 2, '', 'No', '', '', '', '', '', 7, 0, '5000', '', '2021-05-01 12:21:00', 'yes', 'yes', '2021-06-21 11:57:49', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (5, 6, 44, '', '', '', '', '', '', '1', 2, '', 'No', '', '', '', '', '', 7, 0, '5000', '', '2021-05-01 12:24:00', 'no', 'no', '2021-06-04 05:58:45', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (7, 10, 50, '', '', '', '', '', '', '0', 2, '', 'No', '', '', '', '', '', 15, NULL, '5000', '', '2021-05-01 15:52:00', 'no', 'no', '2021-06-04 05:56:01', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (8, 14, 54, '5', '55', '120', '97', 'yy', '70', '15', 2, 'ggg', 'Yes', 'General weakness.\r\nYou have a fever when your temperature rises above its normal range. What', '', '', '', 'ghfhgh', 17, 11, '5000', '', '2021-05-03 12:48:00', 'yes', 'yes', '2021-06-09 10:15:13', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (9, 13, 55, '5', '55', '72', '97', 'fff', '120', '16', 2, 'hhjhg', 'No', '', '', 'No', 'gfdgfdghhhhh yhjhjhjhj', 'hhhhh', 7, 11, '5000', '', '1970-01-01 05:30:00', 'no', 'no', '2021-05-03 12:43:20', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (10, 3, 57, '', '', '', '', '', '', '17', 2, '', 'No', '', '', '', '', '', 7, NULL, '5000', '', '2021-05-04 14:26:00', 'no', 'yes', '2021-05-04 08:57:05', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (11, 15, 58, '', '', '', '', '', '', '18', 2, '', 'No', '', '', '', '', '', 15, NULL, '5000', '', '2021-05-04 14:41:00', 'no', 'yes', '2021-05-04 09:12:15', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (12, 16, 70, '', '', '', '', '', '', '0', 2, '', 'Yes', '', '', 'No', '', '', 15, 0, '', '', '2021-05-05 00:00:00', 'yes', 'yes', '2021-06-04 05:55:40', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (13, 17, 71, '2.4', '40', '111', '190', '111', '131', '2', 1, 'body checkup', 'Yes', 'General weakness.\r\nYou have a fever when your temperature rises above its normal range. What', '', 'No', '', 'test', 7, 0, '', '', '2021-05-05 17:57:00', 'no', 'yes', '2021-05-05 12:30:05', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (14, 14, 69, '5', '55', '120', '97', 'jjf', '72', '0', 2, '', 'Yes', 'breathing difficulties.\r\nna', '', 'No', '', '', 15, 0, '', '', '2021-05-07 10:50:00', 'no', 'yes', '2021-06-04 05:55:40', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (15, 31, 76, '', '', '', '', '', '', '6', 5, 'CC', 'No', '', '', '', '', '', 17, NULL, '5000', '', '2021-05-07 17:23:00', 'no', 'yes', '2021-05-07 11:53:51', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (16, 16, 74, '5', '55', '72', '97', 'dddd', '80', '0', 2, '', 'Yes', '', '', '', '', '', 17, NULL, '', '', '0000-00-00 00:00:00', 'no', 'no', '2021-06-04 05:55:40', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (17, 14, 56, '5', '55', '120', '97', 'jjf', '72', '0', 2, 'hhhh', 'Yes', 'breathing difficulties.\r\nna', 'breathing difficulties.\r\nna', '', '', '', 7, NULL, '', '', '0000-00-00 00:00:00', 'no', 'yes', '2021-06-04 05:55:52', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (18, 10, 65, '', '', '', '', '', '', '0', 2, '', 'Yes', '', '', '', '', '', 14, NULL, '', '', '0000-00-00 00:00:00', 'no', 'no', '2021-06-04 05:55:40', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (19, 4, 66, '', '', '', '', '', '', '0', 2, '', 'Yes', '', '', '', '', '', 7, NULL, '', '', '0000-00-00 00:00:00', 'no', 'no', '2021-06-04 05:55:40', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (20, 9, 62, '', '', '', '', '', '', '0', 2, '', 'Yes', '', '', '', '', '', 17, NULL, '', '', '0000-00-00 00:00:00', 'no', 'no', '2021-06-04 05:55:52', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (21, 5, 64, '', '', '', '', '', '', '0', 2, '', 'Yes', 'General weakness.\r\nYou have a fever when your temperature rises above its normal range. What', 'General weakness.\r\nYou have a fever when your temperature rises above its normal range. What', '', '', '', 15, NULL, '', '', '0000-00-00 00:00:00', 'no', 'no', '2021-06-04 05:55:52', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (22, 13, 49, '5', '55', '120', '97', 'dddd', '72', '0', 2, 'ee', 'Yes', 'General weakness.\r\nYou have a fever when your temperature rises above its normal range. What', 'General weakness.\r\nYou have a fever when your temperature rises above its normal range. What', '', '', 'ddfd', 7, NULL, '', '', '0000-00-00 00:00:00', 'no', 'no', '2021-06-04 05:55:40', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (23, 16, 77, '5', '55', '72', '97', 'dddd', '80', '0', 2, '', 'Yes', '', '', '', '', '', 7, NULL, '', '', '0000-00-00 00:00:00', 'no', 'no', '2021-06-04 05:55:52', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (24, 32, 78, '', '', '', '', '', '', '0', 2, 'covid-19', 'Yes', '', '', 'No', '', '', 7, 0, '', '', '1970-01-01 05:30:00', 'no', 'yes', '2021-06-04 05:55:40', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (28, 18, 110, 'j', 'j', 'k', 'j', 'h', 'h', '25', 7, '', 'No', 'General weakness.\r\nYou have a fever when your temperature rises above its normal range. What', '', 'No', '', 'v', 7, 11, '5000', '', '2021-05-11 16:23:00', 'no', 'no', '2021-05-14 11:51:50', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (29, 16, 128, '', '', '', '', '', '', '0', 2, '', 'Yes', '', '', '', '', '', 17, NULL, '', '', '0000-00-00 00:00:00', 'no', 'yes', '2021-06-04 05:56:01', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (30, 2, 72, '', '', '', '', '', '', '0', 2, 'new', 'Yes', 'ggg', 'ggg', '', '', '', 7, NULL, '', '', '0000-00-00 00:00:00', 'yes', 'no', '2021-06-04 05:55:52', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (33, 139, 145, '', '', '', '', '', '', '33', 1, '', 'No', '', NULL, 'No', '', '', 7, 0, '5000', '', '2021-06-03 06:29:00', 'yes', 'no', '2021-06-03 09:16:35', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (34, 147, 142, '', '', '', '', '', '', '31', 1, '', 'Yes', '', '', '', '', '', 7, NULL, '', '', '0000-00-00 00:00:00', 'yes', 'no', '2021-06-07 10:23:26', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (35, 24, 148, '', '', '', '', '', '', '30', 1, '', 'No', '', NULL, 'No', '', '', 7, 0, '5000', '', '2021-05-17 11:51:00', 'yes', 'no', '2021-06-03 09:30:56', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (36, 139, 151, '', '', '', '', '', '', '31', 1, '', 'No', '', NULL, '', '', '', 25, NULL, '5000', '', '2021-05-19 10:25:00', 'yes', 'no', '2021-06-03 09:37:11', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (37, 146, 141, '', '', '', '', '', '', '34', 1, '', 'Yes', '', NULL, 'No', '', '', 24, 0, '', '', '1999-11-30 00:00:00', 'no', 'no', '2021-06-03 11:24:32', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (38, 184, 157, '', '', '', '', '', '', '12', 2, 'etgfes', 'No', '', NULL, '', '', 'e', 24, 11, '5000', '', '2021-06-18 11:39:00', 'no', 'yes', '2021-06-17 06:14:51', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (39, 204, 197, '', '', '', '', '', '', '2', 1, 'corona', 'Yes', '', '', '', '', '', 7, NULL, '', '', '0000-00-00 00:00:00', 'no', 'yes', '2021-06-21 12:16:41', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (40, 205, 198, '', '', '', '', '', '', '36', 1, 'JJ', 'No', '', NULL, '', '', '', 7, NULL, '5000', '', '2021-04-30 12:59:00', 'no', 'yes', '2021-06-21 12:22:25', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (41, 206, 199, '', '', '', '', '', '', '2', 1, 'NA', 'Yes', '', '', '', '', '', 10, NULL, '', '', '0000-00-00 00:00:00', 'yes', 'yes', '2021-06-28 10:39:00', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (42, 208, 201, '', '', '', '', '', '', '12', 2, 'testcase', 'Yes', '', '', '', '', 'checkmk', 7, NULL, '', '', '0000-00-00 00:00:00', 'no', 'yes', '2021-06-22 15:13:22', NULL);
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `created_at`, `generated_by`) VALUES (43, 226, 216, '', '', '', '', '', '', '37', 1, '', 'No', '', NULL, '', '', '', 7, NULL, '5000', '', '2021-06-29 06:26:00', 'no', 'no', '2021-06-30 08:31:41', NULL);


#
# TABLE STRUCTURE FOR: ipd_doctors
#

DROP TABLE IF EXISTS `ipd_doctors`;

CREATE TABLE `ipd_doctors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) NOT NULL,
  `consult_doctor` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (5, 1, 10, '2021-04-30 07:56:03');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (6, 1, 13, '2021-04-30 07:56:03');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (7, 1, 14, '2021-04-30 07:56:03');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (8, 1, 15, '2021-04-30 07:56:03');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (9, 1, 17, '2021-04-30 07:56:03');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (10, 1, 18, '2021-04-30 07:56:03');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (13, 37, 26, '2021-06-08 18:15:43');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (14, 37, 7, '2021-06-08 18:15:43');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (15, 38, 25, '2021-06-17 06:19:47');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (16, 38, 26, '2021-06-17 06:19:47');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (29, 41, 26, '2021-06-28 10:35:27');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (30, 41, 27, '2021-06-28 10:35:27');
INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (31, 41, 7, '2021-06-28 10:35:27');


#
# TABLE STRUCTURE FOR: ipd_prescription_basic
#

DROP TABLE IF EXISTS `ipd_prescription_basic`;

CREATE TABLE `ipd_prescription_basic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) DEFAULT NULL,
  `visit_details_id` int(11) DEFAULT NULL,
  `header_note` text NOT NULL,
  `footer_note` text NOT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `visit_details_id` (`visit_details_id`),
  CONSTRAINT `ipd_prescription_basic_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_basic_ibfk_2` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (16, NULL, 25, '<p>ggg</p>', '<p>ggg</p>', '2021-05-01', '2021-05-01 09:13:18');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (18, NULL, 30, '<p>sss</p>', '<p>gg</p>', '2021-05-03', '2021-05-03 12:40:56');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (23, NULL, 38, '<p>gg</p>', '<p>gg</p>', '2021-06-23', '2021-06-23 11:27:31');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (26, 14, NULL, '<p>fkvfvkfd</p>', '<p>sdkds</p>', '2021-05-06', '2021-05-06 11:49:27');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (27, NULL, 37, 'ggg', 'gg', '2021-05-06', '2021-05-06 14:03:58');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (29, NULL, 47, '<p>check</p>', '<p>check</p>', '2021-05-18', '2021-05-18 16:47:12');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (31, 24, NULL, '<p>dfggs</p>', '<p>dfdfgdfgd</p>', '2021-05-11', '2021-05-11 10:16:10');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (32, 28, NULL, 'tes', '', '2021-05-12', '2021-05-12 04:32:48');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (34, 29, NULL, '<p>nnn</p>', '<p>nnn</p>', '2021-05-14', '2021-05-14 07:41:59');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (35, 19, NULL, '<p>vv</p>', '<p>vvv</p>', '2021-05-14', '2021-05-14 10:57:50');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (37, NULL, 52, '<p>fdfd</p>', '<p>jhjghddfg</p>', '2021-05-15', '2021-05-15 06:32:31');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (38, 28, NULL, 'tretrt', 'ttttttttt', '2021-05-15', '2021-05-15 08:07:39');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (39, NULL, 53, '<p>hghhgh</p>', '<p>hhhhhh</p>', '2021-05-15', '2021-05-15 10:38:55');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (40, 36, NULL, '<p>fff</p>', '<p>ff</p>', '2021-06-03', '2021-06-03 09:37:09');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (42, 17, NULL, '', '', '2021-06-11', '2021-06-11 09:55:06');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (43, 38, NULL, '<p>ccch</p>', '<p>fg</p>', '2021-06-17', '2021-06-17 06:32:50');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (48, NULL, 105, '<p>rgergfregr</p>', '<p>grgrgrg</p>', '2021-06-21', '2021-06-21 06:34:19');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (50, NULL, 109, '<p>drftregfrgrg</p>', '<p>trgtrgrtg</p>', '2021-06-21', '2021-06-21 07:08:33');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (52, NULL, 113, '<p>trgtrgrtgrt</p>', '<p>tyhythyt</p>', '2021-06-21', '2021-06-21 10:34:47');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (53, NULL, 119, '', '', '2021-06-22', '2021-06-22 05:48:06');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (54, NULL, 123, '<p>uy7ujyu7jyjh</p>', '<p>ujyjy</p>', '2021-06-24', '2021-06-24 04:52:20');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (55, NULL, 112, '<p>this is header&nbsp;</p>', '<p>this is footer</p>', '2021-06-21', '2021-06-21 15:32:21');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (56, NULL, 125, '<p>\r\n\r\nA prescription, often abbreviated ℞ or Rx, is a formal communication from a physician or other registered health-care professional to a pharmacist, authorizing them to dispense a specific prescription drug for a specific patien\r\n\r\n<br></p>', '<p>\r\n\r\nA prescription, often abbreviated ℞ or Rx, is a formal communication from a physician or other registered health-care professional to a pharmacist, authorizing them to dispense a specific prescription drug for a specific patien\r\n\r\n<br></p>', '2021-06-28', '2021-06-28 11:08:15');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (57, NULL, 115, '<p>tutu</p>', '<p>tyu</p>', '2021-06-22', '2021-06-22 05:19:43');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (58, NULL, 117, '', '', '2021-06-22', '2021-06-22 05:46:14');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (59, NULL, 126, '<p>fglibhfgugbiftbji</p>', '<p>jhmlkhjmh</p>', '2021-06-22', '2021-06-22 06:54:14');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (60, NULL, 131, '<p>fghtdhtghg</p>', '<p>hgg</p>', '2021-06-23', '2021-06-23 04:51:56');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (62, 41, NULL, '<p>sdasf</p>', '', '2021-06-24', '2021-06-24 07:41:53');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (63, 42, NULL, '<p>test</p>', '', '2021-06-28', '2021-06-28 05:34:29');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (64, NULL, 135, '<p>\r\n\r\nA <b>prescription</b>&nbsp;is a <b>written</b>, or electronic order, from a practitioner or designated agent to a pharmacist for a particular medication for a specific patient. <b>Prescription</b>&nbsp;is a medicolegal document, hence utmost care is needed while <b>writing</b>&nbsp;a <b>prescription</b>.\r\n\r\n<br></p>', '<p>\r\n\r\nA <b>prescription</b>&nbsp;is a <b>written</b>, or electronic order, from a practitioner or designated agent to a pharmacist for a particular medication for a specific patient. <b>Prescription</b>&nbsp;is a medicolegal document, hence utmost care is needed while <b>writing</b>&nbsp;a <b>prescription</b>.\r\n\r\n<br></p>', '2021-06-29', '2021-06-29 04:49:47');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (65, NULL, 136, '', '', '2021-06-29', '2021-06-29 06:04:12');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (66, NULL, 137, '<p>gffghfg</p>', '<p>gfhnfghn</p>', '2021-06-30', '2021-06-30 04:43:18');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (67, NULL, 138, '<p>fddvfvdfvf</p>', '<p>vfdvfv</p>', '2021-06-30', '2021-06-30 06:23:03');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (68, NULL, 124, '<p>dvsdfvsdvcfsd</p>', '<p>vdsvdsc</p>', '2021-06-30', '2021-06-30 07:28:34');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (69, NULL, 58, '<p>dfdsfsdfs</p>', '<p>fsvgdv</p>', '2021-06-30', '2021-06-30 07:32:35');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (70, NULL, 107, '<p>thtrhthty</p>', '<p>hjtyht</p>', '2021-06-30', '2021-06-30 07:35:55');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (71, NULL, 120, '<p>dewedwqd</p>', '<p>wdwqd</p>', '2021-06-30', '2021-06-30 07:37:12');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (72, NULL, 139, '<p>fgbfhfb</p>', '<p>bfhf</p>', '2021-06-30', '2021-06-30 09:16:16');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `header_note`, `footer_note`, `date`, `created_at`) VALUES (73, NULL, 141, '<p>pathology</p>', '<p>pathology</p>', '2021-07-01', '2021-07-01 05:19:54');


#
# TABLE STRUCTURE FOR: ipd_prescription_details
#

DROP TABLE IF EXISTS `ipd_prescription_details`;

CREATE TABLE `ipd_prescription_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `basic_id` int(11) NOT NULL,
  `pharmacy_id` int(10) DEFAULT NULL,
  `dosage` int(11) NOT NULL,
  `dose_interval_id` int(11) DEFAULT NULL,
  `dose_duration_id` int(11) DEFAULT NULL,
  `instruction` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `basic_id` (`basic_id`),
  KEY `pharmacy_id` (`pharmacy_id`),
  CONSTRAINT `ipd_prescription_details_ibfk_1` FOREIGN KEY (`basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_details_ibfk_2` FOREIGN KEY (`pharmacy_id`) REFERENCES `pharmacy` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (21, 16, 5, 3, 0, 0, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (24, 18, 1, 6, 0, 0, 'dd');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (31, 23, 1, 1, 0, 0, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (36, 26, 1, 1, 0, 0, 'jfjfrjjjjjr');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (37, 27, 4, 3, 0, 0, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (41, 29, 5, 3, 0, 0, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (43, 31, 1, 6, 0, 0, 'jkk');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (44, 32, 1, 1, 0, 0, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (46, 34, 1, 1, 0, 0, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (47, 35, 2, 6, 0, 0, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (48, 37, 1, 6, 3, 1, 'jjhg');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (49, 37, 4, 3, 1, 2, 'hhhh');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (50, 38, 1, 6, 1, 2, 'yyyy');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (51, 38, 5, 18, 6, 1, 'fgfgfg');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (52, 39, 4, 3, 1, 2, 'trtrt');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (53, 29, 1, 1, 1, 1, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (54, 40, 1, 6, 0, 0, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (56, 42, 1, 1, 1, 1, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (57, 43, 2, 1, 1, 1, 'cf');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (62, 48, 1, 1, 1, 1, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (63, 48, 4, 3, 1, 1, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (69, 50, 2, 1, 1, 1, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (74, 52, 2, 1, 1, 1, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (75, 50, 4, 3, 1, 2, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (76, 50, 6, 18, 5, 1, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (77, 53, 2, 1, 1, 1, '43R4');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (78, 54, 1, 1, 1, 1, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (79, 55, 1, 1, 1, 1, 'sf');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (80, 55, 4, 3, 1, 1, 'fgfg');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (81, 56, 1, 1, 1, 1, 'A prescription, often abbreviated ℞ or Rx, is a formal communication from a physician or other registered health-care professional to a pharmacist, authorizing them to dispense a specific prescription drug for a specific patien');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (82, 57, 1, 1, 1, 1, 'tyu');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (83, 57, 2, 1, 4, 2, 'ty');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (84, 58, 1, 1, 0, 0, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (85, 58, 2, 1, 0, 0, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (86, 53, 2, 1, 3, 0, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (87, 59, 1, 6, 1, 2, 'gfjkhtkyjhio');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (88, 60, 1, 1, 1, 1, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (90, 62, 1, 1, 1, 1, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (91, 63, 1, 6, 1, 1, 'instruction');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (92, 64, 1, 1, 1, 1, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (93, 65, 1, 1, 1, 1, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (94, 66, 1, 1, 1, 1, 'cgbgng');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (95, 67, 1, 1, 1, 0, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (96, 68, 1, 1, 1, 0, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (97, 69, 1, 1, 1, 1, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (98, 70, 1, 1, 1, 1, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (99, 71, 1, 1, 1, 1, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (100, 72, 1, 1, 3, 0, '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`) VALUES (101, 73, 1, 1, 1, 0, '');


#
# TABLE STRUCTURE FOR: ipd_prescription_test
#

DROP TABLE IF EXISTS `ipd_prescription_test`;

CREATE TABLE `ipd_prescription_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_prescription_basic_id` int(100) NOT NULL,
  `pathology_id` int(11) DEFAULT NULL,
  `radiology_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  CONSTRAINT `ipd_prescription_test_ibfk_1` FOREIGN KEY (`ipd_prescription_basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=165 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (23, 18, 34, NULL, '2021-05-03 12:40:56');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (24, 18, NULL, 2, '2021-05-03 12:40:56');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (40, 26, 33, NULL, '2021-05-06 11:49:27');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (41, 26, NULL, 2, '2021-05-06 11:49:27');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (42, 26, NULL, 1, '2021-05-06 11:49:27');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (45, 29, 33, NULL, '2021-05-08 10:05:13');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (46, 29, 34, NULL, '2021-05-08 10:05:13');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (47, 29, 35, NULL, '2021-05-08 10:05:13');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (48, 29, NULL, 3, '2021-05-08 10:05:13');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (49, 29, NULL, 2, '2021-05-08 10:05:13');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (50, 29, NULL, 1, '2021-05-08 10:05:13');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (55, 35, 34, NULL, '2021-05-14 10:57:50');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (56, 35, NULL, 1, '2021-05-14 10:57:50');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (57, 37, 34, NULL, '2021-05-15 06:32:31');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (58, 37, NULL, 2, '2021-05-15 06:32:31');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (59, 38, 34, NULL, '2021-05-15 08:07:39');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (60, 38, NULL, 2, '2021-05-15 08:07:39');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (61, 39, 34, NULL, '2021-05-15 10:38:55');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (62, 39, NULL, 1, '2021-05-15 10:38:55');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (63, 40, 34, NULL, '2021-06-03 09:37:09');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (64, 40, NULL, 1, '2021-06-03 09:37:09');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (67, 43, 34, NULL, '2021-06-17 06:32:50');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (68, 43, NULL, 2, '2021-06-17 06:32:50');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (79, 48, 33, NULL, '2021-06-19 08:13:29');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (80, 48, 34, NULL, '2021-06-19 08:13:29');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (81, 48, NULL, 3, '2021-06-19 08:13:29');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (82, 48, NULL, 2, '2021-06-19 08:13:29');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (85, 50, 33, NULL, '2021-06-21 07:08:33');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (86, 50, NULL, 2, '2021-06-21 07:08:33');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (89, 50, 34, NULL, '2021-06-21 07:16:19');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (90, 50, NULL, 1, '2021-06-21 07:16:19');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (93, 52, 33, NULL, '2021-06-21 10:34:47');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (94, 52, NULL, 1, '2021-06-21 10:34:47');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (95, 53, 33, NULL, '2021-06-21 11:35:59');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (96, 53, NULL, 1, '2021-06-21 11:35:59');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (98, 54, NULL, 2, '2021-06-21 13:01:06');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (100, 54, NULL, 1, '2021-06-21 13:04:11');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (101, 55, 34, NULL, '2021-06-21 15:32:21');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (102, 55, NULL, 2, '2021-06-21 15:32:21');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (104, 56, NULL, 2, '2021-06-22 04:35:54');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (105, 57, 35, NULL, '2021-06-22 05:19:43');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (106, 57, NULL, 2, '2021-06-22 05:19:43');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (107, 58, 34, NULL, '2021-06-22 05:46:14');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (108, 58, NULL, 2, '2021-06-22 05:46:14');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (109, 59, 33, NULL, '2021-06-22 06:54:14');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (110, 59, 34, NULL, '2021-06-22 06:54:14');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (111, 59, NULL, 2, '2021-06-22 06:54:14');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (113, 60, 34, NULL, '2021-06-23 04:51:56');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (115, 60, 37, NULL, '2021-06-23 07:18:52');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (116, 60, 38, NULL, '2021-06-23 07:18:52');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (117, 23, 34, NULL, '2021-06-23 11:27:31');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (118, 23, 37, NULL, '2021-06-23 11:27:31');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (121, 54, 34, NULL, '2021-06-24 04:53:45');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (126, 63, 34, NULL, '2021-06-28 05:34:29');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (127, 63, NULL, 3, '2021-06-28 05:34:29');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (128, 64, 34, NULL, '2021-06-29 04:49:47');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (129, 64, 37, NULL, '2021-06-29 04:49:47');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (130, 64, 38, NULL, '2021-06-29 04:49:47');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (131, 64, 39, NULL, '2021-06-29 04:49:47');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (132, 64, 40, NULL, '2021-06-29 04:49:47');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (133, 64, NULL, 3, '2021-06-29 04:49:47');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (134, 65, 34, NULL, '2021-06-29 06:04:12');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (135, 66, 34, NULL, '2021-06-30 04:43:18');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (136, 66, 37, NULL, '2021-06-30 04:43:18');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (137, 66, 38, NULL, '2021-06-30 04:43:18');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (138, 66, 39, NULL, '2021-06-30 04:43:18');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (139, 66, 40, NULL, '2021-06-30 04:43:18');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (140, 66, NULL, 3, '2021-06-30 04:43:18');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (141, 66, NULL, 2, '2021-06-30 04:43:18');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (142, 67, 34, NULL, '2021-06-30 06:23:03');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (143, 67, 37, NULL, '2021-06-30 06:23:03');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (144, 67, 38, NULL, '2021-06-30 06:23:03');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (145, 67, 39, NULL, '2021-06-30 06:23:03');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (146, 67, 40, NULL, '2021-06-30 06:23:03');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (147, 68, 37, NULL, '2021-06-30 07:28:34');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (149, 69, NULL, 3, '2021-06-30 07:32:45');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (150, 69, 37, NULL, '2021-06-30 07:33:16');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (151, 70, 34, NULL, '2021-06-30 07:35:55');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (152, 70, NULL, 3, '2021-06-30 07:35:55');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (153, 71, 34, NULL, '2021-06-30 07:37:12');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (154, 71, NULL, 2, '2021-06-30 07:37:12');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (155, 67, NULL, 4, '2021-06-30 08:28:50');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (156, 67, NULL, 3, '2021-06-30 08:28:50');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (157, 67, NULL, 2, '2021-06-30 08:28:50');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (158, 67, NULL, 1, '2021-06-30 08:28:50');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (159, 72, 34, NULL, '2021-06-30 09:16:16');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (160, 72, 38, NULL, '2021-06-30 09:16:16');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (161, 72, 39, NULL, '2021-06-30 09:28:04');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (162, 72, 40, NULL, '2021-06-30 09:28:04');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (163, 73, 34, NULL, '2021-07-01 05:19:54');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (164, 73, 37, NULL, '2021-07-01 05:19:54');


#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category_id` int(11) DEFAULT NULL,
  `item_store_id` int(11) DEFAULT NULL,
  `item_supplier_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `unit` varchar(200) NOT NULL,
  `item_photo` varchar(225) DEFAULT NULL,
  `description` text NOT NULL,
  `quantity` int(100) NOT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `item_store_id` (`item_store_id`),
  KEY `item_supplier_id` (`item_supplier_id`),
  CONSTRAINT `item_ibfk_1` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_ibfk_2` FOREIGN KEY (`item_store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_ibfk_3` FOREIGN KEY (`item_supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (1, 2, NULL, NULL, 'syrenge', '12', NULL, 'tt', 0, NULL, '2021-05-31 06:37:20');
INSERT INTO `item` (`id`, `item_category_id`, `item_store_id`, `item_supplier_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (2, 2, NULL, NULL, 'Surgery  mask', '100', NULL, 'tt', 0, NULL, '2021-05-31 06:37:14');


#
# TABLE STRUCTURE FOR: item_category
#

DROP TABLE IF EXISTS `item_category`;

CREATE TABLE `item_category` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_category` varchar(255) NOT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'yes',
  `description` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (1, 'stationary', 'yes', 'tt', '2021-05-31 06:19:18');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (2, 'Medicine Instrument', 'yes', 'mi', '2021-05-31 06:19:50');


#
# TABLE STRUCTURE FOR: item_issue
#

DROP TABLE IF EXISTS `item_issue`;

CREATE TABLE `item_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_type` int(11) DEFAULT NULL,
  `issue_to` int(11) DEFAULT NULL,
  `issue_by` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `quantity` int(10) NOT NULL,
  `note` text NOT NULL,
  `is_returned` int(2) NOT NULL DEFAULT '1',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_category_id` (`item_category_id`),
  CONSTRAINT `item_issue_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_2` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `is_active`, `created_at`) VALUES (1, 3, 25, 'Super Admin', '2021-05-01', '2021-05-31', 2, 2, 2, 'rrr', 1, 'no', '2021-05-31 10:37:40');


#
# TABLE STRUCTURE FOR: item_stock
#

DROP TABLE IF EXISTS `item_stock`;

CREATE TABLE `item_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `store_id` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `purchase_price` float(10,2) DEFAULT '0.00',
  `date` date NOT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  `description` text NOT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `item_stock_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `is_active`, `created_at`) VALUES (1, 2, 1, '+', 2, 5, '50.00', '0001-11-30', NULL, 'test test\r\n', 'yes', '2021-06-28 11:39:31');


#
# TABLE STRUCTURE FOR: item_store
#

DROP TABLE IF EXISTS `item_store`;

CREATE TABLE `item_store` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`) VALUES (1, 'syrenge', '897', 'ss');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`) VALUES (2, 'Surgery Mask', '784', 'ss');


#
# TABLE STRUCTURE FOR: item_supplier
#

DROP TABLE IF EXISTS `item_supplier`;

CREATE TABLE `item_supplier` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`) VALUES (1, 'jatin', '9845847587', 'jatin@gmail.com', 'bhopal', '', '', '', '');


#
# TABLE STRUCTURE FOR: lab
#

DROP TABLE IF EXISTS `lab`;

CREATE TABLE `lab` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lab_name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `lab` (`id`, `lab_name`) VALUES (5, 'Digital scan');


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8;

INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 'no', 'no', '2019-11-20 11:23:12', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 'no', 'no', '2019-11-20 11:42:42', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 'no', 'no', '2019-11-20 11:38:50', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 'no', 'no', '2019-11-20 11:47:28', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Afrikaans', 'af', 'af', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Basque', 'eu', 'es', 'no', 'no', '2019-11-20 11:54:10', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Bengali', 'bn', 'in', 'no', 'no', '2019-11-20 11:41:53', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Bosnian', 'bs', 'bs', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Welsh', 'cy', 'cy', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Hungarian', 'hu', 'hu', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Vietnamese', 'vi', 'vi', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Haitian', 'ht', 'ht', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Galician', 'gl', 'gl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Dutch', 'nl', 'nl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Greek', 'el', 'gr', 'no', 'no', '2019-11-20 12:12:08', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Georgian', 'ka', 'ge', 'no', 'no', '2019-11-20 12:11:40', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Gujarati', 'gu', 'in', 'no', 'no', '2019-11-20 11:39:16', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Danish', 'da', 'dk', 'no', 'no', '2019-11-20 12:03:25', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Hebrew', 'he', 'il', 'no', 'no', '2019-11-20 12:13:50', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Yiddish', 'yi', 'il', 'no', 'no', '2019-11-20 12:25:33', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Indonesian', 'id', 'id', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Irish', 'ga', 'ga', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Italian', 'it', 'it', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Icelandic', 'is', 'is', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Spanish', 'es', 'es', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Kannada', 'kn', 'kn', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Catalan', 'ca', 'ca', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Chinese', 'zh', 'cn', 'no', 'no', '2019-11-20 12:01:48', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Korean', 'ko', 'kr', 'no', 'no', '2019-11-20 12:19:09', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Xhosa', 'xh', 'ls', 'no', 'no', '2019-11-20 12:24:39', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Latin', 'la', 'la', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Latvian', 'lv', 'lv', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Lithuanian', 'lt', 'lt', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'Malagasy', 'mg', 'mg', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Malay', 'ms', 'ms', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Malayalam', 'ml', 'ml', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Maltese', 'mt', 'mt', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Macedonian', 'mk', 'mk', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Maori', 'mi', 'nz', 'no', 'no', '2019-11-20 12:20:27', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Marathi', 'mr', 'in', 'no', 'no', '2019-11-20 11:39:51', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Mongolian', 'mn', 'mn', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'German', 'de', 'de', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Nepali', 'ne', 'ne', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Norwegian', 'no', 'no', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Punjabi', 'pa', 'in', 'no', 'no', '2019-11-20 11:40:16', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Persian', 'fa', 'ir', 'no', 'no', '2019-11-20 12:21:17', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Portuguese', 'pt', 'pt', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Romanian', 'ro', 'ro', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Russian', 'ru', 'ru', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Cebuano', 'ceb', 'ph', 'no', 'no', '2019-11-20 11:59:12', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Sinhala', 'si', 'si', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'Slovakian', 'sk', 'sk', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Slovenian', 'sl', 'sl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Swahili', 'sw', 'ke', 'no', 'no', '2019-11-20 12:21:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Sundanese', 'su', 'sd', 'no', 'no', '2019-12-03 11:06:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Thai', 'th', 'th', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Tagalog', 'tl', 'tl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Tamil', 'ta', 'in', 'no', 'no', '2019-11-20 11:40:53', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Telugu', 'te', 'in', 'no', 'no', '2019-11-20 11:41:15', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Turkish', 'tr', 'tr', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Uzbek', 'uz', 'uz', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'Urdu', 'ur', 'pk', 'no', 'no', '2019-11-20 12:23:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'Finnish', 'fi', 'fi', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'French', 'fr', 'fr', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'Hindi', 'hi', 'in', 'no', 'no', '2019-11-20 11:36:34', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'Czech', 'cs', 'cz', 'no', 'no', '2019-11-20 12:02:36', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'Swedish', 'sv', 'sv', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'Scottish', 'gd', 'gd', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'Estonian', 'et', 'et', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'Esperanto', 'eo', 'br', 'no', 'no', '2019-11-21 04:49:18', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'Javanese', 'jv', 'id', 'no', 'no', '2019-11-20 12:18:29', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'Japanese', 'ja', 'jp', 'no', 'no', '2019-11-20 12:14:39', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'Polish', 'pl', 'pl', 'yes', 'no', '2020-04-05 14:09:04', NULL);


#
# TABLE STRUCTURE FOR: leave_types
#

DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `leave_types` (`id`, `type`, `is_active`) VALUES (6, 'CL', 'yes');


#
# TABLE STRUCTURE FOR: logs
#

DROP TABLE IF EXISTS `logs`;

CREATE TABLE `logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text NOT NULL,
  `record_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `action` varchar(50) CHARACTER SET utf8mb4 NOT NULL,
  `ip_address` varchar(50) CHARACTER SET utf8mb4 NOT NULL,
  `platform` varchar(50) NOT NULL,
  `agent` varchar(50) NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_at` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3705 DEFAULT CHARSET=utf8;

INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1, 'New Record inserted Appointment Created 69', 69, 1, 'Insert', '122.168.188.20', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 11:19:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2, 'Record updated Appointment Updated 69', 69, 1, 'Update', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 11:33:30', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (3, 'Record deleted On Appointment Deleted id 69', 69, 1, 'Delete', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 12:17:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (4, 'Record deleted On Appointment Deleted id 65', 65, 1, 'Delete', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 12:18:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (5, 'Record updated On Patient id 4', 4, 1, 'Update', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 13:01:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (6, 'New Record inserted On OPD id 16920', 16920, 1, 'Insert', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 13:01:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (7, 'Record updated On OPD id 11638', 11638, 1, 'Update', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 13:02:20', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (8, 'Record deleted On IPD id 40', 40, 1, 'Delete', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 15:15:25', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (9, 'New Record inserted On IPD id 17', 17, 1, 'Insert', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 15:16:26', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (10, 'Record updated On IPD id 17', 17, 1, 'Update', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 15:17:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (11, 'New Record inserted On pathology Test id 2', 2, 1, 'Insert', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 16:27:29', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (12, 'Record updated On Pathology Test id 2', 2, 1, 'Update', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 16:31:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (13, 'Record deleted On  Pathology Test  id 2', 2, 1, 'Delete', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 16:31:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (14, 'New Record inserted On radiology Test id 4', 4, 1, 'Insert', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 16:32:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (15, 'Record updated On Radiology Test id 4', 4, 1, 'Update', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 16:34:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (16, 'Record deleted On  Radio Test  id 2', 2, 1, 'Delete', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 16:37:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (17, 'Record updated On Patient id 53', 53, 1, 'Update', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 17:10:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (18, 'Record updated On Patient id 33', 33, 1, 'Update', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 17:11:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (19, 'New Record inserted On Operation Theatre id 11', 11, 1, 'Insert', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 17:11:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (20, 'New Record inserted On Pathology Test Report id 7', 7, 1, 'Insert', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 17:14:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (21, 'New Record inserted On Radiology Test Report id 4', 4, 1, 'Insert', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 17:15:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (22, 'Record updated On Radiology Test Report id 2', 2, 1, 'Update', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 17:16:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (23, 'Record deleted On  Radiology Test Report  id 2', 2, 1, 'Delete', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 17:16:20', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (24, 'New Record inserted On Blood Donor id 4', 4, 1, 'Insert', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 17:28:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (25, 'Record updated For Blood Donor id 2', 2, 1, 'Update', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 17:30:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (26, 'Record deleted Where  Blood Donor id 2', 2, 1, 'Delete', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 17:35:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (27, 'New Record inserted On Blood Issue  id 7', 7, 1, 'Insert', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 17:53:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (28, 'Record updatedFor Blood Issue id 2', 2, 1, 'Update', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 17:55:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (29, 'Record deleted Where Blood Issue id 2', 2, 1, 'Delete', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 17:56:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (30, 'New Record inserted On TPA id 4', 4, 1, 'Insert', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 18:21:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (31, 'Record updated On TPA id 4', 4, 1, 'Update', '122.168.189.62', 'Windows 10', 'Chrome 88.0.4324.104', '2021-01-30 18:22:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (32, 'New Record inserted On Income id 6', 6, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 11:23:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (33, 'Record updated For Income id 6', 6, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 11:25:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (34, 'Record deleted Where Income  id 6', 6, 1, 'Delete', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 11:43:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (35, 'Record updated For Expenses id 1', 1, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 11:44:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (36, 'New Record inserted On Expenses id 13', 13, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 11:46:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (37, 'Record updated For Expenses id 12', 12, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 11:51:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (38, 'Record deleted Where Expenses  id 13', 13, 1, 'Delete', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 11:53:57', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (39, 'New Record inserted On Ambulance id 4', 4, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 12:45:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (40, 'New Record inserted On Ambulance Call id 7', 7, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 12:47:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (41, 'Record updated For Ambulance Call id 7', 7, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 12:47:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (42, 'Record deleted Where Ambulance Call id 7', 7, 1, 'Delete', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 12:48:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (43, 'New Record inserted On Ambulance Call id 8', 8, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 12:48:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (44, 'Record deleted Where Ambulance Call id 8', 8, 1, 'Delete', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 12:49:25', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (45, 'New Record inserted On Birth Report id 5', 5, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 13:56:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (46, 'Record updated For Birth Report id 5', 5, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 13:56:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (47, 'Record updated For Birth Report id 5', 5, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 13:56:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (48, 'Record updated For Birth Report id 5', 5, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 13:56:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (49, 'Record deleted Where Birth Report  id 5', 5, 1, 'Delete', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 13:57:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (50, 'New Record inserted On Death Report id 4', 4, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 13:57:53', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (51, 'Record updated For Death Report id 3', 3, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 13:58:08', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (52, 'Record deleted Where Death Report  id 4', 4, 1, 'Delete', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 13:58:25', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (53, 'New Record inserted On Item Stock id 5', 5, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 14:54:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (54, 'Record updated For Item Stock id 5', 5, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 14:54:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (55, 'Record deleted Where Item Stock id 5', 5, 1, 'Delete', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 14:55:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (56, 'New Record inserted On Item Issue id 7', 7, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 14:57:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (57, 'Record deleted Where Item Issue id 7', 7, 1, 'Delete', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 15:05:04', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (58, 'Record updated For Item id 4', 4, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 15:19:39', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (59, 'Record deleted Where Item id 2', 2, 1, 'Delete', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 15:20:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (60, 'New Record inserted On Staff Payslip id 2', 2, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 16:12:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (61, 'Record updated For Staff id 16', 16, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 16:30:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (62, 'Record updated For Staff id 17', 17, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 16:31:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (63, 'Record deleted Where staff id 16', 16, 1, 'Delete', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 16:38:23', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (64, 'Record updated For Staff Leave Request id 4', 4, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 17:53:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (65, 'New Record inserted On Staff Leave Request pending id 5', 5, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 17:59:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (66, 'Record updated For Staff Leave Request approve id 5', 5, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 17:59:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (67, 'New Record inserted On Staff Leave Request Pending id 6', 6, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 18:03:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (68, 'Record updated For Staff Leave Request Approve id 6', 6, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-01 18:04:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (69, 'Record updated Password For Staff id 5', 5, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 10:55:32', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (70, 'Record updated Change Password For Staff id 5', 5, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 10:57:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (71, 'Record updated Change Password For Staff id 4', 4, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 11:35:01', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (72, 'New Record inserted On Staff Payslip id 3', 3, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 11:43:57', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (73, 'Record updated Staff payslip Pay For Staff id 3', 3, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 12:03:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (74, 'Record updated Staff Payslip Reverte For Staff id 3', 3, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 12:13:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (75, 'New Record inserted On Upload Content id 2', 2, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 12:52:30', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (76, 'Record updated For Upload Content id 2', 2, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 12:52:30', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (77, 'New Record inserted On Upload Content id 3', 3, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 13:06:39', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (78, 'New Record inserted On Upload Content id 4', 4, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 13:07:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (79, 'New Record inserted On Upload Content id 5', 5, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 13:15:32', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (80, 'Record updated For Upload Content id 5', 5, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 13:15:32', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (81, 'New Record inserted On Upload Content id 6', 6, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 13:44:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (82, 'Record deleted Where Upload Content id 2', 2, 1, 'Delete', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 13:46:44', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (83, 'New Record inserted On Page Event id 4', 4, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 15:19:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (84, 'Record updated For Page Event id 4', 4, 1, 'Update', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 15:20:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (85, 'New Record inserted On Page Event id 5', 5, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 15:20:49', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (86, 'Record deleted Where Events id 5', 5, 1, 'Delete', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 15:30:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (87, 'New Record inserted On Page notice id 7', 7, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 15:52:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (88, 'New Record inserted On Page events id 8', 8, 1, 'Insert', '122.168.188.28', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-02 16:40:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (89, 'New Record inserted On Page Menu id 9', 9, 1, 'Insert', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 10:46:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (90, 'New Record inserted On Live Consultation id 15', 15, 1, 'Insert', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 11:28:25', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (91, 'Record deleted Where Live Consultation id 15', 15, 1, 'Delete', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 11:30:46', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (92, 'New Record inserted On Live Meeting id 17', 17, 1, 'Insert', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 11:41:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (93, 'Record deleted Where Live Consultation id 17', 17, 1, 'Delete', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 11:47:29', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (94, 'Record updated For conferences 1 id 10', 10, 1, 'Update', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 13:01:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (95, 'New Record inserted On Live Consultation id 18', 18, 1, 'Insert', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 13:09:04', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (96, 'Record updated For conferences Cancelled id 18', 18, 1, 'Update', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 13:09:36', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (97, 'Record updated For Conferences Awaited id 6', 6, 1, 'Update', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 13:10:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (98, 'Record deleted Where Conference id 18', 18, 1, 'Delete', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 13:13:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (99, 'Record updated For Conferences Finished id 6', 6, 1, 'Update', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 13:13:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (100, 'Record updated For Conferences Awaited id 10', 10, 1, 'Update', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 13:14:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (101, 'Record updated For Conferences Finished id 7', 7, 1, 'Update', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 13:14:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (102, 'Record updated For Blood Donor id 4', 4, 1, 'Update', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 15:30:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (103, 'New Record inserted For Blood Donor id 5', 5, 1, 'Insert', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 15:30:53', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (104, 'Record updated For Blood Donor id 3', 3, 1, 'Update', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 15:52:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (105, 'New Record inserted On send notification id 4', 4, 1, 'Insert', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 16:34:53', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (106, 'Record updated On  send notification id 1', 1, 1, 'Update', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 16:38:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (107, 'Record deleted On send notification id 1', 1, 1, 'Delete', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 16:44:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (108, 'New Record inserted On Messages Send SMS id 10', 10, 1, 'Insert', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 17:29:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (109, 'New Record inserted On Messages Send SMS id 11', 11, 1, 'Insert', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 17:30:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (110, 'New Record inserted On Messages Send SMS id 12', 12, 1, 'Insert', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 17:35:23', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (111, 'New Record inserted On Messages Send Mail id 13', 13, 1, 'Insert', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 17:40:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (112, 'Record updated On send notification id 2', 2, 1, 'Update', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 17:44:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (113, 'New Record inserted On Messages Send SMS id 14', 14, 1, 'Insert', '122.168.188.107', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-03 17:55:52', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (114, 'New Record inserted On Messages Send SMS id 15', 15, 1, 'Insert', '122.168.189.1', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-04 10:36:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (115, 'New Record inserted On Messages Send SMS id 16', 16, 1, 'Insert', '122.168.189.1', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-04 10:36:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (116, 'New Record inserted On Messages Send SMS id 17', 17, 1, 'Insert', '122.168.189.1', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-04 10:37:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (117, 'New Record inserted On Messages Send SMS id 18', 18, 1, 'Insert', '122.168.189.1', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-04 10:52:23', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (118, 'New Record inserted On Messages Send Mail id 19', 19, 1, 'Insert', '122.168.189.1', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-04 10:56:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (119, 'Record updated On Patient id 54', 54, 1, 'Update', '122.168.189.1', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-04 11:13:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (120, 'New Record inserted On Operation Theatre id 12', 12, 1, 'Insert', '122.168.189.1', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-04 11:13:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (121, 'Record updated On send notification id 4', 4, 1, 'Update', '122.168.189.1', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-04 11:54:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (122, 'New Record inserted On pathology Test id 2', 2, 1, 'Insert', '122.168.189.1', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-04 12:09:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (123, 'New Record inserted On pathology Test id 3', 3, 1, 'Insert', '122.168.189.1', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-04 12:10:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (124, 'Record deleted On  Pathology Test  id 2', 2, 1, 'Delete', '122.168.189.1', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-04 12:10:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (125, 'New Record inserted On pathology Test id 4', 4, 1, 'Insert', '122.168.189.1', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-04 12:11:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (126, 'New Record inserted On IPD id 18', 18, 1, 'Insert', '122.168.189.1', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-04 20:39:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (127, 'Record updated On Patient id 33', 33, 1, 'Update', '122.168.189.1', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-04 20:39:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (128, 'Record updated On Patient id 33', 33, 1, 'Update', '122.168.189.1', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-04 20:39:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (129, 'Record updated On OPD id 16918', 16918, 1, 'Update', '122.168.189.1', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-04 20:40:57', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (130, 'New Record inserted On Patient id 56', 56, 1, 'Insert', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.104', '2021-02-05 05:19:57', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (131, 'Record updated On Patient id 56', 56, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 14:22:49', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (132, 'New Record inserted On OPD id 16921', 16921, 1, 'Insert', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 14:22:49', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (133, 'New Record inserted On Live Consultation id 15', 15, 1, 'Insert', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 14:22:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (134, 'Record updatedOn Appointment Updated 69', 69, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 14:22:54', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (135, 'Record updated On OPD id 16921', 16921, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 14:23:39', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (136, 'Record updated On Patient id 56', 56, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 14:23:39', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (137, 'New Record inserted On Patient id 60', 60, 1, 'Insert', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 09:06:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (138, 'Record updated On Patient id 68', 68, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 15:09:24', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (139, 'New Record inserted On OPD id 16922', 16922, 1, 'Insert', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 15:09:24', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (140, 'Record updatedOn Appointment Updated 79', 79, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 15:09:24', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (141, 'New Record insertedOn Appointment Created 80', 80, 1, 'Insert', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 15:46:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (142, 'New Record inserted On Patient id 69', 69, 1, 'Insert', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 15:47:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (143, 'Record updatedOn Appointment Updated 80', 80, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 15:47:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (144, 'Record updated On Patient id 69', 69, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 15:47:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (145, 'Record updated On Patient id 69', 69, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 16:33:22', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (146, 'New Record inserted On OPD id 16923', 16923, 1, 'Insert', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 16:33:22', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (147, 'New Record inserted On Live Consultation id 16', 16, 1, 'Insert', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 16:33:23', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (148, 'New Record inserted On Patient id 70', 70, 1, 'Insert', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 16:37:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (149, 'Record updated On Patient id 70', 70, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 16:37:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (150, 'Record updated On Patient id 70', 70, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 16:37:32', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (151, 'New Record inserted On OPD id 16924', 16924, 1, 'Insert', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 16:37:32', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (152, 'New Record inserted On Live Consultation id 17', 17, 1, 'Insert', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 16:37:33', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (153, 'Record updated On OPD id 16924', 16924, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 16:39:54', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (154, 'Record updated For Conferences Finished id 17', 17, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 16:56:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (155, 'Record updated For Conferences Awaited id 17', 17, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 16:56:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (156, 'Record updated For Conferences Finished id 17', 17, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 17:17:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (157, 'Record updatedOn Appointment Updated 70', 70, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 17:30:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (158, 'Record updated On Pathology Test Report id 10', 10, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 17:37:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (159, 'Record updated On Pathology Test Report id 10', 10, 1, 'Update', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 17:37:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (160, 'New Record inserted On Blood Issue  id 8', 8, 1, 'Insert', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 17:52:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (161, 'New Record inserted On Ambulance id 5', 5, 1, 'Insert', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 17:53:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (162, 'New Record insertedOn Appointment Created 90', 90, 1, 'Insert', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 18:25:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (163, 'Record deleted On Appointment Deleted id 90', 90, 1, 'Delete', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 18:26:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (164, 'New Record insertedOn Appointment Created 92', 92, 1, 'Insert', '122.168.188.70', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-05 18:40:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (165, 'New Record inserted On Ambulance Call id 7', 7, 1, 'Insert', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 10:26:07', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (166, 'Record updated On Patient id 90', 90, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 11:25:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (167, 'New Record inserted On OPD id 16925', 16925, 1, 'Insert', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 11:25:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (168, 'New Record inserted On Live Consultation id 18', 18, 1, 'Insert', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 11:25:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (169, 'Record updatedOn Appointment Updated 102', 102, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 11:25:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (170, 'Record updated On Patient id 91', 91, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 11:33:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (171, 'New Record inserted On OPD id 16926', 16926, 1, 'Insert', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 11:33:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (172, 'New Record inserted On Live Consultation id 19', 19, 1, 'Insert', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 11:33:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (173, 'Record updatedOn Appointment Updated 103', 103, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 11:33:07', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (174, 'Record updated On OPD id 16926', 16926, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 11:47:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (175, 'Record updated On Patient id 91', 91, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 12:11:24', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (176, 'New Record inserted On Operation Theatre id 13', 13, 1, 'Insert', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 12:11:24', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (177, 'Record updated On Patient id 54', 54, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 12:15:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (178, 'Record updated On Operation Theatre id 12', 12, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 12:15:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (179, 'Record updated On Patient id 33', 33, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 12:15:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (180, 'Record updated On Operation Theatre id 11', 11, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 12:15:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (181, 'Record updated On Patient id 40', 40, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 12:15:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (182, 'Record updated On Operation Theatre id 8', 8, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 12:15:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (183, 'Record updated On Patient id 89', 89, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 12:19:46', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (184, 'New Record inserted On Operation Theatre id 14', 14, 1, 'Insert', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 12:19:46', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (185, 'New Record insertedOn Appointment Created 105', 105, 1, 'Insert', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 12:26:04', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (186, 'New Record insertedOn Appointment Created 106', 106, 1, 'Insert', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 12:27:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (187, 'Record updated On Patient id 92', 92, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 12:34:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (188, 'New Record inserted On OPD id 16927', 16927, 1, 'Insert', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 12:34:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (189, 'New Record inserted On Live Consultation id 20', 20, 1, 'Insert', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 12:34:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (190, 'Record updatedOn Appointment Updated 105', 105, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 12:34:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (191, 'New Record insertedOn Appointment Created 107', 107, 1, 'Insert', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 13:11:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (192, 'Record updated On Patient id 92', 92, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 13:18:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (193, 'New Record inserted On Operation Theatre id 15', 15, 1, 'Insert', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 13:18:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (194, 'Record updated On Patient id 92', 92, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 13:20:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (195, 'Record updated On Operation Theatre id 15', 15, 1, 'Update', '122.168.188.233', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-06 13:20:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (196, 'New Record insertedOn Appointment Created 109', 109, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 11:12:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (197, 'Record updatedOn Appointment Updated 109', 109, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 11:13:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (198, 'New Record insertedOn Appointment Created 110', 110, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 11:14:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (199, 'Record updated On Patient id 93', 93, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 11:20:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (200, 'New Record inserted On OPD id 16928', 16928, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 11:20:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (201, 'New Record inserted On Live Consultation id 21', 21, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 11:20:32', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (202, 'New Record insertedOn Appointment Created 111', 111, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:07:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (203, 'Record updatedOn Appointment Updated 108', 108, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:10:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (204, 'Record updated On Patient id 93', 93, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:11:26', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (205, 'New Record inserted On OPD id 16929', 16929, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:11:26', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (206, 'New Record inserted On Live Consultation id 22', 22, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:11:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (207, 'Record updatedOn Appointment Updated 108', 108, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:11:32', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (208, 'Record updated On OPD id 16928', 16928, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:15:07', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (209, 'New Record inserted On Patient id 94', 94, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:18:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (210, 'Record updatedOn Appointment Updated 111', 111, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:18:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (211, 'Record updated On Patient id 94', 94, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:18:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (212, 'Record updated On Patient id 94', 94, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:18:36', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (213, 'New Record inserted On OPD id 16930', 16930, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:18:36', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (214, 'New Record inserted On Live Consultation id 23', 23, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:18:37', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (215, 'New Record inserted On Patient id 95', 95, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:22:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (216, 'Record updated On Patient id 95', 95, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:22:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (217, 'New Record inserted On IPD id 19', 19, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:23:24', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (218, 'Record updated On Patient id 95', 95, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:23:24', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (219, 'Record updated On Patient id 95', 95, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:23:24', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (220, 'New Record inserted On Live Consultation id 24', 24, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:23:25', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (221, 'New Record inserted For Blood Donor id 6', 6, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:52:04', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (222, 'Record updated For Blood Donor id 1', 1, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 12:52:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (223, 'Record updated On Patient id 95', 95, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 13:44:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (224, 'New Record inserted On OPD id 16931', 16931, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 13:44:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (225, 'Record updated On OPD id 16931', 16931, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 13:52:49', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (226, 'New Record inserted On Income id 6', 6, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 13:53:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (227, 'Record updated For Income id 6', 6, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 13:53:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (228, 'New Record inserted On Income id 7', 7, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 13:54:36', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (229, 'Record updated For Income id 7', 7, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 13:54:36', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (230, 'New Record inserted On Expenses id 13', 13, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:02:33', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (231, 'Record updated For Expenses id 13', 13, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:02:33', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (232, 'Record deleted Where Expenses  id 13', 13, 1, 'Delete', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:02:49', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (233, 'Record deleted Where Expenses  id 1', 1, 1, 'Delete', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:02:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (234, 'Record deleted Where Expenses  id 4', 4, 1, 'Delete', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:02:57', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (235, 'New Record inserted On Expenses id 14', 14, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:03:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (236, 'Record updated For Expenses id 14', 14, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:03:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (237, 'Record deleted Where Expenses  id 2', 2, 1, 'Delete', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:03:22', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (238, 'Record updated For Expenses id 9', 9, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:05:24', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (239, 'Record updated For Expenses id 9', 9, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:05:24', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (240, 'New Record inserted On Income id 8', 8, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:05:46', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (241, 'New Record inserted On Ambulance id 6', 6, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:16:53', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (242, 'New Record inserted On Ambulance Call id 8', 8, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:19:33', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (243, 'Record updated For Ambulance Call id 6', 6, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:19:46', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (244, 'Record deleted Where Ambulance Call id 6', 6, 1, 'Delete', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:20:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (245, 'New Record inserted On Birth Report id 5', 5, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:21:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (246, 'Record updated For Birth Report id 5', 5, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:21:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (247, 'Record updated For Birth Report id 5', 5, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:21:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (248, 'New Record inserted On Death Report id 4', 4, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:28:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (249, 'Record updated For Death Report id 4', 4, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:30:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (250, 'New Record inserted On send notification id 5', 5, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:40:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (251, 'Record updated Change Password For Staff id 10', 10, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:41:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (252, 'New Record inserted On send notification id 6', 6, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:44:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (253, 'New Record inserted On send notification id 7', 7, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:45:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (254, 'Record deleted On send notification id 7', 7, 10, 'Delete', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:45:57', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (255, 'New Record inserted On Messages Send Mail id 20', 20, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:46:49', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (256, 'New Record inserted On send notification id 8', 8, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:48:26', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (257, 'New Record inserted On send notification id 9', 9, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:49:01', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (258, 'New Record inserted On send notification id 10', 10, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:49:42', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (259, 'Record updated On send notification id 2', 2, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:58:33', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (260, 'Record updated On send notification id 2', 2, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:58:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (261, 'Record deleted On send notification id 10', 10, 1, 'Delete', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:58:37', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (262, 'Record deleted On send notification id 9', 9, 1, 'Delete', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:58:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (263, 'New Record inserted On Upload Content id 7', 7, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 14:59:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (264, 'Record updated For Item Stock id 4', 4, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:04:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (265, 'Record deleted Where Item Stock id 4', 4, 1, 'Delete', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:04:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (266, 'New Record inserted On Item Stock id 5', 5, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:04:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (267, 'Record deleted Where Item Stock id 5', 5, 1, 'Delete', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:04:33', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (268, 'New Record inserted On Item Stock id 6', 6, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:04:57', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (269, 'New Record inserted On Item Issue id 5', 5, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:09:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (270, 'New Record inserted On Item Issue id 6', 6, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:10:49', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (271, 'Record deleted Where Item Issue id 4', 4, 1, 'Delete', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:10:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (272, 'Record updated For Item Issue id 6', 6, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:13:38', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (273, 'Record updated For Item Issue id 5', 5, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:13:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (274, 'Record deleted Where Item Issue id 6', 6, 1, 'Delete', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:13:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (275, 'Record deleted Where Item Issue id 5', 5, 1, 'Delete', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:13:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (276, 'New Record inserted On Item Issue id 7', 7, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:14:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (277, 'Record deleted Where Item Issue id 7', 7, 1, 'Delete', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:15:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (278, 'New Record inserted On Item Issue id 8', 8, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:15:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (279, 'New Record inserted On Item Issue id 9', 9, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:16:23', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (280, 'Record updated On Patient id 95', 95, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:27:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (281, 'New Record inserted On Operation Theatre id 16', 16, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:27:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (282, 'Record updated For Item id 4', 4, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:39:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (283, 'Record updated For Item id 3', 3, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:40:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (284, 'Record updated For Item id 4', 4, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:40:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (285, 'Record updated For Item id 4', 4, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:40:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (286, 'Record updated For Item id 4', 4, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:41:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (287, 'Record updated For Item Stock id 6', 6, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 15:44:46', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (288, 'New Record inserted On Live Consultation id 25', 25, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 16:08:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (289, 'Record deleted Where Conference id 25', 25, 1, 'Delete', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 16:08:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (290, 'Record deleted Where Conference id 24', 24, 1, 'Delete', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 16:08:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (291, 'Record updated For Conferences Cancelled id 23', 23, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 16:11:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (292, 'Record updated For Conferences Finished id 23', 23, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 16:11:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (293, 'Record updated For Conferences Cancelled id 23', 23, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 16:11:49', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (294, 'Record updated For Conferences Awaited id 23', 23, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 16:11:52', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (295, 'Record updated On IPD id 19', 19, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 16:29:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (296, 'Record updated On Patient id 95', 95, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 16:29:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (297, 'Record updated On Pathology Test id 4', 4, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 16:58:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (298, 'Record updated For Staff id 18', 18, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 17:03:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (299, 'Record updated For Staff id 18', 18, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 17:03:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (300, 'New Record inserted On Messages Send SMS id 21', 21, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 17:09:24', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (301, 'New Record inserted On Upload Content id 8', 8, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 17:10:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (302, 'New Record insertedOn Appointment Created 113', 113, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 17:48:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (303, 'New Record inserted On pathology Test id 5', 5, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 18:58:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (304, 'Record updated On Patient id 98', 98, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 18:58:42', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (305, 'New Record inserted On Operation Theatre id 17', 17, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 18:58:42', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (306, 'New Record inserted On IPD id 20', 20, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 19:00:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (307, 'Record updated On Patient id 98', 98, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 19:00:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (308, 'Record updated On Patient id 98', 98, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 19:00:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (309, 'New Record inserted On Live Consultation id 26', 26, 1, 'Insert', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 19:00:44', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (310, 'Record updatedOn Appointment Updated 31', 31, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 19:01:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (311, 'Record updatedOn Appointment Updated 32', 32, 1, 'Update', '122.168.188.2', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-09 19:01:30', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (312, 'Record updated On Pathology Test id 5', 5, 1, 'Update', '122.168.188.103', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-10 11:37:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (313, 'Record deleted On  Radiology Test Billing  id 1', 1, 1, 'Delete', '122.168.188.103', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-10 12:22:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (314, 'Record deleted On  Radiology Test Billing  id 2', 2, 1, 'Delete', '122.168.188.103', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-10 12:23:30', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (315, 'Record updated Change Password For Staff id 6', 6, 1, 'Update', '122.168.188.15', 'Windows 10', 'Chrome 88.0.4324.146', '2021-02-10 17:26:57', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (316, 'New Record inserted On Birth Report id 6', 6, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 14:02:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (317, 'Record updated For Birth Report id 6', 6, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 14:02:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (318, 'Record updated For Birth Report id 6', 6, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 14:02:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (319, 'Record deleted Where Birth Report  id 5', 5, 1, 'Delete', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 14:02:54', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (320, 'New Record inserted On Birth Report id 7', 7, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 14:05:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (321, 'Record updated For Birth Report id 7', 7, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 14:05:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (322, 'Record updated For Birth Report id 7', 7, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 14:05:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (323, 'Record updated For Ambulance id 1', 1, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 14:21:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (324, 'New Record inserted On Death Report id 5', 5, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 14:23:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (325, 'New Record insertedOn Appointment Created 117', 117, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 14:40:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (326, 'Record updated On Patient id 99', 99, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 15:33:08', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (327, 'New Record inserted On OPD id 16932', 16932, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 15:33:08', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (328, 'Record updated On OPD id 16932', 16932, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 15:34:44', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (329, 'Record updated On OPD id 16932', 16932, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 15:35:26', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (330, 'Record updated On IPD id 20', 20, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 15:52:23', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (331, 'Record updated On Patient id 98', 98, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 15:52:23', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (332, 'New Record inserted On Blood Issue  id 9', 9, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 15:57:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (333, 'New Record inserted On Live Consultation id 27', 27, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:00:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (334, 'New Record inserted On Live Meeting id 28', 28, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:00:32', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (335, 'Record deleted Where Conference id 7', 7, 1, 'Delete', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:01:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (336, 'Record updated For Conferences Cancelled id 28', 28, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:02:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (337, 'Record updated For Conferences Awaited id 28', 28, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:02:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (338, 'Record updated For Conferences Awaited id 6', 6, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:02:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (339, 'Record updated For Conferences Cancelled id 6', 6, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:02:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (340, 'Record updated For Conferences Awaited id 6', 6, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:02:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (341, 'Record updated For Conferences Cancelled id 23', 23, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:02:24', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (342, 'Record updated For Conferences Finished id 23', 23, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:02:26', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (343, 'Record updated For Conferences Cancelled id 26', 26, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:02:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (344, 'Record deleted Where Conference id 26', 26, 1, 'Delete', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:02:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (345, 'New Record inserted For TPA id 5', 5, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:02:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (346, 'New Record inserted On Income id 9', 9, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:03:38', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (347, 'Record updated For Income id 9', 9, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:03:38', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (348, 'Record deleted Where Income  id 6', 6, 1, 'Delete', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:03:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (349, 'Record deleted Where Income  id 7', 7, 1, 'Delete', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:03:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (350, 'Record deleted Where Income  id 4', 4, 1, 'Delete', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:04:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (351, 'Record deleted Where Income  id 1', 1, 1, 'Delete', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:04:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (352, 'Record deleted Where Income  id 8', 8, 1, 'Delete', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:04:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (353, 'New Record inserted On Income id 10', 10, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:04:42', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (354, 'New Record inserted On Expenses id 15', 15, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:05:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (355, 'New Record inserted On Birth Report id 8', 8, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:06:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (356, 'Record updated For Birth Report id 8', 8, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:06:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (357, 'Record updated For Birth Report id 8', 8, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:06:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (358, 'New Record insertedOn Appointment Created 118', 118, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:07:49', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (359, 'New Record inserted On Patient id 100', 100, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:10:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (360, 'Record updatedOn Appointment Updated 118', 118, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:10:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (361, 'Record updated On Patient id 100', 100, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:10:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (362, 'Record updated On Patient id 100', 100, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:10:52', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (363, 'New Record inserted On OPD id 16933', 16933, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:10:52', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (364, 'New Record inserted On Live Consultation id 29', 29, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:10:53', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (365, 'New Record inserted For Blood Donor id 7', 7, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 16:28:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (366, 'New Record inserted On Item Stock id 7', 7, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 17:03:30', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (367, 'Record updated For Item Stock id 7', 7, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 17:03:30', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (368, 'New Record inserted On Item Issue id 10', 10, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 17:04:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (369, 'Record updated For Item id 4', 4, 1, 'Update', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 17:04:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (370, 'Record deleted Where Item id 4', 4, 1, 'Delete', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 17:04:54', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (371, 'Record deleted Where Upload Content id 8', 8, 1, 'Delete', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 17:05:01', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (372, 'Record deleted Where Upload Content id 7', 7, 1, 'Delete', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 17:05:04', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (373, 'Record deleted Where Upload Content id 1', 1, 1, 'Delete', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 17:05:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (374, 'Record deleted Where Upload Content id 5', 5, 1, 'Delete', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 17:05:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (375, 'New Record inserted On Messages Send SMS id 22', 22, 1, 'Insert', '122.168.189.137', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 17:06:01', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (376, 'Record updated For Conferences Cancelled id 28', 28, 1, 'Update', '122.168.188.91', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 18:28:36', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (377, 'Record deleted Where Conference id 28', 28, 1, 'Delete', '122.168.188.91', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 18:28:39', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (378, 'Record updated For Conferences Cancelled id 6', 6, 1, 'Update', '122.168.188.91', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 18:28:52', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (379, 'Record updated For Conferences Awaited id 6', 6, 1, 'Update', '122.168.188.91', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 18:28:57', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (380, 'Record deleted Where Expenses  id 3', 3, 1, 'Delete', '122.168.188.91', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 18:34:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (381, 'Record updated Change Password For Staff id 6', 6, 1, 'Update', '122.168.188.91', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-11 18:39:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (382, 'New Record insertedOn Appointment Created 119', 119, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 11:32:04', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (383, 'New Record inserted On Live Consultation id 30', 30, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 12:16:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (384, 'Record updated For Conferences Awaited id 23', 23, 1, 'Update', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 12:16:22', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (385, 'Record updated For Conferences Cancelled id 10', 10, 1, 'Update', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 12:16:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (386, 'Record updated For Conferences Finished id 10', 10, 1, 'Update', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 12:16:33', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (387, 'Record updated For Conferences Awaited id 10', 10, 1, 'Update', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 12:16:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (388, 'Record deleted Where Income  id 5', 5, 1, 'Delete', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 12:23:23', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (389, 'New Record inserted On Income id 11', 11, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 12:23:53', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (390, 'Record updated For Income id 11', 11, 1, 'Update', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 12:23:53', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (391, 'New Record inserted On Expenses id 16', 16, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 12:24:53', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (392, 'Record updated For Expenses id 16', 16, 1, 'Update', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 12:24:53', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (393, 'Record deleted Where Expenses  id 16', 16, 1, 'Delete', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 12:24:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (394, 'New Record inserted On Patient id 101', 101, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 13:22:23', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (395, 'Record updated On Patient id 101', 101, 1, 'Update', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 13:22:23', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (396, 'Record updated On Patient id 30', 30, 1, 'Update', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 15:03:49', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (397, 'Record updated On Patient id 32', 32, 1, 'Update', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 15:05:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (398, 'Record updated On Patient id 101', 101, 1, 'Update', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 15:05:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (399, 'New Record insertedOn Appointment Created 120', 120, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 15:27:44', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (400, 'Record deleted Where Conference id 30', 30, 1, 'Delete', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 15:37:23', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (401, 'New Record inserted On Item Issue id 11', 11, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 15:44:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (402, 'New Record inserted On Item Issue id 12', 12, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 15:45:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (403, 'New Record inserted On Item Issue id 13', 13, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 15:49:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (404, 'Record updated For Item Issue id 12', 12, 1, 'Update', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 15:52:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (405, 'Record updated For Item Issue id 13', 13, 1, 'Update', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 15:52:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (406, 'New Record inserted On Item Issue id 14', 14, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 15:52:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (407, 'New Record inserted On Live Consultation id 31', 31, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 16:05:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (408, 'Record deleted Where Conference id 23', 23, 1, 'Delete', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 16:05:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (409, 'Record updated On Patient id 98', 98, 1, 'Update', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 16:07:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (410, 'New Record inserted On OPD id 16934', 16934, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 16:07:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (411, 'Record updated On Patient id 98', 98, 1, 'Update', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 16:37:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (412, 'New Record inserted On OPD id 16935', 16935, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 16:37:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (413, 'New Record inserted For Blood Donor id 8', 8, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 16:47:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (414, 'New Record inserted On Item Store id 2', 2, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 16:51:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (415, 'New Record inserted On Item Store id 3', 3, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 16:51:30', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (416, 'New Record inserted On Item Stock id 8', 8, 1, 'Insert', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 18:19:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (417, 'Record updated On OPD id 16930', 16930, 1, 'Update', '122.168.188.27', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-12 18:29:26', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (418, 'Record updated On Patient id 99', 99, 1, 'Update', '122.168.189.177', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-13 18:05:46', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (419, 'New Record inserted On OPD id 16936', 16936, 1, 'Insert', '122.168.189.177', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-13 18:05:46', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (420, 'Record updated On OPD id 16936', 16936, 1, 'Update', '122.168.189.177', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-13 18:07:46', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (421, 'Record updated On Patient id 28', 28, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 10:37:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (422, 'New Record inserted On OPD id 16937', 16937, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 10:37:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (423, 'Record updated On Patient id 28', 28, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 10:44:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (424, 'New Record inserted On OPD id 16938', 16938, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 10:44:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (425, 'Record updated On Patient id 100', 100, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 11:27:04', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (426, 'New Record inserted On OPD id 16939', 16939, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 11:27:04', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (427, 'New Record insertedOn Appointment Created 121', 121, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 11:29:36', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (428, 'New Record inserted On Patient id 102', 102, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 11:31:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (429, 'Record updatedOn Appointment Updated 121', 121, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 11:31:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (430, 'Record updated On Patient id 102', 102, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 11:31:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (431, 'Record updated On Patient id 102', 102, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 11:31:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (432, 'New Record inserted On OPD id 16940', 16940, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 11:31:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (433, 'New Record inserted On Live Consultation id 32', 32, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 11:31:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (434, 'Record updated On Patient id 100', 100, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 17:52:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (435, 'New Record inserted On OPD id 16941', 16941, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 17:52:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (436, 'New Record inserted On Patient id 103', 103, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 17:54:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (437, 'Record updated On Patient id 103', 103, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 17:54:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (438, 'Record updated On Patient id 103', 103, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 17:54:38', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (439, 'New Record inserted On OPD id 16942', 16942, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 17:54:38', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (440, 'New Record inserted On Patient id 104', 104, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 17:59:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (441, 'Record updated On Patient id 104', 104, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 17:59:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (442, 'Record updated On Patient id 104', 104, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 17:59:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (443, 'New Record inserted On OPD id 16943', 16943, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 17:59:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (444, 'New Record inserted On Patient id 105', 105, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:00:52', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (445, 'Record updated On Patient id 105', 105, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:00:52', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (446, 'Record updated On Patient id 105', 105, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:01:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (447, 'New Record inserted On OPD id 16944', 16944, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:01:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (448, 'New Record inserted On Patient id 106', 106, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:01:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (449, 'Record updated On Patient id 106', 106, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:01:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (450, 'Record updated On Patient id 106', 106, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:02:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (451, 'New Record inserted On OPD id 16945', 16945, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:02:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (452, 'Record updated On Patient id 103', 103, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:10:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (453, 'New Record inserted On OPD id 16946', 16946, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:10:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (454, 'Record updated On Patient id 103', 103, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:10:54', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (455, 'New Record inserted On OPD id 16947', 16947, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:10:54', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (456, 'New Record inserted On Patient id 107', 107, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:18:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (457, 'Record updated On Patient id 107', 107, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:18:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (458, 'Record updated On Patient id 107', 107, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:18:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (459, 'New Record inserted On OPD id 16948', 16948, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:18:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (460, 'Record updated On Patient id 107', 107, 1, 'Update', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:22:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (461, 'New Record inserted On OPD id 16949', 16949, 1, 'Insert', '122.168.189.74', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-15 18:22:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (462, 'New Record inserted On Patient id 108', 108, 1, 'Insert', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 11:07:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (463, 'Record updated On Patient id 108', 108, 1, 'Update', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 11:07:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (464, 'Record updated On Patient id 108', 108, 1, 'Update', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 11:09:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (465, 'New Record inserted On OPD id 16950', 16950, 1, 'Insert', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 11:09:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (466, 'New Record inserted On IPD id 21', 21, 1, 'Insert', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 11:53:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (467, 'Record updated On Patient id 100', 100, 1, 'Update', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 11:53:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (468, 'Record updated On Patient id 100', 100, 1, 'Update', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 11:53:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (469, 'New Record inserted On id card id 1', 1, 1, 'Insert', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 14:56:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (470, 'Record updated On  id card id 1', 1, 1, 'Update', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 14:56:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (471, 'Record updated On  id card id 1', 1, 1, 'Update', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 14:58:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (472, 'Record updated On  id card id 1', 1, 1, 'Update', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 15:10:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (473, 'Record updated On  id card id 1', 1, 1, 'Update', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 15:14:25', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (474, 'Record updated On  id card id 1', 1, 1, 'Update', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 15:16:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (475, 'New Record inserted On Patient id 109', 109, 1, 'Insert', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 15:55:42', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (476, 'Record updated On Patient id 109', 109, 1, 'Update', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 15:55:42', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (477, 'Record updated On Patient id 109', 109, 1, 'Update', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 15:56:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (478, 'New Record inserted On OPD id 16951', 16951, 1, 'Insert', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 15:56:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (479, 'New Record inserted On Patient id 110', 110, 1, 'Insert', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 15:56:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (480, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 15:56:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (481, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 15:57:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (482, 'New Record inserted On OPD id 16952', 16952, 1, 'Insert', '122.168.189.227', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 15:57:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (483, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.188.173', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 15:58:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (484, 'New Record inserted On OPD id 16953', 16953, 1, 'Insert', '122.168.188.173', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 15:58:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (485, 'Record updated On  id card id 1', 1, 1, 'Update', '122.168.189.52', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 16:43:23', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (486, 'Record updated On  id card id 1', 1, 1, 'Update', '122.168.189.52', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 16:44:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (487, 'Record deleted On id card id 1', 1, 1, 'Delete', '122.168.189.52', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 16:58:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (488, 'New Record inserted On id card id 2', 2, 1, 'Insert', '122.168.189.52', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 17:00:53', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (489, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.52', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 17:00:53', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (490, 'Record deleted On  Radiology Test Billing  id 1', 1, 1, 'Delete', '122.168.188.35', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-16 21:26:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (491, 'Record deleted On  Radiology Test Billing  id 2', 2, 1, 'Delete', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 11:44:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (492, 'Record deleted Where Ambulance id 1', 1, 1, 'Delete', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 11:47:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (493, 'Record deleted Where Ambulance id 3', 3, 1, 'Delete', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 11:47:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (494, 'Record deleted Where Ambulance id 4', 4, 1, 'Delete', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 11:47:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (495, 'Record deleted Where Ambulance id 2', 2, 1, 'Delete', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 11:48:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (496, 'Record deleted Where Conference id 29', 29, 1, 'Delete', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 11:52:57', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (497, 'Record deleted Where Conference id 27', 27, 1, 'Delete', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 12:22:49', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (498, 'Record deleted Where Conference id 31', 31, 1, 'Delete', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 12:23:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (499, 'New Record insertedOn Appointment Created 122', 122, 1, 'Insert', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 15:36:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (500, 'New Record insertedOn Appointment Created 123', 123, 1, 'Insert', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 15:39:37', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (501, 'Record updated On Patient id 109', 109, 1, 'Update', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 17:32:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (502, 'New Record inserted On OPD id 16954', 16954, 1, 'Insert', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 17:32:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (503, 'Record updated On Patient id 109', 109, 1, 'Update', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 17:34:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (504, 'New Record inserted On OPD id 16955', 16955, 1, 'Insert', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 17:34:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (505, 'New Record inserted On id card id 1', 1, 1, 'Insert', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 17:59:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (506, 'Record updated On  id card id 1', 1, 1, 'Update', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 17:59:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (507, 'New Record inserted On Upload Content id 7', 7, 1, 'Insert', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 18:10:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (508, 'New Record inserted On Upload Content id 8', 8, 1, 'Insert', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 18:13:44', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (509, 'New Record inserted On Upload Content id 9', 9, 1, 'Insert', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 18:14:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (510, 'New Record inserted On Upload Content id 10', 10, 1, 'Insert', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 18:17:26', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (511, 'New Record inserted On Upload Content id 11', 11, 1, 'Insert', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 18:22:54', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (512, 'New Record inserted On Upload Content id 12', 12, 1, 'Insert', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 18:23:44', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (513, 'New Record inserted On Upload Content id 13', 13, 1, 'Insert', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 18:29:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (514, 'New Record inserted On Upload Content id 14', 14, 1, 'Insert', '122.168.189.154', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-17 18:30:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (515, 'Record updated On Patient id 30', 30, 1, 'Update', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-18 11:51:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (516, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 12:10:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (517, 'New Record inserted On OPD id 1', 1, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 12:10:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (518, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 12:10:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (519, 'New Record inserted On OPD id 2', 2, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 12:10:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (520, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 12:11:04', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (521, 'New Record inserted On OPD id 3', 3, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 12:11:04', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (522, 'New Record inserted On Upload Content id 15', 15, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-18 12:16:37', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (523, 'New Record inserted On Upload Content id 16', 16, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-18 12:17:22', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (524, 'New Record inserted On Upload Content id 17', 17, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-18 12:18:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (525, 'New Record inserted On Upload Content id 18', 18, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-18 12:19:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (526, 'New Record inserted On Upload Content id 19', 19, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-18 12:20:20', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (527, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 12:21:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (528, 'New Record inserted On OPD id 4', 4, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 12:21:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (529, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 12:22:30', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (530, 'New Record inserted On OPD id 5', 5, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 12:22:30', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (531, 'New Record inserted On Upload Content id 20', 20, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-18 12:22:49', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (532, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 12:23:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (533, 'New Record inserted On OPD id 6', 6, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 12:23:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (534, 'New Record inserted On Upload Content id 21', 21, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-18 12:25:29', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (535, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 12:28:29', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (536, 'New Record inserted On OPD id 1', 1, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 12:28:29', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (537, 'Record deleted Where Ambulance id 6', 6, 1, 'Delete', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-18 12:28:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (538, 'New Record inserted On Income id 12', 12, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-18 12:45:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (539, 'Record updated For Income id 12', 12, 1, 'Update', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-18 12:45:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (540, 'New Record inserted On Income id 13', 13, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-18 12:47:22', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (541, 'Record updated On  id card id 1', 1, 1, 'Update', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 13:17:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (542, 'Record updated On  id card id 1', 1, 1, 'Update', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 13:18:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (543, 'Record deleted On id card id 1', 1, 1, 'Delete', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 13:19:29', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (544, 'New Record inserted On id card id 2', 2, 1, 'Insert', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 13:21:44', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (545, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.188.42', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 13:21:44', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (546, 'Record updated On IPD id 21', 21, 1, 'Update', '27.56.208.38', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 23:16:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (547, 'Record updated On Patient id 100', 100, 1, 'Update', '27.56.208.38', 'Windows 10', 'Chrome 88.0.4324.150', '2021-02-18 23:16:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (548, 'Record updated For Staff id 4', 4, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:42:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (549, 'Record updated For Staff id 4', 4, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:42:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (550, 'Record updated For Staff id 4', 4, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:49:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (551, 'Record updated For Staff id 4', 4, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:49:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (552, 'Record updated For Staff id 4', 4, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:49:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (553, 'Record updated For Staff id 4', 4, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:49:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (554, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:54:25', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (555, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:54:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (556, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:54:52', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (557, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:55:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (558, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:55:20', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (559, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:55:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (560, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:55:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (561, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:56:07', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (562, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:56:26', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (563, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:56:42', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (564, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 12:57:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (565, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 13:47:25', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (566, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 13:47:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (567, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 13:47:49', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (568, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 13:49:30', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (569, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:20:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (570, 'New Record insertedOn Appointment Created 124', 124, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:21:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (571, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:21:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (572, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:22:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (573, 'Record updated On  id card id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:23:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (574, 'New Record inserted On id card id 3', 3, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:30:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (575, 'Record updated On  id card id 3', 3, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:30:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (576, 'Record deleted Where Ambulance id 5', 5, 1, 'Delete', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:31:23', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (577, 'New Record inserted On Upload Content id 22', 22, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:32:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (578, 'New Record inserted On Upload Content id 23', 23, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:33:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (579, 'Record deleted Where Upload Content id 21', 21, 1, 'Delete', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:33:24', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (580, 'New Record inserted On Upload Content id 24', 24, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:33:52', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (581, 'Record deleted Where Upload Content id 24', 24, 1, 'Delete', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:34:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (582, 'Record deleted Where Upload Content id 6', 6, 1, 'Delete', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:34:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (583, 'Record updated On Patient id 30', 30, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:37:36', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (584, 'Record updated On Patient id 30', 30, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:37:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (585, 'New Record insertedOn Appointment Created 125', 125, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:45:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (586, 'Record updatedOn Appointment Updated 87', 87, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:45:37', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (587, 'New Record inserted On Live Consultation id 33', 33, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:47:26', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (588, 'Record deleted Where Conference id 33', 33, 1, 'Delete', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:47:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (589, 'New Record inserted On Ambulance id 7', 7, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:48:29', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (590, 'New Record inserted On Ambulance Call id 9', 9, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:50:36', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (591, 'Record updated On Patient id 109', 109, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 14:53:57', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (592, 'Record updated For Item Store id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 15:13:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (593, 'Record updated For Item Store id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 15:13:49', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (594, 'Record updated For Item Store id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 15:13:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (595, 'Record updated For Item Store id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 15:14:01', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (596, 'Record updated For Item Store id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 15:14:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (597, 'Record deleted On id card id 2', 2, 1, 'Delete', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 15:14:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (598, 'Record updated For Item Store id 2', 2, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 15:14:26', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (599, 'New Record inserted On id card id 3', 3, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 15:17:01', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (600, 'Record updated On  id card id 3', 3, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 15:17:01', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (601, 'Record deleted Where Ambulance id 7', 7, 1, 'Delete', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 15:24:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (602, 'Record updated On Patient id 28', 28, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 15:58:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (603, 'New Record inserted On Upload Content id 25', 25, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 16:26:33', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (604, 'New Record insertedOn Appointment Created 126', 126, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 16:29:46', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (605, 'New Record inserted On send notification id 9', 9, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 16:36:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (606, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 16:36:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (607, 'New Record insertedOn Appointment Created 127', 127, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 17:26:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (608, 'New Record insertedOn Appointment Created 128', 128, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 17:29:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (609, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 17:32:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (610, 'New Record inserted On OPD id 2', 2, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 17:32:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (611, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 17:35:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (612, 'New Record inserted On OPD id 3', 3, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 17:35:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (613, 'Record updatedOn Appointment Updated 110', 110, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 17:35:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (614, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 17:41:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (615, 'New Record inserted On OPD id 4', 4, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 17:41:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (616, 'New Record inserted On Page banner id 9', 9, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 17:47:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (617, 'New Record inserted On Page events id 10', 10, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 17:47:37', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (618, 'Record deleted Where Page Events id 10', 10, 1, 'Delete', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 17:47:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (619, 'Record deleted Where Upload Content id 25', 25, 1, 'Delete', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 17:51:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (620, 'New Record inserted On Upload Content id 26', 26, 1, 'Insert', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 18:00:39', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (621, 'Record updated On TPA id 5', 5, 1, 'Update', '122.168.189.244', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 18:24:53', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (622, 'Record updatedOn Appointment Updated 110', 110, 1, 'Update', '122.168.189.175', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 21:57:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (623, 'Record updatedOn Appointment Updated 110', 110, 1, 'Update', '122.168.189.175', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 22:00:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (624, 'Record updatedOn Appointment Updated 110', 110, 1, 'Update', '122.168.189.175', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-19 22:01:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (625, 'Record deleted On Appointment Deleted id 128', 128, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 11:44:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (626, 'Record deleted On Appointment Deleted id 125', 125, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 11:44:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (627, 'Record updated On Patient id 108', 108, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 11:51:37', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (628, 'New Record inserted On OPD id 5', 5, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 11:51:37', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (629, 'New Record insertedOn Appointment Created 129', 129, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 12:06:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (630, 'New Record inserted On Patient id 111', 111, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 12:07:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (631, 'Record updatedOn Appointment Updated 129', 129, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 12:07:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (632, 'Record updated On Patient id 111', 111, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 12:07:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (633, 'Record updated On Patient id 111', 111, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 12:08:29', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (634, 'New Record inserted On OPD id 6', 6, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 12:08:29', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (635, 'Record updated On Patient id 111', 111, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 12:13:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (636, 'New Record inserted On OPD id 7', 7, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 12:13:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (637, 'Record updated On Patient id 111', 111, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 12:31:37', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (638, 'New Record inserted On OPD id 8', 8, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 12:31:37', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (639, 'Record updated For Blood Donor id 1', 1, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 13:51:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (640, 'New Record inserted On Live Consultation id 33', 33, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 13:51:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (641, 'New Record inserted On Live Meeting id 34', 34, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 13:52:22', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (642, 'Record updated For Conferences Finished id 34', 34, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 13:53:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (643, 'Record updated For Conferences Cancelled id 34', 34, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 13:53:20', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (644, 'Record updated For Conferences Cancelled id 6', 6, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 13:53:25', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (645, 'Record deleted Where Conference id 34', 34, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:16:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (646, 'New Record inserted On Live Consultation id 35', 35, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:16:38', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (647, 'Record updated For Conferences Finished id 33', 33, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:20:46', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (648, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:24:29', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (649, 'Record updated For Conferences Awaited id 6', 6, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:26:36', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (650, 'Record updated For Blood Donor id 8', 8, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:30:32', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (651, 'New Record inserted On Item Stock id 9', 9, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:33:29', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (652, 'Record updated For Item Stock id 9', 9, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:33:29', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (653, 'New Record inserted On Item Issue id 15', 15, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:34:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (654, 'Record deleted Where Upload Content id 23', 23, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:39:57', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (655, 'Record deleted Where Upload Content id 3', 3, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:39:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (656, 'Record deleted Where Upload Content id 4', 4, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:40:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (657, 'Record deleted Where Upload Content id 7', 7, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:40:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (658, 'Record deleted Where Upload Content id 22', 22, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:40:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (659, 'Record deleted Where Upload Content id 8', 8, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:40:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (660, 'Record deleted Where Upload Content id 11', 11, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:40:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (661, 'Record deleted Where Upload Content id 10', 10, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:40:22', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (662, 'Record deleted Where Upload Content id 9', 9, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:40:46', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (663, 'Record deleted Where Upload Content id 12', 12, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:40:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (664, 'New Record inserted On Staff Payslip id 4', 4, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:47:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (665, 'Record deleted On Appointment Deleted id 87', 87, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:58:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (666, 'Record deleted On Appointment Deleted id 124', 124, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:58:08', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (667, 'Record deleted On Appointment Deleted id 127', 127, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:58:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (668, 'Record deleted On Appointment Deleted id 121', 121, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:58:22', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (669, 'Record deleted On Appointment Deleted id 122', 122, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 14:58:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (670, 'New Record insertedOn Appointment Created 130', 130, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 15:05:20', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (671, 'New Record inserted On Live Consultation id 36', 36, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 15:24:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (672, 'Record updated For Conferences Cancelled id 35', 35, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 15:25:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (673, 'Record updated For Conferences Awaited id 35', 35, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 15:25:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (674, 'Record updatedOn Appointment Updated 130', 130, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 15:28:39', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (675, 'Record updatedOn Appointment Updated 130', 130, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 15:28:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (676, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 16:04:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (677, 'New Record inserted On OPD id 9', 9, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 16:04:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (678, 'Record updatedOn Appointment Updated 130', 130, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 16:12:39', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (679, 'Record deleted Where Expenses  id 14', 14, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 17:00:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (680, 'New Record inserted On Expenses id 16', 16, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 17:02:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (681, 'Record updated For Expenses id 16', 16, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 17:02:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (682, 'Record deleted Where Expenses  id 16', 16, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 17:02:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (683, 'New Record inserted On Expenses id 17', 17, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 17:03:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (684, 'Record updated For Expenses id 17', 17, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 17:03:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (685, 'Record deleted Where Expenses  id 11', 11, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 17:03:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (686, 'Record deleted Where Expenses  id 10', 10, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 17:03:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (687, 'Record deleted Where Expenses  id 6', 6, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 18:08:39', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (688, 'Record deleted Where Expenses  id 8', 8, 1, 'Delete', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 18:08:44', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (689, 'New Record inserted On Income id 14', 14, 1, 'Insert', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 18:11:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (690, 'Record updated For Conferences Finished id 10', 10, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 18:27:37', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (691, 'Record updated For Conferences Cancelled id 10', 10, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 18:27:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (692, 'Record updatedOn Appointment Updated 110', 110, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 20:24:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (693, 'Record updatedOn Appointment Updated 111', 111, 1, 'Update', '122.168.188.124', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-20 20:27:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (694, 'New Record inserted On Ambulance id 1', 1, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 10:34:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (695, 'New Record inserted On Ambulance Call id 10', 10, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 10:35:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (696, 'New Record inserted On Item Issue id 16', 16, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 11:05:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (697, 'New Record inserted On Item Issue id 17', 17, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 11:21:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (698, 'New Record inserted On Item Issue id 18', 18, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 11:22:36', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (699, 'New Record insertedOn Appointment Created 131', 131, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 12:07:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (700, 'Record updatedOn Appointment Updated 110', 110, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 12:21:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (701, 'Record deleted Where staff id 12', 12, 1, 'Delete', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 12:34:22', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (702, 'Record updated On Patient id 111', 111, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 13:19:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (703, 'New Record inserted On OPD id 10', 10, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 13:19:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (704, 'New Record inserted On Live Meeting id 37', 37, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 14:10:52', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (705, 'Record deleted Where Conference id 37', 37, 1, 'Delete', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 14:11:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (706, 'Record updated For Conferences Awaited id 10', 10, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 14:12:01', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (707, 'Record updated For Conferences Finished id 10', 10, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 14:12:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (708, 'New Record inserted For TPA id 6', 6, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 14:14:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (709, 'Record deleted Where TPA id 4', 4, 1, 'Delete', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 14:14:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (710, 'Record updatedOn Appointment Updated 111', 111, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 14:47:33', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (711, 'Record updatedOn Appointment Updated 131', 131, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 14:51:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (712, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 15:19:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (713, 'New Record inserted On OPD id 11', 11, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 15:19:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (714, 'Record updated On Patient id 111', 111, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 15:24:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (715, 'New Record inserted On OPD id 12', 12, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 15:24:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (716, 'Record updated On Patient id 111', 111, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 15:24:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (717, 'New Record inserted On OPD id 13', 13, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 15:24:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (718, 'Record updated On Patient id 108', 108, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 15:25:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (719, 'New Record inserted On OPD id 14', 14, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 15:25:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (720, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 15:26:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (721, 'New Record inserted On OPD id 15', 15, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 15:26:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (722, 'Record updated On Patient id 110', 110, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 15:27:01', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (723, 'New Record inserted On OPD id 16', 16, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 15:27:01', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (724, 'New Record insertedOn Appointment Created 132', 132, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 15:58:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (725, 'Record updated On Patient id 111', 111, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 15:59:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (726, 'Record updated On Patient id 111', 111, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 16:08:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (727, 'Record updated On Patient id 109', 109, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 16:22:04', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (728, 'Record updated For Staff id 3', 3, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 16:22:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (729, 'Record updated For Staff id 3', 3, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 16:22:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (730, 'New Record inserted On id card id 4', 4, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 16:24:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (731, 'Record updated On  id card id 4', 4, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 16:24:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (732, 'New Record inserted On id card id 5', 5, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 16:25:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (733, 'Record updated On  id card id 5', 5, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 16:25:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (734, 'Record updated On Patient id 107', 107, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 16:28:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (735, 'New Record inserted On OPD id 17', 17, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 16:28:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (736, 'New Record inserted On Blood Issue  id 10', 10, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 16:32:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (737, 'New Record inserted On Item Store id 4', 4, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 16:43:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (738, 'Record updated On Patient id card id 4', 4, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 16:59:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (739, 'Record deleted On Patient id card id 5', 5, 1, 'Delete', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 17:00:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (740, 'Record updated On Patient id 106', 106, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 17:39:01', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (741, 'New Record inserted On OPD id 18', 18, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 17:39:01', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (742, 'New Record insertedOn Appointment Created 133', 133, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 18:04:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (743, 'Record updatedOn Appointment Updated 133', 133, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 18:04:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (744, 'Record updatedOn Appointment Updated 133', 133, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 18:05:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (745, 'Record updatedOn Appointment Updated 129', 129, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 18:05:24', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (746, 'Record updatedOn Appointment Updated 133', 133, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 18:08:25', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (747, 'Record updatedOn Appointment Updated 133', 133, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 18:08:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (748, 'Record updatedOn Appointment Updated 133', 133, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 18:08:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (749, 'Record updatedOn Appointment Updated 133', 133, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 18:09:04', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (750, 'Record deleted Where Conference id 35', 35, 1, 'Delete', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 18:33:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (751, 'New Record inserted On Item Stock id 10', 10, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 18:33:33', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (752, 'New Record inserted On Item id 4', 4, 1, 'Insert', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 18:33:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (753, 'Record updated For Item id 4', 4, 1, 'Update', '122.168.189.76', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-22 18:34:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (754, 'Record updatedOn Appointment Updated 133', 133, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 11:01:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (755, 'New Record inserted On Item Stock id 11', 11, 1, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 11:05:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (756, 'Record updated For Item Stock id 11', 11, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 11:05:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (757, 'Record updated Change Password For Staff id 6', 6, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 11:09:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (758, 'New Record inserted On Patient id card id 6', 6, 1, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 11:39:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (759, 'Record updated On Patient id card id 6', 6, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 11:39:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (760, 'Record deleted On Patient id card id 6', 6, 1, 'Delete', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 11:42:39', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (761, 'New Record inserted On Patient id card id 7', 7, 1, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 11:46:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (762, 'New Record inserted On Patient id card id 8', 8, 1, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 11:48:30', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (763, 'Record updated On Patient id card id 8', 8, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 11:48:30', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (764, 'Record deleted On Patient id card id 8', 8, 1, 'Delete', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 11:48:37', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (765, 'Record deleted On Patient id card id 7', 7, 1, 'Delete', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 11:48:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (766, 'New Record inserted On Patient id card id 9', 9, 1, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 11:49:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (767, 'Record updated On Patient id card id 9', 9, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 11:49:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (768, 'Record deleted On Patient id card id 4', 4, 1, 'Delete', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 13:40:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (769, 'Record updated Change Password For Staff id 4', 4, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 13:45:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (770, 'New Record inserted On Upload Content id 27', 27, 6, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 13:45:53', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (771, 'Record updated On OPD id 13', 13, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 14:37:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (772, 'Record updated On OPD id 20', 20, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:03:32', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (773, 'Record updated On OPD id 20', 20, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:04:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (774, 'Record updated On OPD id 20', 20, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:14:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (775, 'Record updated On OPD id 20', 20, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:17:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (776, 'Record deleted On Patient id card id 9', 9, 1, 'Delete', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:17:25', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (777, 'Record updated On OPD id 20', 20, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:17:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (778, 'New Record inserted On Patient id card id 10', 10, 1, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:18:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (779, 'Record updated On Patient id card id 10', 10, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:18:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (780, 'Record updated On OPD id 20', 20, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:20:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (781, 'Record updated On OPD id 20', 20, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:20:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (782, 'Record updated On Patient id card id 10', 10, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:23:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (783, 'New Record inserted On Patient id card id 11', 11, 1, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:25:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (784, 'Record updated On Patient id card id 11', 11, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:25:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (785, 'Record updated For Staff id 6', 6, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:33:32', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (786, 'Record updated For Staff id 6', 6, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:33:32', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (787, 'Record updated Change Password For Staff id 4', 4, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:51:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (788, 'New Record insertedOn Appointment Created 134', 134, 4, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 15:56:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (789, 'Record updated Change Password For Staff id 4', 4, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 16:07:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (790, 'Record updated On IPD id 21', 21, 6, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 16:42:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (791, 'Record updated On Patient id 100', 100, 6, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 16:42:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (792, 'New Record inserted On Upload Content id 28', 28, 6, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 17:02:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (793, 'Record updated On Patient id 111', 111, 6, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 17:43:38', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (794, 'New Record inserted On OPD id 19', 19, 6, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 17:43:38', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (795, 'Record updated On Patient id 28', 28, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 17:46:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (796, 'New Record inserted On OPD id 20', 20, 1, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 17:46:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (797, 'Record updated On Patient id 28', 28, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 17:46:52', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (798, 'New Record inserted On OPD id 21', 21, 1, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 17:46:52', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (799, 'New Record inserted On Staff Leave Request Pending id 7', 7, 6, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 17:50:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (800, 'New Record inserted On Live Meeting id 38', 38, 6, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 18:08:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (801, 'Record deleted Where Conference id 38', 38, 6, 'Delete', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 18:09:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (802, 'Record updated On Patient id 28', 28, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 18:11:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (803, 'New Record inserted On OPD id 22', 22, 1, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 18:11:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (804, 'Record updated On Patient id 28', 28, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 18:12:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (805, 'New Record inserted On OPD id 23', 23, 1, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 18:12:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (806, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 18:17:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (807, 'Record updated Change Password For Staff id 3', 3, 1, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 18:18:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (808, 'Record updated On Patient id 111', 111, 3, 'Update', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 18:20:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (809, 'New Record inserted On OPD id 24', 24, 3, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 18:20:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (810, 'New Record inserted For TPA id 7', 7, 3, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 18:29:22', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (811, 'New Record inserted On Live Meeting id 39', 39, 6, 'Insert', '122.168.189.230', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-23 18:50:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (812, 'Record updated On Patient id 107', 107, 1, 'Update', '122.168.188.123', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 11:29:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (813, 'Record updated On Patient id 107', 107, 1, 'Update', '122.168.188.123', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 11:29:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (814, 'Record updated On Patient id 28', 28, 1, 'Update', '122.168.188.123', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 11:30:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (815, 'New Record inserted On OPD id 25', 25, 1, 'Insert', '122.168.188.123', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 11:30:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (816, 'Record updated On Patient id 28', 28, 1, 'Update', '122.168.188.123', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 11:31:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (817, 'New Record inserted On OPD id 26', 26, 1, 'Insert', '122.168.188.123', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 11:31:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (818, 'Record updated On Patient id 28', 28, 1, 'Update', '122.168.188.123', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 11:31:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (819, 'New Record inserted On OPD id 27', 27, 1, 'Insert', '122.168.188.123', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 11:31:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (820, 'New Record inserted On Appointment Created 138', 138, 0, 'Insert', '122.168.188.123', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 12:08:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (821, 'Record updatedOn Appointment Updated 136', 136, 1, 'Update', '122.168.188.123', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 12:59:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (822, 'Record updatedOn Appointment Updated 136', 136, 1, 'Update', '122.168.188.123', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 13:07:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (823, 'New Record inserted On pathology Test id 6', 6, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 16:00:01', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (824, 'New Record inserted On pathology Test id 7', 7, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 16:16:24', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (825, 'New Record inserted On Live Meeting id 40', 40, 1, 'Insert', '122.168.188.123', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 17:30:08', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (826, 'Record updated For Staff id 19', 19, 1, 'Update', '122.168.188.123', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 17:36:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (827, 'New Record inserted On Live Meeting id 41', 41, 1, 'Insert', '122.168.188.123', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 17:37:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (828, 'New Record inserted On Live Meeting id 42', 42, 1, 'Insert', '122.168.188.123', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 17:49:26', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (829, 'New Record inserted On pathology Test id 8', 8, 1, 'Insert', '122.168.188.140', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-24 21:31:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (830, 'New Record inserted On pathology Test id 9', 9, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-25 11:10:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (831, 'New Record inserted On pathology Test id 10', 10, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-25 11:14:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (832, 'New Record inserted On Patient id 112', 112, 1, 'Insert', '122.168.189.222', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-25 13:43:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (833, 'Record updated On Patient id 112', 112, 1, 'Update', '122.168.189.222', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-25 13:43:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (834, 'New Record inserted On Ambulance Call id 11', 11, 1, 'Insert', '122.168.189.222', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-25 13:43:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (835, 'New Record inserted On Ambulance Call id 12', 12, 1, 'Insert', '122.168.189.222', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-25 13:43:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (836, 'Record updated Change Password For Staff id 4', 4, 1, 'Update', '122.168.189.222', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-25 13:55:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (837, 'Record deleted Where Ambulance Call id 12', 12, 1, 'Delete', '122.168.189.222', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-25 14:33:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (838, 'Record updated For Ambulance id 1', 1, 1, 'Update', '122.168.189.222', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-25 14:46:52', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (839, 'Record updated For Ambulance id 1', 1, 1, 'Update', '122.168.189.222', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-25 14:46:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (840, 'New Record inserted On pathology Test id 11', 11, 1, 'Insert', '157.34.33.152', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-25 23:04:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (841, 'New Record inserted On pathology Test id 12', 12, 1, 'Insert', '157.34.33.152', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-25 23:07:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (842, 'New Record inserted On pathology Test id 0', 0, 1, 'Insert', '157.34.33.152', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 00:03:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (843, 'New Record inserted On pathology Test id 0', 0, 1, 'Insert', '157.34.33.152', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 00:05:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (844, 'New Record inserted On pathology Test id 12', 12, 1, 'Insert', '157.34.33.152', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 00:06:58', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (845, 'New Record inserted On pathology Test id 13', 13, 1, 'Insert', '157.34.33.152', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 00:08:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (846, 'New Record inserted On pathology Test id 14', 14, 1, 'Insert', '157.34.33.152', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 00:11:36', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (847, 'New Record inserted On pathology Test id 14', 14, 1, 'Insert', '157.34.33.152', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 00:13:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (848, 'New Record inserted On pathology Test id 14', 14, 1, 'Insert', '157.34.33.152', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 00:14:32', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (849, 'New Record inserted On pathology Test id 14', 14, 1, 'Insert', '157.34.33.152', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 00:15:07', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (850, 'New Record inserted On pathology Test id 14', 14, 1, 'Insert', '157.34.33.152', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 00:18:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (851, 'New Record inserted On pathology Test id 14', 14, 1, 'Insert', '157.34.33.152', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 00:20:46', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (852, 'New Record inserted On pathology Test id 14', 14, 1, 'Insert', '157.34.33.152', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 00:24:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (853, 'Record updated On Patient id 31', 31, 1, 'Update', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 11:56:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (854, 'New Record inserted On OPD id 28', 28, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 11:56:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (855, 'New Record inserted On pathology Test id 15', 15, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 13:19:08', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (856, 'New Record inserted On pathology Test id 15', 15, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 13:19:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (857, 'New Record inserted On pathology Test id 15', 15, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 13:21:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (858, 'New Record inserted On pathology Test id 15', 15, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 13:21:26', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (859, 'New Record inserted On pathology Test id 15', 15, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 13:21:37', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (860, 'New Record inserted On pathology Test id 15', 15, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 13:30:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (861, 'Record updated Change Password For Staff id 6', 6, 1, 'Update', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 13:49:46', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (862, 'New Record inserted On Upload Content id 29', 29, 6, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 13:55:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (863, 'New Record inserted On send notification id 10', 10, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 14:05:44', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (864, 'New Record inserted On send notification id 11', 11, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 14:07:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (865, 'New Record inserted On send notification id 12', 12, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 14:11:44', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (866, 'New Record inserted On send notification id 13', 13, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 14:12:36', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (867, 'New Record inserted On send notification id 14', 14, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 14:14:08', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (868, 'New Record inserted On send notification id 15', 15, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 14:20:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (869, 'New Record inserted On IPD id 22', 22, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 15:01:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (870, 'Record updated On Patient id 97', 97, 1, 'Update', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 15:01:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (871, 'Record updated On Patient id 97', 97, 1, 'Update', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 15:01:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (872, 'Record updated On Patient id 106', 106, 1, 'Update', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 15:06:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (873, 'Record updated On IPD id 20', 20, 1, 'Update', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 15:08:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (874, 'Record updated On Patient id 98', 98, 1, 'Update', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 15:08:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (875, 'New Record inserted On pathology Test id 15', 15, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 15:20:51', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (876, 'Record updated On Patient id 97', 97, 1, 'Update', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 15:52:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (877, 'New Record inserted On OPD id 29', 29, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 15:52:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (878, 'Record updated On Patient id 111', 111, 1, 'Update', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 16:49:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (879, 'Record updated On Patient id 112', 112, 1, 'Update', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 16:51:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (880, 'New Record inserted On Operation Theatre id 18', 18, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 16:51:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (881, 'Record updated Change Password For Staff id 10', 10, 1, 'Update', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 17:01:42', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (882, 'New Record inserted On send notification id 16', 16, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 17:49:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (883, 'New Record inserted On send notification id 17', 17, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 17:50:32', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (884, 'New Record inserted On send notification id 18', 18, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 17:50:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (885, 'New Record inserted On send notification id 19', 19, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 17:58:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (886, 'New Record inserted On send notification id 20', 20, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.182', '2021-02-26 17:58:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (887, 'New Record inserted On Pathology Test Report id 1', 1, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 21:53:46', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (888, 'New Record inserted On Pathology Test Report id 2', 2, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 22:12:44', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (889, 'New Record inserted On Pathology Test Report id 3', 3, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 22:13:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (890, 'New Record inserted On Pathology Test Report id 4', 4, 1, 'Insert', '122.168.189.58', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-26 22:39:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (891, 'Record updated Change Password For Staff id 6', 6, 1, 'Update', '122.168.189.215', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 12:06:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (892, 'New Record inserted On Pathology Test Report id 5', 5, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 14:28:25', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (893, 'New Record inserted On Pathology Test Report id 6', 6, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 14:28:54', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (894, 'New Record inserted On Pathology Test Report id 7', 7, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 14:29:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (895, 'New Record inserted On Patient id card id 12', 12, 1, 'Insert', '122.168.188.49', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 16:44:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (896, 'Record updated On Patient id card id 12', 12, 1, 'Update', '122.168.188.49', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 16:44:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (897, 'Record updated On Patient id card id 12', 12, 1, 'Update', '122.168.188.49', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 16:44:44', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (898, 'New Record inserted On pathology Test id 17', 17, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 16:49:44', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (899, 'Record updated For Ambulance id 1', 1, 1, 'Update', '122.168.188.49', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:04:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (900, 'New Record inserted On Pathology Test Report id 8', 8, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:10:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (901, 'New Record inserted On pathology Test id 17', 17, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:14:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (902, 'New Record inserted On Patient id card id 13', 13, 1, 'Insert', '122.168.188.49', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:21:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (903, 'Record updated On Patient id card id 13', 13, 1, 'Update', '122.168.188.49', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:21:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (904, 'New Record inserted On Pathology Test Report id 9', 9, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:26:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (905, 'New Record inserted On Pathology Test Report id 10', 10, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:27:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (906, 'New Record inserted On Pathology Test Report id 11', 11, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:29:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (907, 'New Record inserted On Patient id card id 14', 14, 1, 'Insert', '122.168.188.49', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:29:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (908, 'Record updated On Patient id card id 14', 14, 1, 'Update', '122.168.188.49', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:29:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (909, 'Record deleted On Patient id card id 14', 14, 1, 'Delete', '122.168.188.49', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:29:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (910, 'Record deleted On Patient id card id 13', 13, 1, 'Delete', '122.168.188.49', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:30:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (911, 'Record deleted On Patient id card id 12', 12, 1, 'Delete', '122.168.188.49', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:30:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (912, 'New Record inserted On Pathology Test Report id 12', 12, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:30:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (913, 'New Record inserted On Pathology Test Report id 13', 13, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:31:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (914, 'New Record inserted On Pathology Test Report id 14', 14, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:32:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (915, 'New Record inserted On Pathology Test Report id 15', 15, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:34:33', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (916, 'New Record inserted On Pathology Test Report id 16', 16, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:37:18', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (917, 'New Record inserted On Pathology Test Report id 17', 17, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:38:11', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (918, 'New Record inserted On Pathology Test Report id 18', 18, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:38:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (919, 'New Record inserted On Pathology Test Report id 19', 19, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:39:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (920, 'New Record inserted On Pathology Test Report id 20', 20, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:40:53', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (921, 'New Record inserted On Pathology Test Report id 21', 21, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:42:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (922, 'New Record inserted On Pathology Test Report id 22', 22, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:42:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (923, 'New Record inserted On Pathology Test Report id 23', 23, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:43:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (924, 'New Record inserted On Pathology Test Report id 24', 24, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:46:04', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (925, 'New Record inserted On Staff id card id 4', 4, 1, 'Insert', '122.168.188.49', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:47:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (926, 'Record updated On Staff id card id 4', 4, 1, 'Update', '122.168.188.49', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:47:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (927, 'Record deleted On id card id 4', 4, 1, 'Delete', '122.168.188.49', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:47:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (928, 'New Record inserted On Pathology Test Report id 25', 25, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:50:39', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (929, 'New Record inserted On Pathology Test Report id 26', 26, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:51:08', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (930, 'New Record inserted On Pathology Test Report id 27', 27, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:51:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (931, 'New Record inserted On Pathology Test Report id 28', 28, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:51:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (932, 'New Record inserted On Pathology Test Report id 29', 29, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:52:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (933, 'New Record inserted On Pathology Test Report id 30', 30, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:52:26', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (934, 'New Record inserted On Pathology Test Report id 31', 31, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:53:04', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (935, 'New Record inserted On Pathology Test Report id 32', 32, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:54:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (936, 'New Record inserted On Pathology Test Report id 33', 33, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 17:55:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (937, 'New Record inserted On Pathology Test Report id 34', 34, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 18:08:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (938, 'New Record inserted On Pathology Test Report id 35', 35, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 18:09:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (939, 'New Record inserted On Pathology Test Report id 36', 36, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 18:21:07', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (940, 'New Record inserted On Pathology Test Report id 37', 37, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 18:22:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (941, 'New Record inserted On Pathology Test Report id 38', 38, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 18:22:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (942, 'New Record inserted On Pathology Test Report id 39', 39, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 18:25:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (943, 'New Record inserted On Pathology Test Report id 40', 40, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 18:29:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (944, 'New Record inserted On Pathology Test Report id 41', 41, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 18:30:07', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (945, 'New Record inserted On Pathology Test Report id 42', 42, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 18:30:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (946, 'New Record inserted On Pathology Test Report id 43', 43, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 18:32:04', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (947, 'New Record inserted On Pathology Test Report id 44', 44, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 19:50:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (948, 'New Record inserted On Pathology Test Report id 45', 45, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 19:51:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (949, 'New Record inserted On Pathology Test Report id 46', 46, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 20:01:50', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (950, 'New Record inserted On Pathology Test Report id 47', 47, 1, 'Insert', '122.168.188.49', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 21:26:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (951, 'New Record inserted On Pathology Test Report id 48', 48, 1, 'Insert', '122.168.188.49', 'Windows 10', 'Chrome 88.0.4324.190', '2021-02-27 21:27:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (952, 'Record updated On Patient id 111', 111, 1, 'Update', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 11:14:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (953, 'New Record inserted On Operation Theatre id 19', 19, 1, 'Insert', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 11:14:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (954, 'Record updated On Patient id 31', 31, 1, 'Update', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 11:22:49', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (955, 'New Record inserted On Operation Theatre id 20', 20, 1, 'Insert', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 11:22:49', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (956, 'Record updated On Patient id 31', 31, 1, 'Update', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 11:23:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (957, 'Record updated On Operation Theatre id 20', 20, 1, 'Update', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 11:23:45', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (958, 'Record updated On Patient id 31', 31, 1, 'Update', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 11:23:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (959, 'Record updated On Operation Theatre id 20', 20, 1, 'Update', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 11:23:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (960, 'Record updated For Blood Donor id 1', 1, 1, 'Update', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 11:27:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (961, 'Record updated For Blood Donor id 1', 1, 1, 'Update', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 11:27:42', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (962, 'Record updated On Patient id 97', 97, 1, 'Update', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 13:03:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (963, 'New Record inserted On OPD id 30', 30, 1, 'Insert', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 13:03:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (964, 'Record updated On Patient id 108', 108, 1, 'Update', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 14:53:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (965, 'New Record inserted On OPD id 31', 31, 1, 'Insert', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 14:53:31', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (966, 'Record updated On Patient id 107', 107, 1, 'Update', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 14:53:54', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (967, 'New Record inserted On OPD id 32', 32, 1, 'Insert', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 14:53:54', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (968, 'Record updatedOn Appointment Updated 107', 107, 1, 'Update', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 14:54:25', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (969, 'New Record inserted On IPD id 23', 23, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 15:55:56', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (970, 'New Record inserted On IPD id 24', 24, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 17:44:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (971, 'New Record inserted On IPD id 25', 25, 1, 'Insert', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 18:08:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (972, 'New Record inserted On IPD id 26', 26, 1, 'Insert', '122.168.188.165', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 18:09:48', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (973, 'New Record inserted On IPD id 27', 27, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 18:38:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (974, 'New Record inserted On Live Consultation id 43', 43, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 18:38:20', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (975, 'New Record inserted On IPD id 28', 28, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 18:38:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (976, 'New Record inserted On IPD id 29', 29, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-01 20:14:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (977, 'New Record inserted On pathology Test id 18', 18, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-02 13:12:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (978, 'New Record inserted On IPD id 30', 30, 1, 'Insert', '122.168.188.57', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-02 18:26:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (979, 'Record deleted On  Radiology Test Billing  id 5', 5, 1, 'Delete', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-02 20:02:33', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (980, 'Record deleted On  Radiology Test Billing  id 4', 4, 1, 'Delete', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-02 20:02:39', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (981, 'Record deleted On  Radiology Test Billing  id 3', 3, 1, 'Delete', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-02 20:02:42', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (982, 'Record deleted On  Radio Test  id 3', 3, 1, 'Delete', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-02 20:15:30', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (983, 'Record deleted On  Radio Test  id 1', 1, 1, 'Delete', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-02 20:15:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (984, 'Record updated For Expenses id 7', 7, 1, 'Update', '122.168.188.179', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-03 17:30:21', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (985, 'New Record inserted On Radiology Test id 2', 2, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-03 17:36:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (986, 'New Record inserted On Radiology Test id 2', 2, 1, 'Insert', '106.207.249.58', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-03 23:16:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (987, 'New Record inserted On Radiology Test id 2', 2, 1, 'Insert', '106.207.249.58', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-03 23:16:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (988, 'New Record inserted On Radiology Test id 2', 2, 1, 'Insert', '106.207.249.58', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-03 23:23:23', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (989, 'New Record inserted On Radiology Test id 2', 2, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-04 15:40:09', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (990, 'Record updated Change Password For Staff id 4', 4, 1, 'Update', '122.168.189.95', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-04 11:56:01', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (991, 'New Record inserted On Staff Leave Request Pending id 8', 8, 4, 'Insert', '122.168.189.95', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-04 17:29:42', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (992, 'New Record inserted On Staff Leave Request Pending id 9', 9, 4, 'Insert', '122.168.189.95', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-04 17:30:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (993, 'Record updated On Patient id 107', 107, 1, 'Update', '122.168.189.242', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-05 10:56:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (994, 'New Record inserted On OPD id 33', 33, 1, 'Insert', '122.168.189.242', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-05 10:56:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (995, 'New Record inserted On OPD id 34', 34, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-05 15:41:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (996, 'New Record inserted On OPD id 35', 35, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-05 15:45:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (997, 'New Record inserted On OPD id 37', 37, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-05 16:12:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (998, 'New Record inserted On OPD id 38', 38, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-05 16:31:46', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (999, 'New Record inserted On OPD id 39', 39, 1, 'Insert', '117.202.25.89', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-05 16:37:53', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1000, 'New Record inserted On OPD id 40', 40, 1, 'Insert', '117.239.39.50', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-05 18:34:01', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1001, 'New Record inserted On Patient id 113', 113, 1, 'Insert', '122.168.188.151', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-10 17:25:20', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1002, 'Record updated On Patient id 113', 113, 1, 'Update', '122.168.188.151', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-10 17:25:20', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1003, 'New Record inserted On OPD id 41', 41, 1, 'Insert', '122.168.188.151', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-10 17:26:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1004, 'New Record inserted On OPD id 42', 42, 1, 'Insert', '122.168.188.151', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-10 17:26:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1005, 'New Record inserted On OPD id 43', 43, 1, 'Insert', '122.168.188.151', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-10 17:27:55', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1006, 'New Record inserted On OPD id 44', 44, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-10 17:33:54', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1007, 'New Record inserted On OPD id 45', 45, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-10 17:56:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1008, 'New Record inserted On OPD id 46', 46, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-10 17:57:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1009, 'New Record inserted On OPD id 47', 47, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-10 17:58:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1010, 'New Record inserted On OPD id 48', 48, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-10 17:59:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1011, 'New Record inserted On OPD id 49', 49, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-10 18:26:52', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1012, 'New Record inserted On OPD id 50', 50, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-10 18:28:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1013, 'New Record inserted On Radiology Test id 3', 3, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-10 18:28:39', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1014, 'New Record inserted On Radiology Test id 4', 4, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-10 18:28:39', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1015, 'New Record inserted On Radiology Test id 5', 5, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-10 18:29:13', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1016, 'New Record inserted On Radiology Test id 6', 6, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-10 18:29:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1017, 'New Record inserted On Ambulance Call id 12', 12, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-10 18:31:22', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1018, 'New Record inserted On pathology Test id 19', 19, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-10 18:34:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1019, 'New Record inserted On pathology Test id 20', 20, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-10 18:34:39', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1020, 'New Record inserted On pathology Test id 21', 21, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-10 18:35:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1021, 'New Record inserted On OPD id 51', 51, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-10 19:43:01', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1022, 'New Record inserted On OPD id 52', 52, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-10 19:46:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1023, 'New Record inserted On OPD id 53', 53, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-10 20:06:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1024, 'New Record inserted On OPD id 1', 1, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-10 20:10:36', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1025, 'New Record inserted On OPD id 2', 2, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-10 20:49:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1026, 'New Record inserted On OPD id 3', 3, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-10 20:59:25', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1027, 'New Record inserted On OPD id 4', 4, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-10 21:11:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1028, 'New Record inserted On OPD id 5', 5, 1, 'Insert', '122.168.188.94', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-10 21:18:17', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1029, 'Record updated On Patient id 31', 31, 1, 'Update', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 11:48:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1030, 'Record updated On Patient id 31', 31, 1, 'Update', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 11:51:02', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1031, 'New Record inserted On OPD id 6', 6, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 12:00:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1032, 'Record updated On OPD id 6', 6, 1, 'Update', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 12:15:24', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1033, 'Record updated On OPD id 6', 6, 1, 'Update', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 12:15:39', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1034, 'Record updated On OPD id 6', 6, 1, 'Update', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 12:28:05', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1035, 'New Record inserted On Patient id 114', 114, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 13:07:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1036, 'Record updated On Patient id 114', 114, 1, 'Update', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 13:07:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1037, 'New Record inserted On OPD id 7', 7, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 13:55:57', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1038, 'New Record inserted On OPD id 8', 8, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 14:10:14', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1039, 'New Record inserted On Patient id 115', 115, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 14:35:07', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1040, 'New Record inserted On Patient id 116', 116, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 14:58:42', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1041, 'New Record inserted On Patient id 117', 117, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 15:15:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1042, 'New Record inserted On OPD id 9', 9, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 15:15:35', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1043, 'New Record inserted On Patient id 118', 118, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 15:46:03', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1044, 'New Record inserted On OPD id 10', 10, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 15:46:40', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1045, 'New Record inserted On Patient id 119', 119, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 15:47:32', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1046, 'New Record inserted On Patient id 120', 120, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 15:52:22', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1047, 'New Record inserted On OPD id 12', 12, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 15:52:22', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1048, 'New Record inserted On Patient id 121', 121, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 15:53:38', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1049, 'New Record inserted On OPD id 13', 13, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 15:53:38', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1050, 'New Record inserted On Patient id 122', 122, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 15:55:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1051, 'New Record inserted On OPD id 14', 14, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 15:55:10', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1052, 'New Record inserted On Patient id 123', 123, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 15:56:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1053, 'New Record inserted On OPD id 15', 15, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 15:56:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1054, 'New Record inserted On Patient id 124', 124, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 16:03:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1055, 'New Record inserted On OPD id 16', 16, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 16:03:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1056, 'New Record inserted On Patient id 125', 125, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 16:03:54', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1057, 'New Record inserted On OPD id 17', 17, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 16:03:54', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1058, 'New Record inserted On Patient id 126', 126, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 16:09:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1059, 'New Record inserted On OPD id 18', 18, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 16:09:16', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1060, 'New Record inserted On Patient id 127', 127, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 16:11:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1061, 'New Record inserted On OPD id 19', 19, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 16:11:06', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1062, 'New Record inserted On Patient id 128', 128, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 16:31:54', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1063, 'New Record inserted On OPD id 20', 20, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 16:31:54', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1064, 'Record updated On OPD id 20', 20, 1, 'Update', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 17:01:04', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1065, 'Record updated On OPD id 20', 20, 1, 'Update', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 17:01:47', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1066, 'Record updated On OPD id 20', 20, 1, 'Update', '122.168.188.46', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-11 17:02:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1067, 'New Record inserted On OPD id 21', 21, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 17:27:59', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1068, 'New Record inserted On OPD id 75', 75, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 19:09:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1069, 'New Record inserted On OPD id 76', 76, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 19:11:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1070, 'New Record inserted On OPD id 22', 22, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 19:21:15', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1071, 'New Record inserted On OPD id 23', 23, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 19:24:19', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1072, 'New Record inserted On OPD id 24', 24, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 19:28:42', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1073, 'New Record inserted On OPD id 25', 25, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 19:32:00', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1074, 'New Record inserted On OPD id 26', 26, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 19:33:26', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1075, 'New Record inserted On OPD id 82', 82, 1, 'Insert', '122.168.188.46', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-11 19:36:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1076, 'New Record inserted On OPD id 27', 27, 1, 'Insert', '122.168.189.36', 'Windows 10', 'Chrome 88.0.4324.190', '2021-03-12 12:21:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1077, 'Record updated On OPD id 83', 83, 1, 'Update', '122.168.189.36', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-12 15:46:20', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1078, 'New Record inserted On OPD id 84', 84, 1, 'Insert', '122.168.189.36', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-12 16:12:22', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1079, 'Record updated On OPD id 84', 84, 1, 'Update', '122.168.189.36', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-12 16:44:57', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1080, 'Record updated On OPD id 83', 83, 1, 'Update', '122.168.189.36', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-12 16:48:41', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1081, 'New Record inserted On OPD id 28', 28, 1, 'Insert', '122.168.189.36', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-12 16:55:34', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1082, 'New Record inserted On OPD id 29', 29, 1, 'Insert', '122.168.189.36', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-12 17:09:32', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1083, 'New Record inserted On OPD id 30', 30, 1, 'Insert', '122.168.189.36', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-12 17:13:20', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1085, 'New Record inserted On OPD id 32', 32, 1, 'Insert', '122.168.189.36', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-12 17:23:12', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1086, 'Record updated On OPD id 89', 89, 1, 'Update', '122.168.189.36', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-12 17:28:07', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1087, 'New Record inserted On Patient id 129', 129, 1, 'Insert', '122.168.189.36', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-12 17:34:27', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1088, 'New Record inserted On Patient id 130', 130, 1, 'Insert', '122.168.189.36', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-12 17:42:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1089, 'New Record inserted On OPD id 33', 33, 1, 'Insert', '122.168.189.36', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-12 17:42:28', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1090, 'New Record inserted On Patient id 131', 131, 1, 'Insert', '122.168.189.36', 'Windows 10', 'Chrome 89.0.4389.82', '2021-03-12 17:52:43', '0000-00-00');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1091, 'New Record inserted On OPD id 34', 34, 1, 'Insert', '122.168.189.36', 'Windows 10